.TH ACM l "Oct 30, 2017"
.SH NAME
acm-5.0-ico \- an aerial combat simulator for X
.SH SYNOPSIS
.B acm
[
.I options
]  
.LP

.SH DESCRIPTION

acm-5.0-ico is a generic flight simulator and a distributed air combat
simulator that runs on the X window system.  Players can engage in
simultaneous air combat from different computers.  Players fly
jet aircraft equipped with radar, heat seeking missiles and cannon.

Please read the complete manual in HTML format that comes with this
package, where more commands and more options are described.


.SH USAGE REFERENCE
.LP
The following command line options are recognized by acm (see full list in the
reference manual):
.LP
.TP
-version
Displays program version and copyright, then exit.
.TP
-plane MODEL
Select the aircraft type that you'd like to fly. Enter an invalid name (for
example "xxx") to see the list of the available models.
.TP
-frame-rate N
Limits the displayed frame rate to N frames per second.
.TP
-geometry GEOMETRY
An X compatible window geometry specification, typically something like
800x600+0+0.

.SS Exit status:

.TP
0
Normal termination of the program. The reason for the termination of the program
is sent to standard output; nothing is written if the program terminated by
player's request. Some diagnostic message might be sent to standard error,
for example invalid DIS packet received or too many entities generated, but these
events are not fatal and do not indicate an error in the program.

.TP
1
Internal error, or invalid command line parameters, or system failure in providing
some service. Appropriate description of the error occurred is sent to standard error.




.SH ENGINE CONTROLS


The following keys control your engine thrust:

.LP
	4	Full Power
.LP
	3	Increase Power (about 2 percent)
.LP
	2	Decrease Power (about the same amount)
.LP
	1	Idle Power
.LP
	a	Toggle Afterburner

Your engine gauge displays the power that you are generating.  Below that,
you have displays showing your total fuel remaining as well as your current
fuel consumption rate.


.SH KEYBOARD COMMAND LIST

Stick and Rudder Controls

.LP
The Mouse is your stick.  It controls pitch and roll.
.LP
z -- Rudder Left
.LP
c -- Rudder Right
.LP
x -- Center the Rudder
.LP
SHIFT-E -- Toggle between stick direct control mode (default) and stick rate
control mode.



Engine Controls

.LP
4 -- Full Power
.LP
3 -- Increase Power
.LP
2 -- Decrease Power
.LP
1 -- Idle
.LP
a -- Toggle Afterburner State



Radar Controls

.LP
r -- Toggle Radar State (On/Standby)
.LP
q -- Target Designator



Flaps

.LP
h -- Extend 10 degrees
.LP
y -- Retract 10 degrees



Speed Brakes

.LP
s -- Extend
.LP
w -- Retract


Weapon Controls

.LP
Mouse Button 1 -- Fire the selected weapon
.LP
Mouse Button 3 -- Select another weapon


Pitch Trim Controls

.LP
u -- Set Take-off pitch trim
.LP
j -- Set pitch trim to the control stick's current pitch setting


Other Controls

.LP
g -- Retract/Extend landing gear
.LP
l -- Launch a target drone
.LP
Shift-Q Shift-Q -- Self-Destruct (Quit the game)



View Controls (Numeric Keypad)

.LP
8 -- Forward
.LP
2 -- Aft
.LP
4 -- Left
.LP
6 -- Right
.LP
5 -- Up


.SH AUTHOR
Riley Rainey <rainey@netcom.com> is the original author of acm-5.0.
Umberto Salsi <salsi@icosaedro.it> made the enhancements published as
`acm-5.0-ico'.

