#!/bin/sh
#
# Copyright (C) 2013-2014 ABINIT group (Yann Pouillon)
#
# This file is part of the Abinit Fallbacks software package. For license
# information, please see the COPYING file in the top-level directory of
# the source distribution.
#

#
# IMPORTANT NOTE:
#
#   For maintainer use only!
#
#   PLEASE DO NOT EDIT THIS FILE, AS IT COULD CAUSE A SERIOUS LOSS OF DATA.
#   *** YOU HAVE BEEN WARNED! ***
#

# Check that we are in the right directory
if test ! -s "./configure.ac" -o ! -s "config/specs/fallbacks.conf"; then
  echo "[fbkclean]   Cowardly refusing to remove something from here!" >&2
  exit 1
fi

# Make sure the directory tree is writeable (some directories can be left
# read-only after a failed 'make distcheck')
chmod -R u+w .

# Remove temporary directories and files
echo "[fbkclean]   Removing temporary directories and files"
find . -depth -name 'tmp*' -exec rm -rf {} \;
find . -depth -name '*.tmp' -exec rm -rf {} \;

# Remove Makefiles and machine-generated files
echo "[fbkclean]   Removing files produced by the configure script"
find . -name Makefile -exec rm {} \;
rm -f fallbacks.dump fallbacks.dump.in
rm -f src/abinit-fallbacks-config.in
rm -f core config.log config.status stamp-h1 config.h config.h.in*
rm -f libtool

# Remove object files, libraries and programs
echo "[fbkclean]   Removing object files, libraries and programs"
rm -rf exports/* sources/* stamps/*

# Remove autotools files
echo "[fbkclean]   Removing autotools files"
find . -name Makefile.in -exec rm {} \;
find . -name Makefile.am -exec rm {} \;
rm -rf aclocal.m4 autom4te.cache configure confstat*
(test -d config/gnu && cd config/gnu && rm -f compile config.guess config.sub depcomp install-sh ltmain.sh missing)
(test -d config/m4 && cd config/m4 && rm -f libtool.m4 ltoptions.m4 ltsugar.m4 ltversion.m4 lt~obsolete.m4 auto-*.m4)
