!{\src2tex{textfont=tt}}
!!****f* ABINIT/clnmpi_img
!! NAME
!!  clnmpi_img
!!
!! FUNCTION
!!  Cleans-up the mpi informations for parallelism over images of the cell (npimage>1).
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2014 ABINIT group (MT,GG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! SIDE EFFECTS
!!  mpi_enreg=informations about MPI parallelization
!!
!! PARENTS
!!      abinit
!!
!! CHILDREN
!!      xcomm_free
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine clnmpi_img(mpi_enreg)

 use defs_basis
 use defs_abitypes
 use m_profiling
 use m_errors
 use m_xmpi

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'clnmpi_img'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 type(MPI_type), intent(inout) :: mpi_enreg

!Local variables-------------------------------

! ***********************************************************************

 DBG_ENTER("COLL")

 if (xmpi_paral==0) return

 if (mpi_enreg%comm_cell/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_cell)
   mpi_enreg%comm_cell=xmpi_comm_null
 end if

 if (mpi_enreg%comm_img/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_img)
   mpi_enreg%comm_img=xmpi_comm_null
 end if

 if (allocated(mpi_enreg%my_imgtab))  then
   ABI_DEALLOCATE(mpi_enreg%my_imgtab)
 end if
 if (allocated(mpi_enreg%distrb_img))  then
   ABI_DEALLOCATE(mpi_enreg%distrb_img)
 end if

 mpi_enreg%paral_img=0
 mpi_enreg%my_nimage=1
 mpi_enreg%me_img=0
 mpi_enreg%me_cell=0
 mpi_enreg%nproc_img=1
 mpi_enreg%nproc_cell=1

 DBG_EXIT("COLL")

end subroutine clnmpi_img
!!***
