!{\src2tex{textfont=tt}}
!!****f* ABINIT/laplacian
!! NAME
!! laplacian
!! 
!! FUNCTION
!! Compute Laplacian of an input wave function:
!!   [d2/dr2-l*(l+1)/r^2]wf(r)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS 
!!  n=dimension of arrays
!!  h=logarithmic step of mesh
!!  l=angular momentum l
!!  r(n)=points of the mesh
!!  r_(n)=r(:) + AA where r(i)=AA*(exp[BB*(i-1)]-1)
!!  wfn(n)=input wave function
!!
!! OUTPUT
!!  del2wfn(n)=output Laplacian [d2/dr2-l*(l+1)/r^2]wfn(r)
!!  work1(n),work2(n)=wok arrays
!!
!! PARENTS
!!      calc_kij
!!
!! CHILDREN
!!      nderiv
!!
!! SOURCE

 subroutine laplacian(n,h,l,r,wfn,del2wfn,work1,work2,r_)

 use defs_basis

 implicit none
 
!Arguments ---------------------------------------------
 integer :: l,n
 real(dp) :: h
 real(dp) :: r(n),r_(n),wfn(n),del2wfn(n),work1(n),work2(n)

!Local variables ---------------------------------------
 integer :: ang,i,lpwr

!--------------------------------------------------------

 lpwr=l+1
 do i=1,n
  work2(i)=wfn(i)/(r(i)**lpwr)
 enddo

 call nderiv(h,work2,work1,n)
 work1=work1/r_
 call nderiv(h,work1,work2,n)
 work2=work2/r_

 ang=2*(l+1)
 do i=1,n
  del2wfn(i)=(r(i)**l)*(ang*work1(i)+r(i)*work2(i))
 enddo

 end subroutine
!!***
