!{\src2tex{textfont=tt}}
!!****f* ABINIT/xderiveWrite
!! NAME
!! xderiveWrite
!!
!! FUNCTION
!! Generic routine to read/write wf files.
!!
!! COPYRIGHT
!! Copyright (C) 2003-2007 ABINIT group (MB)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!!   we use several procedures with the same generic name
!!   xderiveWrite  contains
!!               xderiveWrite_int  :  write integer  value
!!               xderiveWrite_int2d  :  write integer  array 2d
!!               xderiveWrite_dp   :  write double precision value
!!               xderiveWrite_dp2d   : write double precision array 2d
!!
!! PARENTS
!!      outxfhist,rwwf
!!
!! CHILDREN
!!      MPI_FILE_WRITE_AT
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine xderiveWrite_int(wff,xval,n1,ierr)

 use defs_datatypes

 implicit none

#ifndef __VMS
         include 'mpif.h'
#endif
#if defined MPI_IO
           integer  :: statux(MPI_STATUS_SIZE)
#endif
 type(wffile_type),intent(inout) :: wff
 integer,intent(in) :: xval(:),n1
 integer,intent(out) :: ierr

 ierr = 0
#if defined MPI_IO
            call MPI_FILE_WRITE_AT(wff%fhwff,  wff%offwff,xval,n1  &
            & , MPI_INTEGER , statux, ierr)

            wff%offwff = wff%offwff + wff%nbOct_int * n1
#endif

end subroutine xderiveWrite_int

subroutine xderiveWrite_int2d(wff,xval,n1,n2,ierr)

 use defs_datatypes

 implicit none

#ifndef __VMS
         include 'mpif.h'
#endif
#if defined MPI_IO
           integer  :: statux(MPI_STATUS_SIZE)
#endif

 type(wffile_type),intent(inout) :: wff
 integer,intent(in) :: xval(:,:),n1,n2
 integer,intent(out) :: ierr

 ierr = 0
#if defined MPI_IO
           call MPI_FILE_WRITE_AT(wff%fhwff, wff%offwff,xval,n1*n2  &
           & , MPI_INTEGER , statux, ierr)

           wff%offwff = wff%offwff + wff%nbOct_int * n1 *n2
#endif
end subroutine xderiveWrite_int2d


subroutine xderiveWrite_dp(wff,xval,n1,ierr)

 use defs_basis
 use defs_datatypes

 implicit none

#ifndef __VMS
         include 'mpif.h'
#endif
#if defined MPI_IO
           integer  :: statux(MPI_STATUS_SIZE)
#endif
 type(wffile_type),intent(inout) :: wff
 integer,intent(in) :: n1
 integer,intent(out) :: ierr
 real(dp),intent(in) :: xval(:)
 ierr=0

#if defined MPI_IO
           call MPI_FILE_WRITE_AT(wff%fhwff,wff%offwff,xval,n1 &
           & , MPI_DOUBLE_PRECISION , statux, ierr)
           wff%offwff = wff%offwff + wff%nbOct_dp * n1

#endif
end subroutine xderiveWrite_dp

subroutine xderiveWrite_dp2d(wff,xval,n1,n2,ierr)

 use defs_basis
 use defs_datatypes

 implicit none

#ifndef __VMS
         include 'mpif.h'
#endif
#if defined MPI_IO
           integer  :: statux(MPI_STATUS_SIZE)
#endif
 type(wffile_type),intent(inout) :: wff
 integer,intent(in) :: n1,n2
 integer,intent(out) :: ierr
 real(dp),intent(in):: xval(:,:)

 ierr=0
#if defined MPI_IO
           call MPI_FILE_WRITE_AT(wff%fhwff, wff%offwff,xval,n1*n2 &
           &  , MPI_DOUBLE_PRECISION , statux, ierr)
           wff%offwff = wff%offwff + wff%nbOct_dp * n1*n2
#endif
end subroutine xderiveWrite_dp2d
!!***
