!{\src2tex{textfont=tt}}
!!****f* ABINIT/itst0
!! NAME
!! itst0
!!
!! FUNCTION
!! Check whether a q-vector is nominally zero (itst0=1 if so).
!! The criterion is that each component (in RL units) should be smaller
!! than epsilon (originally set to 0.001)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  q(3)=q-vector
!!
!! OUTPUT
!!  function itst0=1 if q-vector is zero
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

integer function itst0(q)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!arrays
 real(dp),intent(in) :: q(3)

!Local variables-------------------------------
!scalars
 real(dp),parameter :: epsil=0.001_dp

! *************************************************************************

 itst0=0
 if(all(abs(q(:))<epsil)) itst0=1

 end function itst0
!!***
