!{\src2tex{textfont=tt}}
!!****f* ABINIT/cppm2par
!! NAME
!! cppm2par
!!
!! FUNCTION
!! Calculate the plasmon-pole parameters using Hybertsen and Louie model
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (RShaltaf, GMR, XG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  epsm1(npwvec,npwvec,nomega,nq)=dielectric matrix at nomega frequencies, and nq wavevectors
!!  npwvec=number of plane waves
!!  nomega=number of frequencies (usually 2)
!!  nq=number of q points
!!  omega(nomega)=frequencies
!!  omegaplasma=input variable
!!  qratio=(q+G).(q+G')/|q+G|^2
!!  rho=charge deinsity on real space FFT grid
!!
!! OUTPUT
!!  bigomegatwsq(npwvec,npwvec,nq)=parameter of the plasmon-pole model (see gwa.pdf file)
!!  omegatw(npwvec,npwvec,nq)=parameter of the plasmon-pole model (see gwa.pdf file)
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      cggfft,fourdp
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cppm2par(npwvec,nq,nomega,epsm1,bigomegatwsq,omegatw,&
& ngfft1,ngfft2,ngfft3,gvec,qratio,rho,nr,q,b1,b2,b3)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12ffts
 use interfaces_15gw, except_this_one => cppm2par
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ngfft1,ngfft2,ngfft3,nomega,npwvec,nq,nr
!arrays
 integer,intent(in) :: gvec(3,npwvec)
 real(dp),intent(in) :: b1(3),b2(3),b3(3),q(nq),qratio(npwvec,npwvec,nq)
 real(dp),intent(inout) :: rho(nr)
 complex,intent(in) :: epsm1(npwvec,npwvec,nomega,nq)
 complex,intent(out) :: bigomegatwsq(npwvec,npwvec,nq)
 complex,intent(out) :: omegatw(npwvec,npwvec,nq)

!Local variables-------------------------------
!scalars
 integer :: ig,ig_s,igp,igp_s,iq,istat,j,tim_fourdp=2
 real(dp) :: lambda,phi,x1
 logical,parameter :: use_symmetrized=.true.
 character(len=5000) :: message
 type(MPI_type) :: mpi_enreg
!arrays
 integer :: gdiff(3),ngfft(18)
 integer,allocatable :: igfft(:,:)
 real(dp),allocatable :: qplusg(:),rhog_dp(:,:)
 complex,allocatable :: omegatwsq(:,:),rhog(:),rhogg(:,:),temp(:,:)

!*************************************************************************
 ! compute the density in G space rhog(G)
 allocate(rhog_dp(2,nr),rhog(nr))

 ngfft(1)=ngfft1
 ngfft(2)=ngfft2
 ngfft(3)=ngfft3
 ngfft(4)=2*(ngfft(1)/2)+1
 ngfft(5)=2*(ngfft(2)/2)+1
 ngfft(6)=ngfft(3)
 ngfft(7)=100
 ngfft(8)=256
 ngfft(9)=0
 ngfft(10)=1
 ngfft(11)=0
 ngfft(12)=ngfft2
 ngfft(13)=ngfft3
 ngfft(14)=0

 !conduct FFT to rhog
 !MG should augment the FFT grid to calculate correctly the Fourier components at G-Gp
 mpi_enreg%me_fft=0
 mpi_enreg%nproc_fft=1
 call fourdp(1,rhog_dp,rho,-1,mpi_enreg,nr,ngfft,0)
 rhog(1:nr)=cmplx(rhog_dp(1,1:nr),rhog_dp(2,1:nr))

 !calculate the FFT index of each (G-G') vector and assign the value
 !of correspondent density simultanously
 allocate(igfft(npwvec,npwvec),rhogg(npwvec,npwvec))

 call cggfft(npwvec,ngfft1,ngfft2,ngfft3,gvec,igfft)

 do ig=1,npwvec
  do igp=1,npwvec
   rhogg(ig,igp)=rhog(igfft(ig,igp))
  end do
 end do

 do ig=1,npwvec
  do igp=1,npwvec
   if(igfft(ig,igp)>nr)then
    write (message,'(a,a,a)') &
&    'BUG:can not find rho(G-Gpr) for some G, Gpr, contact ABINIT group',ch10,&
&    'program will stop'
   call wrtout(ab_out,message,'COLL')
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
   end if
   rhogg(ig,igp)=rhog(igfft(ig,igp))
  end do
 end do

 rhogg(:,:)= 4*pi*rhogg(:,:)

 !Now we have rhogg
 deallocate(igfft,rhog_dp,rhog)

 !start calculating GPP parameters
 !unsemetrize epsm1 -> epsm1=|q+G''|/|q+G|*epsm1
 allocate(qplusg(npwvec),stat=istat)
 if(istat/=0) stop 'qplusg out of memory'
 allocate(temp(npwvec,npwvec),stat=istat)
 if(istat/=0) stop 'temp out of memory'
 allocate(omegatwsq(npwvec,npwvec),stat=istat)
 if(istat/=0) stop 'temp out of memory'


 do iq=1,nq

 temp(:,:)=-1*epsm1(:,:,1,iq)
 !still not obvious for me wether one shall use the symmitrized inverse DM or the nonsymetrized one
 !the default here is to use the symmetrized one, I must discuss this with XG
 !MG I think it is better to use the unsymmetrized DM, it turns out that we can use the present implementation 
 !but we have to modify the expression for omegatwsq adding |q+Gp|/|q+G|, shoul check this part carefully FIXME 

 if(.not.use_symmetrized)then
  call cvc(nq,iq,q,b1,b2,b3,npwvec,gvec,qplusg)
  do ig=1,npwvec
   do igp=1,npwvec
    temp(ig,igp)=qplusg(igp)/qplusg(ig)*temp(ig,igp)
   end do
  end do
 end if

 do ig=1,npwvec
  temp(ig,ig)=temp(ig,ig)+1
  do igp=1,npwvec
   bigomegatwsq(ig,igp,iq)=rhogg(ig,igp)*qratio(ig,igp,iq)
   omegatwsq(ig,igp)=bigomegatwsq(ig,igp,iq)/temp(ig,igp)

   if(real(omegatwsq(ig,igp))<=zero .or. aimag(omegatwsq(ig,igp))**2*tol12>real(omegatwsq(ig,igp))**2)then
    !set omegatw to any arbitrary number to avoid dealing with undefined numbers like (INF)
    !simply ignore all cases of omegatw with imaginary values
    !in principle these correspond to cases where the imaginary part of epsm1 does not have
    !a well defined peak. The imaginary part of epsm1 in these cases oscillates  with a small amplitude
    !since the amplitude A_GGpr=-pi/2*bigomegatwsq/omegatw, it follows that
    !bigomegatwsq shall be set to zero for these cases
    bigomegatwsq(ig,igp,iq)=(0.,0.)
    omegatw(ig,igp,iq)=ten
   else 
    !MG this part has been added to deal with systems without inversion symmetry
    !this new implementation gives the same results as the previous one if 
    !omegatwsq is a pure real number and has the advantage of being an improved
    !approach for systems without an inversion center
    lambda=abs(omegatwsq(ig,igp))
    phi=atan(aimag(omegatwsq(ig,igp))/real(omegatwsq(ig,igp)))
    omegatw(ig,igp,iq)=sqrt(lambda/cos(phi))
    bigomegatwsq(ig,igp,iq)=bigomegatwsq(ig,igp,iq)*(1.-(0.,1.)*tan(phi))
    !MG old part, just uncomment the following line and comment the previous 4
    !lines to restore the old version
    !omegatw(ig,igp,iq)=sqrt(real(omegatwsq(ig,igp)))
    !END old part
     end if
   end do
  end do

 end do !iq

 deallocate(omegatwsq,rhogg,temp,qplusg)

end subroutine cppm2par
!!***
