!{\src2tex{textfont=tt}}
!!****f* ABINIT/psp7nl
!! NAME
!! psp7nl
!!
!! FUNCTION
!! Make paw projector form factors f_l(q) for each l
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  indlmn(6,lmnmax)= array giving l,m,n,lm,ln,s for i=lmn
!!  lmnmax=max number of (l,m,n) components
!!  lnmax=max number of (l,n) components
!!  mqgrid=number of grid points for q grid
!!  qgrid(mqgrid)=values at which form factors are returned
!!  radmesh <type(pawrad_type)>=data containing radial grid informations
!!  wfll(mmax,lnmax)=paw projector on radial grid
!!
!! OUTPUT
!!  ffspl(mqgrid,2,lnmax)= form factor f_l(q) and second derivative
!!
!! NOTES
!!  u_l(r) is the paw projector (input as wfll);
!!  j_l(q) is a spherical Bessel function;
!!  f_l(q) = $ \int_0^{rmax}[j_l(2\pi q r) u_l(r)  r dr]$
!!  This file has been written from psp5nl (DCA, XG, FrD, GZ)
!!
!! PARENTS
!!      psp7in
!!
!! CHILDREN
!!      copymesh,leave_new,simp_gen,spline,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine psp7nl(ffspl,indlmn,lmnmax,lnmax,mqgrid,qgrid,radmesh,wfll)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: lmnmax,lnmax,mqgrid
 type(pawrad_type),intent(in) :: radmesh
!arrays
 integer,intent(in) :: indlmn(6,lmnmax)
 real(dp),intent(in) :: qgrid(mqgrid),wfll(radmesh%mesh_size,lnmax)
 real(dp),intent(out) :: ffspl(mqgrid,2,lnmax)

!Local variables-------------------------------
!scalars
 integer :: ilmn,iln,iln0,iq,ir,ll,meshsz,mmax
 real(dp),parameter :: eps=tol14**4
 real(dp) :: arg,argn,bes0a,bes0ap,bes0b,bes0bp,bes1a,bes1ap,bes1b,bes1bp,bes2a
 real(dp) :: bes2ap,bes2b,bes2bp,bes3a,bes3ap,bes3b,bes3bp,bessel,besselp,qr
 real(dp) :: yp1,ypn
 character(len=500) :: message
 type(pawrad_type) :: tmpmesh
!arrays
 real(dp),allocatable :: ff(:),rr(:),rr2(:),rr2wf(:),rrwf(:),work(:)

!*************************************************************************

!=== l=0,1,2 and 3 spherical Bessel functions (and derivatives) ===
!The accuracy of the bes1, bes2, bes3 functions for small arguments
!may be insufficient. In the present version of the routines,
!some care is taken with the value of the argument.
!If smaller than 1.d-3, a two terms Taylor series expansion is prefered.
 bes0a(arg)=1.0_dp-arg**2/6.0_dp*(1.0_dp-arg**2/20.0_dp)
 bes0b(arg)=sin(arg)/arg
 bes1a(arg)=(10.d0-arg*arg)*arg/30.0d0
 bes1b(arg)=(sin(arg)-arg*cos(arg))/arg**2
 bes2a(arg)=arg*arg/15.0d0-arg**4/210.0d0
 bes2b(arg)=((3.0d0-arg**2)*sin(arg)-3.0d0*arg*cos(arg))/arg**3
 bes3a(arg)=arg*arg*arg/105.0d0-arg**5/1890.0d0+arg**7/83160.0d0
 bes3b(arg)=(15.d0*sin(arg)-15.d0*arg*cos(arg) &
&            -6.d0*arg**2*sin(arg)+arg**3*cos(arg))/arg**4
 bes0ap(arg)=(-10.d0+arg*arg)*arg/30.0d0
 bes0bp(arg)=-(sin(arg)-arg*cos(arg))/arg**2
 bes1ap(arg)=(10.d0-3.d0*arg*arg)/30.d0
 bes1bp(arg)=((arg*arg-2.d0)*sin(arg)+2.d0*arg*cos(arg))/arg**3
 bes2ap(arg)=(1.d0-arg*arg/7.d0)*2.d0*arg/15.0d0
 bes2bp(arg)=((4.d0*arg*arg-9.d0)*sin(arg)+(9.d0-arg*arg)*arg*cos(arg))/arg**4
 bes3ap(arg)=(1.d0/35-arg*arg/378.d0+arg**4/11880.d0)*arg*arg
 bes3bp(arg)=((-60.d0+27.d0*arg*arg-arg**4)*sin(arg)+(60.d0*arg-7.d0*arg**3)*cos(arg))/arg**5
!Is mesh beginning with r=0 ?
 if (radmesh%rad(1)>1.d-10) then
  write(message, '(a,a,a,a)' ) ch10,&
&   ' psp7nl: BUG -',ch10,&
&   '  Radial mesh cannot begin with r<>0 !'
  call wrtout(06,  message,'COLL')
  call leave_new('COLL')
 end if
!Init. temporary arrays and variables
 call copymesh(radmesh,tmpmesh)
 meshsz=tmpmesh%mesh_size;mmax=meshsz
 allocate(ff(meshsz),rr(meshsz),rr2(meshsz),rrwf(meshsz),rr2wf(meshsz),work(mqgrid))
 rr(:) =tmpmesh%rad(:)
 rr2(:)=two_pi*rr(:)*rr(:)
 argn=two_pi*qgrid(mqgrid)
!Loop on (l,n) projectors
 iln0=0
 do ilmn=1,lmnmax
  iln=indlmn(5,ilmn)
  if(iln>iln0) then
   iln0=iln;ll=indlmn(1,ilmn)

   ir=meshsz;do while (abs(wfll(ir,iln))<eps);ir=ir-1;end do;ir=min(ir+1,meshsz)
   if (ir/=mmax) then
    mmax=ir;call compmesh(tmpmesh,rr(mmax))
   end if

   rrwf(:) =rr (:)*wfll(:,iln)
   rr2wf(:)=rr2(:)*wfll(:,iln)
   if (ll==0) then

!==> l=0 form factor
!  1-Compute f_0(q=0)
   call simp_gen(ffspl(1,1,iln),rrwf,tmpmesh)
!  2-Compute f_0(q>0)
   do iq=2,mqgrid
    arg=two_pi*qgrid(iq)
    do ir=1,mmax
     qr=arg*rr(ir)
     if(qr<1.d-3)then
      bessel=bes0a(qr)
     else
      bessel=bes0b(qr)
     end if
     ff(ir)=bessel*rrwf(ir)
    end do
    call simp_gen(ffspl(iq,1,iln),ff,tmpmesh)
   end do
!  3-Compute first derivative of f_0(q) at q=0
   yp1=zero
!  4-Compute first derivative of f_0(q) at q=qmax
   do ir=1,mmax
    qr=argn*rr(ir)
    if(qr<1.d-3)then
     besselp=bes0ap(qr)
    else
     besselp=bes0bp(qr)
    end if
    ff(ir)=besselp*rr2wf(ir)
   end do
   call simp_gen(ypn,ff,tmpmesh)
!  5-Compute second derivative of f_0(q)
   call spline(qgrid,ffspl(:,1,iln),mqgrid,yp1,ypn,ffspl(:,2,iln),work)
!  Finished if ll=0
  else if (ll==1) then

!==> l=1 form factor
!  1-Compute f_1(q=0)
   ffspl(1,1,iln)=zero
!  2-Compute f_1(q>0)
   do iq=2,mqgrid
    arg=two_pi*qgrid(iq)
    do ir=1,mmax
     qr=arg*rr(ir)
     if(qr<1.d-3)then
      bessel=bes1a(qr)
     else
      bessel=bes1b(qr)
     end if
     ff(ir)=bessel*rrwf(ir)
    end do
    call simp_gen(ffspl(iq,1,iln),ff,tmpmesh)
   end do
!  3-Compute first derivative of f_1(q) at q=0
   call simp_gen(yp1,rr2wf,tmpmesh)
   yp1=yp1/3.d0
!  4-Compute first derivative of f_1(q) at q=qmax
   do ir=1,mmax
    qr=argn*rr(ir)
    if(qr<1.d-3)then
     besselp=bes1ap(qr)
    else
     besselp=bes1bp(qr)
    end if
    ff(ir)=besselp*rr2wf(ir)
   end do
   call simp_gen(ypn,ff,tmpmesh)
!  5-Compute second derivative of f_1(q)
   call spline(qgrid,ffspl(:,1,iln),mqgrid,yp1,ypn,ffspl(:,2,iln),work)
! Finished if ll=1
  else if (ll==2) then

!==> l=2 nonlocal form factor
!  1-Compute f_2(q=0)
   ffspl(1,1,iln)=zero
!  1-Compute f_2(q>0)
   do iq=2,mqgrid
    arg=two_pi*qgrid(iq)
    do ir=1,mmax
     qr=arg*rr(ir)
     if(qr<1.d-3)then
      bessel=bes2a(qr)
     else
      bessel=bes2b(qr)
     end if
     ff(ir)=bessel*rrwf(ir)
    end do
    call simp_gen(ffspl(iq,1,iln),ff,tmpmesh)
   end do
!  3-Compute first derivative of f_2(q) at q=0
   yp1=zero
!  4-Compute first derivative of f_2(q) at q=qmax
   do ir=1,mmax
    qr=argn*rr(ir)
    if(qr<1.d-3)then
     besselp=bes2ap(qr)
    else
     besselp=bes2bp(qr)
    end if
    ff(ir)=besselp*rr2wf(ir)
   end do
   call simp_gen(ypn,ff,tmpmesh)
!  5-Compute second derivative of f_2(q)
   call spline(qgrid,ffspl(:,1,iln),mqgrid,yp1,ypn,ffspl(:,2,iln),work)
!  Finished if ll=2
 else if (ll==3) then
!==> l=3 nonlocal form factor
!  1-Compute f_3(q=0)
   ffspl(1,1,iln)=zero
!  1-Compute f_3(q>0)
   do iq=2,mqgrid
    arg=two_pi*qgrid(iq)
    do ir=1,mmax
     qr=arg*rr(ir)
     if(qr<1.d-3)then
      bessel=bes3a(qr)
     else
      bessel=bes3b(qr)
     end if
     ff(ir)=bessel*rrwf(ir)
    end do
    call simp_gen(ffspl(iq,1,iln),ff,tmpmesh)
   end do
!  3-Compute first derivative of f_3(q) at q=0
   yp1=zero
!  4-Compute first derivative of f_3(q) at q=qmax
   do ir=1,mmax
    qr=argn*rr(ir)
    if(qr<1.d-3)then
     besselp=bes3ap(qr)
    else
     besselp=bes3bp(qr)
    end if
    ff(ir)=besselp*rr2wf(ir)
   end do
   call simp_gen(ypn,ff,tmpmesh)
!  5-Compute second derivative of f_3(q)
   call spline(qgrid,ffspl(:,1,iln),mqgrid,yp1,ypn,ffspl(:,2,iln),work)
!  Finished if ll=3

! Endif condition on ll
  end if
! End loop on (l,n) projectors
  end if
 end do

 deallocate(ff,rr,rr2,rrwf,rr2wf,work)
 deallocate(tmpmesh%rad,tmpmesh%radfact,tmpmesh%simfact)
end subroutine psp7nl
!!***
