double precision function v(dist,reall,rcut,options)
  !La  fonction potentiel
  USE types_def
  implicit none
  TYPE(options_type) :: options
  double precision :: dist,reall,distrl,rcut,vfm_alu
  distrl=dist*reall
  if(options%potopt=="test1") then
     if(distrl > rcut) then
        v=0.0d0
     else
        v=4.d0*(1.d0/distrl**12.d0-1.d0/distrl**6.d0)
     endif
  elseif(options%potopt=="fm_alu")then
     v=vfm_alu(distrl)
  else
     print*,'option inconnue'
     stop 
  endif
  return
end function v
double precision function vprim(dist,reall,rcut,options)
  !La derivee de la fonction potentiel
  USE types_def
  implicit none
  TYPE(options_type) :: options
  double precision :: dist,reall,distrl,rcut,dvfm_alu
  distrl=dist*reall
  if(options%potopt=="test1") then
     if(distrl > rcut) then
        vprim=0.0d0
     else
        vprim=4.d0*(-12.d0/distrl**13.d0+6.d0/distrl**7.d0)*reall
     endif
  elseif(options%potopt=="fm_alu")then
     vprim=dvfm_alu(distrl)*reall
  else
     print*,'option inconnue'
     stop
  endif
  return
end function vprim
