#
# Makefile for the BigDFT library embedded in ABINIT
#

include ../../config.mk

all_targets all bigdft: install
	@echo "$(bigdft_pkg_name) is now ready for use."

uncompress: uncompress-stamp
	@echo "$(bigdft_pkg_name) has been uncompressed."

configure: configure-stamp
	@echo "$(bigdft_pkg_name) has been configured."

build: build-stamp
	@echo "$(bigdft_pkg_name) has been built."

install: install-stamp
	@echo "$(bigdft_pkg_name) has been installed in tmp."

uncompress-stamp:
	tar xf $(abinit_srcdir)/lib/bigdft/$(bigdft_pkg_name).tar
	touch uncompress-stamp

configure-stamp: uncompress
	-mkdir tmp
	cd $(bigdft_pkg_name) && \
	 F90="$(FC) $(EXTRA_FC_LDFLAGS)" \
	 F90FLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_BIGDFT)" \
	 FC="$(FC) $(EXTRA_FC_LDFLAGS)" \
	 FCFLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_BIGDFT)"\
	 ./configure --prefix=$(PWD)/tmp --enable-mpi="$(enable_mpi)" --disable-binaries --disable-libxc --disable-libpoissonsolver
	touch configure-stamp

build-stamp: configure
	cd $(bigdft_pkg_name) && $(MAKE)
	touch build-stamp

install-stamp: build
	cd $(bigdft_pkg_name) && $(MAKE) install
	mv tmp/include/$(fc_type)/* tmp/include
	rmdir tmp/include/$(fc_type)
	touch install-stamp

clean:
	rm -rf $(bigdft_pkg_name) tmp
	rm -f uncompress-stamp configure-stamp build-stamp install-stamp
