/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_PhysicalPackageCapacityAccess.h"

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(PhysicalAsset_CIM_PhysicalElement_load(broker, errorMessage));
	CF_assert(PhysicalAsset_CIM_PhysicalCapacity_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(PhysicalAsset_CIM_PhysicalElement_unload(errorMessage));
	CF_assert(PhysicalAsset_CIM_PhysicalCapacity_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_isAssociated(const Instance& Element, const Instance& Capacity, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PhysicalPackageCapacity>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_enumerateElements(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_enumerateElements(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			Element_classnames[0], Capacity_classnames[0],
			Element_role.c_str(), Capacity_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_referenceElementToCapacity(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PhysicalPackageCapacity& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath Element_objectpath;
	instance.getElement(Element_objectpath);
	Instance Element_instance;
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_getElement(broker, ctx, Element_objectpath, Element_instance, NULL, errorMessage));
	
	Objectpath Capacity_objectpath;
	instance.getCapacity(Capacity_objectpath);
	Instance Capacity_instance;
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_getCapacity(broker, ctx, Capacity_objectpath, Capacity_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_isAssociated(Element_instance, Capacity_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackageCapacity& newInstance, const OpenDRIM_PhysicalPackageCapacity& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackageCapacity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackageCapacity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_associatorElementToCapacity(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Element_instance, const char** properties, vector<Instance>& Capacity_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Capacity_instances;
	if (discriminant=="a")
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_enumerateCapacitys(broker, ctx, Capacity_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_enumerateCapacitys(broker, ctx, Capacity_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_enumerateCapacitys(broker, ctx, Capacity_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Capacity_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_isAssociated(Element_instance, Capacity_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			Capacity_associatedInstances.push_back(Capacity_instances[i]);
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_associatorCapacityToElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capacity_instance, const char** properties, vector<Instance>& Element_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Element_instances;
	if (discriminant=="a")
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_enumerateElements(broker, ctx, Element_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_enumerateElements(broker, ctx, Element_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_enumerateElements(broker, ctx, Element_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Element_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_isAssociated(Element_instances[i], Capacity_instance, isAssociated, errorMessage));
		if (isAssociated)
			Element_associatedInstances.push_back(Element_instances[i]);
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_referenceElementToCapacity(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Element_instance, const vector<Instance>& Capacity_instances, vector<OpenDRIM_PhysicalPackageCapacity>& OpenDRIM_PhysicalPackageCapacity_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Capacity_instances.size(); i++) {
		OpenDRIM_PhysicalPackageCapacity instance;
		instance.setElement(((Instance) Element_instance).getObjectpath());
		instance.setCapacity(((Instance) Capacity_instances[i]).getObjectpath());
		
		OpenDRIM_PhysicalPackageCapacity_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_referenceCapacityToElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capacity_instance, const vector<Instance>& Element_instances, vector<OpenDRIM_PhysicalPackageCapacity>& OpenDRIM_PhysicalPackageCapacity_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Element_instances.size(); i++) {
		OpenDRIM_PhysicalPackageCapacity instance;
		instance.setElement(((Instance) Element_instances[i]).getObjectpath());
		instance.setCapacity(((Instance) Capacity_instance).getObjectpath());
		
		OpenDRIM_PhysicalPackageCapacity_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_populate(OpenDRIM_PhysicalPackageCapacity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

