/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#ifndef OPENDRIM_REGISTEREDDHCPPROFILEACCESS_H_
#define OPENDRIM_REGISTEREDDHCPPROFILEACCESS_H_

#include "DHCP_Common.h"

#include "OpenDRIM_RegisteredDHCPProfile.h"

int DHCP_OpenDRIM_RegisteredDHCPProfile_load(const CMPIBroker* broker, string& errorMessage);

int DHCP_OpenDRIM_RegisteredDHCPProfile_unload(string& errorMessage);

int DHCP_OpenDRIM_RegisteredDHCPProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredDHCPProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_RegisteredDHCPProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredDHCPProfile& instance, const char** properties, string& errorMessage);

int DHCP_OpenDRIM_RegisteredDHCPProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDHCPProfile& newInstance, const OpenDRIM_RegisteredDHCPProfile& oldInstance, const char** properties, string& errorMessage);

int DHCP_OpenDRIM_RegisteredDHCPProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDHCPProfile& instance, string& errorMessage);

int DHCP_OpenDRIM_RegisteredDHCPProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDHCPProfile& instance, string& errorMessage);

int DHCP_OpenDRIM_RegisteredDHCPProfile_populate(OpenDRIM_RegisteredDHCPProfile& instance, string& errorMessage);

#endif /*OPENDRIM_REGISTEREDDHCPPROFILEACCESS_H_*/
