/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.launch;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.debug.launch.CudaGdbLaunchDelegate;
import com.nvidia.cuda.ide.debug.launch.CudaLaunch;
import com.nvidia.cuda.ide.remote.RemoteUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.debug.RemoteCudaDebugServiceFactory;
import com.nvidia.cuda.ide.remote.internal.launch.RemoteLaunchLookupDirector;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.RemoteConnectionToolkitWizard;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import com.nvidia.cuda.ide.remote.ui.launch.RemoteLaunchHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RSEHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;

public final class RunCudaGdbServerDelegate
extends CudaGdbLaunchDelegate {
    public static final String PREEMPTION_CONNECTION_PROPERTY = "preemption";

    private static Map<String, String> getEnvironmentMap(ILaunchConfiguration config) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        String[] environment = manager.getEnvironment(config);
        if (environment != null) {
            HashMap<String, String> env = new HashMap<String, String>(environment.length);
            String[] stringArray = environment;
            int n = environment.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!CoreUtil.isNullOrEmpty((String)string)) {
                    String[] var = string.split("=");
                    env.put(var[0], var.length > 0 ? var[1] : null);
                }
                ++n2;
            }
            return env;
        }
        return null;
    }

    private void addRemoteShellListener(IHostShell remoteShell, final boolean[] gdbServerReady) {
        remoteShell.addOutputListener(new IHostShellOutputListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void shellOutputChanged(IHostShellChangeEvent event) {
                IHostOutput[] iHostOutputArray = event.getLines();
                int n = iHostOutputArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IHostOutput line = iHostOutputArray[n2];
                    if (line.getString().contains("Listening on port")) {
                        boolean[] blArray = gdbServerReady;
                        synchronized (gdbServerReady) {
                            gdbServerReady[0] = true;
                            gdbServerReady.notifyAll();
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            break;
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    private String appAndArguments(String remoteExePath, ILaunchConfiguration config) throws CoreException {
        String app = RemoteUtil.quote((String)remoteExePath);
        String arguments = this.getProgramArguments(config);
        if (!CoreUtil.isNullOrEmpty((String)arguments)) {
            return String.valueOf(app) + " " + arguments;
        }
        return app;
    }

    protected boolean canTogglePreemption() {
        return false;
    }

    protected DsfSourceLookupDirector createDsfSourceLocator(ILaunchConfiguration configuration, DsfSession session) throws CoreException {
        return new RemoteLaunchLookupDirector(session);
    }

    private String gdbServer(ILaunchConfiguration config, boolean preemption, ICudaToolkit toolkit) throws CoreException {
        StringBuilder command = new StringBuilder();
        command.append(RemoteUtil.quote((String)toolkit.getToolPath(ICudaToolkit.Tool.GdbServer)));
        command.append(preemption ? " --cuda-use-lockfile=0 " : " ");
        String gdbserverPortNumber = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
        command.append(":").append(gdbserverPortNumber).append(" ");
        return command.toString();
    }

    private IRemoteConnection getConnection(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection connection = RemoteLaunchHelper.getRemoteConnection(config, monitor);
        if (connection == null) {
            RemoteLaunchHelper.fail("No connection configured", new Object[0]);
        }
        return connection;
    }

    protected String getPluginID() {
        return "com.nvidia.cuda.ide.remote";
    }

    protected String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    private ICudaToolkit getToolkit(final IRemoteConnection connection) throws CoreException {
        ICudaToolkit tk;
        block4: {
            ICudaToolkit toolkit = (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                    return service.getToolkit(connection.getName());
                }
            });
            if (toolkit != null) {
                return toolkit;
            }
            try {
                tk = (ICudaToolkit)SWTUtil.call((Callable)new Callable<ICudaToolkit>(){

                    @Override
                    public ICudaToolkit call() throws Exception {
                        RemoteConnectionToolkitWizard wizard = new RemoteConnectionToolkitWizard(connection);
                        wizard.setWarning("Please setup a toolkit location for connection %s", new Object[]{connection});
                        if (new WizardDialog(SWTUtil.getShell(), (IWizard)wizard).open() == 0) {
                            return wizard.getCudaToolkit();
                        }
                        return null;
                    }
                });
                if (tk != null) break block4;
                RemoteLaunchHelper.fail("Toolkit for connection %s is not configured", connection);
                return null;
            }
            catch (Exception e) {
                RemoteLaunchHelper.fail(e, "Error setting up toolkit", new Object[0]);
                return null;
            }
        }
        return tk;
    }

    protected boolean isPreemption(String filter) {
        return false;
    }

    private static ICudaRemoteDebugConstants.ExecutableTransferMode getTransferMode(ILaunchConfiguration config) throws CoreException {
        String noTransferName = ICudaRemoteDebugConstants.ExecutableTransferMode.Notransfer.name();
        String transfer = config.getAttribute(ICudaRemoteDebugConstants.ATTRIBUTE_EXECUTABLE_TRANSFER, noTransferName);
        return ICudaRemoteDebugConstants.ExecutableTransferMode.valueOf(transfer);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.launchHelper(config, mode, launch, monitor);
        }
        catch (CoreException ex) {
            if (ex.getStatus().getSeverity() == 8) {
                throw new OperationCanceledException(ex.getStatus().getMessage());
            }
            throw ex;
        }
    }

    private void launchHelper(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean tempPath;
        IPath exePath;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format("Launching %s", config.getName()), (int)320);
        RemoteLaunchHelper.initRSE((IProgressMonitor)subMonitor.newChild(10));
        IRemoteConnection connection = this.getConnection(config, (IProgressMonitor)subMonitor.newChild(10));
        ICudaRemoteDebugConstants.ExecutableTransferMode transferMode = RunCudaGdbServerDelegate.getTransferMode(config);
        if (transferMode == ICudaRemoteDebugConstants.ExecutableTransferMode.Download) {
            if (!"run".equals(mode)) {
                exePath = RemoteLaunchHelper.downloadExecutable(connection, config, (IProgressMonitor)subMonitor.newChild(100));
                if (exePath == null) {
                    String remotePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "");
                    throw CoreUtil.coreException((String)"Unable to download %s from remote system", (Object[])new Object[]{remotePath});
                }
                tempPath = true;
            } else {
                exePath = new Path("");
                tempPath = false;
            }
        } else {
            tempPath = false;
            exePath = this.checkBinaryDetails(config);
            if (exePath != null && ICudaRemoteDebugConstants.ExecutableTransferMode.Upload == transferMode) {
                exePath = RemoteLaunchHelper.uploadExecutable(connection, config, exePath, (IProgressMonitor)subMonitor.newChild(100));
            } else {
                subMonitor.worked(100);
            }
        }
        Process remoteShellProcess = null;
        try {
            try {
                String remoteExePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, null);
                if (exePath != null && !CoreUtil.isNullOrEmpty((String)remoteExePath)) {
                    if ("run".equals(mode)) {
                        remoteShellProcess = this.runApplication(remoteExePath, connection, config, launch, (IProgressMonitor)subMonitor.newChild(200));
                    } else {
                        remoteShellProcess = this.startRemoteServer(remoteExePath, config, launch, connection, exePath, tempPath, (IProgressMonitor)subMonitor.newChild(100));
                        super.launch(config, mode, launch, (IProgressMonitor)subMonitor.newChild(100));
                    }
                } else {
                    launch.terminate();
                }
            }
            catch (CoreException ex) {
                if (remoteShellProcess != null) {
                    remoteShellProcess.destroy();
                }
                throw ex;
            }
        }
        finally {
            monitor.done();
        }
    }

    private IHostShell launchRemoteShell(ILaunchConfiguration config, String command, IProgressMonitor monitor) throws Exception {
        return RSEHelper.execCmdInRemoteShell((ILaunchConfiguration)config, (String)"", (String)"/bin/sh", (String)String.format("-c %s", RemoteUtil.quote((String)command)), (IProgressMonitor)monitor);
    }

    private String preLaunchSteps(String remoteExePath, String prelaunch, IRemoteConnection connection, ILaunchConfiguration config, ICudaToolkit toolkit) throws CoreException {
        StringBuilder command = new StringBuilder();
        String workingDirectory = config.getAttribute(ICudaRemoteDebugConstants.ATTRIBUTE_REMOTE_WORKING_DIR, new Path(remoteExePath).removeLastSegments(1).toString());
        command.append(RemoteUtil.cd((IRemoteConnection)connection, (String)workingDirectory));
        command.append(RemoteUtil.setEnvironment((IRemoteConnection)connection, (ICudaToolkit)toolkit, RunCudaGdbServerDelegate.getEnvironmentMap(config)));
        if (!CoreUtil.isNullOrEmpty((String)prelaunch)) {
            command.append(prelaunch).append(";");
        }
        return command.toString();
    }

    protected Process runApplication(String remoteExePath, IRemoteConnection connection, ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ICudaToolkit toolkit = this.getToolkit(connection);
        StringBuilder command = new StringBuilder();
        command.append(this.preLaunchSteps(remoteExePath, null, connection, config, toolkit));
        command.append(this.appAndArguments(remoteExePath, config));
        try {
            IHostShell shell = this.launchRemoteShell(config, command.toString(), monitor);
            HostShellProcessAdapter processAdapter = new HostShellProcessAdapter(shell);
            DebugPlugin.newProcess((ILaunch)launch, (Process)processAdapter, (String)Messages.RemoteRunLaunchDelegate_RemoteShell);
            return processAdapter;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            RSEHelper.abort((String)"Remote launch failed", (Throwable)e, (int)0);
            return null;
        }
    }

    private Process startRemoteServer(String remoteExePath, ILaunchConfiguration config, ILaunch launch, IRemoteConnection connection, IPath exePath, boolean tempExe, IProgressMonitor mon) throws CoreException {
        RemoteShellProcessAdapter remoteShellProcess;
        IHostShell remoteShell;
        boolean preemption = connection.getProperty(PREEMPTION_CONNECTION_PROPERTY, false);
        if (launch instanceof CudaLaunch) {
            ((CudaLaunch)launch).setPreemptionEnabled(preemption);
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)40);
        ICudaToolkit toolkit = this.getToolkit(connection);
        StringBuilder command = new StringBuilder();
        String prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
        command.append(this.preLaunchSteps(remoteExePath, prelaunchCmd, connection, config, toolkit));
        command.append(this.gdbServer(config, preemption, toolkit));
        command.append(this.appAndArguments(remoteExePath, config));
        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_9);
        try {
            remoteShell = this.launchRemoteShell(config, command.toString(), (IProgressMonitor)monitor.newChild(40));
        }
        catch (Exception e1) {
            RSEHelper.abort((String)e1.getMessage(), (Throwable)e1, (int)150);
            throw new IllegalStateException("Should not return from RSEHelper::abort");
        }
        boolean[] gdbServerReady = new boolean[1];
        this.addRemoteShellListener(remoteShell, gdbServerReady);
        GdbLaunch l = (GdbLaunch)launch;
        try {
            remoteShellProcess = new RemoteShellProcessAdapter(remoteShell, l);
        }
        catch (Exception e) {
            RSEHelper.abort((String)Messages.RemoteRunLaunchDelegate_7, (Throwable)e, (int)150);
            throw new IllegalStateException("Should not return from RSEHelper::abort");
        }
        IProcess iProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)((Object)remoteShellProcess), (String)Messages.RemoteRunLaunchDelegate_RemoteShell);
        this.waitForServerToStart((IProgressMonitor)monitor, l, gdbServerReady, (Process)((Object)remoteShellProcess), iProcess);
        RemoteLaunchHelper.fillServerProperties(config, exePath, tempExe);
        return remoteShellProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForServerToStart(IProgressMonitor monitor, final GdbLaunch l, boolean[] gdbServerReady, Process remoteShellProcess, IProcess iProcess) throws CoreException {
        boolean[] blArray = gdbServerReady;
        synchronized (gdbServerReady) {
            while (true) {
                if (gdbServerReady[0]) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
                if (monitor.isCanceled() || iProcess.isTerminated()) {
                    if (remoteShellProcess != null) {
                        remoteShellProcess.destroy();
                    }
                    try {
                        l.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                l.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                    RSEHelper.abort((String)Messages.RemoteGdbLaunchDelegate_gdbserverFailedToStartErrorMessage, null, (int)106);
                }
                try {
                    gdbServerReady.wait(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected IDsfDebugServicesFactory newServiceFactory(String version) {
        return new RemoteCudaDebugServiceFactory(version);
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = this.verifyCProject(config);
        IPath exePath = LaunchUtils.verifyProgramPath((ILaunchConfiguration)config, (ICProject)project);
        LaunchUtils.verifyBinary((ILaunchConfiguration)config, (IPath)exePath, (boolean)true);
        return exePath;
    }

    private static final class RemoteShellProcessAdapter
    extends HostShellProcessAdapter {
        private final GdbLaunch l;

        private RemoteShellProcessAdapter(IHostShell hostShell, GdbLaunch l) throws IOException {
            super(hostShell);
            this.l = l;
        }

        public synchronized void destroy() {
            final DsfSession session = this.l.getSession();
            if (session != null) {
                try {
                    session.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            DsfServicesTracker tracker = new DsfServicesTracker(Activator.getDefault().getBundle().getBundleContext(), session.getId());
                            IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                            if (control != null) {
                                control.terminate((RequestMonitor)new ImmediateRequestMonitor());
                            }
                            tracker.dispose();
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
            super.destroy();
        }
    }
}

