/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.view;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;

public final class ToggleLinkSelectionAction
extends Action
implements IAction {
    private final AtomicBoolean ignoreOnce = new AtomicBoolean(false);
    private final IPresentationContext context;

    public ToggleLinkSelectionAction(IPresentationContext context) {
        super("Link Selection", 2);
        this.setText("Link Selection");
        this.setToolTipText("Link selection");
        this.setDescription("Link selection");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
        this.context = context;
        context.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("link.selection") && !ToggleLinkSelectionAction.this.ignoreOnce.compareAndSet(true, false)) {
                    ToggleLinkSelectionAction.this.updateToggle();
                }
            }
        });
        this.updateToggle();
    }

    public void run() {
        this.ignoreOnce.set(true);
        if (this.isChecked()) {
            this.context.setProperty("link.selection", null);
        } else {
            this.context.setProperty("link.selection", (Object)false);
        }
    }

    protected void updateToggle() {
        boolean selectionSet;
        Object property = this.context.getProperty("link.selection");
        boolean bl = selectionSet = !Boolean.FALSE.equals(property);
        if (selectionSet != this.isChecked()) {
            this.setChecked(selectionSet);
        }
    }
}

