/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui;

import java.util.Collection;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public final class TerminateCudaGdbLaunchesPromptDialog
extends MessageDialog {
    private final Collection<ILaunch> launches;
    private TableViewer viewer;

    public TerminateCudaGdbLaunchesPromptDialog(IShellProvider parentShell, Collection<ILaunch> launches) {
        super(parentShell.getShell(), "Device in Use", null, "Only one cuda-gdb instance can use CUDA device.\nDo you want to terminate these launches?", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.launches = launches;
    }

    protected Control createCustomArea(Composite parent) {
        if (this.launches.size() == 1) {
            Composite root = (Composite)super.createCustomArea(parent);
            this.messageLabel.setText(String.format("Another cuda-gdb instance (\"%s\") may already be using device.", this.launches.iterator().next().getLaunchConfiguration().getName()));
            return root;
        }
        this.messageLabel.setText("Following cuda-gdb instances are currently running. Only one cuda-gdb instance can use a device.");
        Table table = new Table(parent, 2048);
        table.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final ILabelProvider delegate = DebugUITools.newDebugModelPresentation();

            public String getText(Object element) {
                return ((ILaunch)element).getLaunchConfiguration().getName();
            }

            public Image getImage(Object element) {
                return this.delegate.getImage(element);
            }
        });
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput(this.launches);
        return table;
    }
}

