/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.state;

import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public abstract class AbstractCudaStateManager {
    protected abstract IDMContext createDMContext(IDMContext var1, CudaCoord var2) throws CudaException;

    protected IDMContext[] getActiveElements(IDMContext parent, boolean fillGaps, final ICoordSorter sorter, final CudaDim dim, Iterator<Long> keySet) throws CudaException {
        if (parent == null || dim == null) {
            return new IDMContext[0];
        }
        TreeSet<CudaCoord> coords = new TreeSet<CudaCoord>(new Comparator<CudaCoord>(){

            @Override
            public int compare(CudaCoord o1, CudaCoord o2) {
                long ord2;
                long ord1 = sorter.ordinal(dim, o1);
                return ord1 < (ord2 = sorter.ordinal(dim, o2)) ? -1 : (ord1 > ord2 ? 1 : 0);
            }
        });
        while (keySet.hasNext()) {
            long n = keySet.next();
            coords.add(dim.getCoord(n));
        }
        long inactiveStart = 0L;
        ArrayList<IDMContext> res = new ArrayList<IDMContext>(coords.size() + 2);
        for (CudaCoord coord : coords) {
            long n = sorter.ordinal(dim, coord);
            if (fillGaps && n != inactiveStart) {
                res.add(new RangeContext(parent, inactiveStart, n - 1L, sorter));
            }
            inactiveStart = n + 1L;
            res.add(this.createDMContext(parent, coord));
        }
        int count = dim.elementCount();
        if (fillGaps && inactiveStart < (long)count) {
            Object ctx = inactiveStart == (long)(count - 1) ? this.createDMContext(parent, dim.getCoord(inactiveStart)) : new RangeContext(parent, inactiveStart, count - 1, sorter);
            res.add((IDMContext)ctx);
        }
        return res.toArray(new IDMContext[res.size()]);
    }
}

