/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.query;

import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

public final class Dim3Filter {
    private static final CudaCoord[] EMPTY_ARRAY = new CudaCoord[0];
    private final int x;
    private final int y;
    private final int z;

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dim3Filter other = (Dim3Filter)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public Dim3Filter(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Dim3Filter(CudaCoord c) {
        this(c.getX(), c.getY(), c.getZ());
    }

    public String toString() {
        return String.format("(%s, %s, %s)", this.adjust(this.x), this.adjust(this.y), this.adjust(this.z));
    }

    private String adjust(int n) {
        return n < 0 ? "*" : String.valueOf(n);
    }

    public boolean isAllElements() {
        return this.x == -1 & this.y == -1 && this.z == -1;
    }

    public boolean matches(Object o) {
        if (o instanceof CudaDim) {
            CudaDim dim = (CudaDim)o;
            return this.x < dim.getX() && this.y < dim.getY() && this.z < dim.getZ();
        }
        if (o instanceof CudaCoord) {
            CudaCoord cudaCoord = (CudaCoord)o;
            return !(this.x >= 0 && this.x != cudaCoord.getX() || this.y >= 0 && this.y != cudaCoord.getY() || this.z >= 0 && this.z != cudaCoord.getZ());
        }
        return false;
    }

    public CudaCoord[] getAllCoords(CudaDim gridDim) {
        Collection<Object> coords;
        if (this.x < 0) {
            coords = new TreeSet();
            int i = 0;
            while (i < gridDim.getX()) {
                coords.addAll(this.getY(i, gridDim));
                ++i;
            }
        } else if (this.x < gridDim.getX()) {
            coords = this.getY(this.x, gridDim);
        } else {
            return EMPTY_ARRAY;
        }
        return coords.toArray(new CudaCoord[coords.size()]);
    }

    private Collection<CudaCoord> getY(int x, CudaDim gridDim) {
        if (this.y < 0) {
            TreeSet<CudaCoord> coords = new TreeSet<CudaCoord>();
            int i = 0;
            while (i < gridDim.getY()) {
                coords.addAll(this.getZ(x, i, gridDim));
                ++i;
            }
            return coords;
        }
        if (this.y < gridDim.getY()) {
            return this.getZ(x, this.y, gridDim);
        }
        return Collections.emptyList();
    }

    private Collection<CudaCoord> getZ(int x, int y, CudaDim gridDim) {
        if (this.z < 0) {
            TreeSet<CudaCoord> coords = new TreeSet<CudaCoord>();
            int i = 0;
            while (i < gridDim.getZ()) {
                coords.add(new CudaCoord(x, y, i));
                ++i;
            }
            return coords;
        }
        if (this.z < gridDim.getZ()) {
            return Collections.singleton(new CudaCoord(x, y, this.z));
        }
        return Collections.emptyList();
    }
}

