/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CudaCoord
implements Comparable<CudaCoord>,
Serializable {
    private static final Pattern PARSER = Pattern.compile("\\(?(\\d*)\\s*,\\s*(\\d*)\\s*,\\s*(\\d+)\\s*\\)?");
    private static final long serialVersionUID = 1648968913115308537L;
    public static final CudaCoord ZERO = new CudaCoord(0, 0, 0);
    private final int x;
    private final int y;
    private final int z;

    public CudaCoord(int x) {
        this(x, 0, 0);
    }

    public CudaCoord(int x, int y) {
        this(x, y, 0);
    }

    public CudaCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public static final CudaCoord parse(String string) {
        Matcher matcher = PARSER.matcher(string);
        if (matcher.matches()) {
            int x = Integer.parseInt(matcher.group(1));
            int y = Integer.parseInt(matcher.group(2));
            int z = Integer.parseInt(matcher.group(3));
            return new CudaCoord(x, y, z);
        }
        return null;
    }

    @Override
    public int compareTo(CudaCoord o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.z > o.z) {
            return 1;
        }
        if (this.z < o.z) {
            return -1;
        }
        if (this.y > o.y) {
            return 1;
        }
        if (this.y < o.y) {
            return -1;
        }
        if (this.x > o.x) {
            return 1;
        }
        if (this.x < o.x) {
            return -1;
        }
        throw new IllegalStateException("Equals is broken");
    }

    public int hashCode() {
        return (this.x << 20) + (this.y << 10) + this.z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CudaCoord other = (CudaCoord)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return String.format("(%d,%d,%d)", this.x, this.y, this.z);
    }
}

