/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IPathEntryContainerExtension;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

@Deprecated
public class CPElement {
    public static final String SOURCEATTACHMENT = "sourcepath";
    public static final String SOURCEATTACHMENTROOT = "rootpath";
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUDE = "includepath";
    public static final String LIBRARY = "librarypath";
    public static final String SYSTEM_INCLUDE = "systeminclude";
    public static final String MACRO_NAME = "macroname";
    public static final String MACRO_VALUE = "macrovalue";
    public static final String BASE_REF = "base-ref";
    public static final String BASE = "base-path";
    public static final String PARENT = "parent";
    public static final String PARENT_CONTAINER = "parent-container";
    public static final String INCLUDE_FILE = "includefile";
    public static final String MACROS_FILE = "macrosfile";
    private final int fEntryKind;
    private final IPath fPath;
    private final ICProject fCProject;
    private final IResource fResource;
    private final ArrayList<Object> fChildren = new ArrayList(1);
    private boolean fIsExported;
    private IPathEntry fCachedEntry;
    private CPElement Inherited;
    private IStatus fStatus;

    public CPElement(CPElement element, IPath path, IResource res) {
        this(element.getCProject(), element.getEntryKind(), path, res);
        this.setExported(element.isExported());
        this.fChildren.clear();
        int i = 0;
        while (i < element.fChildren.size()) {
            CPElementAttribute attrib = (CPElementAttribute)element.fChildren.get(i);
            this.fChildren.add(new CPElementAttribute(this, attrib.getKey(), attrib.getValue()));
            ++i;
        }
        this.Inherited = element;
    }

    public CPElement(ICProject project, int entryKind, IPath path, IResource res) {
        this.fCProject = project;
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fResource = res;
        this.fIsExported = false;
        this.fCachedEntry = null;
        switch (entryKind) {
            case 128: {
                this.createAttributeElement(EXCLUSION, new Path[0]);
                break;
            }
            case 8: {
                this.createAttributeElement(EXCLUSION, new Path[0]);
                break;
            }
            case 1: {
                this.createAttributeElement(LIBRARY, new Path(""));
                this.createAttributeElement(SOURCEATTACHMENT, null);
                this.createAttributeElement(BASE_REF, new Path(""));
                this.createAttributeElement(BASE, new Path(""));
                break;
            }
            case 16: {
                this.createAttributeElement(INCLUDE, new Path(""));
                this.createAttributeElement(EXCLUSION, new Path[0]);
                this.createAttributeElement(SYSTEM_INCLUDE, true);
                this.createAttributeElement(BASE_REF, new Path(""));
                this.createAttributeElement(BASE, new Path(""));
                break;
            }
            case 256: {
                this.createAttributeElement(INCLUDE_FILE, new Path(""));
                this.createAttributeElement(EXCLUSION, new Path[0]);
                this.createAttributeElement(BASE_REF, new Path(""));
                this.createAttributeElement(BASE, new Path(""));
                break;
            }
            case 64: {
                this.createAttributeElement(MACRO_NAME, "");
                this.createAttributeElement(MACRO_VALUE, "");
                this.createAttributeElement(EXCLUSION, new Path[0]);
                this.createAttributeElement(BASE_REF, new Path(""));
                this.createAttributeElement(BASE, new Path(""));
                break;
            }
            case 512: {
                this.createAttributeElement(MACROS_FILE, new Path(""));
                this.createAttributeElement(EXCLUSION, new Path[0]);
                this.createAttributeElement(BASE_REF, new Path(""));
                this.createAttributeElement(BASE, new Path(""));
                break;
            }
            case 32: {
                try {
                    IPathEntryContainer container = CoreModel.getPathEntryContainer((IPath)this.fPath, (ICProject)this.fCProject);
                    if (container == null) break;
                    IPathEntry[] entries = null;
                    if (container instanceof IPathEntryContainerExtension && res instanceof IFile) {
                        IPathEntryContainerExtension extContainer = (IPathEntryContainerExtension)container;
                        entries = extContainer.getPathEntries(res.getFullPath(), 848);
                    } else {
                        entries = container.getPathEntries();
                    }
                    IPathEntry[] iPathEntryArray = entries;
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPathEntry entrie = iPathEntryArray[n2];
                        CPElement curr = CPElement.createFromExisting(entrie, (ICElement)this.fCProject);
                        curr.createAttributeElement(PARENT_CONTAINER, this);
                        CPElementGroup group = new CPElementGroup(this, curr.getEntryKind());
                        int indx = this.fChildren.indexOf(group);
                        if (indx == -1) {
                            this.fChildren.add(group);
                        } else {
                            group = (CPElementGroup)this.fChildren.get(indx);
                        }
                        group.addChild(curr);
                        ++n2;
                    }
                }
                catch (CModelException cModelException) {}
                break;
            }
        }
    }

    public IPathEntry getPathEntry() {
        if (this.Inherited != null) {
            return null;
        }
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newPathEntry();
        }
        return this.fCachedEntry;
    }

    private IPathEntry newPathEntry() {
        IPath[] exclusionPattern = (IPath[])this.getAttribute(EXCLUSION);
        IPath base = (IPath)this.getAttribute(BASE);
        IPath baseRef = (IPath)this.getAttribute(BASE_REF);
        switch (this.fEntryKind) {
            case 128: {
                return CoreModel.newOutputEntry((IPath)this.fPath, (IPath[])exclusionPattern);
            }
            case 8: {
                return CoreModel.newSourceEntry((IPath)this.fPath, (IPath[])exclusionPattern);
            }
            case 1: {
                IPath libraryPath = (IPath)this.getAttribute(LIBRARY);
                IPath attach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                if (!baseRef.isEmpty()) {
                    return CoreModel.newLibraryRefEntry((IPath)this.fPath, (IPath)baseRef, (IPath)libraryPath);
                }
                return CoreModel.newLibraryEntry((IPath)this.fPath, (IPath)base, (IPath)libraryPath, (IPath)attach, null, null, (boolean)this.isExported());
            }
            case 4: {
                return CoreModel.newProjectEntry((IPath)this.fPath, (boolean)this.isExported());
            }
            case 32: {
                return CoreModel.newContainerEntry((IPath)this.fPath, (boolean)this.isExported());
            }
            case 16: {
                IPath include = (IPath)this.getAttribute(INCLUDE);
                if (!baseRef.isEmpty()) {
                    return CoreModel.newIncludeRefEntry((IPath)this.fPath, (IPath)baseRef, (IPath)include);
                }
                return CoreModel.newIncludeEntry((IPath)this.fPath, (IPath)base, (IPath)include, (boolean)((Boolean)this.getAttribute(SYSTEM_INCLUDE)), (IPath[])exclusionPattern, (boolean)this.isExported());
            }
            case 256: {
                IPath includeFile = (IPath)this.getAttribute(INCLUDE_FILE);
                return CoreModel.newIncludeFileEntry((IPath)this.fPath, (IPath)baseRef, (IPath)base, (IPath)includeFile, (IPath[])exclusionPattern, (boolean)this.isExported());
            }
            case 64: {
                String macroName = (String)this.getAttribute(MACRO_NAME);
                String macroValue = (String)this.getAttribute(MACRO_VALUE);
                if (!baseRef.isEmpty()) {
                    return CoreModel.newMacroRefEntry((IPath)this.fPath, (IPath)baseRef, (String)macroName);
                }
                return CoreModel.newMacroEntry((IPath)this.fPath, (String)macroName, (String)macroValue, (IPath[])exclusionPattern, (boolean)this.isExported());
            }
            case 512: {
                IPath macrosFile = (IPath)this.getAttribute(MACROS_FILE);
                return CoreModel.newMacroFileEntry((IPath)this.fPath, (IPath)baseRef, (IPath)base, (IPath)macrosFile, (IPath[])exclusionPattern, (boolean)this.isExported());
            }
        }
        return null;
    }

    public static StringBuffer appendEncodePath(IPath path, StringBuffer buf) {
        if (path != null) {
            String str = path.toString();
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf.append(';');
    }

    public StringBuffer appendEncodedSettings(StringBuffer buf) {
        buf.append(this.fEntryKind).append(';');
        CPElement.appendEncodePath(this.fPath, buf).append(';');
        buf.append((Object)this.fIsExported).append(';');
        block0 : switch (this.fEntryKind) {
            case 8: 
            case 16: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                IPath[] exclusion = (IPath[])this.getAttribute(EXCLUSION);
                buf.append('[').append(exclusion.length).append(']');
                IPath[] iPathArray = exclusion;
                int n = exclusion.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath element = iPathArray[n2];
                    CPElement.appendEncodePath(element, buf);
                    ++n2;
                }
                switch (this.fEntryKind) {
                    case 16: {
                        IPath baseRef = (IPath)this.getAttribute(BASE_REF);
                        CPElement.appendEncodePath(baseRef, buf);
                        IPath base = (IPath)this.getAttribute(BASE);
                        CPElement.appendEncodePath(base, buf);
                        IPath include = (IPath)this.getAttribute(INCLUDE);
                        CPElement.appendEncodePath(include, buf);
                        break block0;
                    }
                    case 256: {
                        IPath baseRef = (IPath)this.getAttribute(BASE_REF);
                        CPElement.appendEncodePath(baseRef, buf);
                        IPath base = (IPath)this.getAttribute(BASE);
                        CPElement.appendEncodePath(base, buf);
                        IPath includeFile = (IPath)this.getAttribute(INCLUDE_FILE);
                        CPElement.appendEncodePath(includeFile, buf);
                        break block0;
                    }
                    case 64: {
                        IPath baseRef = (IPath)this.getAttribute(BASE_REF);
                        CPElement.appendEncodePath(baseRef, buf);
                        IPath base = (IPath)this.getAttribute(BASE);
                        CPElement.appendEncodePath(base, buf);
                        String symbol = (String)this.getAttribute(MACRO_NAME);
                        buf.append(symbol).append(';');
                        break block0;
                    }
                    case 512: {
                        IPath baseRef = (IPath)this.getAttribute(BASE_REF);
                        CPElement.appendEncodePath(baseRef, buf);
                        IPath base = (IPath)this.getAttribute(BASE);
                        CPElement.appendEncodePath(base, buf);
                        IPath macrosFile = (IPath)this.getAttribute(MACROS_FILE);
                        CPElement.appendEncodePath(macrosFile, buf);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                IPath baseRef = (IPath)this.getAttribute(BASE_REF);
                CPElement.appendEncodePath(baseRef, buf);
                IPath base = (IPath)this.getAttribute(BASE);
                CPElement.appendEncodePath(base, buf);
                IPath sourceAttach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                CPElement.appendEncodePath(sourceAttach, buf);
                IPath library = (IPath)this.getAttribute(LIBRARY);
                CPElement.appendEncodePath(library, buf);
                break;
            }
        }
        buf.setLength(buf.length() - 1);
        return buf;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public CPElement getParentContainer() {
        CPElementAttribute attribute = this.findAttributeElement(PARENT_CONTAINER);
        if (attribute != null) {
            return (CPElement)attribute.getValue();
        }
        return null;
    }

    public void setParent(CPElementGroup group) {
        CPElementAttribute attribute = this.findAttributeElement(PARENT);
        if (attribute == null) {
            if (group != null) {
                this.createAttributeElement(PARENT, group);
            }
        } else {
            attribute.setValue(group);
        }
    }

    public CPElementGroup getParent() {
        CPElementAttribute attribute = this.findAttributeElement(PARENT);
        if (attribute != null) {
            return (CPElementGroup)attribute.getValue();
        }
        return null;
    }

    public CPElementAttribute setAttribute(String key, Object value) {
        CPElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        attribute.setValue(value);
        this.attributeChanged(key);
        return attribute;
    }

    private CPElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            CPElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPElementAttribute && key.equals((elem = (CPElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        CPElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    private void createAttributeElement(String key, Object value) {
        this.fChildren.add(new CPElementAttribute(this, key, value));
    }

    public Object[] getChildren() {
        switch (this.fEntryKind) {
            case 8: 
            case 16: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                if (this.getInherited() != null || this.getParentContainer() != null) break;
                return new Object[]{this.findAttributeElement(EXCLUSION)};
            }
            case 32: {
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while (i < this.fChildren.size()) {
                    Object curr = this.fChildren.get(i);
                    if (curr instanceof CPElementGroup) {
                        list.add(curr);
                    }
                    ++i;
                }
                return list.toArray();
            }
        }
        return new Object[0];
    }

    private void attributeChanged(String key) {
        this.fCachedEntry = null;
        this.fStatus = null;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            CPElement elem = (CPElement)other;
            if (elem.fEntryKind != this.fEntryKind || !elem.fPath.equals((Object)this.fPath)) {
                return false;
            }
            switch (this.fEntryKind) {
                case 1: {
                    return this.getAttribute(LIBRARY).equals(elem.getAttribute(LIBRARY)) && this.getAttribute(BASE).equals(elem.getAttribute(BASE)) && this.getAttribute(BASE_REF).equals(elem.getAttribute(BASE_REF));
                }
                case 16: {
                    return this.getAttribute(INCLUDE).equals(elem.getAttribute(INCLUDE)) && this.getAttribute(BASE_REF).equals(elem.getAttribute(BASE_REF)) && this.getAttribute(BASE).equals(elem.getAttribute(BASE));
                }
                case 256: {
                    return this.getAttribute(INCLUDE_FILE).equals(elem.getAttribute(INCLUDE_FILE)) && this.getAttribute(BASE_REF).equals(elem.getAttribute(BASE_REF)) && this.getAttribute(BASE).equals(elem.getAttribute(BASE));
                }
                case 64: {
                    return this.getAttribute(MACRO_NAME).equals(elem.getAttribute(MACRO_NAME)) && this.getAttribute(BASE_REF).equals(elem.getAttribute(BASE_REF)) && this.getAttribute(BASE).equals(elem.getAttribute(BASE));
                }
                case 512: {
                    return this.getAttribute(MACROS_FILE).equals(elem.getAttribute(MACROS_FILE)) && this.getAttribute(BASE_REF).equals(elem.getAttribute(BASE_REF)) && this.getAttribute(BASE).equals(elem.getAttribute(BASE));
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.fPath.hashCode() + this.fEntryKind;
        switch (this.fEntryKind) {
            case 1: {
                hashCode = hashCode * 89 + this.getAttribute(LIBRARY).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE_REF).hashCode();
                break;
            }
            case 16: {
                hashCode = hashCode * 89 + this.getAttribute(INCLUDE).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE_REF).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE).hashCode();
                break;
            }
            case 256: {
                hashCode = hashCode * 89 + this.getAttribute(INCLUDE_FILE).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE_REF).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE).hashCode();
                break;
            }
            case 64: {
                hashCode = hashCode * 89 + this.getAttribute(MACRO_NAME).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE_REF).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE).hashCode();
                break;
            }
            case 512: {
                hashCode = hashCode * 89 + this.getAttribute(MACROS_FILE).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE_REF).hashCode();
                hashCode = hashCode * 89 + this.getAttribute(BASE).hashCode();
            }
        }
        return hashCode;
    }

    public String toString() {
        return this.getPathEntry().toString();
    }

    public IStatus getStatus() {
        if (this.Inherited != null) {
            return this.Inherited.getStatus();
        }
        if (this.fStatus == null) {
            this.fStatus = Status.OK_STATUS;
            IResource res = null;
            IWorkspaceRoot root = CUIPlugin.getWorkspace().getRoot();
            IPathEntry entry = this.getPathEntry();
            switch (this.getEntryKind()) {
                case 32: {
                    try {
                        if (CoreModel.getPathEntryContainer((IPath)this.fPath, (ICProject)this.fCProject) != null) break;
                        this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_pathContainerMissing, null);
                    }
                    catch (CModelException cModelException) {}
                    break;
                }
                case 1: {
                    if (((ILibraryEntry)entry).getFullLibraryPath().toFile().exists()) break;
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_libraryPathNotFound, null);
                    break;
                }
                case 8: {
                    IPath path = this.fPath.removeTrailingSeparator();
                    res = root.findMember(path);
                    if (res != null) break;
                    if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_sourcePathMissing, null);
                    break;
                }
                case 128: {
                    IPath path = this.fPath.removeTrailingSeparator();
                    res = root.findMember(path);
                    if (res != null) break;
                    if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_outputPathMissing, null);
                    break;
                }
                case 16: {
                    IPath path = this.fPath.removeTrailingSeparator();
                    res = root.findMember(path);
                    if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    if (res != null && res.getType() != 8 && res.getType() != 4 && this.fCProject != null && !this.fCProject.isOnSourceRoot(res)) {
                        this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_notOnSourcePath, null);
                    }
                    if (((IIncludeEntry)entry).getFullIncludePath().toFile().exists()) break;
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_includePathNotFound, null);
                    break;
                }
                case 256: {
                    IPath path = this.fPath.removeTrailingSeparator();
                    res = root.findMember(path);
                    if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    if (res != null && res.getType() != 8 && res.getType() != 4 && this.fCProject != null && !this.fCProject.isOnSourceRoot(res)) {
                        this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_notOnSourcePath, null);
                    }
                    if (((IIncludeFileEntry)entry).getFullIncludeFilePath().toFile().exists()) break;
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_includeFilePathNotFound, null);
                    break;
                }
                case 64: {
                    IPath path = this.fPath.removeTrailingSeparator();
                    res = root.findMember(path);
                    if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    if (res == null || res.getType() == 8 || res.getType() == 4 || this.fCProject == null || this.fCProject.isOnSourceRoot(res)) break;
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_notOnSourcePath, null);
                    break;
                }
                case 512: {
                    IPath path = this.fPath.removeTrailingSeparator();
                    res = root.findMember(path);
                    if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    if (res != null && res.getType() != 8 && res.getType() != 4 && this.fCProject != null && !this.fCProject.isOnSourceRoot(res)) {
                        this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_notOnSourcePath, null);
                    }
                    if (((IMacroFileEntry)entry).getFullMacroFilePath().toFile().exists()) break;
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_macrosFilePathNotFound, null);
                    break;
                }
                case 4: {
                    res = root.findMember(this.fPath);
                    if (res != null) break;
                    this.fStatus = new Status(4, "org.eclipse.cdt.ui", -1, CPathEntryMessages.CPElement_status_missingProjectPath, null);
                }
            }
        }
        return this.fStatus;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public CPElement getInherited() {
        return this.Inherited;
    }

    public ICProject getCProject() {
        return this.fCProject;
    }

    public static CPElement createFromExisting(IPathEntry curr, ICElement element) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = CUIPlugin.getWorkspace().getRoot();
        IPath sourceAttachment = null;
        IPath[] exclusion = null;
        IPath include = null;
        IPath includeFile = null;
        IPath library = null;
        String macroName = null;
        String macroValue = null;
        IPath macrosFile = null;
        boolean sysInclude = false;
        IPath baseRef = null;
        IPath base = null;
        IResource res = null;
        switch (curr.getEntryKind()) {
            case 32: {
                res = element instanceof ICProject ? null : element.getResource();
                break;
            }
            case 1: {
                library = ((ILibraryEntry)curr).getLibraryPath();
                sourceAttachment = ((ILibraryEntry)curr).getSourceAttachmentPath();
                base = ((ILibraryEntry)curr).getBasePath();
                baseRef = ((ILibraryEntry)curr).getBaseReference();
                break;
            }
            case 8: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                exclusion = ((ISourceEntry)curr).getExclusionPatterns();
                break;
            }
            case 128: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                exclusion = ((IOutputEntry)curr).getExclusionPatterns();
                break;
            }
            case 16: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                exclusion = ((IIncludeEntry)curr).getExclusionPatterns();
                sysInclude = ((IIncludeEntry)curr).isSystemInclude();
                baseRef = ((IIncludeEntry)curr).getBaseReference();
                base = ((IIncludeEntry)curr).getBasePath();
                include = ((IIncludeEntry)curr).getIncludePath();
                break;
            }
            case 256: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                exclusion = ((IIncludeFileEntry)curr).getExclusionPatterns();
                includeFile = ((IIncludeFileEntry)curr).getIncludeFilePath();
                baseRef = ((IIncludeFileEntry)curr).getBaseReference();
                base = ((IIncludeFileEntry)curr).getBasePath();
                break;
            }
            case 64: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                exclusion = ((IMacroEntry)curr).getExclusionPatterns();
                macroName = ((IMacroEntry)curr).getMacroName();
                macroValue = ((IMacroEntry)curr).getMacroValue();
                baseRef = ((IMacroEntry)curr).getBaseReference();
                base = ((IMacroEntry)curr).getBasePath();
                break;
            }
            case 512: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                exclusion = ((IMacroFileEntry)curr).getExclusionPatterns();
                macrosFile = ((IMacroFileEntry)curr).getMacroFilePath();
                baseRef = ((IMacroFileEntry)curr).getBaseReference();
                base = ((IMacroFileEntry)curr).getBasePath();
                break;
            }
            case 4: {
                res = root.findMember(path);
            }
        }
        CPElement elem = new CPElement(element == null ? null : element.getCProject(), curr.getEntryKind(), path, res);
        elem.setAttribute(SOURCEATTACHMENT, sourceAttachment);
        elem.setAttribute(EXCLUSION, exclusion);
        elem.setAttribute(INCLUDE, include);
        elem.setAttribute(INCLUDE_FILE, includeFile);
        elem.setAttribute(LIBRARY, library);
        elem.setAttribute(MACRO_NAME, macroName);
        elem.setAttribute(MACRO_VALUE, macroValue);
        elem.setAttribute(MACROS_FILE, macrosFile);
        elem.setAttribute(SYSTEM_INCLUDE, sysInclude);
        elem.setAttribute(BASE_REF, baseRef);
        elem.setAttribute(BASE, base);
        elem.setExported(curr.isExported());
        return elem;
    }
}

