/*
 * Copyright @ 2017 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWAR OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *    Pengfei Qu <Pengfei.qu@intel.com>
 *    Sreerenj Balachandran <sreerenj.balachandran@intel.com>
 *
 */


#include "i965_avc_const_def.h"

/* Gen9  */
/*
init const table for scaling/sfd/curbe
*/

const char gen9_avc_sfd_cost_table_p_frame[AVC_QP_MAX] = {
    44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 60, 60, 60, 60,
    73, 73, 73, 76, 76, 76, 88, 89, 89, 91, 92, 93, 104, 104, 106, 107, 108, 109, 120,
    120, 122, 123, 124, 125, 136, 136, 138, 139, 140, 141, 143, 143
};

const char gen9_avc_sfd_cost_table_b_frame[AVC_QP_MAX] = {
    57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 73, 73, 73, 73,
    77, 77, 77, 89, 89, 89, 91, 93, 93, 95, 105, 106, 107, 108, 110, 111, 121, 122,
    123, 124, 125, 127, 137, 138, 139, 140, 142, 143, 143, 143, 143, 143
};

/*
MBBRC const: mv mode cost  ,skip value,scaling factor
*/
const unsigned int gen9_avc_old_intra_mode_cost[AVC_QP_MAX] = {
    0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a,
    0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a, 0x1e03000a,
    0x2e06001a, 0x2e06001a, 0x2e06001a, 0x2e06001a, 0x3b09001f, 0x3b09001f, 0x3b09001f, 0x3e0c002a,
    0x3e0c002a, 0x3e0c002a, 0x490f002d, 0x4b19002f, 0x4b19002f, 0x4c1b0039, 0x4e1c003a, 0x581e003b,
    0x591f003d, 0x5a28003e, 0x5b2a0048, 0x5c2b0049, 0x5e2c004a, 0x682e004b, 0x692f004d, 0x6a39004e,
    0x6b390058, 0x6d3b0059, 0x6e3c005a, 0x783e005b, 0x793f005d, 0x7a48005e, 0x7b4a0068, 0x7c4b0069,
    0x7e4c006a, 0x884e006b, 0x894f006d, 0x8a59006e
};

const unsigned int gen9_avc_mv_cost_p_skip_adjustment[AVC_QP_MAX] = {
    0x09060500, 0x09060500, 0x09060500, 0x09060500, 0x09060500, 0x09060500, 0x09060500, 0x09060500,
    0x09060500, 0x09060500, 0x09060500, 0x09060500, 0x09060500, 0x09060500, 0x09060500, 0x09060500,
    0x190c0a00, 0x190c0a00, 0x190c0a00, 0x190c0a00, 0x1e190f00, 0x1e190f00, 0x1e190f00, 0x291c1a00,
    0x291c1a00, 0x291c1a00, 0x2b1f1d00, 0x2e291f00, 0x2e291f00, 0x382b2900, 0x392c2a00, 0x3a2e2b00,
    0x3b2f2d00, 0x3c382e00, 0x3f3a3800, 0x483b3900, 0x493c3a00, 0x4a3e3b00, 0x4b3f3d00, 0x4d493e00,
    0x4e494800, 0x584b4900, 0x594c4a00, 0x5a4e4b00, 0x5b4f4d00, 0x5d584e00, 0x5e5a5800, 0x685b5900,
    0x695c5a00, 0x6a5e5b00, 0x6b5f5d00, 0x6d695e00
};

const unsigned short gen9_avc_skip_value_p[2][2][64] = {
    {
        // Block Based Skip = 0 and Transform Flag = 0
        {
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
            0x0006, 0x000c, 0x000c, 0x0015, 0x0015, 0x0021, 0x0021, 0x0033,
            0x0033, 0x004b, 0x004b, 0x0069, 0x0069, 0x0096, 0x0096, 0x00cc,
            0x00cc, 0x0111, 0x0111, 0x0165, 0x0165, 0x01cb, 0x01cb, 0x0246,
            0x0246, 0x02d3, 0x02d3, 0x0378, 0x0378, 0x0438, 0x0438, 0x0510,
            0x0510, 0x0603, 0x0603, 0x0714, 0x0714, 0x0846, 0x0846, 0x0999,
            0x0999, 0x0b10, 0x0b10, 0x0c3c, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
        },

        // Block Based Skip = 0 and Transform Flag = 1
        {
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
            0x0006, 0x000c, 0x000c, 0x0015, 0x0015, 0x0021, 0x0021, 0x0033,
            0x0033, 0x004b, 0x004b, 0x0069, 0x0069, 0x0096, 0x0096, 0x00cc,
            0x00cc, 0x0111, 0x0111, 0x0165, 0x0165, 0x01cb, 0x01cb, 0x0246,
            0x0246, 0x02d3, 0x02d3, 0x0378, 0x0378, 0x0438, 0x0438, 0x0510,
            0x0510, 0x0603, 0x0603, 0x0714, 0x0714, 0x0846, 0x0846, 0x0999,
            0x0999, 0x0b10, 0x0b10, 0x0c3c, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
        }
    },
    {
        // Block Based Skip = 1 and Transform Flag = 0
        {
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
            0x0001, 0x0002, 0x0002, 0x0003, 0x0003, 0x0005, 0x0005, 0x0008,
            0x0008, 0x000c, 0x000c, 0x0011, 0x0011, 0x0019, 0x0019, 0x0022,
            0x0022, 0x002d, 0x002d, 0x003b, 0x003b, 0x004c, 0x004c, 0x0061,
            0x0061, 0x0078, 0x0078, 0x0094, 0x0094, 0x00b4, 0x00b4, 0x00d8,
            0x00d8, 0x0100, 0x0100, 0x012e, 0x012e, 0x0161, 0x0161, 0x0199,
            0x0199, 0x01d8, 0x01d8, 0x020a, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
        },

        // Block Based Skip = 1 and Transform Flag = 1
        {
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
            0x0002, 0x0004, 0x0004, 0x0007, 0x0007, 0x000b, 0x000b, 0x0011,
            0x0011, 0x0019, 0x0019, 0x0023, 0x0023, 0x0032, 0x0032, 0x0044,
            0x0044, 0x005b, 0x005b, 0x0077, 0x0077, 0x0099, 0x0099, 0x00c2,
            0x00c2, 0x00f1, 0x00f1, 0x0128, 0x0128, 0x0168, 0x0168, 0x01b0,
            0x01b0, 0x0201, 0x0201, 0x025c, 0x025c, 0x02c2, 0x02c2, 0x0333,
            0x0333, 0x03b0, 0x03b0, 0x0414, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
        }
    }
};

const unsigned short gen9_avc_skip_value_b[2][2][64] = {
    {
        // Block Based Skip = 0 and Transform Flag = 0
        {
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0024,
            0x0024, 0x0060, 0x0060, 0x0099, 0x0099, 0x00cf, 0x00cf, 0x0105,
            0x0105, 0x0141, 0x0141, 0x0183, 0x0183, 0x01ce, 0x01ce, 0x0228,
            0x0228, 0x0291, 0x0291, 0x030c, 0x030c, 0x039f, 0x039f, 0x0447,
            0x0447, 0x050d, 0x050d, 0x05f1, 0x05f1, 0x06f6, 0x06f6, 0x0822,
            0x0822, 0x0972, 0x0972, 0x0aef, 0x0aef, 0x0c96, 0x0c96, 0x0e70,
            0x0e70, 0x107a, 0x107a, 0x1284, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
        },
        // Block Based Skip = 0 and Transform Flag = 1
        {
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0024,
            0x0024, 0x0060, 0x0060, 0x0099, 0x0099, 0x00cf, 0x00cf, 0x0105,
            0x0105, 0x0141, 0x0141, 0x0183, 0x0183, 0x01ce, 0x01ce, 0x0228,
            0x0228, 0x0291, 0x0291, 0x030c, 0x030c, 0x039f, 0x039f, 0x0447,
            0x0447, 0x050d, 0x050d, 0x05f1, 0x05f1, 0x06f6, 0x06f6, 0x0822,
            0x0822, 0x0972, 0x0972, 0x0aef, 0x0aef, 0x0c96, 0x0c96, 0x0e70,
            0x0e70, 0x107a, 0x107a, 0x1284, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
        }
    },
    {
        // Block Based Skip = 1 and Transform Flag = 0
        {
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
            0x0006, 0x0010, 0x0010, 0x0019, 0x0019, 0x0022, 0x0022, 0x002b,
            0x002b, 0x0035, 0x0035, 0x0040, 0x0040, 0x004d, 0x004d, 0x005c,
            0x005c, 0x006d, 0x006d, 0x0082, 0x0082, 0x009a, 0x009a, 0x00b6,
            0x00b6, 0x00d7, 0x00d7, 0x00fd, 0x00fd, 0x0129, 0x0129, 0x015b,
            0x015b, 0x0193, 0x0193, 0x01d2, 0x01d2, 0x0219, 0x0219, 0x0268,
            0x0268, 0x02bf, 0x02bf, 0x0316, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
        },
        // Block Based Skip = 1 and Transform Flag = 1
        {
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c,
            0x000c, 0x0020, 0x0020, 0x0033, 0x0033, 0x0045, 0x0045, 0x0057,
            0x0057, 0x006b, 0x006b, 0x0081, 0x0081, 0x009a, 0x009a, 0x00b8,
            0x00b8, 0x00db, 0x00db, 0x0104, 0x0104, 0x0135, 0x0135, 0x016d,
            0x016d, 0x01af, 0x01af, 0x01fb, 0x01fb, 0x0252, 0x0252, 0x02b6,
            0x02b6, 0x0326, 0x0326, 0x03a5, 0x03a5, 0x0432, 0x0432, 0x04d0,
            0x04d0, 0x057e, 0x057e, 0x062c, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
        }
    }
};

// QP is from 0 - 51, pad it to 64 since BRC needs array size to be 64 bytes
const unsigned char gen9_avc_adaptive_intra_scaling_factor[64] = {
    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0c, 0x0c,
    0x0c, 0x0c, 0x0d, 0x0d, 0x0d, 0x0d, 0x0e, 0x0e,
    0x0e, 0x0e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// QP is from 0 - 51, pad it to 64 since BRC needs array size to be 64 bytes
const unsigned char gen9_avc_intra_scaling_factor[64] = {
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// AVC MBEnc CURBE init data
const unsigned int gen9_avc_mbenc_curbe_normal_i_frame_init_data[GEN9_AVC_MBENC_CURBE_SIZE] = {
    0x00000082, 0x00000000, 0x00003910, 0x00a83000, 0x00000000, 0x28300000, 0x05000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80800000, 0x00040c24, 0x00000000, 0xffff00ff, 0x40000000, 0x00000080, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};


const unsigned int gen9_avc_mbenc_curbe_normal_p_frame_init_data[GEN9_AVC_MBENC_CURBE_SIZE] = {
    0x000000a3, 0x00000008, 0x00003910, 0x00ae3000, 0x30000000, 0x28300000, 0x05000000, 0x01400060,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80010000, 0x00040c24, 0x00000000, 0xffff00ff, 0x60000000, 0x000000a1, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};

const unsigned int gen9_avc_mbenc_curbe_normal_b_frame_init_data[GEN9_AVC_MBENC_CURBE_SIZE] = {
    0x000000a3, 0x00200008, 0x00003910, 0x00aa7700, 0x50020000, 0x20200000, 0x05000000, 0xff400000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x01010000, 0x00040c24, 0x00000000, 0xffff00ff, 0x60000000, 0x000000a1, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};

// AVC I_DIST CURBE init data
const unsigned int gen9_avc_mbenc_curbe_i_frame_dist_init_data[GEN9_AVC_MBENC_CURBE_SIZE] = {
    0x00000082, 0x00200008, 0x001e3910, 0x00a83000, 0x90000000, 0x28300000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100,
    0x80800000, 0x00000000, 0x00000800, 0xffff00ff, 0x40000000, 0x00000080, 0x00003900, 0x28300000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};

// AVC ME CURBE init data
const unsigned int gen9_avc_me_curbe_init_data[39] = {
    0x00000000, 0x00200010, 0x00003939, 0x77a43000, 0x00000000, 0x28300000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};

/*
ME cost table: mv/ref/mode
*/
// AVC MBEnc ModeCost and MVCost tables, index [CodingType][QP] and
const unsigned int gen75_avc_mode_mv_cost_table[3][52][8] = {
    // I-Frame
    {
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff010101, 0x00000000, 0x00000000},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff020202, 0x00000000, 0x00000000},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff030303, 0x00000000, 0x00000000},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff040404, 0x00000000, 0x00000000},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff050505, 0x00000000, 0x00000000},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff060606, 0x00000000, 0x00000000},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff070707, 0x01010001, 0x01010101},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff080808, 0x01010001, 0x01010101},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff090909, 0x03030003, 0x03030303},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0a0a0a, 0x03030003, 0x03030303},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0b0b0b, 0x06060006, 0x06060606},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0c0c0c, 0x06060006, 0x06060606},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0d0d0d, 0x08080008, 0x08080808},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0e0e0e, 0x08080008, 0x08080808},
        {0x1e03000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0f0f0f, 0x0b0b000b, 0x0b0b0b0b},
        {0x2e06001a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff101010, 0x0b0b000b, 0x0b0b0b0b},
        {0x2e06001a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff111111, 0x0d0d000d, 0x0d0d0d0d},
        {0x2e06001a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff121212, 0x0d0d000d, 0x0d0d0d0d},
        {0x2e06001a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff131313, 0x10100010, 0x10101010},
        {0x3b09001f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff141414, 0x10100010, 0x10101010},
        {0x3b09001f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff151515, 0x13130013, 0x13131313},
        {0x3b09001f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff161616, 0x13130013, 0x13131313},
        {0x3e0c002a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff171717, 0x16160016, 0x16161616},
        {0x3e0c002a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff181818, 0x16160016, 0x16161616},
        {0x3e0c002a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff191919, 0x1a1a001a, 0x1a1a1a1a},
        {0x490f002d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1a1a1a, 0x1a1a001a, 0x1a1a1a1a},
        {0x4b19002f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1b1b1b, 0x1e1e001e, 0x1e1e1e1e},
        {0x4b19002f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1c1c1c, 0x1e1e001e, 0x1e1e1e1e},
        {0x4c1b0039, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1d1d1d, 0x22220022, 0x22222222},
        {0x4e1c003a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1e1e1e, 0x22220022, 0x22222222},
        {0x581e003b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1f1f1f, 0x27270027, 0x27272727},
        {0x591f003d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff202020, 0x27270027, 0x27272727},
        {0x5a28003e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff212121, 0x2c2c002c, 0x2c2c2c2c},
        {0x5b2a0048, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff222222, 0x2c2c002c, 0x2c2c2c2c},
        {0x5c2b0049, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff232323, 0x32320032, 0x32323232},
        {0x5e2c004a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff242424, 0x32320032, 0x32323232},
        {0x682e004b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff252525, 0x38380038, 0x38383838},
        {0x692f004d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff262626, 0x38380038, 0x38383838},
        {0x6a39004e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff272727, 0x3e3e003e, 0x3e3e3e3e},
        {0x6b390058, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff282828, 0x3e3e003e, 0x3e3e3e3e},
        {0x6d3b0059, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff292929, 0x45450045, 0x45454545},
        {0x6e3c005a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2a2a2a, 0x45450045, 0x45454545},
        {0x783e005b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2b2b2b, 0x4d4d004d, 0x4d4d4d4d},
        {0x793f005d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2c2c2c, 0x4d4d004d, 0x4d4d4d4d},
        {0x7a48005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2d2d2d, 0x55550055, 0x55555555},
        {0x7b4a0068, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2e2e2e, 0x55550055, 0x55555555},
        {0x7c4b0069, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2f2f2f, 0x5e5e005e, 0x5e5e5e5e},
        {0x7e4c006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff303030, 0x5e5e005e, 0x5e5e5e5e},
        {0x884e006b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff313131, 0x68680068, 0x68686868},
        {0x894f006d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff323232, 0x68680068, 0x68686868},
        {0x8a59006e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff333333, 0x73730073, 0x73737373},
    },
    // P-Frame
    {
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff000000, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff010101, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff020202, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff030303, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff040404, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff050505, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff060606, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff070707, 0x01010001, 0x01010101},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff080808, 0x01010001, 0x01010101},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff090909, 0x03030003, 0x03030303},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0a0a0a, 0x03030003, 0x03030303},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0b0b0b, 0x06060006, 0x06060606},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0c0c0c, 0x06060006, 0x06060606},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0d0d0d, 0x08080008, 0x08080808},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0e0e0e, 0x08080008, 0x08080808},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0f0f0f, 0x0b0b000b, 0x0b0b0b0b},
        {0x492e2a0e, 0x0d090519, 0x0008000b, 0x190a0802, 0x1f1e1c1a, 0xff101010, 0x0b0b000b, 0x0b0b0b0b},
        {0x492e2a0e, 0x0d090519, 0x0008000b, 0x190a0802, 0x1f1e1c1a, 0xff111111, 0x0d0d000d, 0x0d0d0d0d},
        {0x492e2a0e, 0x0d090519, 0x0008000b, 0x190a0802, 0x1f1e1c1a, 0xff121212, 0x0d0d000d, 0x0d0d0d0d},
        {0x492e2a0e, 0x0d090519, 0x0008000b, 0x190a0802, 0x1f1e1c1a, 0xff131313, 0x10100010, 0x10101010},
        {0x4d3b2f1b, 0x1a0d071d, 0x000c0018, 0x1e0f0c03, 0x2b2b291f, 0xff141414, 0x10100010, 0x10101010},
        {0x4d3b2f1b, 0x1a0d071d, 0x000c0018, 0x1e0f0c03, 0x2b2b291f, 0xff151515, 0x13130013, 0x13131313},
        {0x4d3b2f1b, 0x1a0d071d, 0x000c0018, 0x1e0f0c03, 0x2b2b291f, 0xff161616, 0x13130013, 0x13131313},
        {0x593e3a1e, 0x1d190a29, 0x0018001b, 0x291a1804, 0x2f2e2c2a, 0xff171717, 0x16160016, 0x16161616},
        {0x593e3a1e, 0x1d190a29, 0x0018001b, 0x291a1804, 0x2f2e2c2a, 0xff181818, 0x16160016, 0x16161616},
        {0x593e3a1e, 0x1d190a29, 0x0018001b, 0x291a1804, 0x2f2e2c2a, 0xff191919, 0x1a1a001a, 0x1a1a1a1a},
        {0x5b493d29, 0x281c0d2b, 0x001a001e, 0x2b1d1a05, 0x39392f2d, 0xff1a1a1a, 0x1a1a001a, 0x1a1a1a1a},
        {0x5d4b3f2b, 0x2a1e0f2d, 0x001c0028, 0x2e1f1c06, 0x3b3b392f, 0xff1b1b1b, 0x1e1e001e, 0x1e1e1e1e},
        {0x5d4b3f2b, 0x2a1e0f2d, 0x001c0028, 0x2e1f1c06, 0x3b3b392f, 0xff1c1c1c, 0x1e1e001e, 0x1e1e1e1e},
        {0x5f4c492c, 0x2c28192f, 0x001e002a, 0x38291e07, 0x3d3c3b39, 0xff1d1d1d, 0x22220022, 0x22222222},
        {0x694e4a2e, 0x2d291b39, 0x0028002b, 0x392a2808, 0x3f3e3c3a, 0xff1e1e1e, 0x22220022, 0x22222222},
        {0x6a584b38, 0x2f2a1c3a, 0x0029002c, 0x3a2b2909, 0x48483e3b, 0xff1f1f1f, 0x27270027, 0x27272727},
        {0x6b594d39, 0x382c1d3b, 0x002a002e, 0x3b2d2a0a, 0x49493f3d, 0xff202020, 0x27270027, 0x27272727},
        {0x6c5a4e3a, 0x392d1f3c, 0x002b002f, 0x3c2e2b0b, 0x4a4a483e, 0xff212121, 0x2c2c002c, 0x2c2c2c2c},
        {0x6e5b583b, 0x3b2f293e, 0x002d0039, 0x3f382d0d, 0x4c4b4a48, 0xff222222, 0x2c2c002c, 0x2c2c2c2c},
        {0x6f5c593c, 0x3c38293f, 0x002e003a, 0x48392e0e, 0x4d4c4b49, 0xff232323, 0x32320032, 0x32323232},
        {0x795e5a3e, 0x3d392b49, 0x0038003b, 0x493a3818, 0x4f4e4c4a, 0xff242424, 0x32320032, 0x32323232},
        {0x7a685b48, 0x3f3a2c4a, 0x0039003c, 0x4a3b3919, 0x58584e4b, 0xff252525, 0x38380038, 0x38383838},
        {0x7b695d49, 0x483c2d4b, 0x003a003e, 0x4b3d3a1a, 0x59594f4d, 0xff262626, 0x38380038, 0x38383838},
        {0x7d6a5e4a, 0x4a3d2f4c, 0x003c0048, 0x4d3e3c1c, 0x5b5a594e, 0xff272727, 0x3e3e003e, 0x3e3e3e3e},
        {0x7e6b684b, 0x4a3e384d, 0x003d0049, 0x4e483d1d, 0x5c5b5958, 0xff282828, 0x3e3e003e, 0x3e3e3e3e},
        {0x886d694d, 0x4c483a4f, 0x003f004a, 0x58493f1f, 0x5e5d5b59, 0xff292929, 0x45450045, 0x45454545},
        {0x896e6a4e, 0x4d493b59, 0x0048004b, 0x594a4828, 0x5f5e5c5a, 0xff2a2a2a, 0x45450045, 0x45454545},
        {0x8a786b58, 0x4f4a3c5a, 0x0049004c, 0x5a4b4929, 0x68685e5b, 0xff2b2b2b, 0x4d4d004d, 0x4d4d4d4d},
        {0x8b796d59, 0x584c3d5b, 0x004a004e, 0x5b4d4a2a, 0x69695f5d, 0xff2c2c2c, 0x4d4d004d, 0x4d4d4d4d},
        {0x8c7a6e5a, 0x594d3f5c, 0x004b004f, 0x5d4e4b2b, 0x6b6a685e, 0xff2d2d2d, 0x55550055, 0x55555555},
        {0x8e7b785b, 0x5b4f485e, 0x004d0059, 0x5e584d2d, 0x6c6b6a68, 0xff2e2e2e, 0x55550055, 0x55555555},
        {0x8f7c795c, 0x5c58495f, 0x004e005a, 0x68594e2e, 0x6d6c6b69, 0xff2f2f2f, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f7e7a5e, 0x5d594b69, 0x0058005b, 0x695a5838, 0x6f6e6c6a, 0xff303030, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f887b68, 0x5f5a4c6a, 0x0059005c, 0x6a5b5939, 0x6f6f6e6b, 0xff313131, 0x68680068, 0x68686868},
        {0x8f897d69, 0x685c4d6b, 0x005a005e, 0x6b5d5a3a, 0x6f6f6f6d, 0xff323232, 0x68680068, 0x68686868},
        {0x8f8a7e6a, 0x695d4f6c, 0x005b0068, 0x6d5e5b3b, 0x6f6f6f6e, 0xff333333, 0x73730073, 0x73737373},
    },
    // B-Frame
    {
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff000000, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff010101, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff020202, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff030303, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff040404, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff050505, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff060606, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff070707, 0x01010001, 0x01010101},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff080808, 0x01010001, 0x01010101},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff090909, 0x03030003, 0x03030303},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0a0a0a, 0x03030003, 0x03030303},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0b0b0b, 0x06060006, 0x06060606},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0c0c0c, 0x06060006, 0x06060606},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0d0d0d, 0x08080008, 0x08080808},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0e0e0e, 0x08080008, 0x08080808},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0f0f0f, 0x0b0b000b, 0x0b0b0b0b},
        {0x4a3a390e, 0x1b190d1c, 0x0008040c, 0x0c040400, 0x281e1c1a, 0xff101010, 0x0b0b000b, 0x0b0b0b0b},
        {0x4a3a390e, 0x1b190d1c, 0x0008040c, 0x0c040400, 0x281e1c1a, 0xff111111, 0x0d0d000d, 0x0d0d0d0d},
        {0x4a3a390e, 0x1b190d1c, 0x0008040c, 0x0c040400, 0x281e1c1a, 0xff121212, 0x0d0d000d, 0x0d0d0d0d},
        {0x4a3a390e, 0x1b190d1c, 0x0008040c, 0x0c040400, 0x281e1c1a, 0xff131313, 0x10100010, 0x10101010},
        {0x4f3f3d1b, 0x281d1a29, 0x000c0619, 0x19060600, 0x2c2b291f, 0xff141414, 0x10100010, 0x10101010},
        {0x4f3f3d1b, 0x281d1a29, 0x000c0619, 0x19060600, 0x2c2b291f, 0xff151515, 0x13130013, 0x13131313},
        {0x4f3f3d1b, 0x281d1a29, 0x000c0619, 0x19060600, 0x2c2b291f, 0xff161616, 0x13130013, 0x13131313},
        {0x5a4a491e, 0x2b291d2c, 0x0018081c, 0x1c080800, 0x382e2c2a, 0xff171717, 0x16160016, 0x16161616},
        {0x5a4a491e, 0x2b291d2c, 0x0018081c, 0x1c080800, 0x382e2c2a, 0xff181818, 0x16160016, 0x16161616},
        {0x5a4a491e, 0x2b291d2c, 0x0018081c, 0x1c080800, 0x382e2c2a, 0xff191919, 0x1a1a001a, 0x1a1a1a1a},
        {0x5d4d4b29, 0x2d2b282f, 0x001a0a1f, 0x1f0a0a00, 0x3a392f2d, 0xff1a1a1a, 0x1a1a001a, 0x1a1a1a1a},
        {0x5f4f4d2b, 0x382d2a39, 0x001c0c29, 0x290c0c00, 0x3c3b392f, 0xff1b1b1b, 0x1e1e001e, 0x1e1e1e1e},
        {0x5f4f4d2b, 0x382d2a39, 0x001c0c29, 0x290c0c00, 0x3c3b392f, 0xff1c1c1c, 0x1e1e001e, 0x1e1e1e1e},
        {0x69594f2c, 0x392f2b3b, 0x001e0e2b, 0x2b0e0e00, 0x3e3c3b39, 0xff1d1d1d, 0x22220022, 0x22222222},
        {0x6a5a592e, 0x3b392d3c, 0x0028182c, 0x2c181800, 0x483e3c3a, 0xff1e1e1e, 0x22220022, 0x22222222},
        {0x6b5b5a38, 0x3c3a2f3e, 0x0029192e, 0x2e191900, 0x49483e3b, 0xff1f1f1f, 0x27270027, 0x27272727},
        {0x6d5d5b39, 0x3d3b383f, 0x002a1a2f, 0x2f1a1a00, 0x4a493f3d, 0xff202020, 0x27270027, 0x27272727},
        {0x6e5e5c3a, 0x3e3c3948, 0x002b1b38, 0x381b1b00, 0x4b4a483e, 0xff212121, 0x2c2c002c, 0x2c2c2c2c},
        {0x78685e3b, 0x493e3b4a, 0x002d1d3a, 0x3a1d1d00, 0x4d4b4a48, 0xff222222, 0x2c2c002c, 0x2c2c2c2c},
        {0x79695f3c, 0x493f3b4b, 0x002e1e3b, 0x3b1e1e00, 0x4e4c4b49, 0xff232323, 0x32320032, 0x32323232},
        {0x7a6a693e, 0x4b493d4c, 0x0038283c, 0x3c282800, 0x584e4c4a, 0xff242424, 0x32320032, 0x32323232},
        {0x7b6b6a48, 0x4c4a3f4e, 0x0039293e, 0x3e292900, 0x59584e4b, 0xff252525, 0x38380038, 0x38383838},
        {0x7d6d6b49, 0x4d4b484f, 0x003a2a3f, 0x3f2a2a00, 0x5a594f4d, 0xff262626, 0x38380038, 0x38383838},
        {0x7e6e6c4a, 0x4f4c4959, 0x003c2c49, 0x492c2c00, 0x5c5a594e, 0xff272727, 0x3e3e003e, 0x3e3e3e3e},
        {0x88786d4b, 0x584d4a59, 0x003d2d49, 0x492d2d00, 0x5d5b5958, 0xff282828, 0x3e3e003e, 0x3e3e3e3e},
        {0x89796f4d, 0x5a4f4c5b, 0x003f2f4b, 0x4b2f2f00, 0x5f5d5b59, 0xff292929, 0x45450045, 0x45454545},
        {0x8a7a794e, 0x5b594d5c, 0x0048384c, 0x4c383800, 0x685e5c5a, 0xff2a2a2a, 0x45450045, 0x45454545},
        {0x8b7b7a58, 0x5c5a4f5e, 0x0049394e, 0x4e393900, 0x69685e5b, 0xff2b2b2b, 0x4d4d004d, 0x4d4d4d4d},
        {0x8d7d7b59, 0x5d5b585f, 0x004a3a4f, 0x4f3a3a00, 0x6a695f5d, 0xff2c2c2c, 0x4d4d004d, 0x4d4d4d4d},
        {0x8e7e7c5a, 0x5f5c5968, 0x004b3b58, 0x583b3b00, 0x6b6a685e, 0xff2d2d2d, 0x55550055, 0x55555555},
        {0x8f887e5b, 0x685e5a6a, 0x004d3d5a, 0x5a3d3d00, 0x6d6b6a68, 0xff2e2e2e, 0x55550055, 0x55555555},
        {0x8f897f5c, 0x695f5c6b, 0x004e3e5b, 0x5b3e3e00, 0x6e6c6b69, 0xff2f2f2f, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f8a895e, 0x6b695d6c, 0x0058485c, 0x5c484800, 0x6f6e6c6a, 0xff303030, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f8b8a68, 0x6c6a5f6e, 0x0059495e, 0x5e494900, 0x6f6f6e6b, 0xff313131, 0x68680068, 0x68686868},
        {0x8f8d8b69, 0x6d6b686f, 0x005a4a5f, 0x5f4a4a00, 0x6f6f6f6d, 0xff323232, 0x68680068, 0x68686868},
        {0x8f8e8c6a, 0x6f6c6979, 0x005b4b69, 0x694b4b00, 0x6f6f6f6e, 0xff333333, 0x73730073, 0x73737373},
    }
};

const unsigned int gen9_avc_mode_mv_cost_table[3][52][8] = {
    // I-Frame
    {
        {0x0d000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000},
        {0x0f000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff010101, 0x00000000, 0x00000000},
        {0x19000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff020202, 0x00000000, 0x00000000},
        {0x1a000005, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff030303, 0x00000000, 0x00000000},
        {0x1b000005, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff040404, 0x00000000, 0x00000000},
        {0x1c000006, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff050505, 0x00000000, 0x00000000},
        {0x1e000007, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff060606, 0x00000000, 0x00000000},
        {0x28000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff070707, 0x01010001, 0x01010101},
        {0x29000009, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff080808, 0x01010001, 0x01010101},
        {0x2a00000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff090909, 0x03030003, 0x03030303},
        {0x2b00000b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0a0a0a, 0x03030003, 0x03030303},
        {0x2c00000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0b0b0b, 0x06060006, 0x06060606},
        {0x2e00000e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0c0c0c, 0x06060006, 0x06060606},
        {0x38000018, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0d0d0d, 0x08080008, 0x08080808},
        {0x39000019, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0e0e0e, 0x08080008, 0x08080808},
        {0x3a00001b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0f0f0f, 0x0b0b000b, 0x0b0b0b0b},
        {0x3b00001c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff101010, 0x0b0b000b, 0x0b0b0b0b},
        {0x3c00001d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff111111, 0x0d0d000d, 0x0d0d0d0d},
        {0x3e00001f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff121212, 0x0d0d000d, 0x0d0d0d0d},
        {0x48020028, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff131313, 0x10100010, 0x10101010},
        {0x49020029, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff141414, 0x10100010, 0x10101010},
        {0x4a03002a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff151515, 0x13130013, 0x13131313},
        {0x4b03002b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff161616, 0x13130013, 0x13131313},
        {0x4c04002b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff171717, 0x16160016, 0x16161616},
        {0x4e04002c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff181818, 0x16160016, 0x16161616},
        {0x5805002e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff191919, 0x1a1a001a, 0x1a1a1a1a},
        {0x5905002f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1a1a1a, 0x1a1a001a, 0x1a1a1a1a},
        {0x5a06002e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1b1b1b, 0x1e1e001e, 0x1e1e1e1e},
        {0x5b07002f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1c1c1c, 0x1e1e001e, 0x1e1e1e1e},
        {0x5c080039, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1d1d1d, 0x22220022, 0x22222222},
        {0x5e09003a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1e1e1e, 0x22220022, 0x22222222},
        {0x6828003a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1f1f1f, 0x27270027, 0x27272727},
        {0x6929003b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff202020, 0x27270027, 0x27272727},
        {0x6a2a003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff212121, 0x2c2c002c, 0x2c2c2c2c},
        {0x6b2c003e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff222222, 0x2c2c002c, 0x2c2c2c2c},
        {0x6c3a003e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff232323, 0x32320032, 0x32323232},
        {0x6e3b0048, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff242424, 0x32320032, 0x32323232},
        {0x783c0049, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff252525, 0x38380038, 0x38383838},
        {0x793e004a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff262626, 0x38380038, 0x38383838},
        {0x7a3e004b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff272727, 0x3e3e003e, 0x3e3e3e3e},
        {0x7b48004c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff282828, 0x3e3e003e, 0x3e3e3e3e},
        {0x7c49004e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff292929, 0x45450045, 0x45454545},
        {0x7e4a0058, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2a2a2a, 0x45450045, 0x45454545},
        {0x884d0059, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2b2b2b, 0x4d4d004d, 0x4d4d4d4d},
        {0x894f005a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2c2c2c, 0x4d4d004d, 0x4d4d4d4d},
        {0x8a58005b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2d2d2d, 0x55550055, 0x55555555},
        {0x8b59005c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2e2e2e, 0x55550055, 0x55555555},
        {0x8c5c005b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff2f2f2f, 0x5e5e005e, 0x5e5e5e5e},
        {0x8e5d005c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff303030, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f5f005d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff313131, 0x68680068, 0x68686868},
        {0x8f68005f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff323232, 0x68680068, 0x68686868},
        {0x8f690068, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff333333, 0x73730073, 0x73737373}
    },
    // P-Frame
    {
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff000000, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff010101, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff020202, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff030303, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff040404, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff050505, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff060606, 0x00000000, 0x00000000},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff070707, 0x01010001, 0x01010101},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff080808, 0x01010001, 0x01010101},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff090909, 0x03030003, 0x03030303},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0a0a0a, 0x03030003, 0x03030303},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0b0b0b, 0x06060006, 0x06060606},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0c0c0c, 0x06060006, 0x06060606},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0d0d0d, 0x08080008, 0x08080808},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0e0e0e, 0x08080008, 0x08080808},
        {0x391e1a07, 0x06040208, 0x00040005, 0x09050401, 0x0f0e0c0a, 0xff0f0f0f, 0x0b0b000b, 0x0b0b0b0b},
        {0x492e2a0e, 0x0d090519, 0x0008000b, 0x190a0802, 0x1f1e1c1a, 0xff101010, 0x0b0b000b, 0x0b0b0b0b},
        {0x492e2a0e, 0x0d090519, 0x0008000b, 0x190a0802, 0x1f1e1c1a, 0xff111111, 0x0d0d000d, 0x0d0d0d0d},
        {0x492e2a0e, 0x0d090519, 0x0008000b, 0x190a0802, 0x1f1e1c1a, 0xff121212, 0x0d0d000d, 0x0d0d0d0d},
        {0x492e2a0e, 0x0d090519, 0x0008000b, 0x190a0802, 0x1f1e1c1a, 0xff131313, 0x10100010, 0x10101010},
        {0x4d3b2f1b, 0x1a0d071d, 0x000c0018, 0x1e0f0c03, 0x2b2b291f, 0xff141414, 0x10100010, 0x10101010},
        {0x4d3b2f1b, 0x1a0d071d, 0x000c0018, 0x1e0f0c03, 0x2b2b291f, 0xff151515, 0x13130013, 0x13131313},
        {0x4d3b2f1b, 0x1a0d071d, 0x000c0018, 0x1e0f0c03, 0x2b2b291f, 0xff161616, 0x13130013, 0x13131313},
        {0x593e3a1e, 0x1d190a29, 0x0018001b, 0x291a1804, 0x2f2e2c2a, 0xff171717, 0x16160016, 0x16161616},
        {0x593e3a1e, 0x1d190a29, 0x0018001b, 0x291a1804, 0x2f2e2c2a, 0xff181818, 0x16160016, 0x16161616},
        {0x593e3a1e, 0x1d190a29, 0x0018001b, 0x291a1804, 0x2f2e2c2a, 0xff191919, 0x1a1a001a, 0x1a1a1a1a},
        {0x5b493d29, 0x281c0d2b, 0x001a001e, 0x2b1d1a05, 0x39392f2d, 0xff1a1a1a, 0x1a1a001a, 0x1a1a1a1a},
        {0x5d4b3f2b, 0x2a1e0f2d, 0x001c0028, 0x2e1f1c06, 0x3b3b392f, 0xff1b1b1b, 0x1e1e001e, 0x1e1e1e1e},
        {0x5d4b3f2b, 0x2a1e0f2d, 0x001c0028, 0x2e1f1c06, 0x3b3b392f, 0xff1c1c1c, 0x1e1e001e, 0x1e1e1e1e},
        {0x5f4c492c, 0x2c28192f, 0x001e002a, 0x38291e07, 0x3d3c3b39, 0xff1d1d1d, 0x22220022, 0x22222222},
        {0x694e4a2e, 0x2d291b39, 0x0028002b, 0x392a2808, 0x3f3e3c3a, 0xff1e1e1e, 0x22220022, 0x22222222},
        {0x6a584b38, 0x2f2a1c3a, 0x0029002c, 0x3a2b2909, 0x48483e3b, 0xff1f1f1f, 0x27270027, 0x27272727},
        {0x6b594d39, 0x382c1d3b, 0x002a002e, 0x3b2d2a0a, 0x49493f3d, 0xff202020, 0x27270027, 0x27272727},
        {0x6c5a4e3a, 0x392d1f3c, 0x002b002f, 0x3c2e2b0b, 0x4a4a483e, 0xff212121, 0x2c2c002c, 0x2c2c2c2c},
        {0x6e5b583b, 0x3b2f293e, 0x002d0039, 0x3f382d0d, 0x4c4b4a48, 0xff222222, 0x2c2c002c, 0x2c2c2c2c},
        {0x6f5c593c, 0x3c38293f, 0x002e003a, 0x48392e0e, 0x4d4c4b49, 0xff232323, 0x32320032, 0x32323232},
        {0x795e5a3e, 0x3d392b49, 0x0038003b, 0x493a3818, 0x4f4e4c4a, 0xff242424, 0x32320032, 0x32323232},
        {0x7a685b48, 0x3f3a2c4a, 0x0039003c, 0x4a3b3919, 0x58584e4b, 0xff252525, 0x38380038, 0x38383838},
        {0x7b695d49, 0x483c2d4b, 0x003a003e, 0x4b3d3a1a, 0x59594f4d, 0xff262626, 0x38380038, 0x38383838},
        {0x7d6a5e4a, 0x4a3d2f4c, 0x003c0048, 0x4d3e3c1c, 0x5b5a594e, 0xff272727, 0x3e3e003e, 0x3e3e3e3e},
        {0x7e6b684b, 0x4a3e384d, 0x003d0049, 0x4e483d1d, 0x5c5b5958, 0xff282828, 0x3e3e003e, 0x3e3e3e3e},
        {0x886d694d, 0x4c483a4f, 0x003f004a, 0x58493f1f, 0x5e5d5b59, 0xff292929, 0x45450045, 0x45454545},
        {0x896e6a4e, 0x4d493b59, 0x0048004b, 0x594a4828, 0x5f5e5c5a, 0xff2a2a2a, 0x45450045, 0x45454545},
        {0x8a786b58, 0x4f4a3c5a, 0x0049004c, 0x5a4b4929, 0x68685e5b, 0xff2b2b2b, 0x4d4d004d, 0x4d4d4d4d},
        {0x8b796d59, 0x584c3d5b, 0x004a004e, 0x5b4d4a2a, 0x69695f5d, 0xff2c2c2c, 0x4d4d004d, 0x4d4d4d4d},
        {0x8c7a6e5a, 0x594d3f5c, 0x004b004f, 0x5d4e4b2b, 0x6b6a685e, 0xff2d2d2d, 0x55550055, 0x55555555},
        {0x8e7b785b, 0x5b4f485e, 0x004d0059, 0x5e584d2d, 0x6c6b6a68, 0xff2e2e2e, 0x55550055, 0x55555555},
        {0x8f7c795c, 0x5c58495f, 0x004e005a, 0x68594e2e, 0x6d6c6b69, 0xff2f2f2f, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f7e7a5e, 0x5d594b69, 0x0058005b, 0x695a5838, 0x6f6e6c6a, 0xff303030, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f887b68, 0x5f5a4c6a, 0x0059005c, 0x6a5b5939, 0x6f6f6e6b, 0xff313131, 0x68680068, 0x68686868},
        {0x8f897d69, 0x685c4d6b, 0x005a005e, 0x6b5d5a3a, 0x6f6f6f6d, 0xff323232, 0x68680068, 0x68686868},
        {0x8f8a7e6a, 0x695d4f6c, 0x005b0068, 0x6d5e5b3b, 0x6f6f6f6e, 0xff333333, 0x73730073, 0x73737373}
    },
    // B-Frame
    {
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff000000, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff010101, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff020202, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff030303, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff040404, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff050505, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff060606, 0x00000000, 0x00000000},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff070707, 0x01010001, 0x01010101},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff080808, 0x01010001, 0x01010101},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff090909, 0x03030003, 0x03030303},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0a0a0a, 0x03030003, 0x03030303},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0b0b0b, 0x06060006, 0x06060606},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0c0c0c, 0x06060006, 0x06060606},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0d0d0d, 0x08080008, 0x08080808},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0e0e0e, 0x08080008, 0x08080808},
        {0x3a2a2907, 0x0a08060c, 0x00040206, 0x06020200, 0x180e0c0a, 0xff0f0f0f, 0x0b0b000b, 0x0b0b0b0b},
        {0x4a3a390e, 0x1b190d1c, 0x0008040c, 0x0c040400, 0x281e1c1a, 0xff101010, 0x0b0b000b, 0x0b0b0b0b},
        {0x4a3a390e, 0x1b190d1c, 0x0008040c, 0x0c040400, 0x281e1c1a, 0xff111111, 0x0d0d000d, 0x0d0d0d0d},
        {0x4a3a390e, 0x1b190d1c, 0x0008040c, 0x0c040400, 0x281e1c1a, 0xff121212, 0x0d0d000d, 0x0d0d0d0d},
        {0x4a3a390e, 0x1b190d1c, 0x0008040c, 0x0c040400, 0x281e1c1a, 0xff131313, 0x10100010, 0x10101010},
        {0x4f3f3d1b, 0x281d1a29, 0x000c0619, 0x19060600, 0x2c2b291f, 0xff141414, 0x10100010, 0x10101010},
        {0x4f3f3d1b, 0x281d1a29, 0x000c0619, 0x19060600, 0x2c2b291f, 0xff151515, 0x13130013, 0x13131313},
        {0x4f3f3d1b, 0x281d1a29, 0x000c0619, 0x19060600, 0x2c2b291f, 0xff161616, 0x13130013, 0x13131313},
        {0x5a4a491e, 0x2b291d2c, 0x0018081c, 0x1c080800, 0x382e2c2a, 0xff171717, 0x16160016, 0x16161616},
        {0x5a4a491e, 0x2b291d2c, 0x0018081c, 0x1c080800, 0x382e2c2a, 0xff181818, 0x16160016, 0x16161616},
        {0x5a4a491e, 0x2b291d2c, 0x0018081c, 0x1c080800, 0x382e2c2a, 0xff191919, 0x1a1a001a, 0x1a1a1a1a},
        {0x5d4d4b29, 0x2d2b282f, 0x001a0a1f, 0x1f0a0a00, 0x3a392f2d, 0xff1a1a1a, 0x1a1a001a, 0x1a1a1a1a},
        {0x5f4f4d2b, 0x382d2a39, 0x001c0c29, 0x290c0c00, 0x3c3b392f, 0xff1b1b1b, 0x1e1e001e, 0x1e1e1e1e},
        {0x5f4f4d2b, 0x382d2a39, 0x001c0c29, 0x290c0c00, 0x3c3b392f, 0xff1c1c1c, 0x1e1e001e, 0x1e1e1e1e},
        {0x69594f2c, 0x392f2b3b, 0x001e0e2b, 0x2b0e0e00, 0x3e3c3b39, 0xff1d1d1d, 0x22220022, 0x22222222},
        {0x6a5a592e, 0x3b392d3c, 0x0028182c, 0x2c181800, 0x483e3c3a, 0xff1e1e1e, 0x22220022, 0x22222222},
        {0x6b5b5a38, 0x3c3a2f3e, 0x0029192e, 0x2e191900, 0x49483e3b, 0xff1f1f1f, 0x27270027, 0x27272727},
        {0x6d5d5b39, 0x3d3b383f, 0x002a1a2f, 0x2f1a1a00, 0x4a493f3d, 0xff202020, 0x27270027, 0x27272727},
        {0x6e5e5c3a, 0x3e3c3948, 0x002b1b38, 0x381b1b00, 0x4b4a483e, 0xff212121, 0x2c2c002c, 0x2c2c2c2c},
        {0x78685e3b, 0x493e3b4a, 0x002d1d3a, 0x3a1d1d00, 0x4d4b4a48, 0xff222222, 0x2c2c002c, 0x2c2c2c2c},
        {0x79695f3c, 0x493f3b4b, 0x002e1e3b, 0x3b1e1e00, 0x4e4c4b49, 0xff232323, 0x32320032, 0x32323232},
        {0x7a6a693e, 0x4b493d4c, 0x0038283c, 0x3c282800, 0x584e4c4a, 0xff242424, 0x32320032, 0x32323232},
        {0x7b6b6a48, 0x4c4a3f4e, 0x0039293e, 0x3e292900, 0x59584e4b, 0xff252525, 0x38380038, 0x38383838},
        {0x7d6d6b49, 0x4d4b484f, 0x003a2a3f, 0x3f2a2a00, 0x5a594f4d, 0xff262626, 0x38380038, 0x38383838},
        {0x7e6e6c4a, 0x4f4c4959, 0x003c2c49, 0x492c2c00, 0x5c5a594e, 0xff272727, 0x3e3e003e, 0x3e3e3e3e},
        {0x88786d4b, 0x584d4a59, 0x003d2d49, 0x492d2d00, 0x5d5b5958, 0xff282828, 0x3e3e003e, 0x3e3e3e3e},
        {0x89796f4d, 0x5a4f4c5b, 0x003f2f4b, 0x4b2f2f00, 0x5f5d5b59, 0xff292929, 0x45450045, 0x45454545},
        {0x8a7a794e, 0x5b594d5c, 0x0048384c, 0x4c383800, 0x685e5c5a, 0xff2a2a2a, 0x45450045, 0x45454545},
        {0x8b7b7a58, 0x5c5a4f5e, 0x0049394e, 0x4e393900, 0x69685e5b, 0xff2b2b2b, 0x4d4d004d, 0x4d4d4d4d},
        {0x8d7d7b59, 0x5d5b585f, 0x004a3a4f, 0x4f3a3a00, 0x6a695f5d, 0xff2c2c2c, 0x4d4d004d, 0x4d4d4d4d},
        {0x8e7e7c5a, 0x5f5c5968, 0x004b3b58, 0x583b3b00, 0x6b6a685e, 0xff2d2d2d, 0x55550055, 0x55555555},
        {0x8f887e5b, 0x685e5a6a, 0x004d3d5a, 0x5a3d3d00, 0x6d6b6a68, 0xff2e2e2e, 0x55550055, 0x55555555},
        {0x8f897f5c, 0x695f5c6b, 0x004e3e5b, 0x5b3e3e00, 0x6e6c6b69, 0xff2f2f2f, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f8a895e, 0x6b695d6c, 0x0058485c, 0x5c484800, 0x6f6e6c6a, 0xff303030, 0x5e5e005e, 0x5e5e5e5e},
        {0x8f8b8a68, 0x6c6a5f6e, 0x0059495e, 0x5e494900, 0x6f6f6e6b, 0xff313131, 0x68680068, 0x68686868},
        {0x8f8d8b69, 0x6d6b686f, 0x005a4a5f, 0x5f4a4a00, 0x6f6f6f6d, 0xff323232, 0x68680068, 0x68686868},
        {0x8f8e8c6a, 0x6f6c6979, 0x005b4b69, 0x694b4b00, 0x6f6f6f6e, 0xff333333, 0x73730073, 0x73737373}
    }
};
const unsigned char gen75_avc_qp_adjustment_dist_threshold_max_frame_threshold_dist_qp_adjustment_ipb[576] = {
    0x01, 0x02, 0x03, 0x05, 0x06, 0x01, 0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x01, 0x02, 0x03, 0xff,
    0x00, 0x00, 0x01, 0x02, 0xff, 0x00, 0x00, 0x00, 0x01, 0xfe, 0xfe, 0xff, 0x00, 0x01, 0xfd, 0xfd,
    0xff, 0xff, 0x00, 0xfb, 0xfd, 0xfe, 0xff, 0xff, 0xfa, 0xfb, 0xfd, 0xfe, 0xff, 0x00, 0x04, 0x1e,
    0x3c, 0x50, 0x78, 0x8c, 0xc8, 0xff, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x03, 0x05, 0x06, 0x01, 0x01, 0x02, 0x03, 0x05, 0x00, 0x01, 0x01, 0x02, 0x03, 0xff,
    0x00, 0x00, 0x01, 0x02, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x00, 0x01, 0xfe, 0xff,
    0xff, 0xff, 0x00, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0xfb, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0x04, 0x1e,
    0x3c, 0x50, 0x78, 0x8c, 0xc8, 0xff, 0x04, 0x05, 0x06, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x02, 0x04, 0x05, 0x01, 0x01, 0x01, 0x02, 0x04, 0x00, 0x00, 0x01, 0x01, 0x02, 0xff,
    0x00, 0x00, 0x01, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x01, 0xfe, 0xff,
    0xff, 0xff, 0x00, 0xfd, 0xfe, 0xff, 0xff, 0x00, 0xfb, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0x02, 0x14,
    0x28, 0x46, 0x82, 0xa0, 0xc8, 0xff, 0x04, 0x04, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
    0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
    0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
    0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
    0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
    0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
    0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const unsigned char gen9_avc_qp_adjustment_dist_threshold_max_frame_threshold_dist_qp_adjustment_ipb[576] = {
    0x01, 0x02, 0x03, 0x05, 0x06, 0x01, 0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x01, 0x02, 0x03, 0xff,
    0x00, 0x00, 0x01, 0x02, 0xff, 0x00, 0x00, 0x00, 0x01, 0xfe, 0xfe, 0xff, 0x00, 0x01, 0xfd, 0xfd,
    0xff, 0xff, 0x00, 0xfb, 0xfd, 0xfe, 0xff, 0xff, 0xfa, 0xfb, 0xfd, 0xfe, 0xff, 0x00, 0x04, 0x1e,
    0x3c, 0x50, 0x78, 0x8c, 0xc8, 0xff, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x03, 0x05, 0x06, 0x01, 0x01, 0x02, 0x03, 0x05, 0x00, 0x01, 0x01, 0x02, 0x03, 0xff,
    0x00, 0x00, 0x01, 0x02, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x00, 0x01, 0xfe, 0xff,
    0xff, 0xff, 0x00, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0xfb, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0x04, 0x1e,
    0x3c, 0x50, 0x78, 0x8c, 0xc8, 0xff, 0x04, 0x05, 0x06, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x02, 0x04, 0x05, 0x01, 0x01, 0x01, 0x02, 0x04, 0x00, 0x00, 0x01, 0x01, 0x02, 0xff,
    0x00, 0x00, 0x01, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x01, 0xfe, 0xff,
    0xff, 0xff, 0x00, 0xfd, 0xfe, 0xff, 0xff, 0x00, 0xfb, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0x02, 0x14,
    0x28, 0x46, 0x82, 0xa0, 0xc8, 0xff, 0x04, 0x04, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
    0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
    0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
    0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
    0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
    0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
    0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// SkipVal (DW offset 9) in the following table needs to be changed by Driver based on the BlockbasedSkip and Transform Flag.
// Kernel indexes this table based on the MB QP.
const unsigned int gen9_avc_mb_brc_const_data[3][AVC_QP_MAX][16] = {
    //I-slice
    {
        //ModeCOST(0), ModeCOST(1), ModeCOST(2), MVCOST(3),   MVCOST(4),   QP(5),       FTQ Thds(6), FTQ Thds(7), RefCost(8),  SkipVal(9),  IntraSF(10) ,Zero(11),  Zero(12),   Zero(13),   Zero(14) ,  Zero(15)
        {0x0d000003,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x0f000004,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff010101,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x19000004,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff020202,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x1a000005,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff030303,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x1b000005,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff040404,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x1c000006,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff050505,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x1e000007,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff060606,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x28000008,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff070707,  0x01010001,  0x01010101,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x29000009,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff080808,  0x01010001,  0x01010101,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x2a00000a,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff090909,  0x03030003,  0x03030303,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x2b00000b,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0a0a0a,  0x03030003,  0x03030303,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x2c00000c,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0b0b0b,  0x06060006,  0x06060606,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x2e00000e,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0c0c0c,  0x06060006,  0x06060606,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x38000018,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0d0d0d,  0x08080008,  0x08080808,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x39000019,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0e0e0e,  0x08080008,  0x08080808,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a00001b,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0f0f0f,  0x0b0b000b,  0x0b0b0b0b,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3b00001c,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff101010,  0x0b0b000b,  0x0b0b0b0b,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3c00001d,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff111111,  0x0d0d000d,  0x0d0d0d0d,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3e00001f,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff121212,  0x0d0d000d,  0x0d0d0d0d,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x48020028,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff131313,  0x10100010,  0x10101010,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x49020029,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff141414,  0x10100010,  0x10101010,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4a03002a,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff151515,  0x13130013,  0x13131313,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4b03002b,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff161616,  0x13130013,  0x13131313,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4c04002b,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff171717,  0x16160016,  0x16161616,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4e04002c,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff181818,  0x16160016,  0x16161616,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5805002e,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff191919,  0x1a1a001a,  0x1a1a1a1a,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5905002f,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1a1a1a,  0x1a1a001a,  0x1a1a1a1a,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5a06002e,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1b1b1b,  0x1e1e001e,  0x1e1e1e1e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5b07002f,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1c1c1c,  0x1e1e001e,  0x1e1e1e1e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5c080039,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1d1d1d,  0x22220022,  0x22222222,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5e09003a,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1e1e1e,  0x22220022,  0x22222222,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6828003a,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1f1f1f,  0x27270027,  0x27272727,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6929003b,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff202020,  0x27270027,  0x27272727,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6a2a003c,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff212121,  0x2c2c002c,  0x2c2c2c2c,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6b2c003e,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff222222,  0x2c2c002c,  0x2c2c2c2c,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6c3a003e,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff232323,  0x32320032,  0x32323232,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6e3b0048,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff242424,  0x32320032,  0x32323232,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x783c0049,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff252525,  0x38380038,  0x38383838,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x793e004a,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff262626,  0x38380038,  0x38383838,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7a3e004b,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff272727,  0x3e3e003e,  0x3e3e3e3e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7b48004c,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff282828,  0x3e3e003e,  0x3e3e3e3e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7c49004e,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff292929,  0x45450045,  0x45454545,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7e4a0058,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2a2a2a,  0x45450045,  0x45454545,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x884d0059,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2b2b2b,  0x4d4d004d,  0x4d4d4d4d,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x894f005a,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2c2c2c,  0x4d4d004d,  0x4d4d4d4d,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8a58005b,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2d2d2d,  0x55550055,  0x55555555,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8b59005c,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2e2e2e,  0x55550055,  0x55555555,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8c5c005b,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2f2f2f,  0x5e5e005e,  0x5e5e5e5e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8e5d005c,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff303030,  0x5e5e005e,  0x5e5e5e5e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f5f005d,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff313131,  0x68680068,  0x68686868,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f68005f,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff323232,  0x68680068,  0x68686868,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f690068,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff333333,  0x73730073,  0x73737373,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}
    },
    //P-slice
    {
        //ModeCOST(0), ModeCOST(1), ModeCOST(2), MVCOST(3),   MVCOST(4),   QP(5),       FTQ Thds(6), FTQ Thds(7), RefCost(8),  SkipVal(9),  IntraSF(10) ,Zero(11),  Zero(12),   Zero(13),   Zero(14) ,  Zero(15)
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff010101,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff020202,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff030303,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff040404,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff050505,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff060606,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff070707,  0x01010001,  0x01010101,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff080808,  0x01010001,  0x01010101,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff090909,  0x03030003,  0x03030303,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff0a0a0a,  0x03030003,  0x03030303,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff0b0b0b,  0x06060006,  0x06060606,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff0c0c0c,  0x06060006,  0x06060606,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff0d0d0d,  0x08080008,  0x08080808,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff0e0e0e,  0x08080008,  0x08080808,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x391e1a07,   0x06040208,  0x00040005,  0x09050401,  0x0f0e0c0a,  0xff0f0f0f,  0x0b0b000b,  0x0b0b0b0b,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x492e2a0e,   0x0d090519,  0x0008000b,  0x190a0802,  0x1f1e1c1a,  0xff101010,  0x0b0b000b,  0x0b0b0b0b,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x492e2a0e,   0x0d090519,  0x0008000b,  0x190a0802,  0x1f1e1c1a,  0xff111111,  0x0d0d000d,  0x0d0d0d0d,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x492e2a0e,   0x0d090519,  0x0008000b,  0x190a0802,  0x1f1e1c1a,  0xff121212,  0x0d0d000d,  0x0d0d0d0d,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x492e2a0e,   0x0d090519,  0x0008000b,  0x190a0802,  0x1f1e1c1a,  0xff131313,  0x10100010,  0x10101010,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4d3b2f1b,   0x1a0d071d,  0x000c0018,  0x1e0f0c03,  0x2b2b291f,  0xff141414,  0x10100010,  0x10101010,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4d3b2f1b,   0x1a0d071d,  0x000c0018,  0x1e0f0c03,  0x2b2b291f,  0xff151515,  0x13130013,  0x13131313,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4d3b2f1b,   0x1a0d071d,  0x000c0018,  0x1e0f0c03,  0x2b2b291f,  0xff161616,  0x13130013,  0x13131313,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x593e3a1e,   0x1d190a29,  0x0018001b,  0x291a1804,  0x2f2e2c2a,  0xff171717,  0x16160016,  0x16161616,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x593e3a1e,   0x1d190a29,  0x0018001b,  0x291a1804,  0x2f2e2c2a,  0xff181818,  0x16160016,  0x16161616,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x593e3a1e,   0x1d190a29,  0x0018001b,  0x291a1804,  0x2f2e2c2a,  0xff191919,  0x1a1a001a,  0x1a1a1a1a,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5b493d29,   0x281c0d2b,  0x001a001e,  0x2b1d1a05,  0x39392f2d,  0xff1a1a1a,  0x1a1a001a,  0x1a1a1a1a,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5d4b3f2b,   0x2a1e0f2d,  0x001c0028,  0x2e1f1c06,  0x3b3b392f,  0xff1b1b1b,  0x1e1e001e,  0x1e1e1e1e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5d4b3f2b,   0x2a1e0f2d,  0x001c0028,  0x2e1f1c06,  0x3b3b392f,  0xff1c1c1c,  0x1e1e001e,  0x1e1e1e1e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5f4c492c,   0x2c28192f,  0x001e002a,  0x38291e07,  0x3d3c3b39,  0xff1d1d1d,  0x22220022,  0x22222222,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x694e4a2e,   0x2d291b39,  0x0028002b,  0x392a2808,  0x3f3e3c3a,  0xff1e1e1e,  0x22220022,  0x22222222,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6a584b38,   0x2f2a1c3a,  0x0029002c,  0x3a2b2909,  0x48483e3b,  0xff1f1f1f,  0x27270027,  0x27272727,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6b594d39,   0x382c1d3b,  0x002a002e,  0x3b2d2a0a,  0x49493f3d,  0xff202020,  0x27270027,  0x27272727,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6c5a4e3a,   0x392d1f3c,  0x002b002f,  0x3c2e2b0b,  0x4a4a483e,  0xff212121,  0x2c2c002c,  0x2c2c2c2c,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6e5b583b,   0x3b2f293e,  0x002d0039,  0x3f382d0d,  0x4c4b4a48,  0xff222222,  0x2c2c002c,  0x2c2c2c2c,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6f5c593c,   0x3c38293f,  0x002e003a,  0x48392e0e,  0x4d4c4b49,  0xff232323,  0x32320032,  0x32323232,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x795e5a3e,   0x3d392b49,  0x0038003b,  0x493a3818,  0x4f4e4c4a,  0xff242424,  0x32320032,  0x32323232,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7a685b48,   0x3f3a2c4a,  0x0039003c,  0x4a3b3919,  0x58584e4b,  0xff252525,  0x38380038,  0x38383838,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7b695d49,   0x483c2d4b,  0x003a003e,  0x4b3d3a1a,  0x59594f4d,  0xff262626,  0x38380038,  0x38383838,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7d6a5e4a,   0x4a3d2f4c,  0x003c0048,  0x4d3e3c1c,  0x5b5a594e,  0xff272727,  0x3e3e003e,  0x3e3e3e3e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7e6b684b,   0x4a3e384d,  0x003d0049,  0x4e483d1d,  0x5c5b5958,  0xff282828,  0x3e3e003e,  0x3e3e3e3e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x886d694d,   0x4c483a4f,  0x003f004a,  0x58493f1f,  0x5e5d5b59,  0xff292929,  0x45450045,  0x45454545,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x896e6a4e,   0x4d493b59,  0x0048004b,  0x594a4828,  0x5f5e5c5a,  0xff2a2a2a,  0x45450045,  0x45454545,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8a786b58,   0x4f4a3c5a,  0x0049004c,  0x5a4b4929,  0x68685e5b,  0xff2b2b2b,  0x4d4d004d,  0x4d4d4d4d,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8b796d59,   0x584c3d5b,  0x004a004e,  0x5b4d4a2a,  0x69695f5d,  0xff2c2c2c,  0x4d4d004d,  0x4d4d4d4d,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8c7a6e5a,   0x594d3f5c,  0x004b004f,  0x5d4e4b2b,  0x6b6a685e,  0xff2d2d2d,  0x55550055,  0x55555555,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8e7b785b,   0x5b4f485e,  0x004d0059,  0x5e584d2d,  0x6c6b6a68,  0xff2e2e2e,  0x55550055,  0x55555555,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f7c795c,   0x5c58495f,  0x004e005a,  0x68594e2e,  0x6d6c6b69,  0xff2f2f2f,  0x5e5e005e,  0x5e5e5e5e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f7e7a5e,   0x5d594b69,  0x0058005b,  0x695a5838,  0x6f6e6c6a,  0xff303030,  0x5e5e005e,  0x5e5e5e5e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f887b68,   0x5f5a4c6a,  0x0059005c,  0x6a5b5939,  0x6f6f6e6b,  0xff313131,  0x68680068,  0x68686868,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f897d69,   0x685c4d6b,  0x005a005e,  0x6b5d5a3a,  0x6f6f6f6d,  0xff323232,  0x68680068,  0x68686868,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f8a7e6a,   0x695d4f6c,  0x005b0068,  0x6d5e5b3b,  0x6f6f6f6e,  0xff333333,  0x73730073,  0x73737373,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}
    },
    //B-slice
    {
        //ModeCOST(0), ModeCOST(1), ModeCOST(2), MVCOST(3),   MVCOST(4),   QP(5),       FTQ Thds(6), FTQ Thds(7), RefCost(8),  SkipVal(9),  IntraSF(10) ,Zero(11),  Zero(12),   Zero(13),   Zero(14) ,  Zero(15)
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff010101,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff020202,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff030303,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff040404,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff050505,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff060606,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff070707,  0x01010001,  0x01010101,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff080808,  0x01010001,  0x01010101,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff090909,  0x03030003,  0x03030303,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff0a0a0a,  0x03030003,  0x03030303,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff0b0b0b,  0x06060006,  0x06060606,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff0c0c0c,  0x06060006,  0x06060606,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff0d0d0d,  0x08080008,  0x08080808,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff0e0e0e,  0x08080008,  0x08080808,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x3a2a2907,   0x0a08060c,  0x00040206,  0x06020200,  0x180e0c0a,  0xff0f0f0f,  0x0b0b000b,  0x0b0b0b0b,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4a3a390e,   0x1b190d1c,  0x0008040c,  0x0c040400,  0x281e1c1a,  0xff101010,  0x0b0b000b,  0x0b0b0b0b,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4a3a390e,   0x1b190d1c,  0x0008040c,  0x0c040400,  0x281e1c1a,  0xff111111,  0x0d0d000d,  0x0d0d0d0d,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4a3a390e,   0x1b190d1c,  0x0008040c,  0x0c040400,  0x281e1c1a,  0xff121212,  0x0d0d000d,  0x0d0d0d0d,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4a3a390e,   0x1b190d1c,  0x0008040c,  0x0c040400,  0x281e1c1a,  0xff131313,  0x10100010,  0x10101010,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4f3f3d1b,   0x281d1a29,  0x000c0619,  0x19060600,  0x2c2b291f,  0xff141414,  0x10100010,  0x10101010,  0x00000000,  0x00000000,  0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4f3f3d1b,   0x281d1a29,  0x000c0619,  0x19060600,  0x2c2b291f,  0xff151515,  0x13130013,  0x13131313,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x4f3f3d1b,   0x281d1a29,  0x000c0619,  0x19060600,  0x2c2b291f,  0xff161616,  0x13130013,  0x13131313,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5a4a491e,   0x2b291d2c,  0x0018081c,  0x1c080800,  0x382e2c2a,  0xff171717,  0x16160016,  0x16161616,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5a4a491e,   0x2b291d2c,  0x0018081c,  0x1c080800,  0x382e2c2a,  0xff181818,  0x16160016,  0x16161616,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5a4a491e,   0x2b291d2c,  0x0018081c,  0x1c080800,  0x382e2c2a,  0xff191919,  0x1a1a001a,  0x1a1a1a1a,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5d4d4b29,   0x2d2b282f,  0x001a0a1f,  0x1f0a0a00,  0x3a392f2d,  0xff1a1a1a,  0x1a1a001a,  0x1a1a1a1a,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5f4f4d2b,   0x382d2a39,  0x001c0c29,  0x290c0c00,  0x3c3b392f,  0xff1b1b1b,  0x1e1e001e,  0x1e1e1e1e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x5f4f4d2b,   0x382d2a39,  0x001c0c29,  0x290c0c00,  0x3c3b392f,  0xff1c1c1c,  0x1e1e001e,  0x1e1e1e1e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x69594f2c,   0x392f2b3b,  0x001e0e2b,  0x2b0e0e00,  0x3e3c3b39,  0xff1d1d1d,  0x22220022,  0x22222222,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6a5a592e,   0x3b392d3c,  0x0028182c,  0x2c181800,  0x483e3c3a,  0xff1e1e1e,  0x22220022,  0x22222222,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6b5b5a38,   0x3c3a2f3e,  0x0029192e,  0x2e191900,  0x49483e3b,  0xff1f1f1f,  0x27270027,  0x27272727,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6d5d5b39,   0x3d3b383f,  0x002a1a2f,  0x2f1a1a00,  0x4a493f3d,  0xff202020,  0x27270027,  0x27272727,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x6e5e5c3a,   0x3e3c3948,  0x002b1b38,  0x381b1b00,  0x4b4a483e,  0xff212121,  0x2c2c002c,  0x2c2c2c2c,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x78685e3b,   0x493e3b4a,  0x002d1d3a,  0x3a1d1d00,  0x4d4b4a48,  0xff222222,  0x2c2c002c,  0x2c2c2c2c,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x79695f3c,   0x493f3b4b,  0x002e1e3b,  0x3b1e1e00,  0x4e4c4b49,  0xff232323,  0x32320032,  0x32323232,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7a6a693e,   0x4b493d4c,  0x0038283c,  0x3c282800,  0x584e4c4a,  0xff242424,  0x32320032,  0x32323232,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7b6b6a48,   0x4c4a3f4e,  0x0039293e,  0x3e292900,  0x59584e4b,  0xff252525,  0x38380038,  0x38383838,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7d6d6b49,   0x4d4b484f,  0x003a2a3f,  0x3f2a2a00,  0x5a594f4d,  0xff262626,  0x38380038,  0x38383838,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x7e6e6c4a,   0x4f4c4959,  0x003c2c49,  0x492c2c00,  0x5c5a594e,  0xff272727,  0x3e3e003e,  0x3e3e3e3e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x88786d4b,   0x584d4a59,  0x003d2d49,  0x492d2d00,  0x5d5b5958,  0xff282828,  0x3e3e003e,  0x3e3e3e3e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x89796f4d,   0x5a4f4c5b,  0x003f2f4b,  0x4b2f2f00,  0x5f5d5b59,  0xff292929,  0x45450045,  0x45454545,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8a7a794e,   0x5b594d5c,  0x0048384c,  0x4c383800,  0x685e5c5a,  0xff2a2a2a,  0x45450045,  0x45454545,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8b7b7a58,   0x5c5a4f5e,  0x0049394e,  0x4e393900,  0x69685e5b,  0xff2b2b2b,  0x4d4d004d,  0x4d4d4d4d,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8d7d7b59,   0x5d5b585f,  0x004a3a4f,  0x4f3a3a00,  0x6a695f5d,  0xff2c2c2c,  0x4d4d004d,  0x4d4d4d4d,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8e7e7c5a,   0x5f5c5968,  0x004b3b58,  0x583b3b00,  0x6b6a685e,  0xff2d2d2d,  0x55550055,  0x55555555,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f887e5b,   0x685e5a6a,  0x004d3d5a,  0x5a3d3d00,  0x6d6b6a68,  0xff2e2e2e,  0x55550055,  0x55555555,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f897f5c,   0x695f5c6b,  0x004e3e5b,  0x5b3e3e00,  0x6e6c6b69,  0xff2f2f2f,  0x5e5e005e,  0x5e5e5e5e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f8a895e,   0x6b695d6c,  0x0058485c,  0x5c484800,  0x6f6e6c6a,  0xff303030,  0x5e5e005e,  0x5e5e5e5e,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f8b8a68,   0x6c6a5f6e,  0x0059495e,  0x5e494900,  0x6f6f6e6b,  0xff313131,  0x68680068,  0x68686868,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f8d8b69,   0x6d6b686f,  0x005a4a5f,  0x5f4a4a00,  0x6f6f6f6d,  0xff323232,  0x68680068,  0x68686868,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
        {0x8f8e8c6a,   0x6f6c6979,  0x005b4b69,  0x694b4b00,  0x6f6f6f6e,  0xff333333,  0x73730073,  0x73737373,  0x00000000,  0x00000000,  0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}
    }
};

// AVC MBEnc RefCost tables, index [CodingType][QP]
// QP is from 0 - 51, pad it to 64 since BRC needs each subarray size to be 128bytes
const unsigned short gen9_avc_ref_cost[3][64] = {
    // I-frame
    {
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000
    },
    // P-slice
    {
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000
    },
    //B-slice
    {
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000
    }
};

const bool gen9_avc_mbbrc_enable[PRESET_NUM] = {
    false, true, true, false, false, false, false, false
};

const unsigned int gen9_avc_super_hme[PRESET_NUM] = {
    0, 1, 1, 1, 1, 1, 1, 1
};

const unsigned int gen9_avc_ultra_hme[PRESET_NUM] = {
    0, 1, 1, 1, 1, 1, 1, 0
};

// 1 for P, 3 for P & B
const unsigned int gen9_avc_all_fractional[PRESET_NUM] = {
    0, 3, 3, 3, 3, 3, 3, 0
};

const unsigned char gen9_avc_max_ref_id0_progressive_4k[PRESET_NUM] = {
    0, 3, 3, 2, 2, 2, 0, 0
};

const unsigned char gen9_avc_max_ref_id0[PRESET_NUM] = {
    0, 7, 5, 2, 2, 2, 0, 0
};

const unsigned char gen9_avc_max_b_ref_id0[PRESET_NUM] = {
    0, 3, 3, 1, 1, 1, 0, 0
};

const unsigned char gen9_avc_max_ref_id1[PRESET_NUM] = {
    0, 1, 1, 1, 1, 1, 0, 0
};

const unsigned int gen9_avc_inter_rounding_p[PRESET_NUM] = {
    // gen9 and gen95
    0, 3, 3, 3, 3, 3, 3, 3
};

const unsigned int gen9_avc_inter_rounding_b_ref[PRESET_NUM] = {
    // gen9 and gen95
    0, 2, 2, 2, 2, 2, 2, 2
};

const unsigned int gen9_avc_inter_rounding_b[PRESET_NUM] = {
    // gen9 and gen95
    0, 0, 0, 0, 0, 0, 0, 0
};

// This applies only for progressive pictures. For interlaced, CAF is currently not disabled.
const unsigned int gen9_avc_disable_all_fractional_check_for_high_res[PRESET_NUM] = {
    0, 0, 0, 1, 1, 1, 1, 1
};

const unsigned char gen9_avc_adaptive_inter_rounding_p[AVC_QP_MAX] = {
//QP =  0   1   2   3   4   5   6   7   8   9   10  11  12
    4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  //QP=[0~12]
    4,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,  3,  3,  //QP=[13~25]
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  //QP=[26~38]
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3   //QP=[39~51]
};

const unsigned char gen9_avc_adaptive_inter_rounding_b[AVC_QP_MAX] = {
//QP =  0   1   2   3   4   5   6   7   8   9   10  11  12
    4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  //QP=[0~12]
    4,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  //QP=[13~25]
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  //QP=[26~38]
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0   //QP=[39~51]
};

const unsigned char gen9_avc_adaptive_inter_rounding_p_without_b[AVC_QP_MAX] = {
//QP =  0   1   2   3   4   5   6   7   8   9   10  11  12
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  //QP=[0~12]
    3,  3,  3,  3,  3,  3,  3,  3,  1,  0,  0,  0,  0,  //QP=[13~25]
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  //QP=[26~38]
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0   //QP=[39~51]
};

const unsigned int gen9_avc_trellis_quantization_enable[PRESET_NUM] = {
    //gen9 and gen95
    0, 1, 0, 0, 0, 0, 0, 0
};

const unsigned int gen9_avc_trellis_quantization_rounding[PRESET_NUM] = {
    0, 6, 0, 0, 0, 0, 0, 0
};

const unsigned int gen9_avc_enable_adaptive_trellis_quantization[PRESET_NUM] = {
    //gen9 and gen95
    0, 1, 0, 0, 0, 0, 0, 0
};

const unsigned int gen9_avc_super_combine_dist[PRESET_NUM + 1] = {
    0, 1, 1, 5, 5, 5, 9, 9, 0
};

const unsigned char gen9_avc_b_me_method[PRESET_NUM + 1] = {
    0, 4, 4, 6, 6, 6, 6, 4, 7
};

const unsigned char gen9_avc_p_me_method[PRESET_NUM + 1] = {
    0, 4, 4, 6, 6, 6, 6, 4, 7
};

const unsigned int gen9_avc_enable_adaptive_search[PRESET_NUM] = {
    0, 1, 1, 1, 1, 1, 0, 0
};

const unsigned int gen9_avc_max_len_sp[PRESET_NUM] = {
    0, 57, 57, 25, 25, 25, 16, 9
};

const unsigned int gen9_avc_max_ftq_based_skip[PRESET_NUM] = {
    0, 3, 3, 3, 3, 3, 3, 0
};

const unsigned int gen9_avc_mr_disable_qp_check[PRESET_NUM] = {
    0, 1, 0, 0, 0, 0, 0, 0
};

const unsigned int gen9_avc_multi_pred[PRESET_NUM] = {
    0, 3, 3, 0, 0, 0, 0, 0
};

const unsigned int gen9_avc_hme_b_combine_len[PRESET_NUM] = {
    0, 8, 8, 8, 8, 8, 8, 8
};
const unsigned int gen9_avc_hme_combine_len[PRESET_NUM] = {
    0, 8, 8, 8, 8, 8, 16, 8
};

const unsigned int gen9_avc_search_x[PRESET_NUM] = {
    0, 48, 48, 48, 48, 48, 48, 28
};
const unsigned int gen9_avc_search_y[PRESET_NUM] = {
    0, 40, 40, 40, 40, 40, 40, 28
};

const unsigned int gen9_avc_b_search_x[PRESET_NUM] = {
    0, 32, 32, 32, 32, 32, 32, 24
};
const unsigned int gen9_avc_b_search_y[PRESET_NUM] = {
    0, 32, 32, 32, 32, 32, 32, 24
};

const unsigned char gen9_avc_enable_adaptive_tx_decision[PRESET_NUM] = {
    0, 1, 1, 1, 1, 1, 1, 0
};

const unsigned char gen9_avc_kernel_mode[PRESET_NUM] = {
    1,  0,  0, 1, 1, 1, 1, 2
};

/*===== AVC FEI specific constants =========*/
const unsigned int gen9_avc_fei_mbenc_curbe_i_frame_init_data [GEN9_AVC_FEI_MBENC_CURBE_SIZE] = {
    0x00000082, 0x00000000, 0x00003910, 0x00a83000, 0x00000000, 0x28300000, 0x05000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80800000, 0x00040c24, 0x00000000, 0xffff00ff, 0x40000000, 0x00000080, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};
/* AVC MBEnc CURBE init data for P frame, gen9 Kernel */
const unsigned int gen9_avc_fei_mbenc_curbe_p_frame_init_data [GEN9_AVC_FEI_MBENC_CURBE_SIZE] = {
    0x000000a3, 0x00000008, 0x00003910, 0x00ae3000, 0x30000000, 0x28300000, 0x05000000, 0x01400060,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80010000, 0x00040c24, 0x00000000, 0xffff00ff, 0x60000000, 0x000000a1, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};
/* AVC MBEnc CURBE init data for B frame, gen9 Kernel */
const unsigned int gen9_avc_fei_mbenc_curbe_b_frame_init_data [GEN9_AVC_FEI_MBENC_CURBE_SIZE] = {
    0x000000a3, 0x00200008, 0x00003910, 0x00aa7700, 0x50020000, 0x20200000, 0x05000000, 0xff400000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x01010000, 0x00040c24, 0x00000000, 0xffff00ff, 0x60000000, 0x000000a1, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};
const unsigned int gen9_avc_fei_mbenc_curbe_i_frame_dist_init_data[GEN9_AVC_FEI_MBENC_CURBE_SIZE] = {
    0x00000082, 0x00200008, 0x001e3910, 0x00a83000, 0x90000000, 0x28300000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100,
    0x80800000, 0x00000000, 0x00000800, 0xffff00ff, 0x40000000, 0x00000080, 0x00003900, 0x28300000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};

/***** Gen9 avc prenenc init curbes ******/

/* AVC PreProc curbe init data for I frame */
const unsigned int gen9_avc_preenc_preproc_curbe_i_frame_init_data [GEN9_AVC_PREPROC_CURBE_SIZE] = {
    0x00000082, 0x00000000, 0x00003910, 0x00a83000, 0x00000000, 0x28300000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00040c24, 0x00000000, 0x00000000, 0x40000000, 0x00000080, 0x00003900, 0x28301000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff
};

/* AVC PreProc curbe init data for P frame */
const unsigned int gen9_avc_preenc_preproc_curbe_p_frame_init_data [GEN9_AVC_PREPROC_CURBE_SIZE] = {
    0x000000a3, 0x00000008, 0x00003910, 0x00ae3000, 0x00000000, 0x28300000, 0x00000000, 0x01400060,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00040c24, 0x00000000, 0x00000000, 0x60000000, 0x000000a1, 0x00003900, 0x28301000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff
};

/* AVC PreProc curbe init data for B frame */
const unsigned int gen9_avc_preenc_preproc_curbe_b_frame_init_data [GEN9_AVC_PREPROC_CURBE_SIZE] = {
    0x000000a3, 0x00200008, 0x00003910, 0x00aa7700, 0x00000000, 0x20200000, 0x00000000, 0xff400000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00040c24, 0x00000000, 0x00000000, 0x60000000, 0x000000a1, 0x00003900, 0x28301000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff
};


//ModeCOST(0), ModeCOST(1), ModeCOST(2), MVCOST(3),   MVCOST(4),   QP(5),       FTQ Thds(6), FTQ Thds(7), RefCost(8),  SkipVal(9),  IntraSF(10) ,Zero(11),  Zero(12),   Zero(13),   Zero(14) ,  Zero(15)
const unsigned int gen9_avc_preenc_preproc_ftq_lut [AVC_QP_MAX][16] = {
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff010101,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff020202,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff030303,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff040404,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff050505,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff060606,  0x00000000,  0x00000000,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff070707,  0x01010001,  0x01010101,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff080808,  0x01010001,  0x01010101,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff090909,  0x03030003,  0x03030303,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0a0a0a,  0x03030003,  0x03030303,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0b0b0b,  0x06060006,  0x06060606,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0c0c0c,  0x06060006,  0x06060606,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0d0d0d,  0x08080008,  0x08080808,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0e0e0e,  0x08080008,  0x08080808,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff0f0f0f,  0x0b0b000b,  0x0b0b0b0b,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff101010,  0x0b0b000b,  0x0b0b0b0b,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff111111,  0x0d0d000d,  0x0d0d0d0d,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff121212,  0x0d0d000d,  0x0d0d0d0d,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff131313,  0x10100010,  0x10101010,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff141414,  0x10100010,  0x10101010,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff151515,  0x13130013,  0x13131313,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff161616,  0x13130013,  0x13131313,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff171717,  0x16160016,  0x16161616,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff181818,  0x16160016,  0x16161616,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff191919,  0x1a1a001a,  0x1a1a1a1a,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1a1a1a,  0x1a1a001a,  0x1a1a1a1a,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1b1b1b,  0x1e1e001e,  0x1e1e1e1e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1c1c1c,  0x1e1e001e,  0x1e1e1e1e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1d1d1d,  0x22220022,  0x22222222,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1e1e1e,  0x22220022,  0x22222222,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff1f1f1f,  0x27270027,  0x27272727,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff202020,  0x27270027,  0x27272727,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff212121,  0x2c2c002c,  0x2c2c2c2c,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff222222,  0x2c2c002c,  0x2c2c2c2c,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff232323,  0x32320032,  0x32323232,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff242424,  0x32320032,  0x32323232,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff252525,  0x38380038,  0x38383838,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff262626,  0x38380038,  0x38383838,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff272727,  0x3e3e003e,  0x3e3e3e3e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff282828,  0x3e3e003e,  0x3e3e3e3e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff292929,  0x45450045,  0x45454545,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2a2a2a,  0x45450045,  0x45454545,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2b2b2b,  0x4d4d004d,  0x4d4d4d4d,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2c2c2c,  0x4d4d004d,  0x4d4d4d4d,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2d2d2d,  0x55550055,  0x55555555,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2e2e2e,  0x55550055,  0x55555555,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff2f2f2f,  0x5e5e005e,  0x5e5e5e5e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff303030,  0x5e5e005e,  0x5e5e5e5e,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff313131,  0x68680068,  0x68686868,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff323232,  0x68680068,  0x68686868,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    { 0x00000000,   0x00000000,  0x00000000,  0x00000000,  0x00000000,  0xff333333,  0x73730073,  0x73737373,  0x00000000,  0x00000000,  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 }
};

/* Gen95  */
const unsigned int gen95_avc_trellis_quantization_rounding[PRESET_NUM] = {
    0, 3, 0, 0, 0, 0, 0, 0
};

// AVC MBEnc CURBE init data
const unsigned int gen95_avc_mbenc_curbe_normal_i_frame_init_data[GEN9_AVC_MBENC_CURBE_SIZE] = {
    0x00000082, 0x00000000, 0x00003910, 0x00a83000, 0x00000000, 0x28300000, 0x05000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80800000, 0x00040c24, 0x00000000, 0xffff00ff, 0x40000000, 0x00000080, 0x00003900, 0x28300000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00000000
};


const unsigned int gen95_avc_mbenc_curbe_normal_p_frame_init_data[GEN9_AVC_MBENC_CURBE_SIZE] = {
    0x000000a3, 0x00000008, 0x00003910, 0x00ae3000, 0x30000000, 0x28300000, 0x05000000, 0x01400060,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80010000, 0x00040c24, 0x00000000, 0xffff00ff, 0x60000000, 0x000000a1, 0x00003900, 0x28300000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00000000
};

const unsigned int gen95_avc_mbenc_curbe_normal_b_frame_init_data[GEN9_AVC_MBENC_CURBE_SIZE] = {
    0x000000a3, 0x00200008, 0x00003910, 0x00aa7700, 0x50020000, 0x20200000, 0x05000000, 0xff400000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x01010000, 0x00040c24, 0x00000000, 0xffff00ff, 0x60000000, 0x000000a1, 0x00003900, 0x28300000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00000000
};

// AVC I_DIST CURBE init data
const unsigned int gen95_avc_mbenc_curbe_i_frame_dist_init_data[GEN9_AVC_MBENC_CURBE_SIZE] = {
    0x00000082, 0x00200008, 0x001e3910, 0x00a83000, 0x90000000, 0x28300000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100,
    0x80800000, 0x00000000, 0x00000800, 0xffff00ff, 0x40000000, 0x00000080, 0x00003900, 0x28300000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

// Lambda values for Trellis Quantization
const unsigned int gen95_avc_tq_lambda_i_frame[AVC_QP_MAX][2] = {
    {0x00070000, 0x00060000},
    {0x00080000, 0x00080000},
    {0x000a0000, 0x00090000},
    {0x000d0000, 0x000c0000},
    {0x00110000, 0x000f0000},
    {0x00150000, 0x00130000},
    {0x001b0000, 0x00180000},
    {0x00220000, 0x001f0000},
    {0x002b0000, 0x00270000},
    {0x00360000, 0x00310000},
    {0x00440000, 0x003e0000},
    {0x00550000, 0x004e0000},
    {0x006c0000, 0x00630000},
    {0x00870000, 0x007d0000},
    {0x00ab0000, 0x009d0000},
    {0x00d70000, 0x00c70000},
    {0x010f0000, 0x00fb0000},
    {0x01560000, 0x013d0000},
    {0x01af0000, 0x01900000},
    {0x021f0000, 0x01f90000},
    {0x02ac0000, 0x027e0000},
    {0x035e0000, 0x03260000},
    {0x043e0000, 0x03fa0000},
    {0x057a0000, 0x05070000},
    {0x06f90000, 0x065a0000},
    {0x08770000, 0x08060000},
    {0x0af50000, 0x0a240000},
    {0x0d720000, 0x0cd10000},
    {0x10ef0000, 0x10340000},
    {0x156a0000, 0x147b0000},
    {0x1ae50000, 0x19e50000},
    {0x225d0000, 0x20be0000},
    {0x2ad50000, 0x29670000},
    {0x36490000, 0x345c0000},
    {0x443b0000, 0x423a0000},
    {0x56290000, 0x53c50000},
    {0x6c930000, 0x69f90000},
    {0x88770000, 0x86130000},
    {0xabd30000, 0xa9a40000},
    {0xd8a60000, 0xd6aa0000},

    // Rounding offsets
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000},
    {0xfffa0000, 0xfffa0000}
};

const unsigned int gen95_avc_tq_lambda_p_frame[AVC_QP_MAX][2] = {
    {0x00070009, 0x00060009},
    {0x0008000c, 0x0008000c},
    {0x000a000f, 0x0009000f},
    {0x000d0013, 0x000c0013},
    {0x00110018, 0x000f0018},
    {0x0015001e, 0x0013001e},
    {0x001b0026, 0x00180026},
    {0x00220030, 0x001f0030},
    {0x002b003c, 0x0027003c},
    {0x0036004c, 0x0031004c},
    {0x00440060, 0x003e0060},
    {0x00550079, 0x004e0079},
    {0x006c0099, 0x00630099},
    {0x008700c1, 0x007d00c1},
    {0x00ab00f3, 0x009d00f3},
    {0x00d70132, 0x00c70133},
    {0x010f0181, 0x00fb0183},
    {0x015601e5, 0x013d01e8},
    {0x01af0264, 0x01900268},
    {0x021f0303, 0x01f90309},
    {0x02ac03cb, 0x027e03d5},
    {0x035e04c8, 0x032604d5},
    {0x043e0606, 0x03fa061a},
    {0x057a07c7, 0x050707b3},
    {0x06f909e6, 0x065a09b8},
    {0x08770c05, 0x08060c45},
    {0x0af50f8e, 0x0a240f7e},
    {0x0d721317, 0x0cd1138f},
    {0x10ef180a, 0x103418b2},
    {0x156a1e67, 0x147b1f30},
    {0x1ae5262e, 0x19e52762},
    {0x225d30c9, 0x20be31bd},
    {0x2ad53cce, 0x29673ed2},
    {0x36494d11, 0x345c4f59},
    {0x443b60dd, 0x423a643c},
    {0x56297a51, 0x53c57e9f},
    {0x6c939a22, 0x69f99ff9},
    {0x8877c1ba, 0x8613ca1e},
    {0xabd3ffef, 0xa9a4ffef},
    {0xd8a6ffef, 0xd6aaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef}
};

const unsigned int gen95_avc_tq_lambda_b_frame[AVC_QP_MAX][2] = {
    {0x00070009, 0x00060009},
    {0x0008000c, 0x0008000c},
    {0x000a000f, 0x0009000f},
    {0x000d0013, 0x000c0013},
    {0x00110018, 0x000f0018},
    {0x0015001e, 0x0013001e},
    {0x001b0026, 0x00180026},
    {0x00220030, 0x001f0030},
    {0x002b003c, 0x0027003c},
    {0x0036004c, 0x0031004c},
    {0x00440060, 0x003e0060},
    {0x00550079, 0x004e0079},
    {0x006c0099, 0x00630099},
    {0x008700c1, 0x007d00c1},
    {0x00ab00f3, 0x009d00f3},
    {0x00d70132, 0x00c70133},
    {0x010f0181, 0x00fb0183},
    {0x015601e5, 0x013d01e8},
    {0x01af0264, 0x01900268},
    {0x021f0303, 0x01f90309},
    {0x02ac03cb, 0x027e03d5},
    {0x035e04c8, 0x032604d5},
    {0x043e0606, 0x03fa061a},
    {0x057a07c7, 0x050707b3},
    {0x06f909e6, 0x065a09b8},
    {0x08770c05, 0x08060c45},
    {0x0af50f8e, 0x0a240f7e},
    {0x0d721317, 0x0cd1138f},
    {0x10ef180a, 0x103418b2},
    {0x156a1e67, 0x147b1f30},
    {0x1ae5262e, 0x19e52762},
    {0x225d30c9, 0x20be31bd},
    {0x2ad53cce, 0x29673ed2},
    {0x36494d11, 0x345c4f59},
    {0x443b60dd, 0x423a643c},
    {0x56297a51, 0x53c57e9f},
    {0x6c939a22, 0x69f99ff9},
    {0x8877c1ba, 0x8613ca1e},
    {0xabd3ffef, 0xa9a4ffef},
    {0xd8a6ffef, 0xd6aaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef},
    {0xfffaffef, 0xfffaffef}
};

const unsigned short gen95_avc_lambda_data[256] = {
    9,     7,     9,     6,    12,     8,    12,     8,    15,    10,    15,     9,    19,    13,    19,    12,    24,
    17,    24,    15,    30,    21,    30,    19,    38,    27,    38,    24,    48,    34,    48,    31,    60,    43,
    60,    39,    76,    54,    76,    49,    96,    68,    96,    62,   121,    85,   121,    78,   153,   108,   153,
    99,   193,   135,   193,   125,   243,   171,   243,   157,   306,   215,   307,   199,   385,   271,   387,   251,
    485,   342,   488,   317,   612,   431,   616,   400,   771,   543,   777,   505,   971,   684,   981,   638,  1224,
    862,  1237,   806,  1542,  1086,  1562,  1018,  1991,  1402,  1971,  1287,  2534,  1785,  2488,  1626,  3077,  2167,
    3141,  2054,  3982,  2805,  3966,  2596,  4887,  3442,  5007,  3281,  6154,  4335,  6322,  4148,  7783,  5482,  7984,
    5243,  9774,  6885, 10082,  6629, 12489,  8797, 12733,  8382, 15566, 10965, 16082, 10599, 19729, 13897, 20313, 13404,
    24797, 17467, 25660, 16954, 31313, 22057, 32415, 21445, 39458, 27795, 40953, 27129, 49594, 34935, 51742, 34323, 61440,
    43987, 61440, 43428, 61440, 55462, 61440, 54954, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440,
    61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440,
    61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440, 61440,
    61440, 61440, 61440, 61440,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,
};

const unsigned char gen95_avc_ftq25[64] = { //27 value 4 dummy
    0,                                      //qp=0
    0, 0, 0, 0, 0, 0,                       //qp=1,2;3,4;5,6;
    1, 1, 3, 3, 6, 6, 8, 8, 11, 11,         //qp=7,8;9,10;11,12;13,14;15;16
    13, 13, 16, 16, 19, 19, 22, 22, 26, 26, //qp=17,18;19,20;21,22;23,24;25,26
    30, 30, 34, 34, 39, 39, 44, 44, 50, 50, //qp=27,28;29,30;31,32;33,34;35,36
    56, 56, 62, 62, 69, 69, 77, 77, 85, 85, //qp=37,38;39,40;41,42;43,44;45,46
    94, 94, 104, 104, 115, 115,             //qp=47,48;49,50;51
    0, 0, 0, 0, 0, 0, 0, 0                  //dummy
};

/* Gen8  */
/*
init const table for scaling/sfd/curbe
*/


// AVC I_DIST CURBE init data
const unsigned int gen8_avc_mbenc_curbe_i_frame_dist_init_data[GEN8_AVC_MBENC_CURBE_SIZE] = {
    0x00000082, 0x00200008, 0x001e3910, 0x00a83000, 0x90000000, 0x28300000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100,
    0x80800000, 0x00000000, 0x00000800, 0xffff00ff, 0x40000000, 0x00000080, 0x00003900, 0x28300000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};

// AVC MBEnc CURBE init data
const unsigned int gen8_avc_mbenc_curbe_normal_i_frame_init_data[GEN8_AVC_MBENC_CURBE_SIZE] = {
    0x00000082, 0x00000000, 0x00003910, 0x00a83000, 0x00000000, 0x28300000, 0x05000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80800000, 0x00040c24, 0x00000000, 0xffff00ff, 0x40000000, 0x00000080, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};
const unsigned int gen8_avc_mbenc_curbe_normal_p_frame_init_data[GEN8_AVC_MBENC_CURBE_SIZE] = {
    0x000000a3, 0x00000008, 0x00003910, 0x00ae3000, 0x30000000, 0x28300000, 0x05000000, 0x01400060,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80010000, 0x00040c24, 0x00000000, 0xffff00ff, 0x60000000, 0x000000a1, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff

};
const unsigned int gen8_avc_mbenc_curbe_normal_b_frame_init_data[GEN8_AVC_MBENC_CURBE_SIZE] = {
    0x000000a3, 0x00200008, 0x00003910, 0x00aa7700, 0x50020000, 0x20200000, 0x05000000, 0xff400000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x01010000, 0x00040c24, 0x00000000, 0xffff00ff, 0x60000000, 0x000000a1, 0x00003900, 0x28301000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000002,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};

const unsigned int gen8_avc_me_curbe_init_data[GEN8_AVC_ME_CURBE_SIZE] = {
    0x00000000, 0x00200010, 0x00003939, 0x77a43000, 0x00000000, 0x28300000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
};

const unsigned short gen8_avc_ref_cost[3][64] = {
    // I-frame
    {
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000
    },
    // P-slice
    {
        0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
        0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0008, 0x0008, 0x0008, 0x0008,
        0x000C, 0x000C, 0x000C, 0x0010, 0x0010, 0x0010, 0x0014, 0x0018, 0x0018, 0x001C,
        0x0020, 0x0024, 0x0028, 0x002C, 0x0034, 0x0038, 0x0040, 0x0048, 0x0050, 0x005C,
        0x0064, 0x0074, 0x0080, 0x0090, 0x00A0, 0x00B4, 0x00CC, 0x00E4, 0x0100, 0x0120,
        0x0144, 0x016C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000
    },
    //B-slice
    {
        0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
        0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0008, 0x0008, 0x0008, 0x0008,
        0x000C, 0x000C, 0x000C, 0x0010, 0x0010, 0x0010, 0x0014, 0x0018, 0x0018, 0x001C,
        0x0020, 0x0024, 0x0028, 0x002C, 0x0034, 0x0038, 0x0040, 0x0048, 0x0050, 0x005C,
        0x0064, 0x0074, 0x0080, 0x0090, 0x00A0, 0x00B4, 0x00CC, 0x00E4, 0x0100, 0x0120,
        0x0144, 0x016C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000
    }
};

