/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ChildrenFinderStrategy;
import org.fest.swing.hierarchy.ContainerComponentsQuery;
import org.fest.swing.hierarchy.JDesktopPaneChildrenFinder;
import org.fest.swing.hierarchy.JMenuChildrenFinder;
import org.fest.swing.hierarchy.WindowChildrenFinder;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChildrenFinder {
    private static List<ChildrenFinderStrategy> strategies = new ArrayList<ChildrenFinderStrategy>();

    ChildrenFinder() {
    }

    @RunsInCurrentThread
    Collection<Component> childrenOf(Component c) {
        if (!(c instanceof Container)) {
            return Collections.emptyList();
        }
        Container container = (Container)c;
        ArrayList<Component> children = new ArrayList<Component>();
        children.addAll(ContainerComponentsQuery.componentsOf(container));
        children.addAll(this.nonExplicitChildrenOf(container));
        return children;
    }

    private Collection<Component> nonExplicitChildrenOf(Container c) {
        ArrayList<Component> children = new ArrayList<Component>();
        for (ChildrenFinderStrategy s : strategies) {
            children.addAll(s.nonExplicitChildrenOf(c));
        }
        return children;
    }

    @VisibleForTesting
    static List<ChildrenFinderStrategy> strategies() {
        return new ArrayList<ChildrenFinderStrategy>(strategies);
    }

    @VisibleForTesting
    static void replaceStrategiesWith(List<ChildrenFinderStrategy> newStrategies) {
        strategies = new ArrayList<ChildrenFinderStrategy>(newStrategies);
    }

    static {
        strategies.add(new JDesktopPaneChildrenFinder());
        strategies.add(new JMenuChildrenFinder());
        strategies.add(new WindowChildrenFinder());
    }
}

