//
// Copyright (C) 2005-2014 Simon Howard
// Copyright (C) 2002-2004  The DOSBox Team
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// "High resolution" font.
//
// This is an enhanced version of the 8x16 font from txt_font.h that
// has been doubled in size to 16x32, and then manually tweaked.
//

static uint8_t large_font_data[] =
{
    // 0:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 1:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xfc, 0x7f, 0xfe, 0xe0, 0x07, 0xc0, 0x03,
    0xcc, 0x33, 0xcc, 0x33, 0xc0, 0x03, 0xc0, 0x03,
    0xc0, 0x03, 0xc0, 0x03, 0xcf, 0xf3, 0xcf, 0xf3,
    0xc7, 0xe3, 0xc3, 0xc3, 0xc0, 0x03, 0xc0, 0x03,
    0xc0, 0x03, 0xe0, 0x07, 0x7f, 0xfe, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 2:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xfc, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0xcf, 0xf3, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf8, 0x1f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 3:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x38, 0x70, 0x7c, 0xf8, 0xff, 0xfc, 0xff, 0xfc,
    0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xf8,
    0x7f, 0xf8, 0x3f, 0xf0, 0x3f, 0xf0, 0x1f, 0xe0,
    0x0f, 0xc0, 0x07, 0x80, 0x03, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 4:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x07, 0x80, 0x0f, 0xc0, 0x1f, 0xe0,
    0x3f, 0xf0, 0x7f, 0xf8, 0xff, 0xfc, 0xff, 0xfc,
    0x7f, 0xf8, 0x3f, 0xf0, 0x1f, 0xe0, 0x0f, 0xc0,
    0x07, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 5:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0,
    0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x7c, 0x3e, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f,
    0xfc, 0x3f, 0x7c, 0x3e, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 6:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0,
    0x0f, 0xf0, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x7f, 0xfe, 0x3b, 0xdc, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 7:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 8:
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf8, 0x1f, 0xfc, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    // 9:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x1f, 0xf8,
    0x3c, 0x3c, 0x38, 0x1c, 0x30, 0x0c, 0x30, 0x0c,
    0x30, 0x0c, 0x30, 0x0c, 0x38, 0x1c, 0x3c, 0x3c,
    0x1f, 0xf8, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 10:
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xe0, 0x07,
    0xc3, 0xc3, 0xc7, 0xe3, 0xcf, 0xf3, 0xcf, 0xf3,
    0xcf, 0xf3, 0xcf, 0xf3, 0xc7, 0xe3, 0xc3, 0xc3,
    0xe0, 0x07, 0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    // 11:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xfc, 0x03, 0xfc, 0x00, 0xfc, 0x00, 0xfc,
    0x01, 0xec, 0x03, 0xcc, 0x07, 0x8c, 0x0f, 0x0c,
    0x3f, 0xc0, 0x7f, 0xe0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0x7f, 0xe0, 0x3f, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 12:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xf0, 0x1f, 0xf8, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x1f, 0xf8, 0x0f, 0xf0,
    0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x3f, 0xfc,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 13:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xff, 0x0f, 0xff, 0x0f, 0x0f, 0x0f, 0x0f,
    0x0f, 0xff, 0x0f, 0xff, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x3f, 0x00, 0x7f, 0x00,
    0xff, 0x00, 0xff, 0x00, 0xfe, 0x00, 0x7c, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 14:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xff, 0x3f, 0xff, 0x3c, 0x0f, 0x3c, 0x0f,
    0x3f, 0xff, 0x3f, 0xff, 0x3c, 0x0f, 0x3c, 0x0f,
    0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f,
    0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x1f, 0x3c, 0x3f,
    0x7c, 0x3f, 0xfc, 0x3f, 0xfc, 0x3e, 0xfc, 0x1c,
    0xf8, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 15:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xc3, 0xc3, 0xf3, 0xcf,
    0x3f, 0xfc, 0x0f, 0xf0, 0xfc, 0x3f, 0xfc, 0x3f,
    0x0f, 0xf0, 0x3f, 0xfc, 0xf3, 0xcf, 0xc3, 0xc3,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 16:
    0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x00,
    0xe0, 0x00, 0xf0, 0x00, 0xf8, 0x00, 0xfc, 0x00,
    0xfe, 0x00, 0xff, 0x00, 0xff, 0x80, 0xff, 0xc0,
    0xff, 0xe0, 0xff, 0xe0, 0xff, 0xc0, 0xff, 0x80,
    0xff, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xf8, 0x00,
    0xf0, 0x00, 0xe0, 0x00, 0xc0, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 17:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0c,
    0x00, 0x1c, 0x00, 0x3c, 0x00, 0x7c, 0x00, 0xfc,
    0x01, 0xfc, 0x03, 0xfc, 0x07, 0xfc, 0x0f, 0xfc,
    0x1f, 0xfc, 0x1f, 0xfc, 0x0f, 0xfc, 0x07, 0xfc,
    0x03, 0xfc, 0x01, 0xfc, 0x00, 0xfc, 0x00, 0x7c,
    0x00, 0x3c, 0x00, 0x1c, 0x00, 0x0c, 0x00, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 18:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0,
    0x1f, 0xf8, 0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x3f, 0xfc, 0x1f, 0xf8, 0x0f, 0xf0, 0x07, 0xe0,
    0x03, 0xc0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 19:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 20:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xff, 0x7f, 0xff, 0xe3, 0xcf, 0xe3, 0xcf,
    0xe3, 0xcf, 0xe3, 0xcf, 0xe3, 0xcf, 0xe3, 0xcf,
    0x7f, 0xcf, 0x3f, 0xcf, 0x03, 0xcf, 0x03, 0xcf,
    0x03, 0xcf, 0x03, 0xcf, 0x03, 0xcf, 0x03, 0xcf,
    0x03, 0xcf, 0x03, 0xcf, 0x03, 0xcf, 0x03, 0xcf,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 21:
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x1c, 0x7c, 0x00, 0x3f, 0x00,
    0x1f, 0xc0, 0x0f, 0xe0, 0x1c, 0xf0, 0x38, 0x78,
    0x70, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x38,
    0x78, 0x70, 0x3c, 0xe0, 0x1f, 0xc0, 0x0f, 0xc0,
    0x03, 0xf0, 0x00, 0xf8, 0xe0, 0x7c, 0xf0, 0x3c,
    0x7f, 0xf8, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 22:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc,
    0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 23:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0,
    0x1f, 0xf8, 0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x3f, 0xfc, 0x1f, 0xf8, 0x0f, 0xf0, 0x07, 0xe0,
    0x03, 0xc0, 0x01, 0x80, 0x3f, 0xfc, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 24:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0,
    0x1f, 0xf8, 0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 25:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x1f, 0xf8,
    0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0, 0x01, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 26:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x01, 0xc0,
    0x00, 0xe0, 0x00, 0x70, 0xff, 0xf8, 0xff, 0xf8,
    0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 27:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x0e, 0x00,
    0x1c, 0x00, 0x38, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
    0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 28:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 29:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x20, 0x0c, 0x30,
    0x1c, 0x38, 0x3c, 0x3c, 0x7f, 0xfe, 0x7f, 0xfe,
    0x3c, 0x3c, 0x1c, 0x38, 0x0c, 0x30, 0x04, 0x20,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 30:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x03, 0x00, 0x07, 0x80, 0x07, 0x80,
    0x0f, 0xc0, 0x0f, 0xc0, 0x1f, 0xe0, 0x1f, 0xe0,
    0x3f, 0xf0, 0x3f, 0xf0, 0x7f, 0xf8, 0x7f, 0xf8,
    0xff, 0xfc, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 31:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xf8, 0x7f, 0xf8,
    0x3f, 0xf0, 0x3f, 0xf0, 0x1f, 0xe0, 0x1f, 0xe0,
    0x0f, 0xc0, 0x0f, 0xc0, 0x07, 0x80, 0x07, 0x80,
    0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 32:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 33:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x07, 0xe0, 0x07, 0xe0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 34:
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x1c, 0x38, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 35:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xe0, 0x1c, 0xe0,
    0x1c, 0xe0, 0x1c, 0xe0, 0xff, 0xfc, 0xff, 0xfc,
    0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0,
    0x1c, 0xe0, 0x1c, 0xe0, 0xff, 0xfc, 0xff, 0xfc,
    0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 36:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x3f, 0xf0, 0x7f, 0xf8, 0xf0, 0x3c, 0xf0, 0x1c,
    0xf0, 0x0c, 0xf0, 0x0c, 0xf0, 0x00, 0xf0, 0x00,
    0x7f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0xc0, 0x3c, 0xc0, 0x3c,
    0xe0, 0x3c, 0xf0, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 37:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x60, 0x0c, 0xf0, 0x1c, 0xf0, 0x3c, 0x60, 0x78,
    0x00, 0xf0, 0x01, 0xe0, 0x03, 0xc0, 0x07, 0x80,
    0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x00, 0x78, 0x00,
    0xf0, 0x18, 0xe0, 0x3c, 0xc0, 0x3c, 0x80, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 38:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xc0, 0x1f, 0xe0, 0x3c, 0xf0, 0x3c, 0xf0,
    0x3c, 0xf0, 0x1c, 0xe0, 0x0f, 0xc0, 0x0f, 0xc0,
    0x3f, 0x0c, 0x7f, 0x1c, 0xf3, 0xf8, 0xf3, 0xf8,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf1, 0xf0, 0x7f, 0xfc, 0x3f, 0x38,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 39:
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x1e, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 40:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf0, 0x01, 0xf0, 0x03, 0xc0, 0x07, 0x80,
    0x07, 0x00, 0x07, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x07, 0x00, 0x07, 0x00,
    0x07, 0x80, 0x03, 0xc0, 0x01, 0xf0, 0x00, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 41:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0x00, 0x0f, 0x80, 0x03, 0xc0, 0x01, 0xe0,
    0x00, 0xe0, 0x00, 0xe0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xe0, 0x00, 0xe0,
    0x01, 0xe0, 0x03, 0xc0, 0x0f, 0x80, 0x0f, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 42:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x1c, 0x3c, 0x3c, 0x1e, 0x78,
    0x0f, 0xf0, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0x0f, 0xf0, 0x0f, 0xf0, 0x1e, 0x78, 0x3c, 0x3c,
    0x38, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 43:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x3f, 0xfc,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 44:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x07, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 45:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 46:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 47:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x0c, 0x00, 0x1c, 0x00, 0x3c,
    0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0, 0x03, 0xc0,
    0x07, 0x80, 0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x00,
    0x78, 0x00, 0xf0, 0x00, 0xe0, 0x00, 0xc0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 48:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xf0, 0x1f, 0xf8, 0x3c, 0x3c, 0x78, 0x1e,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf1, 0x8f, 0xf3, 0xcf, 0xf3, 0xcf, 0xf1, 0x8f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0x78, 0x1e, 0x3c, 0x3c, 0x1f, 0xf8, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 49:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0xc0, 0x03, 0xc0, 0x07, 0xc0, 0x0f, 0xc0,
    0x1f, 0xc0, 0x3f, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 50:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xe0, 0x3f, 0xf0, 0x70, 0x38, 0xe0, 0x3c,
    0x00, 0x3c, 0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0,
    0x03, 0xc0, 0x07, 0x80, 0x0f, 0x00, 0x1e, 0x00,
    0x3c, 0x00, 0x38, 0x00, 0x70, 0x00, 0x70, 0x00,
    0xf0, 0x0c, 0xf0, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 51:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xf0, 0x7f, 0xf8, 0xf8, 0x7c, 0xf0, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0x0f, 0xf0, 0x0f, 0xf0, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0xf0, 0x3c, 0xf8, 0x7c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 52:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x70, 0x00, 0xf0, 0x01, 0xf0, 0x03, 0xf0,
    0x07, 0xf0, 0x0f, 0xf0, 0x1e, 0xf0, 0x3c, 0xf0,
    0x78, 0xf0, 0xf0, 0xf0, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x03, 0xfc, 0x03, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 53:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xff, 0xf0, 0xff, 0xf8, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 54:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xc0, 0x1f, 0xc0, 0x3c, 0x00, 0x78, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xff, 0xf0, 0xff, 0xf8, 0xf8, 0x7c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf8, 0x7c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 55:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0, 0x03, 0xc0,
    0x07, 0x80, 0x07, 0x80, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 56:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xf0, 0x7f, 0xf8, 0xf8, 0x7c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x78,
    0x3f, 0xf0, 0x3f, 0xf0, 0x78, 0x78, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf8, 0x7c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 57:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xf0, 0x7f, 0xf8, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x7f, 0xfc, 0x3f, 0xfc, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x78, 0x00, 0xf0, 0x3f, 0xe0, 0x3f, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 58:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x80, 0x03, 0xc0, 0x03, 0xc0, 0x01, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0xc0,
    0x03, 0xc0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 59:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x80, 0x03, 0xc0, 0x03, 0xc0, 0x01, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x07, 0x80, 0x0f, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 60:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x78,
    0x00, 0xf0, 0x01, 0xe0, 0x03, 0xc0, 0x07, 0x80,
    0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x1e, 0x00, 0x0f, 0x00, 0x07, 0x80, 0x03, 0xc0,
    0x01, 0xe0, 0x00, 0xf0, 0x00, 0x78, 0x00, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 61:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xfc, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 62:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x1e, 0x00,
    0x0f, 0x00, 0x07, 0x80, 0x03, 0xc0, 0x01, 0xe0,
    0x00, 0xf0, 0x00, 0x78, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0, 0x03, 0xc0,
    0x07, 0x80, 0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 63:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xf0, 0x7f, 0xf8, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x7c, 0x00, 0xf8, 0x01, 0xf0,
    0x03, 0xe0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 64:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf1, 0xfc, 0xf3, 0xfc, 0xf3, 0xfc, 0xf3, 0xfc,
    0xf3, 0xfc, 0xf3, 0xfc, 0xf3, 0xf8, 0xf1, 0xf0,
    0xf0, 0x00, 0xf0, 0x00, 0x7f, 0xf0, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 65:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x07, 0x80, 0x0f, 0xc0, 0x1f, 0xe0,
    0x3c, 0xf0, 0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 66:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xe0, 0xff, 0xf0, 0x3c, 0x38, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x38,
    0x3f, 0xf0, 0x3f, 0xf0, 0x3c, 0x38, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x38, 0xff, 0xf0, 0xff, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 67:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x0f, 0xf0, 0x1e, 0x78, 0x3c, 0x3c,
    0x78, 0x1c, 0x78, 0x0c, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0x78, 0x0c, 0x78, 0x1c,
    0x3c, 0x3c, 0x1e, 0x78, 0x0f, 0xf0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 68:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0x80, 0xff, 0xc0, 0x3d, 0xe0, 0x3c, 0xf0,
    0x3c, 0x78, 0x3c, 0x38, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x38, 0x3c, 0x78,
    0x3c, 0xf0, 0x3d, 0xe0, 0xff, 0xc0, 0xff, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 69:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0x3c, 0x3c, 0x3c, 0x1c,
    0x3c, 0x0c, 0x3c, 0x04, 0x3c, 0xc0, 0x3c, 0xc0,
    0x3f, 0xc0, 0x3f, 0xc0, 0x3c, 0xc0, 0x3c, 0xc0,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x04, 0x3c, 0x0c,
    0x3c, 0x1c, 0x3c, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 70:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0x3c, 0x3c, 0x3c, 0x1c,
    0x3c, 0x0c, 0x3c, 0x04, 0x3c, 0xc0, 0x3c, 0xc0,
    0x3f, 0xc0, 0x3f, 0xc0, 0x3c, 0xc0, 0x3c, 0xc0,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0xff, 0x00, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 71:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0xe0, 0x0f, 0xf0, 0x1e, 0x38, 0x3c, 0x1c,
    0x78, 0x0c, 0x70, 0x0c, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf3, 0xfc, 0xf3, 0xfc,
    0xf0, 0x3c, 0xf0, 0x3c, 0x70, 0x3c, 0x78, 0x3c,
    0x3c, 0x3c, 0x1e, 0x7c, 0x0f, 0xec, 0x07, 0xcc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 72:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xff, 0xfc, 0xff, 0xfc, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 73:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xf0, 0x0f, 0xf0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 74:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xfc, 0x03, 0xfc, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0x7f, 0xe0, 0x3f, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 75:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xfc, 0x3c, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x78, 0x3c, 0xf0,
    0x3f, 0xe0, 0x3f, 0xc0, 0x3f, 0xc0, 0x3f, 0xe0,
    0x3c, 0xf0, 0x3c, 0x78, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0xfc, 0x3c, 0xfc, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 76:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0x00, 0xff, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x04, 0x3c, 0x0c,
    0x3c, 0x1c, 0x3c, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 77:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe0, 0x07, 0xf0, 0x0f, 0xf8, 0x1f, 0xfc, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0xcf, 0xf1, 0x8f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 78:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe0, 0x3c, 0xf0, 0x3c, 0xf8, 0x3c, 0xfc, 0x3c,
    0xfe, 0x3c, 0xff, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0xf3, 0xfc, 0xf1, 0xfc, 0xf0, 0xfc, 0xf0, 0x7c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 79:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1f, 0xe0, 0x3f, 0xf0, 0x78, 0x78, 0x78, 0x78,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x78, 0x78, 0x78, 0x78, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 80:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xe0, 0xff, 0xf0, 0x3c, 0x78, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x78,
    0x3f, 0xf0, 0x3f, 0xe0, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0xff, 0x00, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 81:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xf0, 0x7f, 0xf8, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf3, 0x3c, 0xf3, 0x3c,
    0xf3, 0xfc, 0xf3, 0xfc, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xfc, 0x00, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 82:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xe0, 0xff, 0xf0, 0x3c, 0x38, 0x3c, 0x1c,
    0x3c, 0x1c, 0x3c, 0x1c, 0x3c, 0x3c, 0x3c, 0x38,
    0x3f, 0xf0, 0x3f, 0xe0, 0x3c, 0xe0, 0x3c, 0x70,
    0x3c, 0x38, 0x3c, 0x38, 0x3c, 0x1c, 0x3c, 0x1c,
    0x3c, 0x1c, 0x3c, 0x1c, 0xfc, 0x1c, 0xfc, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 83:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xf0, 0x7f, 0xf8, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x00, 0x3c, 0x00,
    0x1f, 0x00, 0x0f, 0xc0, 0x03, 0xf0, 0x00, 0xf8,
    0x00, 0x3c, 0x00, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf8, 0x7c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 84:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0xcf, 0xe3, 0xc7,
    0xc3, 0xc3, 0x83, 0xc1, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 85:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x78, 0x78, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 86:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0x78, 0x1e, 0x3c, 0x3c,
    0x1e, 0x78, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 87:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf1, 0x8f, 0xf1, 0x8f,
    0xf3, 0xcf, 0xf3, 0xcf, 0xf7, 0xef, 0xf7, 0xef,
    0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x3c, 0x3c, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 88:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0x78, 0x1e, 0x3c, 0x3c, 0x1e, 0x78, 0x0f, 0xf0,
    0x07, 0xe0, 0x03, 0xc0, 0x03, 0xc0, 0x07, 0xe0,
    0x0f, 0xf0, 0x1e, 0x78, 0x3c, 0x3c, 0x78, 0x1e,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 89:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0x78, 0x1e, 0x3c, 0x3c, 0x1e, 0x78,
    0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 90:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xe0, 0x1e,
    0xc0, 0x3c, 0x80, 0x78, 0x00, 0xf0, 0x01, 0xe0,
    0x03, 0xc0, 0x07, 0x80, 0x0f, 0x00, 0x1e, 0x00,
    0x3c, 0x00, 0x78, 0x00, 0xf0, 0x01, 0xf0, 0x03,
    0xf0, 0x07, 0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 91:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 92:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xfc, 0x00, 0xfc, 0x00,
    0x3f, 0x00, 0x3f, 0x00, 0x0f, 0xc0, 0x0f, 0xc0,
    0x03, 0xf0, 0x03, 0xf0, 0x00, 0xfc, 0x00, 0xfc,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x0c, 0x00, 0x0c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 93:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xf0, 0x0f, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 94:
    0x00, 0x00, 0x03, 0x00, 0x07, 0x80, 0x0f, 0xc0,
    0x1c, 0xe0, 0x38, 0x70, 0x70, 0x38, 0xe0, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 95:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 96:
    0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x07, 0x00,
    0x03, 0xc0, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 97:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x3f, 0xc0,
    0x00, 0xe0, 0x00, 0xf0, 0x1f, 0xf0, 0x3f, 0xf0,
    0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0x79, 0xf0, 0x3f, 0x3c, 0x1e, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 98:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xfc, 0x00, 0xfc, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3f, 0x80, 0x3f, 0xc0,
    0x3c, 0xe0, 0x3c, 0x70, 0x3c, 0x38, 0x3c, 0x38,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x38, 0x3c, 0x38, 0x3f, 0xf0, 0x3f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 99:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x3f, 0xf0,
    0x78, 0x38, 0xf0, 0x3c, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x1c, 0x78, 0x38, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 100:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xf0, 0x03, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x0f, 0xf0, 0x1f, 0xf0,
    0x3c, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf8, 0xf0, 0x7f, 0xbc, 0x3f, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 101:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x1c, 0xf8, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 102:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x80, 0x0f, 0xc0, 0x1c, 0xe0, 0x3c, 0x70,
    0x3c, 0x30, 0x3c, 0x30, 0x3c, 0x00, 0x3c, 0x00,
    0xff, 0x00, 0xff, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0xff, 0x00, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 103:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0x1c, 0x3f, 0xbc,
    0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0x70, 0xf0, 0x3f, 0xf0, 0x1f, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0xe0, 0xf0, 0x70, 0xf0,
    0x3f, 0xc0, 0x1f, 0xc0, 0x00, 0x00, 0x00, 0x00,

    // 104:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xfc, 0x00, 0xfc, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0xf0, 0x3d, 0xf8,
    0x3f, 0x3c, 0x3e, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0xfc, 0x3c, 0xfc, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 105:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x80, 0x03, 0xc0, 0x03, 0xc0, 0x01, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x0f, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 106:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x18, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xfc,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x1c, 0x38,
    0x0f, 0xf0, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x00,

    // 107:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xfc, 0x00, 0xfc, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x1c, 0x3c, 0x38,
    0x3c, 0x70, 0x3c, 0xe0, 0x3d, 0xc0, 0x3f, 0x80,
    0x3f, 0x80, 0x3f, 0xc0, 0x3c, 0xe0, 0x3c, 0x70,
    0x3c, 0x38, 0x3c, 0x1c, 0xfc, 0x1c, 0xfc, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 108:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xc0, 0x0f, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 109:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xfc, 0x3c, 0xfe, 0x7e,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0xcf, 0xf3, 0xcf,
    0xf3, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf,
    0xf3, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 110:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe3, 0xe0, 0xf7, 0xf0,
    0x3c, 0x38, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 111:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x3f, 0xf0,
    0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x78, 0x78, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 112:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe3, 0xe0, 0xf7, 0xf0,
    0x3e, 0x78, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x78, 0x3f, 0xf0, 0x3f, 0xe0,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 113:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0x1c, 0x3f, 0xbc,
    0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0x78, 0xf0, 0x3f, 0xf0, 0x1f, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x03, 0xfc, 0x03, 0xfc, 0x00, 0x00, 0x00, 0x00,

    // 114:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe1, 0xe0, 0xf3, 0xf0,
    0x3f, 0x38, 0x3e, 0x1c, 0x3c, 0x1c, 0x3c, 0x1c,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0xff, 0x00, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 115:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x3c, 0x7c, 0x00, 0x3f, 0x00,
    0x0f, 0xc0, 0x03, 0xe0, 0x00, 0xf0, 0x00, 0x78,
    0xf0, 0x3c, 0xf0, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 116:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0xff, 0xf0, 0xff, 0xf0,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x1c, 0x07, 0x3c, 0x03, 0xf0, 0x01, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 117:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf1, 0xf0, 0x7f, 0xbc, 0x3f, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 118:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0x78, 0x1e, 0x3c, 0x3c,
    0x1e, 0x78, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 119:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
    0xf3, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0x7e, 0x7e, 0x3c, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 120:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0xf8, 0x1f,
    0x3c, 0x3c, 0x1e, 0x78, 0x0f, 0xf0, 0x07, 0xe0,
    0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1e, 0x78,
    0x3c, 0x3c, 0x78, 0x1e, 0xf0, 0x0f, 0xe0, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 121:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x70, 0x3c, 0x3f, 0xfc, 0x1f, 0xfc,
    0x00, 0x3c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0,
    0xff, 0xc0, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,

    // 122:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0xff, 0xf8,
    0xe0, 0x70, 0xc0, 0xe0, 0x01, 0xc0, 0x03, 0x80,
    0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00,
    0x70, 0x0c, 0xe0, 0x1c, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 123:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x7c, 0x00, 0xfc, 0x01, 0xc0, 0x03, 0x80,
    0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
    0x3f, 0x00, 0x3f, 0x00, 0x03, 0x80, 0x03, 0x80,
    0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
    0x03, 0xc0, 0x03, 0xc0, 0x00, 0xfc, 0x00, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 124:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 125:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3e, 0x00, 0x3f, 0x00, 0x03, 0x80, 0x01, 0xc0,
    0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
    0x00, 0xfc, 0x00, 0xfc, 0x01, 0xc0, 0x01, 0xc0,
    0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
    0x03, 0xc0, 0x03, 0x80, 0x3f, 0x00, 0x3e, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 126:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1e, 0x1c, 0x3f, 0x3c, 0x73, 0xf0, 0xe1, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 127:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x00, 0x07, 0x80, 0x0f, 0xc0,
    0x1c, 0xe0, 0x38, 0x70, 0x70, 0x38, 0xe0, 0x1c,
    0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c,
    0xff, 0xfc, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 128:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0xe0, 0x0f, 0xf0, 0x1c, 0x38, 0x38, 0x1c,
    0x70, 0x0c, 0xf0, 0x0c, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x0c, 0x70, 0x0c, 0x38, 0x1c, 0x1c, 0x38,
    0x0f, 0xf0, 0x07, 0xf0, 0x00, 0xf0, 0x00, 0x70,
    0x00, 0x38, 0x00, 0x38, 0x3f, 0xf0, 0x3f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 129:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf1, 0xf0, 0x7f, 0xbc, 0x3f, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 130:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
    0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x1c, 0xf8, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 131:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
    0x07, 0x80, 0x0f, 0xc0, 0x1c, 0xe0, 0x38, 0x70,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x3f, 0xc0,
    0x00, 0xe0, 0x00, 0xf0, 0x1f, 0xf0, 0x3f, 0xf0,
    0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0x79, 0xf0, 0x3f, 0x3c, 0x1e, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 132:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x3f, 0xc0,
    0x00, 0xe0, 0x00, 0xf0, 0x1f, 0xf0, 0x3f, 0xf0,
    0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0x79, 0xf0, 0x3f, 0x3c, 0x1e, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 133:
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x1c, 0x00,
    0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x3f, 0xc0,
    0x00, 0xe0, 0x00, 0xf0, 0x1f, 0xf0, 0x3f, 0xf0,
    0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0x79, 0xf0, 0x3f, 0x3c, 0x1e, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 134:
    0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0f, 0xc0,
    0x38, 0x70, 0x38, 0x70, 0x0f, 0xc0, 0x07, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x3f, 0xc0,
    0x00, 0xe0, 0x00, 0xf0, 0x1f, 0xf0, 0x3f, 0xf0,
    0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0x79, 0xf0, 0x3f, 0x3c, 0x1e, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 135:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0xe0, 0x0f, 0xf0, 0x1c, 0x38, 0x3c, 0x1c,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x1c, 0x1c, 0x38, 0x0f, 0xf0, 0x07, 0xf0,
    0x00, 0xf0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x38,
    0x0f, 0xf0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 136:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
    0x07, 0x80, 0x0f, 0xc0, 0x1c, 0xe0, 0x38, 0x70,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x1c, 0xf8, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 137:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x3c, 0xf0, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x1c, 0xf8, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 138:
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x1c, 0x00,
    0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x1c, 0xf8, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 139:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x0f, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 140:
    0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0xc0,
    0x07, 0xe0, 0x0e, 0x70, 0x1c, 0x38, 0x38, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x0f, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 141:
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x1c, 0x00,
    0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x0f, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 142:
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
    0x07, 0x80, 0x0f, 0xc0, 0x1c, 0xe0, 0x38, 0x70,
    0x70, 0x38, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xff, 0xfc, 0xff, 0xfc, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 143:
    0x07, 0x80, 0x0f, 0xc0, 0x38, 0x70, 0x38, 0x70,
    0x0f, 0xc0, 0x07, 0x80, 0x00, 0x00, 0x03, 0x00,
    0x07, 0x80, 0x0f, 0xc0, 0x1c, 0xe0, 0x38, 0x70,
    0x70, 0x38, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xff, 0xfc, 0xff, 0xfc, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 144:
    0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
    0x1c, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0x3c, 0x1c, 0x3c, 0x0c,
    0x3c, 0x00, 0x3c, 0x00, 0x3f, 0xf0, 0x3f, 0xf0,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x0c, 0x3c, 0x1c, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 145:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x38, 0x78, 0x1c, 0xfc,
    0x0f, 0xce, 0x07, 0xcf, 0x03, 0xcf, 0x03, 0xce,
    0x1f, 0xfc, 0x3f, 0xf8, 0x73, 0xc0, 0xe3, 0xc0,
    0xe3, 0xe0, 0x73, 0x78, 0x3f, 0x3f, 0x1e, 0x0f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 146:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0xfc, 0x0f, 0xfc, 0x1c, 0xf0, 0x38, 0xf0,
    0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xff, 0xfc, 0xff, 0xfc, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xfc, 0xf0, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 147:
    0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x07, 0x80,
    0x0f, 0xc0, 0x1c, 0xe0, 0x38, 0x70, 0x70, 0x38,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x3f, 0xf0,
    0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x78, 0x78, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 148:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x3c, 0xf0, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x3f, 0xf0,
    0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x78, 0x78, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 149:
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x1c, 0x00,
    0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x3f, 0xf0,
    0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x78, 0x78, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 150:
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0f, 0x00,
    0x1f, 0x80, 0x39, 0xc0, 0x70, 0xe0, 0xe0, 0x70,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf1, 0xf0, 0x7f, 0xbc, 0x3f, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 151:
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x1c, 0x00,
    0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf1, 0xf0, 0x7f, 0xbc, 0x3f, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 152:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x3c, 0xf0, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x70, 0x3c, 0x3f, 0xfc, 0x1f, 0xfc,
    0x00, 0x3c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0,
    0x3f, 0xc0, 0x3f, 0x80, 0x00, 0x00, 0x00, 0x00,

    // 153:
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x3f, 0xf0,
    0x70, 0x38, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x70, 0x38, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 154:
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x70, 0x38, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 155:
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x1f, 0xf8, 0x3f, 0xfc,
    0x70, 0x0e, 0xe0, 0x07, 0xe0, 0x00, 0xe0, 0x00,
    0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
    0xe0, 0x07, 0x70, 0x0e, 0x3f, 0xfc, 0x1f, 0xf8,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 156:
    0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0f, 0xc0,
    0x1c, 0xe0, 0x3c, 0x70, 0x3c, 0x30, 0x3c, 0x30,
    0x3c, 0x00, 0x3c, 0x00, 0xff, 0x00, 0xff, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0xfc, 0x1c, 0xfc, 0x38, 0xff, 0xf0, 0xff, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 157:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe0, 0x07, 0x70, 0x0e, 0x38, 0x1c, 0x1c, 0x38,
    0x0e, 0x70, 0x07, 0xe0, 0x03, 0xc0, 0x03, 0xc0,
    0xff, 0xff, 0xff, 0xff, 0x03, 0xc0, 0x03, 0xc0,
    0xff, 0xff, 0xff, 0xff, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 158:
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0xff, 0xf8,
    0x3c, 0x3c, 0x3c, 0x1c, 0x3c, 0x1c, 0x3c, 0x3c,
    0x3f, 0xf8, 0x3f, 0xf0, 0x3c, 0x0c, 0x3c, 0x1c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xff, 0x3c, 0xff,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0xff, 0x1f, 0xff, 0x0f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 159:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xfc,
    0x01, 0xee, 0x03, 0xc7, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x3f, 0xfc, 0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0xe3, 0xc0, 0x77, 0x80, 0x3f, 0x00, 0x1e, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 160:
    0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x03, 0x80,
    0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x3f, 0xc0,
    0x00, 0xe0, 0x00, 0xf0, 0x1f, 0xf0, 0x3f, 0xf0,
    0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0x79, 0xf0, 0x3f, 0x3c, 0x1e, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 161:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
    0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x0f, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 162:
    0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x03, 0x80,
    0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x3f, 0xf0,
    0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0x78, 0x78, 0x3f, 0xf0, 0x1f, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 163:
    0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x03, 0x80,
    0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf1, 0xf0, 0x7f, 0xbc, 0x3f, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 164:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1e, 0x1c, 0x3f, 0x3c, 0xf3, 0xf0, 0xe1, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0xe3, 0xe0, 0xf7, 0xf0,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 165:
    0x1e, 0x1c, 0x3f, 0x3c, 0xf3, 0xf0, 0xe1, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0xe0, 0x3c, 0xf0, 0x3c,
    0xf8, 0x3c, 0xfc, 0x3c, 0xfe, 0x3c, 0xff, 0x3c,
    0xff, 0xbc, 0xf7, 0xfc, 0xf3, 0xfc, 0xf1, 0xfc,
    0xf0, 0xfc, 0xf0, 0x7c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 166:
    0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x0f, 0xf0,
    0x1c, 0xf0, 0x38, 0xf0, 0x38, 0xf0, 0x1c, 0xf0,
    0x0f, 0xfc, 0x07, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xfc, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 167:
    0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0f, 0xc0,
    0x1c, 0xe0, 0x38, 0x70, 0x38, 0x70, 0x1c, 0xe0,
    0x0f, 0xc0, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xf0, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 168:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, 0x00,
    0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x00, 0x78, 0x00,
    0xf0, 0x00, 0xe0, 0x00, 0xe0, 0x1c, 0xe0, 0x1c,
    0xe0, 0x1c, 0xf0, 0x3c, 0x7f, 0xf8, 0x3f, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 169:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 170:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 171:
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x04, 0xf0, 0x0c,
    0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x70, 0xf0, 0xe0,
    0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
    0x1c, 0x00, 0x38, 0x00, 0x70, 0x7c, 0xe0, 0xfe,
    0xc1, 0xcf, 0x83, 0x8f, 0x00, 0x1c, 0x00, 0x38,
    0x00, 0x70, 0x00, 0xe0, 0x01, 0xff, 0x03, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 172:
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x04, 0xf0, 0x0c,
    0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x70, 0xf0, 0xe0,
    0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
    0x1c, 0x3c, 0x38, 0x7c, 0x70, 0xfc, 0xe1, 0xbc,
    0xc3, 0x3c, 0x86, 0x3c, 0x0f, 0xfc, 0x0f, 0xfc,
    0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 173:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x07, 0xe0, 0x07, 0xe0,
    0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0,
    0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 174:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0x1e, 0x78,
    0x3c, 0xf0, 0x79, 0xe0, 0xf3, 0xc0, 0xf3, 0xc0,
    0x79, 0xe0, 0x3c, 0xf0, 0x1e, 0x78, 0x0f, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 175:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf3, 0xc0, 0x79, 0xe0,
    0x3c, 0xf0, 0x1e, 0x78, 0x0f, 0x3c, 0x0f, 0x3c,
    0x1e, 0x78, 0x3c, 0xf0, 0x79, 0xe0, 0xf3, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 176:
    0x03, 0x03, 0x03, 0x03, 0x30, 0x30, 0x30, 0x30,
    0x03, 0x03, 0x03, 0x03, 0x30, 0x30, 0x30, 0x30,
    0x03, 0x03, 0x03, 0x03, 0x30, 0x30, 0x30, 0x30,
    0x03, 0x03, 0x03, 0x03, 0x30, 0x30, 0x30, 0x30,
    0x03, 0x03, 0x03, 0x03, 0x30, 0x30, 0x30, 0x30,
    0x03, 0x03, 0x03, 0x03, 0x30, 0x30, 0x30, 0x30,
    0x03, 0x03, 0x03, 0x03, 0x30, 0x30, 0x30, 0x30,
    0x03, 0x03, 0x03, 0x03, 0x30, 0x30, 0x30, 0x30,

    // 177:
    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,

    // 178:
    0xf3, 0xf3, 0xf3, 0xf3, 0x3f, 0x3f, 0x3f, 0x3f,
    0xf3, 0xf3, 0xf3, 0xf3, 0x3f, 0x3f, 0x3f, 0x3f,
    0xf3, 0xf3, 0xf3, 0xf3, 0x3f, 0x3f, 0x3f, 0x3f,
    0xf3, 0xf3, 0xf3, 0xf3, 0x3f, 0x3f, 0x3f, 0x3f,
    0xf3, 0xf3, 0xf3, 0xf3, 0x3f, 0x3f, 0x3f, 0x3f,
    0xf3, 0xf3, 0xf3, 0xf3, 0x3f, 0x3f, 0x3f, 0x3f,
    0xf3, 0xf3, 0xf3, 0xf3, 0x3f, 0x3f, 0x3f, 0x3f,
    0xf3, 0xf3, 0xf3, 0xf3, 0x3f, 0x3f, 0x3f, 0x3f,

    // 179:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 180:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0xff, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 181:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0xff, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0xff, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 182:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3c, 0xff, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 183:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0xff, 0xfc,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 184:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0xff, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 185:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3c, 0xff, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0xff, 0x3c, 0xff, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 186:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 187:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x3c, 0x00, 0x3c, 0xff, 0x3c, 0xff, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 188:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3c, 0xff, 0x3c,
    0x00, 0x3c, 0x00, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 189:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 190:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0xff, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0xff, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 191:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 192:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 193:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 194:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 195:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 196:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 197:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 198:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 199:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3f, 0x0f, 0x3f,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 200:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3f, 0x0f, 0x3f,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0xff, 0x0f, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 201:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x0f, 0xff,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x3f, 0x0f, 0x3f,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 202:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3f, 0xff, 0x3f,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 203:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0xff, 0x3f, 0xff, 0x3f,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 204:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3f, 0x0f, 0x3f,
    0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x3f, 0x0f, 0x3f,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 205:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 206:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3f, 0xff, 0x3f,
    0x00, 0x00, 0x00, 0x00, 0xff, 0x3f, 0xff, 0x3f,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 207:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 208:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 209:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 210:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 211:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0xff, 0x0f, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 212:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 213:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x03, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 214:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x0f, 0xff,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 215:
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0xff, 0xff, 0xff,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
    0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,

    // 216:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 217:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0xff, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 218:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x03, 0xff,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 219:
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    // 220:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    // 221:
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,

    // 222:
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,

    // 223:
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 224:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3e, 0x3c, 0x7f, 0x7c,
    0xf3, 0xf8, 0xe1, 0xf0, 0xe1, 0xc0, 0xe1, 0xc0,
    0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
    0xe1, 0xf0, 0xf3, 0xf8, 0x7f, 0xbc, 0x3f, 0x1c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 225:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1f, 0x80, 0x3f, 0xc0, 0x70, 0xe0, 0x70, 0xe0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xe0, 0xf1, 0xe0,
    0xf3, 0xc0, 0xf3, 0xc0, 0xf1, 0xe0, 0xf0, 0xf0,
    0xf0, 0x70, 0xf0, 0x38, 0xf0, 0x38, 0xf0, 0x38,
    0xf0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 226:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 227:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0x3c, 0xf0, 0x3c, 0xf0,
    0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0,
    0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0,
    0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 228:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0xff, 0xfc,
    0xf0, 0x1c, 0x78, 0x0c, 0x3c, 0x00, 0x1e, 0x00,
    0x0f, 0x00, 0x07, 0x80, 0x03, 0xc0, 0x03, 0xc0,
    0x07, 0x80, 0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x00,
    0x78, 0x0c, 0xf0, 0x1c, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 229:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfc, 0x3f, 0xfc,
    0x73, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
    0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
    0xe1, 0xc0, 0x73, 0x80, 0x3f, 0x00, 0x1e, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 230:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x38, 0x3c, 0x78, 0x3f, 0xf0, 0x3f, 0xe0,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x38, 0x00,
    0xf0, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 231:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1e, 0x1c, 0x3f, 0x3c, 0xf3, 0xf0, 0xe3, 0xe0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 232:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc,
    0x03, 0xc0, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0,
    0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
    0x38, 0x1c, 0x1c, 0x38, 0x0f, 0xf0, 0x07, 0xe0,
    0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 233:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0f, 0xc0,
    0x1c, 0xe0, 0x38, 0x70, 0x70, 0x38, 0x70, 0x38,
    0xe0, 0x1c, 0xe0, 0x1c, 0xff, 0xfc, 0xff, 0xfc,
    0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x38, 0x70, 0x38,
    0x38, 0x70, 0x1c, 0xe0, 0x0f, 0xc0, 0x07, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 234:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xc0, 0x1f, 0xe0, 0x3c, 0xf0, 0x78, 0x78,
    0xf0, 0x3c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c,
    0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x38, 0x78, 0x78,
    0x38, 0x70, 0x3c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0,
    0x1c, 0xe0, 0x1c, 0xe0, 0xfc, 0xfc, 0xfc, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 235:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xfc, 0x03, 0xfc, 0x07, 0x00, 0x07, 0x00,
    0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0, 0x00, 0xf0,
    0x07, 0xf8, 0x0f, 0xfc, 0x1c, 0x3c, 0x38, 0x1c,
    0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
    0x38, 0x1c, 0x1c, 0x38, 0x0f, 0xf0, 0x07, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 236:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x3f, 0xfc,
    0x73, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf,
    0xf3, 0xcf, 0x73, 0xcf, 0x3f, 0xfc, 0x1f, 0xf8,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 237:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x0e,
    0x00, 0x1c, 0x00, 0x38, 0x1f, 0xf8, 0x3f, 0xfc,
    0x70, 0xee, 0xf1, 0xcf, 0xf3, 0xcf, 0xf7, 0x8f,
    0xff, 0x0f, 0xff, 0x0e, 0x3f, 0xfc, 0x3f, 0xf8,
    0x38, 0x00, 0x30, 0x00, 0x70, 0x00, 0xe0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 238:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf0, 0x03, 0xf0, 0x07, 0x80, 0x0f, 0x00,
    0x1e, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
    0x3f, 0xf0, 0x3f, 0xf0, 0x3c, 0x00, 0x3c, 0x00,
    0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x1e, 0x00,
    0x0f, 0x00, 0x07, 0x80, 0x03, 0xf0, 0x00, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 239:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x7f, 0xf8,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 240:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0xff, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 241:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x3f, 0xfc, 0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 242:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0f, 0x00,
    0x07, 0x80, 0x03, 0xc0, 0x01, 0xe0, 0x00, 0xf0,
    0x00, 0x78, 0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0,
    0x03, 0xc0, 0x07, 0x80, 0x0f, 0x00, 0x0e, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 243:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xf0,
    0x01, 0xe0, 0x03, 0xc0, 0x07, 0x80, 0x0f, 0x00,
    0x1e, 0x00, 0x1e, 0x00, 0x0f, 0x00, 0x07, 0x80,
    0x03, 0xc0, 0x01, 0xe0, 0x00, 0xf0, 0x00, 0x70,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 244:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xfc, 0x01, 0xfe, 0x03, 0xcf, 0x03, 0xcf,
    0x03, 0xcf, 0x03, 0xcf, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,

    // 245:
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
    0xf3, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0,
    0xf3, 0xc0, 0xf3, 0xc0, 0x7f, 0x80, 0x3f, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 246:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x80, 0x03, 0xc0, 0x03, 0xc0, 0x01, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0xc0,
    0x03, 0xc0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 247:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1e, 0x1c, 0x3f, 0x3c,
    0xf3, 0xf0, 0xe1, 0xe0, 0x00, 0x00, 0x00, 0x00,
    0x1e, 0x1c, 0x3f, 0x3c, 0xf3, 0xf0, 0xe1, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 248:
    0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0f, 0xc0,
    0x1c, 0xe0, 0x38, 0x70, 0x38, 0x70, 0x1c, 0xe0,
    0x0f, 0xc0, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 249:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
    0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 250:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 251:
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
    0x00, 0xf0, 0x00, 0xf0, 0xe0, 0xf0, 0xf0, 0xf0,
    0x78, 0xf0, 0x3c, 0xf0, 0x1e, 0xf0, 0x0f, 0xf0,
    0x07, 0xf0, 0x03, 0xf0, 0x01, 0xf0, 0x00, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 252:
    0x00, 0x00, 0x00, 0x00, 0xf3, 0xc0, 0xf7, 0xe0,
    0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0,
    0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0,
    0x3c, 0xf0, 0x3c, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 253:
    0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x3f, 0x00,
    0x73, 0x80, 0xe3, 0xc0, 0x07, 0x00, 0x0e, 0x00,
    0x1c, 0x00, 0x38, 0x00, 0x70, 0xc0, 0xe0, 0xc0,
    0xff, 0xc0, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 254:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf0,
    0x3f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf0,
    0x3f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf0,
    0x3f, 0xf0, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    // 255:
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static txt_font_t large_font =
{
    large_font_data,
    16,                   // width
    32                    // height
};

