/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* sun.strongswan.org */
  2, X'73756e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=sun.strongswan.org' */
  11, X'edcd6347cdd12fb63000b605430713544c9d318a'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b8308202a0a003020102020100300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303130303131385a170d3139303930373130303131385a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381b23081af30120603551d130101ff040830060101ff020101300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010023929aa101b412d1f5a577532088f209b34798a72ed7bd6945d74beaa2b3a1768764ad7f8b0df8d97a1a3ed1102e92a5f107e3059dc2250be49d02261ca83a342e0e5de7d43c37744e3fcea3197720ca1184d4ef94e6beeb0d241746b0b92b7fb1004c08e88bf9eb4ce60f3e149466f3e9fc3f98bce449f448f9d465e52b59f0101e6203cfad0d89e23509fa043d4c12021e8f32be7db8b2edbada641d64aa1a04af64a2ee5b814a753dd76b30e3de04f3c6b61166e632f8364d51cf3730a9564a4d93b9227c28b09b0f5595d92a632f72fe509a129ca9ee54df2b0edc6c3d38564f10256efcd8be82b2ec64977e3a6f5ef098eaa7f00662a6cded16cb80637c'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=sun.strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 5 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6 
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=sun.strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 5 
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 6 
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_SUN', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, mobike, dpd_delay
) VALUES (
  'net-net', 1, 5, 4, 0, 0
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'net-net', 'ipsec _updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a020000', X'0a02ffff'
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

