/* string.c generated by valac 0.40.4, the Vala compiler
 * generated from string.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;



gint64 g_ascii_strtoll (const gchar* str,
                        gchar** endptr,
                        guint num_base);
#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
gboolean is_string_empty (const gchar* s);
gint utf8_cs_compare (void* a,
                      void* b);
gint utf8_ci_compare (void* a,
                      void* b);
gchar* uchar_array_to_string (guchar* data,
                              int data_length1,
                              gint length);
guchar* string_to_uchar_array (const gchar* str,
                               int* result_length1);
static void _vala_array_add1 (guchar* * array,
                       int* length,
                       int* size,
                       guchar value);
gchar* guarded_markup_escape_text (const gchar* plain);
glong find_last_offset (const gchar* str,
                        gchar c);
gboolean is_in_ci_array (const gchar* str,
                         gchar** strings,
                         int strings_length1);
GType prepare_input_text_options_get_type (void) G_GNUC_CONST;
gchar* guess_convert (const gchar* text);
gchar* prepare_input_text (const gchar* text,
                           PrepareInputTextOptions options,
                           gint dest_length);
gint64 parse_int64 (const gchar* str,
                    gint num_base);
gboolean string_contains_char (const gchar* haystack,
                               gunichar needle);
gboolean string_contains_str (const gchar* haystack,
                              const gchar* needle);
gchar* string_sliced_at (const gchar* str,
                         gint index);
gchar* string_sliced_at_first_str (const gchar* haystack,
                                   const gchar* needle,
                                   gint start_index);
gchar* string_sliced_at_last_str (const gchar* haystack,
                                  const gchar* needle,
                                  gint start_index);
gchar* string_sliced_at_first_char (const gchar* haystack,
                                    gunichar ch,
                                    gint start_index);
gchar* string_sliced_at_last_char (const gchar* haystack,
                                   gunichar ch,
                                   gint start_index);
gchar* string_strip_leading_zeroes (const gchar* str);
gchar* string_remove_diacritics (const gchar* istring);
gchar* string_to_hex_string (const gchar* str);
guint string_collated_hash (void* ptr);
guint string_precollated_hash (void* ptr);
gint string_collated_compare (void* a,
                              void* b);
gint string_precollated_compare (const gchar* astr,
                                 const gchar* akey,
                                 const gchar* bstr,
                                 const gchar* bkey);
gboolean string_collated_equals (void* a,
                                 void* b);
gboolean string_precollated_equals (const gchar* astr,
                                    const gchar* akey,
                                    const gchar* bstr,
                                    const gchar* bkey);


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 117 "string.c"
}


inline gboolean
is_string_empty (const gchar* s)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
	if (s == NULL) {
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = TRUE;
#line 130 "string.c"
	} else {
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = string_get (s, (glong) 0) == '\0';
#line 134 "string.c"
	}
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 140 "string.c"
}


gint
utf8_cs_compare (void* a,
                 void* b)
{
	gint result = 0;
#line 17 "/home/jens/Source/shotwell/src/util/string.vala"
	result = g_utf8_collate ((const gchar*) a, (const gchar*) b);
#line 17 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 153 "string.c"
}


gint
utf8_ci_compare (void* a,
                 void* b)
{
	gint result = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_utf8_strdown ((const gchar*) a, (gssize) -1);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = _tmp0_;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = g_utf8_strdown ((const gchar*) b, (gssize) -1);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = _tmp2_;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = g_utf8_collate (_tmp1_, _tmp3_);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (_tmp3_);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (_tmp1_);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp4_;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 185 "string.c"
}


gchar*
uchar_array_to_string (guchar* data,
                       int data_length1,
                       gint length)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
#line 27 "/home/jens/Source/shotwell/src/util/string.vala"
	if (length < 0) {
#line 28 "/home/jens/Source/shotwell/src/util/string.vala"
		length = data_length1;
#line 204 "string.c"
	}
#line 30 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_string_new ("");
#line 30 "/home/jens/Source/shotwell/src/util/string.vala"
	builder = _tmp0_;
#line 210 "string.c"
	{
		gint ctr = 0;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
		ctr = 0;
#line 215 "string.c"
		{
			gboolean _tmp1_ = FALSE;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp1_ = TRUE;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
			while (TRUE) {
#line 222 "string.c"
				gint _tmp3_;
				gint _tmp4_;
				guchar _tmp5_;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!_tmp1_) {
#line 228 "string.c"
					gint _tmp2_;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp2_ = ctr;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
					ctr = _tmp2_ + 1;
#line 234 "string.c"
				}
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp1_ = FALSE;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp3_ = ctr;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!(_tmp3_ < length)) {
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
					break;
#line 244 "string.c"
				}
#line 32 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp4_ = ctr;
#line 32 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp5_ = data[_tmp4_];
#line 32 "/home/jens/Source/shotwell/src/util/string.vala"
				if (_tmp5_ != ((guchar) '\0')) {
#line 252 "string.c"
					GString* _tmp6_;
					gint _tmp7_;
					guchar _tmp8_;
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp6_ = builder;
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp7_ = ctr;
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp8_ = data[_tmp7_];
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					g_string_append_c (_tmp6_, (gchar) _tmp8_);
#line 264 "string.c"
				} else {
#line 35 "/home/jens/Source/shotwell/src/util/string.vala"
					break;
#line 268 "string.c"
				}
			}
		}
	}
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp9_ = builder;
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp10_ = _tmp9_->str;
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp11_;
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_string_free0 (builder);
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 285 "string.c"
}


static void
_vala_array_add1 (guchar* * array,
                  int* length,
                  int* size,
                  guchar value)
{
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((*length) == (*size)) {
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
		*array = g_renew (guchar, *array, *size);
#line 301 "string.c"
	}
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
	(*array)[(*length)++] = value;
#line 305 "string.c"
}


guchar*
string_to_uchar_array (const gchar* str,
                       int* result_length1)
{
	guchar* result = NULL;
	guchar* data = NULL;
	guchar* _tmp0_;
	gint data_length1;
	gint _data_size_;
	guchar* _tmp8_;
	gint _tmp8__length1;
#line 42 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 43 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_new0 (guchar, 0);
#line 43 "/home/jens/Source/shotwell/src/util/string.vala"
	data = _tmp0_;
#line 43 "/home/jens/Source/shotwell/src/util/string.vala"
	data_length1 = 0;
#line 43 "/home/jens/Source/shotwell/src/util/string.vala"
	_data_size_ = data_length1;
#line 330 "string.c"
	{
		gint ctr = 0;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
		ctr = 0;
#line 335 "string.c"
		{
			gboolean _tmp1_ = FALSE;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp1_ = TRUE;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
			while (TRUE) {
#line 342 "string.c"
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				guchar* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!_tmp1_) {
#line 351 "string.c"
					gint _tmp2_;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp2_ = ctr;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
					ctr = _tmp2_ + 1;
#line 357 "string.c"
				}
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp1_ = FALSE;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp3_ = ctr;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp4_ = strlen (str);
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp5_ = _tmp4_;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!(_tmp3_ < _tmp5_)) {
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
					break;
#line 371 "string.c"
				}
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp6_ = data;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp6__length1 = data_length1;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp7_ = ctr;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_vala_array_add1 (&data, &data_length1, &_data_size_, (guchar) string_get (str, (glong) _tmp7_));
#line 381 "string.c"
			}
		}
	}
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp8_ = data;
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp8__length1 = data_length1;
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	if (result_length1) {
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
		*result_length1 = _tmp8__length1;
#line 393 "string.c"
	}
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp8_;
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 399 "string.c"
}


inline gchar*
guarded_markup_escape_text (const gchar* plain)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	if (!is_string_empty (plain)) {
#line 411 "string.c"
		gboolean _tmp2_;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = g_utf8_validate (plain, (gssize) -1, NULL);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = _tmp2_;
#line 417 "string.c"
	} else {
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = FALSE;
#line 421 "string.c"
	}
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp1_) {
#line 425 "string.c"
		gchar* _tmp3_;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = g_markup_escape_text (plain, (gssize) -1);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp0_);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = _tmp3_;
#line 433 "string.c"
	} else {
		gchar* _tmp4_;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = g_strdup ("");
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp0_);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = _tmp4_;
#line 442 "string.c"
	}
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 448 "string.c"
}


glong
find_last_offset (const gchar* str,
                  gchar c)
{
	glong result = 0L;
	glong offset = 0L;
	gint _tmp0_;
	gint _tmp1_;
#line 61 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, 0L);
#line 62 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = strlen (str);
#line 62 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = _tmp0_;
#line 62 "/home/jens/Source/shotwell/src/util/string.vala"
	offset = (glong) _tmp1_;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
	while (TRUE) {
#line 470 "string.c"
		glong _tmp2_;
		glong _tmp3_;
		glong _tmp4_;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = offset;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
		offset = _tmp2_ - 1;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = offset;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
		if (!(_tmp3_ >= ((glong) 0))) {
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
			break;
#line 484 "string.c"
		}
#line 64 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = offset;
#line 64 "/home/jens/Source/shotwell/src/util/string.vala"
		if (string_get (str, _tmp4_) == c) {
#line 65 "/home/jens/Source/shotwell/src/util/string.vala"
			result = offset;
#line 65 "/home/jens/Source/shotwell/src/util/string.vala"
			return result;
#line 494 "string.c"
		}
	}
#line 68 "/home/jens/Source/shotwell/src/util/string.vala"
	result = (glong) -1;
#line 68 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 501 "string.c"
}


gboolean
is_in_ci_array (const gchar* str,
                gchar** strings,
                int strings_length1)
{
	gboolean result = FALSE;
	gchar* strdown = NULL;
	gchar* _tmp0_;
#line 73 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, FALSE);
#line 74 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_utf8_strdown (str, (gssize) -1);
#line 74 "/home/jens/Source/shotwell/src/util/string.vala"
	strdown = _tmp0_;
#line 519 "string.c"
	{
		gchar** str_element_collection = NULL;
		gint str_element_collection_length1 = 0;
		gint _str_element_collection_size_ = 0;
		gint str_element_it = 0;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
		str_element_collection = strings;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
		str_element_collection_length1 = strings_length1;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
		for (str_element_it = 0; str_element_it < strings_length1; str_element_it = str_element_it + 1) {
#line 531 "string.c"
			gchar* _tmp1_;
			gchar* str_element = NULL;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp1_ = g_strdup (str_element_collection[str_element_it]);
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
			str_element = _tmp1_;
#line 538 "string.c"
			{
				const gchar* _tmp2_;
				const gchar* _tmp3_;
#line 76 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp2_ = strdown;
#line 76 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp3_ = str_element;
#line 76 "/home/jens/Source/shotwell/src/util/string.vala"
				if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
#line 77 "/home/jens/Source/shotwell/src/util/string.vala"
					result = TRUE;
#line 77 "/home/jens/Source/shotwell/src/util/string.vala"
					_g_free0 (str_element);
#line 77 "/home/jens/Source/shotwell/src/util/string.vala"
					_g_free0 (strdown);
#line 77 "/home/jens/Source/shotwell/src/util/string.vala"
					return result;
#line 556 "string.c"
				}
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_free0 (str_element);
#line 560 "string.c"
			}
		}
	}
#line 80 "/home/jens/Source/shotwell/src/util/string.vala"
	result = FALSE;
#line 80 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (strdown);
#line 80 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 570 "string.c"
}


GType
prepare_input_text_options_get_type (void)
{
	static volatile gsize prepare_input_text_options_type_id__volatile = 0;
	if (g_once_init_enter (&prepare_input_text_options_type_id__volatile)) {
		static const GFlagsValue values[] = {{PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL, "PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL", "empty-is-null"}, {PREPARE_INPUT_TEXT_OPTIONS_VALIDATE, "PREPARE_INPUT_TEXT_OPTIONS_VALIDATE", "validate"}, {PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL, "PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL", "invalid-is-null"}, {PREPARE_INPUT_TEXT_OPTIONS_STRIP, "PREPARE_INPUT_TEXT_OPTIONS_STRIP", "strip"}, {PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF, "PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF", "strip-crlf"}, {PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE, "PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE", "normalize"}, {PREPARE_INPUT_TEXT_OPTIONS_DEFAULT, "PREPARE_INPUT_TEXT_OPTIONS_DEFAULT", "default"}, {0, NULL, NULL}};
		GType prepare_input_text_options_type_id;
		prepare_input_text_options_type_id = g_flags_register_static ("PrepareInputTextOptions", values);
		g_once_init_leave (&prepare_input_text_options_type_id__volatile, prepare_input_text_options_type_id);
	}
	return prepare_input_text_options_type_id__volatile;
}


gchar*
guess_convert (const gchar* text)
{
	gchar* result = NULL;
	gchar* output = NULL;
	gsize bytes_read = 0UL;
	const gchar* charset = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gsize _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GError * _inner_error_ = NULL;
#line 94 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 95 "/home/jens/Source/shotwell/src/util/string.vala"
	output = NULL;
#line 96 "/home/jens/Source/shotwell/src/util/string.vala"
	bytes_read = (gsize) 0;
#line 97 "/home/jens/Source/shotwell/src/util/string.vala"
	charset = NULL;
#line 98 "/home/jens/Source/shotwell/src/util/string.vala"
	g_debug ("string.vala:98: CONVERT: Text did not validate as UTF-8, trying conver" \
"sion");
#line 101 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = g_get_charset (&_tmp0_);
#line 101 "/home/jens/Source/shotwell/src/util/string.vala"
	charset = _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/util/string.vala"
	if (!_tmp1_) {
#line 617 "string.c"
		gint _tmp2_;
		gint _tmp3_;
		gsize _tmp4_ = 0UL;
		gchar* _tmp5_;
		gsize _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 102 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = strlen (text);
#line 102 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = _tmp2_;
#line 102 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp5_ = g_locale_to_utf8 (text, (gssize) _tmp3_, &_tmp4_, NULL, NULL);
#line 102 "/home/jens/Source/shotwell/src/util/string.vala"
		bytes_read = _tmp4_;
#line 102 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (output);
#line 102 "/home/jens/Source/shotwell/src/util/string.vala"
		output = _tmp5_;
#line 103 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = bytes_read;
#line 103 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = strlen (text);
#line 103 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp8_ = _tmp7_;
#line 103 "/home/jens/Source/shotwell/src/util/string.vala"
		if (_tmp6_ == ((gsize) _tmp8_)) {
#line 645 "string.c"
			const gchar* _tmp9_;
#line 104 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp9_ = charset;
#line 104 "/home/jens/Source/shotwell/src/util/string.vala"
			g_debug ("string.vala:104: CONVERT: Locale is not UTF-8, convert from %s", _tmp9_);
#line 105 "/home/jens/Source/shotwell/src/util/string.vala"
			result = output;
#line 105 "/home/jens/Source/shotwell/src/util/string.vala"
			return result;
#line 655 "string.c"
		}
	}
	{
		gchar* _tmp10_ = NULL;
		gint _tmp11_;
		gint _tmp12_;
		gsize _tmp13_ = 0UL;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp11_ = strlen (text);
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp12_ = _tmp11_;
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp14_ = g_convert (text, (gssize) _tmp12_, "UTF-8", "WINDOWS-1252", &_tmp13_, NULL, &_inner_error_);
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		bytes_read = _tmp13_;
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp10_ = _tmp14_;
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
			if (_inner_error_->domain == G_CONVERT_ERROR) {
#line 679 "string.c"
				goto __catch6_g_convert_error;
			}
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
			_g_free0 (output);
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
			g_clear_error (&_inner_error_);
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
			return NULL;
#line 690 "string.c"
		}
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp15_ = _tmp10_;
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp10_ = NULL;
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (output);
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
		output = _tmp15_;
#line 111 "/home/jens/Source/shotwell/src/util/string.vala"
		charset = "WINDOWS-1252";
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp10_);
#line 704 "string.c"
	}
	goto __finally6;
	__catch6_g_convert_error:
	{
		GError* _error_ = NULL;
		GError* _tmp16_;
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
		_error_ = _inner_error_;
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
		_inner_error_ = NULL;
#line 113 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp16_ = _error_;
#line 113 "/home/jens/Source/shotwell/src/util/string.vala"
		if (g_error_matches (_tmp16_, G_CONVERT_ERROR, G_CONVERT_ERROR_NO_CONVERSION)) {
#line 719 "string.c"
			{
				gchar* _tmp17_ = NULL;
				gint _tmp18_;
				gint _tmp19_;
				gsize _tmp20_ = 0UL;
				gchar* _tmp21_;
				gchar* _tmp22_;
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp18_ = strlen (text);
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp19_ = _tmp18_;
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp21_ = g_convert (text, (gssize) _tmp19_, "UTF-8", "ISO-8859-1", &_tmp20_, NULL, &_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				bytes_read = _tmp20_;
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp17_ = _tmp21_;
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 739 "string.c"
					goto __catch7_g_error;
				}
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp22_ = _tmp17_;
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp17_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_free0 (output);
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
				output = _tmp22_;
#line 116 "/home/jens/Source/shotwell/src/util/string.vala"
				charset = "ISO-8859-1";
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_free0 (_tmp17_);
#line 754 "string.c"
			}
			goto __finally7;
			__catch7_g_error:
			{
				GError* _error_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				_error_ = _inner_error_;
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				_inner_error_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_error_free0 (_error_);
#line 766 "string.c"
			}
			__finally7:
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_error_free0 (_error_);
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_error_free0 (_error_);
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_free0 (output);
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				g_clear_error (&_inner_error_);
#line 114 "/home/jens/Source/shotwell/src/util/string.vala"
				return NULL;
#line 783 "string.c"
			}
		}
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_error_free0 (_error_);
#line 788 "string.c"
	}
	__finally6:
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (output);
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
		g_clear_error (&_inner_error_);
#line 109 "/home/jens/Source/shotwell/src/util/string.vala"
		return NULL;
#line 801 "string.c"
	}
#line 121 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp23_ = bytes_read;
#line 121 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp24_ = strlen (text);
#line 121 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp25_ = _tmp24_;
#line 121 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp23_ == ((gsize) _tmp25_)) {
#line 811 "string.c"
		const gchar* _tmp26_;
#line 122 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp26_ = charset;
#line 122 "/home/jens/Source/shotwell/src/util/string.vala"
		g_debug ("string.vala:122: CONVERT: Guessed conversion from %s", _tmp26_);
#line 124 "/home/jens/Source/shotwell/src/util/string.vala"
		result = output;
#line 124 "/home/jens/Source/shotwell/src/util/string.vala"
		return result;
#line 821 "string.c"
	}
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
	result = NULL;
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (output);
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 829 "string.c"
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1248 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _result_;
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 854 "string.c"
}


static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1256 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1256 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (delimiters != NULL, NULL);
#line 1257 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1257 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1258 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1258 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_strdelimit (_tmp1_, delimiters, new_delimiter);
#line 1259 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _result_;
#line 1259 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 883 "string.c"
}


gchar*
prepare_input_text (const gchar* text,
                    PrepareInputTextOptions options,
                    gint dest_length)
{
	gchar* result = NULL;
	gchar* prepped = NULL;
	gchar* _tmp0_;
	gboolean _tmp12_ = FALSE;
#line 131 "/home/jens/Source/shotwell/src/util/string.vala"
	if (text == NULL) {
#line 132 "/home/jens/Source/shotwell/src/util/string.vala"
		result = NULL;
#line 132 "/home/jens/Source/shotwell/src/util/string.vala"
		return result;
#line 902 "string.c"
	}
#line 134 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_strdup (text);
#line 134 "/home/jens/Source/shotwell/src/util/string.vala"
	prepped = _tmp0_;
#line 135 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) == PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) {
#line 910 "string.c"
		gboolean _tmp1_;
#line 136 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = g_utf8_validate (text, (gssize) -1, NULL);
#line 136 "/home/jens/Source/shotwell/src/util/string.vala"
		if (!_tmp1_) {
#line 916 "string.c"
			gchar* _tmp2_;
			const gchar* _tmp3_;
#line 137 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp2_ = guess_convert (text);
#line 137 "/home/jens/Source/shotwell/src/util/string.vala"
			_g_free0 (prepped);
#line 137 "/home/jens/Source/shotwell/src/util/string.vala"
			prepped = _tmp2_;
#line 139 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp3_ = prepped;
#line 139 "/home/jens/Source/shotwell/src/util/string.vala"
			if (_tmp3_ == NULL) {
#line 929 "string.c"
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
#line 140 "/home/jens/Source/shotwell/src/util/string.vala"
				if ((options & PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) != 0) {
#line 140 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp4_ = NULL;
#line 936 "string.c"
				} else {
#line 140 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp4_ = "";
#line 940 "string.c"
				}
#line 140 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp5_ = g_strdup (_tmp4_);
#line 140 "/home/jens/Source/shotwell/src/util/string.vala"
				result = _tmp5_;
#line 140 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_free0 (prepped);
#line 140 "/home/jens/Source/shotwell/src/util/string.vala"
				return result;
#line 950 "string.c"
			}
		}
	}
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE) != 0) {
#line 956 "string.c"
		const gchar* _tmp6_;
		gchar* _tmp7_;
#line 150 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = prepped;
#line 150 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = g_utf8_normalize (_tmp6_, (gssize) -1, G_NORMALIZE_NFC);
#line 150 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 150 "/home/jens/Source/shotwell/src/util/string.vala"
		prepped = _tmp7_;
#line 967 "string.c"
	}
#line 152 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_STRIP) != 0) {
#line 971 "string.c"
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp8_ = prepped;
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp9_ = string_strip (_tmp8_);
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
		prepped = _tmp9_;
#line 982 "string.c"
	}
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) != 0) {
#line 986 "string.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
#line 158 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp10_ = prepped;
#line 158 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp11_ = string_delimit (_tmp10_, "\n\r", ' ');
#line 158 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 158 "/home/jens/Source/shotwell/src/util/string.vala"
		prepped = _tmp11_;
#line 997 "string.c"
	}
#line 160 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL) != 0) {
#line 1001 "string.c"
		const gchar* _tmp13_;
#line 160 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp13_ = prepped;
#line 160 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp12_ = is_string_empty (_tmp13_);
#line 1007 "string.c"
	} else {
#line 160 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp12_ = FALSE;
#line 1011 "string.c"
	}
#line 160 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp12_) {
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
		result = NULL;
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
		return result;
#line 1021 "string.c"
	}
#line 166 "/home/jens/Source/shotwell/src/util/string.vala"
	if (dest_length >= 0) {
#line 1025 "string.c"
		GString* sb = NULL;
		const gchar* _tmp14_;
		GString* _tmp15_;
		GString* _tmp16_;
		GString* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
#line 167 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp14_ = prepped;
#line 167 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp15_ = g_string_new (_tmp14_);
#line 167 "/home/jens/Source/shotwell/src/util/string.vala"
		sb = _tmp15_;
#line 168 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp16_ = sb;
#line 168 "/home/jens/Source/shotwell/src/util/string.vala"
		g_string_truncate (_tmp16_, (gsize) dest_length);
#line 169 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp17_ = sb;
#line 169 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp18_ = _tmp17_->str;
#line 169 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 169 "/home/jens/Source/shotwell/src/util/string.vala"
		result = _tmp19_;
#line 169 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_string_free0 (sb);
#line 169 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 169 "/home/jens/Source/shotwell/src/util/string.vala"
		return result;
#line 1057 "string.c"
	}
#line 173 "/home/jens/Source/shotwell/src/util/string.vala"
	result = prepped;
#line 173 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1063 "string.c"
}


gint64
parse_int64 (const gchar* str,
             gint num_base)
{
	gint64 result = 0LL;
	gint64 _tmp0_;
#line 176 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, 0LL);
#line 177 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_ascii_strtoll (str, NULL, (guint) num_base);
#line 177 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 177 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1081 "string.c"
}


static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1045 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1046 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1046 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1048 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1048 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1104 "string.c"
		gchar* _tmp2_;
#line 1049 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1049 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1049 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1112 "string.c"
	} else {
#line 1051 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = -1;
#line 1051 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1118 "string.c"
	}
}


inline gboolean
string_contains_char (const gchar* haystack,
                      gunichar needle)
{
	gboolean result = FALSE;
#line 182 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, FALSE);
#line 183 "/home/jens/Source/shotwell/src/util/string.vala"
	result = string_index_of_char (haystack, needle, 0) >= 0;
#line 183 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1134 "string.c"
}


static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1025 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1025 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1026 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1026 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1028 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1028 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1159 "string.c"
		gchar* _tmp2_;
#line 1029 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1029 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1029 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1167 "string.c"
	} else {
#line 1031 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = -1;
#line 1031 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1173 "string.c"
	}
}


inline gboolean
string_contains_str (const gchar* haystack,
                     const gchar* needle)
{
	gboolean result = FALSE;
#line 186 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, FALSE);
#line 186 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 187 "/home/jens/Source/shotwell/src/util/string.vala"
	result = string_index_of (haystack, needle, 0) >= 0;
#line 187 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1191 "string.c"
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
#line 1369 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1370 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1370 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1370 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1371 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1217 "string.c"
		glong _tmp2_;
#line 1372 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = string_length;
#line 1372 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		start = _tmp2_ + start;
#line 1223 "string.c"
	}
#line 1374 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1227 "string.c"
		glong _tmp3_;
#line 1375 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1375 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		end = _tmp3_ + end;
#line 1233 "string.c"
	}
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1237 "string.c"
		glong _tmp5_;
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = start <= _tmp5_;
#line 1243 "string.c"
	} else {
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = FALSE;
#line 1247 "string.c"
	}
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp4_, NULL);
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1253 "string.c"
		glong _tmp7_;
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = string_length;
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = end <= _tmp7_;
#line 1259 "string.c"
	} else {
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = FALSE;
#line 1263 "string.c"
	}
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp6_, NULL);
#line 1379 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1380 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1380 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp8_;
#line 1380 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1275 "string.c"
}


inline gchar*
string_sliced_at (const gchar* str,
                  gint index)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 190 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
	if (index >= 0) {
#line 1289 "string.c"
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = strlen (str);
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = _tmp1_;
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = string_slice (str, (glong) index, (glong) _tmp2_);
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp0_);
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = _tmp3_;
#line 1303 "string.c"
	} else {
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp0_);
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = NULL;
#line 1309 "string.c"
	}
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 191 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1315 "string.c"
}


inline gchar*
string_sliced_at_first_str (const gchar* haystack,
                            const gchar* needle,
                            gint start_index)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 194 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, NULL);
#line 194 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (needle != NULL, NULL);
#line 195 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = string_sliced_at (haystack, string_index_of (haystack, needle, start_index));
#line 195 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 195 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1336 "string.c"
}


static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1035 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1035 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1036 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1036 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1038 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1038 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1361 "string.c"
		gchar* _tmp2_;
#line 1039 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1039 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1039 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1369 "string.c"
	} else {
#line 1041 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = -1;
#line 1041 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1375 "string.c"
	}
}


inline gchar*
string_sliced_at_last_str (const gchar* haystack,
                           const gchar* needle,
                           gint start_index)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 198 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, NULL);
#line 198 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (needle != NULL, NULL);
#line 199 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = string_sliced_at (haystack, string_last_index_of (haystack, needle, start_index));
#line 199 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 199 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1397 "string.c"
}


inline gchar*
string_sliced_at_first_char (const gchar* haystack,
                             gunichar ch,
                             gint start_index)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 202 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, NULL);
#line 203 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = string_sliced_at (haystack, string_index_of_char (haystack, ch, start_index));
#line 203 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 203 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1416 "string.c"
}


static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1055 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1056 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1056 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1058 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1058 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1439 "string.c"
		gchar* _tmp2_;
#line 1059 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1059 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1059 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1447 "string.c"
	} else {
#line 1061 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = -1;
#line 1061 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1453 "string.c"
	}
}


inline gchar*
string_sliced_at_last_char (const gchar* haystack,
                            gunichar ch,
                            gint start_index)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 206 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, NULL);
#line 207 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = string_sliced_at (haystack, string_last_index_of_char (haystack, ch, start_index));
#line 207 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 207 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1473 "string.c"
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
#line 1154 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1155 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1155 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1488 "string.c"
}


gchar*
string_strip_leading_zeroes (const gchar* str)
{
	gchar* result = NULL;
	GString* stripped = NULL;
	GString* _tmp0_;
	gboolean prev_is_space = FALSE;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
#line 211 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 212 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_string_new ("");
#line 212 "/home/jens/Source/shotwell/src/util/string.vala"
	stripped = _tmp0_;
#line 213 "/home/jens/Source/shotwell/src/util/string.vala"
	prev_is_space = TRUE;
#line 1510 "string.c"
	{
		const gchar* iter = NULL;
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
		iter = str;
#line 1515 "string.c"
		{
			gboolean _tmp1_ = FALSE;
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp1_ = TRUE;
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
			while (TRUE) {
#line 1522 "string.c"
				const gchar* _tmp4_;
				gunichar ch = 0U;
				const gchar* _tmp5_;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_;
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!_tmp1_) {
#line 1530 "string.c"
					const gchar* _tmp2_;
					const gchar* _tmp3_;
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp2_ = iter;
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp3_ = g_utf8_next_char (_tmp2_);
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
					iter = _tmp3_;
#line 1539 "string.c"
				}
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp1_ = FALSE;
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp4_ = iter;
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!(string_get_char (_tmp4_, (glong) 0) != ((gunichar) 0))) {
#line 214 "/home/jens/Source/shotwell/src/util/string.vala"
					break;
#line 1549 "string.c"
				}
#line 215 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp5_ = iter;
#line 215 "/home/jens/Source/shotwell/src/util/string.vala"
				ch = string_get_char (_tmp5_, (glong) 0);
#line 217 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp7_ = prev_is_space;
#line 217 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!_tmp7_) {
#line 217 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp6_ = TRUE;
#line 1561 "string.c"
				} else {
					gunichar _tmp8_;
#line 217 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp8_ = ch;
#line 217 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp6_ = _tmp8_ != ((gunichar) '0');
#line 1568 "string.c"
				}
#line 217 "/home/jens/Source/shotwell/src/util/string.vala"
				if (_tmp6_) {
#line 1572 "string.c"
					GString* _tmp9_;
					gunichar _tmp10_;
					gunichar _tmp11_;
#line 218 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp9_ = stripped;
#line 218 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp10_ = ch;
#line 218 "/home/jens/Source/shotwell/src/util/string.vala"
					g_string_append_unichar (_tmp9_, _tmp10_);
#line 219 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp11_ = ch;
#line 219 "/home/jens/Source/shotwell/src/util/string.vala"
					prev_is_space = g_unichar_isspace (_tmp11_);
#line 1586 "string.c"
				}
			}
		}
	}
#line 223 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp12_ = stripped;
#line 223 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp13_ = _tmp12_->str;
#line 223 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 223 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp14_;
#line 223 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_string_free0 (stripped);
#line 223 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1603 "string.c"
}


static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gunichar _tmp0_;
#line 1143 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1144 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1145 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = _vala_c;
#line 1145 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_ != ((gunichar) 0)) {
#line 1623 "string.c"
		gchar* _tmp1_;
#line 1146 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = g_utf8_next_char (((gchar*) self) + (*index));
#line 1146 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp1_ - ((gchar*) self));
#line 1147 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1147 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (c) {
#line 1147 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 1635 "string.c"
		}
#line 1147 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1639 "string.c"
	} else {
#line 1149 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1149 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (c) {
#line 1149 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 1647 "string.c"
		}
#line 1149 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1651 "string.c"
	}
#line 1143 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (c) {
#line 1143 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 1657 "string.c"
	}
}


gchar*
string_remove_diacritics (const gchar* istring)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gunichar ch = 0U;
	gint i = 0;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
#line 226 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (istring != NULL, NULL);
#line 227 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_string_new ("");
#line 227 "/home/jens/Source/shotwell/src/util/string.vala"
	builder = _tmp0_;
#line 229 "/home/jens/Source/shotwell/src/util/string.vala"
	i = 0;
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
	while (TRUE) {
#line 1683 "string.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gunichar _tmp6_;
		GString* _tmp7_;
		gunichar _tmp8_;
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = g_utf8_normalize (istring, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = _tmp1_;
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = string_get_next_char (_tmp2_, &i, &_tmp3_);
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
		ch = _tmp3_;
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp5_ = !_tmp4_;
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp2_);
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
		if (_tmp5_) {
#line 230 "/home/jens/Source/shotwell/src/util/string.vala"
			break;
#line 1708 "string.c"
		}
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = ch;
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
		switch (g_unichar_type (_tmp6_)) {
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_CONTROL:
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_FORMAT:
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_UNASSIGNED:
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_NON_SPACING_MARK:
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_COMBINING_MARK:
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_ENCLOSING_MARK:
#line 1726 "string.c"
			{
#line 239 "/home/jens/Source/shotwell/src/util/string.vala"
				continue;
#line 1730 "string.c"
			}
			default:
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
			break;
#line 1735 "string.c"
		}
#line 241 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = builder;
#line 241 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp8_ = ch;
#line 241 "/home/jens/Source/shotwell/src/util/string.vala"
		g_string_append_unichar (_tmp7_, _tmp8_);
#line 1743 "string.c"
	}
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp9_ = builder;
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp10_ = _tmp9_->str;
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp11_;
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_string_free0 (builder);
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1757 "string.c"
}


gchar*
string_to_hex_string (const gchar* str)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	guint8* data = NULL;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
#line 246 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 247 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_string_new ("");
#line 247 "/home/jens/Source/shotwell/src/util/string.vala"
	builder = _tmp0_;
#line 249 "/home/jens/Source/shotwell/src/util/string.vala"
	data = (guint8*) str;
#line 250 "/home/jens/Source/shotwell/src/util/string.vala"
	while (TRUE) {
#line 1781 "string.c"
		guint8* _tmp1_;
		const gchar* _tmp2_ = NULL;
		guint8* _tmp3_;
		GString* _tmp4_;
		guint8* _tmp5_;
#line 250 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = data;
#line 250 "/home/jens/Source/shotwell/src/util/string.vala"
		if (!(((gint) (*_tmp1_)) != 0)) {
#line 250 "/home/jens/Source/shotwell/src/util/string.vala"
			break;
#line 1793 "string.c"
		}
#line 251 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = data;
#line 251 "/home/jens/Source/shotwell/src/util/string.vala"
		if (((gint) (*_tmp3_)) != 0) {
#line 251 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp2_ = " ";
#line 1801 "string.c"
		} else {
#line 251 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp2_ = "";
#line 1805 "string.c"
		}
#line 251 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = builder;
#line 251 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp5_ = data;
#line 251 "/home/jens/Source/shotwell/src/util/string.vala"
		data = _tmp5_ + 1;
#line 251 "/home/jens/Source/shotwell/src/util/string.vala"
		g_string_append_printf (_tmp4_, "%02Xh%s", (guint) (*_tmp5_), _tmp2_);
#line 1815 "string.c"
	}
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp6_ = builder;
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp7_ = _tmp6_->str;
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp8_;
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_string_free0 (builder);
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1829 "string.c"
}


guint
string_collated_hash (void* ptr)
{
	guint result = 0U;
	gchar* str = NULL;
	gchar* _tmp0_;
	GHashFunc _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint _tmp4_;
#line 273 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_strdup ((const gchar*) ptr);
#line 273 "/home/jens/Source/shotwell/src/util/string.vala"
	str = _tmp0_;
#line 275 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = g_str_hash;
#line 275 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = g_utf8_collate_key (str, (gssize) -1);
#line 275 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = _tmp2_;
#line 275 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = _tmp1_ (_tmp3_);
#line 275 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (_tmp3_);
#line 275 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp4_;
#line 275 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (str);
#line 275 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1863 "string.c"
}


guint
string_precollated_hash (void* ptr)
{
	guint result = 0U;
	GHashFunc _tmp0_;
#line 280 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_str_hash;
#line 280 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_ ((const gchar*) ptr);
#line 280 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1878 "string.c"
}


gint
string_collated_compare (void* a,
                         void* b)
{
	gint result = 0;
	gchar* astr = NULL;
	gchar* _tmp0_;
	gchar* bstr = NULL;
	gchar* _tmp1_;
	gint _result_ = 0;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_;
#line 285 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_strdup ((const gchar*) a);
#line 285 "/home/jens/Source/shotwell/src/util/string.vala"
	astr = _tmp0_;
#line 286 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = g_strdup ((const gchar*) b);
#line 286 "/home/jens/Source/shotwell/src/util/string.vala"
	bstr = _tmp1_;
#line 288 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = astr;
#line 288 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = bstr;
#line 288 "/home/jens/Source/shotwell/src/util/string.vala"
	_result_ = g_utf8_collate (_tmp2_, _tmp3_);
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = _result_;
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp5_ != 0) {
#line 1914 "string.c"
		gint _tmp6_;
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = _result_;
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = _tmp6_;
#line 1920 "string.c"
	} else {
		GCompareFunc _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = g_strcmp0;
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp8_ = astr;
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp9_ = bstr;
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = _tmp7_ (_tmp8_, _tmp9_);
#line 1933 "string.c"
	}
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp4_;
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (bstr);
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (astr);
#line 290 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1943 "string.c"
}


gint
string_precollated_compare (const gchar* astr,
                            const gchar* akey,
                            const gchar* bstr,
                            const gchar* bkey)
{
	gint result = 0;
	gint _result_ = 0;
	GCompareFunc _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
#line 294 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (astr != NULL, 0);
#line 294 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (akey != NULL, 0);
#line 294 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (bstr != NULL, 0);
#line 294 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (bkey != NULL, 0);
#line 295 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_strcmp0;
#line 295 "/home/jens/Source/shotwell/src/util/string.vala"
	_result_ = _tmp0_ (akey, bkey);
#line 297 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = _result_;
#line 297 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp2_ != 0) {
#line 1974 "string.c"
		gint _tmp3_;
#line 297 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = _result_;
#line 297 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = _tmp3_;
#line 1980 "string.c"
	} else {
		GCompareFunc _tmp4_;
#line 297 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = g_strcmp0;
#line 297 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = _tmp4_ (astr, bstr);
#line 1987 "string.c"
	}
#line 297 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp1_;
#line 297 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1993 "string.c"
}


gboolean
string_collated_equals (void* a,
                        void* b)
{
	gboolean result = FALSE;
#line 302 "/home/jens/Source/shotwell/src/util/string.vala"
	result = string_collated_compare (a, b) == 0;
#line 302 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 2006 "string.c"
}


gboolean
string_precollated_equals (const gchar* astr,
                           const gchar* akey,
                           const gchar* bstr,
                           const gchar* bkey)
{
	gboolean result = FALSE;
#line 306 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (astr != NULL, FALSE);
#line 306 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (akey != NULL, FALSE);
#line 306 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (bstr != NULL, FALSE);
#line 306 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (bkey != NULL, FALSE);
#line 307 "/home/jens/Source/shotwell/src/util/string.vala"
	result = string_precollated_compare (astr, akey, bstr, bkey) == 0;
#line 307 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 2029 "string.c"
}



