/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef hmac_sha3_224_vectors_h__
#define hmac_sha3_224_vectors_h__

#include "testvectors_base/test-structs.h"

const HmacTestVector kHmacSha3224WycheproofVectors[] = {
    {1, "empty message",
     "7eef1e40253350eb9307cc6bd8ab8df434bc2faf7095e45b50ffdd64", "",
     "f2aa17e549253ac51a9332c5c2390fc0c5003c40bed255df439c3d05", false},

    {2, "short message",
     "8648ee936c6ebc5ae4bb48c1139a54e3ac5d897beec492dc4d740752", "2e",
     "e4bbe7b3a8f173736a1b1e58283040bd20090a772ba1d1fa1f0f02ce", false},

    {3, "short message",
     "2297d78cc45faf9b885b36ac80205cc08e1b730f264f23f4edbbb406", "329f",
     "ec7ef165239a3eea8ea6310c9b98f33aa036175be706fc0186a86ef9", false},

    {4, "short message",
     "0361a904f7cbd107a617614ab69d11208ee6d423b3ae90e2bb6d7e54", "e6e765",
     "fcbcf9840d73b4143fbc2a988b801bea0212049e615dd0e5fd823b0a", false},

    {5, "short message",
     "264a8d2128e8fd0972d9acc66dc275b1286beeb0aff7ce8e97c7b96c", "25838e50",
     "edffc65c657d16730fe63bb6326ab7fd4366596ed6a62c26ae43d3d8", false},

    {6, "short message",
     "6dde8828f09b7aa981082aa116fca3b7341721c0440803f52cc9732e", "be81602da7",
     "6b349764a2d6cc6cc8ecdbbb2526d7cb9acfe2abe7057dae3755ad20", false},

    {7, "short message",
     "3ba156ffdc55d155bd085105aca64d13044db60c82cf2cd9d61d098f", "69c76c8937a0",
     "f0a6bc996be079f62c2c6a73337ce50013a05180a876d3363e07f12a", false},

    {8, "short message",
     "9c2739bae2a863fb0236466ba3408f4eec8d43206d56bb7aa2f8f75e",
     "aaf4c9146db948",
     "a473dd1d6f34fb1cf2586d1bb5a414d232e7dcc7397a1ef1735fb46f", false},

    {9, "short message",
     "31d9cae2c3df064018209b121f9e883976ea757942ecda9d92fdadfd",
     "b844289529206f5a",
     "2e44f4d141c338a4c882be2c8d326dda3ab53dcb02536a2096392726", false},

    {10, "short message",
     "89a1b9e9004444c1d4e967570c21a05512d3f618ec168fc3e13ea5a2",
     "6b42eb6d84e90c70c2",
     "56a078272a84a7dd98d9fd2551679b308f2ca0b8a31ec90448ffc2e4", false},

    {11, "short message",
     "4398731752fd7af1db86ebccbee0ad65eb5faf00ace6c9aa35441faa",
     "1ae2e7d917c48026570d",
     "37e090b83d12e0663c9ea9037ed32ab67afbfe43783669e6f57544e4", false},

    {12, "short message",
     "339460d6bb26ca60ebcef10c38587b9e575c398491782ccf9e8f6803",
     "ca03eb4f37536b2377738e",
     "ab81ecca201e69b7a6c11102943d141157865b6884b67da7593b6953", false},

    {13, "short message",
     "025f8380d10b8207b3623e4a90f79c3e753b1be6a35b88b68330a40c",
     "e57daef9ede4e915c3a9eece",
     "a22d2b3586b2f574eb65798f18a04e763935c88be53963a2e904838a", false},

    {14, "short message",
     "0bdc5f51f8a1a35d75554be70efbcdf51e54f30fa4696f727431941f",
     "cc3dd1eb0690f7af09ad408f9c",
     "96d7cc8bae498a3345b05d399b126162e156920eddca40e6f488f5bc", false},

    {15, "short message",
     "5ada97d90a74a7d4a68c5464fff25a9b7fa2e75d6acf0a59f143a2e9",
     "3fe4ede158af108e09f543e14ab7",
     "c5c07816701eecfa1d61b5c11ed9ed1d11ec495f711ec9752e6787ba", false},

    {16, "short message",
     "007afe6b7c0701c30cb76b431afa3510c8b31d21cfe0bbaa5289cd08",
     "c2cf80005c591c1f737369fcc212f0",
     "fb651bc4f41ab50d88849739529199519e33e948635e246235c81af3", false},

    {17, "", "26491168a32ce8cbc4c0cd64107e4fcc432f07d59c992862e1e55b1e",
     "15e51091b4f424ba1fdecb5e2fba11f6",
     "6ca3ae8f244120dee0b4c1d4db3dbed42564c04206fb47cfded97662", false},

    {18, "", "6978b6c134dd6949832d65e4cb9c1e1dc36beae4a134907c80da0f44",
     "6641d834b3fbfdb5d178007801f7b4e7b1",
     "fffc90de02cf66f6c9dc4272faf6b5cdcb165b3295add1b359f504cd", false},

    {19, "", "9f9fb280adf12e739548b1d676cb794d685b9104e63b619b055cb60f",
     "91513dd6de40a1c23f8d1eb0ab8f5ea6f6835506ec750894",
     "c49f485f16bbc63695ee3e5221d8b3dfda5b85aa461dbe925e44d18d", false},

    {20, "", "3b1b16e6dd2e69559dbeb964e10fc94c068471b2374d3a2d24d2d466",
     "8ecd55b56c668dcb8e8b1efd699c0e4a464204d29af140f87d3f5075495378a3",
     "9d849dee727eed22ae379f5bbd3f77a0f35d88f8f39a753013bdd4d0", false},

    {21, "long message",
     "fc296398845063e661bdf36ff3615926eaccbf06947cd31e6677f710",
     "62bd0ad75d64c554cb2cc109c6e4019fc601c61cabdf99f8de871edc17a301b4c1f55a15e"
     "d66f91eb4666dd08bc59c",
     "74dd2a6644c4ee035ae39ad8ff88c93003eeadb7ddc3042e69975816", false},

    {22, "long message",
     "6c98d1feafff9861351966bc6ed19ed467f9dc767fa0df6b56955554",
     "e99d51a1d9a25c5842501a5383133578c8debe501581b1610f7575519bbd26f01ab7cbe06"
     "9bfd5df3699a2fea5b461a3",
     "66f22e75e9cb458aab043c45ac3914e51d4cb6bc4c9c9bc376b566d9", false},

    {23, "long message",
     "42a164f94e33d574118e0f8c938bbc2874bab219ee7a179f21e13b02",
     "e895639631f8b5d48e3ce00eb310bf129976ffced96a6f30a09d6ac1c291f73e93690526d"
     "86cc4d1a8e21c11f5a8979308",
     "bf5f90d12aa12812778beea4cebe1972c715a04d90aa651f95fe58d2", false},

    {24, "long message",
     "c1b5b91210667e72aa510346e1811358815a3330c5ed27a695c39451",
     "bf1086c3ea8b8840418c690c92152c73a6730bd1a0210c8b1d25c43a2193e739684f04a25"
     "a52cc305599f22ba6f70c8ed00d10b914a9522a25e06c471ebca2ff1bb4fa6799b8512202"
     "0978dfa66ef12ed26ad38331b26eaf591afceac96d8c771eae50fb7f46242337dd0029f48"
     "13b53",
     "37d74bbc46661f0e2819bf745b136ab9a2ac5833b0b53ec4e25fc59a", false},

    {25, "long message",
     "4f09d14d40e475b68288c080668ebb1bc8c6be3191f6664d91a23fcd",
     "ae8b6ecc219b368d22fb596e42652d0bffee0b20d69cfd089ce3dc9303ba2f054ccaf5f51"
     "47c7968a028b140f5e3c9274eae2afc61c3bb6298dc598df77dec1cd2dd84212693b082b8"
     "132ad0f0b19f66db69fa7f6bf352b4feac724ce048440d2a42b44d53bb62fe2ab25f7f54b"
     "edf9ce7ddafd8e09330dacc6d52ee9b65f5",
     "8cf86ed44adb37c55b7a9be866b89b8fec1d772050b5424a5fa890d2", false},

    {26, "long message",
     "613f414cd94130bb8a6243e12eccd90836808428b4a7177867934da0",
     "f696b9063b64816a45064f48ca05ffe4d5cc3d0b3beb0dd4057b6ada994969bf039bfbb72"
     "ce197101cc4e4b3959b3702f045afb7fb3113c997606dcaf2aaab31e02ac6ee597dfc0f91"
     "43d0effedc9ae7ea10e7ddb1db860a91afec62c48ed9c0a6c10b4da1de748caf7f7a5e017"
     "99ac57090daf4e3352fe859c5131c205d262d",
     "0c8165ba519c38c931095d5d4cd13c8fb3035252896f26c058167fe0", false},

    {27, "long message",
     "5b88275307aaf691a0cf0c51f50553dda972d14f8afff98e62c2d972",
     "57e4efbde1ce9fee2e29db19dfc6ba3bcb17f33765af7f20133bbd1910d542145c7def187"
     "a304517b8d8954454a90a717f67f9c8cc587965fd9b43f41ecc50b3458d8ce9f66b475f1e"
     "aef4a29ba89a3d58e5011c92acd1536fcd18abec29411b389b64f7f344777ed6deae32127"
     "abaa69a50ba22a11d6e59354f2ff0e3c3e3293cdc335411cf55b180bab59da36903a6fba9"
     "1df34d2aadf7017ff49a4fbd73c9c74469f225dafc0a0c7048c2b824cc0cba8cad8aced11"
     "b8cdac3243cdb5b654f7a15ce2014e92ee287d06904d778512a1b1f5ec0c9b090b9ab439c"
     "44266b6be3d6a98947d26d079e4f7e849f3c6d93de98624e6c5f53ec02dbd368bc24a300",
     "9c62c309977641be25ede8f7cd227df71bbf1514d26c0df5ff3adfe7", false},

    {28, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "42b8f94fe31d2662600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {29, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "14bbda5ae11dc2dfad9608568f019710300a5e0b56672f6199fc62eb", true},

    {30, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "41b8f94fe31d2662600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {31, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "17bbda5ae11dc2dfad9608568f019710300a5e0b56672f6199fc62eb", true},

    {32, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "c3b8f94fe31d2662600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {33, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "95bbda5ae11dc2dfad9608568f019710300a5e0b56672f6199fc62eb", true},

    {34, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b9f94fe31d2662600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {35, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bada5ae11dc2dfad9608568f019710300a5e0b56672f6199fc62eb", true},

    {36, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f9cfe31d2662600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {37, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbdadae11dc2dfad9608568f019710300a5e0b56672f6199fc62eb", true},

    {38, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe21d2662600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {39, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae01dc2dfad9608568f019710300a5e0b56672f6199fc62eb", true},

    {40, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe11d2662600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {41, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae31dc2dfad9608568f019710300a5e0b56672f6199fc62eb", true},

    {42, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d26e2600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {43, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc25fad9608568f019710300a5e0b56672f6199fc62eb", true},

    {44, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662610c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {45, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfac9608568f019710300a5e0b56672f6199fc62eb", true},

    {46, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662e00c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {47, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2df2d9608568f019710300a5e0b56672f6199fc62eb", true},

    {48, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662602c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {49, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfadb608568f019710300a5e0b56672f6199fc62eb", true},

    {50, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c96097aa0d45422de6c5beb14dc05f76ba6da", true},

    {51, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfad9609568f019710300a5e0b56672f6199fc62eb", true},

    {52, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097ba0d45422de6c5beb14dc05f76ba6da", true},

    {53, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfad9608568e019710300a5e0b56672f6199fc62eb", true},

    {54, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c970978a0d45422de6c5beb14dc05f76ba6da", true},

    {55, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfad9608568d019710300a5e0b56672f6199fc62eb", true},

    {56, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c9709faa0d45422de6c5beb14dc05f76ba6da", true},

    {57, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfad9608560f019710300a5e0b56672f6199fc62eb", true},

    {58, "Flipped bit 216 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097aa0d45422de6c5beb14dc05f76ba6db", true},

    {59, "Flipped bit 216 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfad9608568f019710300a5e0b56672f6199fc62ea", true},

    {60, "Flipped bit 217 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097aa0d45422de6c5beb14dc05f76ba6d8", true},

    {61, "Flipped bit 217 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfad9608568f019710300a5e0b56672f6199fc62e9", true},

    {62, "Flipped bit 222 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097aa0d45422de6c5beb14dc05f76ba69a", true},

    {63, "Flipped bit 222 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfad9608568f019710300a5e0b56672f6199fc62ab", true},

    {64, "Flipped bit 223 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097aa0d45422de6c5beb14dc05f76ba65a", true},

    {65, "Flipped bit 223 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc2dfad9608568f019710300a5e0b56672f6199fc626b", true},

    {66, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "42b8f94fe31d2662610c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {67, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "14bbda5ae11dc2dfac9608568f019710300a5e0b56672f6199fc62eb", true},

    {68, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f9cfe31d26e2600c97097aa0d45422de6c5beb14dc05f76ba6da", true},

    {69, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbdadae11dc25fad9608568f019710300a5e0b56672f6199fc62eb", true},

    {70, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d26e2600c97097aa0d4d422de6c5beb14dc05f76ba6da", true},

    {71, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "15bbda5ae11dc25fad9608568f019790300a5e0b56672f6199fc62eb", true},

    {72, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "bc4706b01ce2d99d9ff368f6855f2babdd2193a414eb23fa08945925", true},

    {73, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "ea4425a51ee23d205269f7a970fe68efcff5a1f4a998d09e66039d14", true},

    {74, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "00000000000000000000000000000000000000000000000000000000", true},

    {75, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "00000000000000000000000000000000000000000000000000000000", true},

    {76, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "ffffffffffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {77, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "ffffffffffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {78, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "c33879cf639da6e2e08c1789fa2054d4a25eecdb6b945c8577eb265a", true},

    {79, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "953b5ada619d425f2d1688d60f811790b08ade8bd6e7afe1197ce26b", true},

    {80, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "42b9f84ee21c2763610d96087ba1d55523df6d5aea15dd04f66aa7db", true},

    {81, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f",
     "14badb5be01cc3deac9709578e009611310b5f0a57662e6098fd63ea", true},

    {82, "empty message",
     "26f314170b054daef5349804da18f969c94174baca2beeb009d47a23", "",
     "32f3e12826c2c869660ed7ac65a5", false},

    {83, "short message",
     "17429a622dc18d38715b31f8f2b963108e952a6708f3e52d5b25848a", "da",
     "24cae2ffb844b1074fbecfa21585", false},

    {84, "short message",
     "0acfe12d89acd7d9ca49bae6318f35b2fbbfc84e5d2c9d4954beded7", "03a8",
     "2594d62daaedef9e87080713ead3", false},

    {85, "short message",
     "5a0680f112354bd467865b19ae956b2719e21ecee1a913bdca294339", "a0fb73",
     "5111521c27f8235f154cce85d02c", false},

    {86, "short message",
     "46fa59aa524fe30a0f4e39561b5666854440dbd970bb59925ce0ae1a", "c8b2f557",
     "038521397a49e95f43c741276bd0", false},

    {87, "short message",
     "29efc5ab5d30e535357603f2711b6e0aa6cf4613546c23144436d213", "c8d9f5b373",
     "bcce4dd5a90f1a0431d45e8f1dcf", false},

    {88, "short message",
     "fe60e0322035538f2b1de9de380cde35f291deeb6e027b5d829ecd1e", "185e4cada4f4",
     "a11873691fd9ffcad1f1a3f66511", false},

    {89, "short message",
     "1bf7fcdf3742fa77991528cc1c678b98be9876a8c8c5b809beab7d9c",
     "9c0f34a5654279", "63722a805684c31a37aba7f5d79a", false},

    {90, "short message",
     "32533c16f792ed0acf8e9e60f54aa173937c7194b882ecc3e671009f",
     "f968dc7a19afe339", "348666b68285b51787be5d8d50ca", false},

    {91, "short message",
     "3cf28a476ce7eaecfc3fbf1b0859a042a568740a584c77cb8f9603ac",
     "dbca9e4bdd84b38934", "49a78665d8f77df14ad66047c377", false},

    {92, "short message",
     "a2a8090aef69277f92830ec7404c032f8fdebfbceabb9e590968a77f",
     "6b790a946a83364c79d7", "e7c0183be70df5d06d288827012b", false},

    {93, "short message",
     "6f999929e91672bac35ea70f8ff8b9aeefa5489493c99b0d27797207",
     "b7dabb237aeae2be8b5e19", "920b9e959d3d05bc7065d4f126f1", false},

    {94, "short message",
     "4525b96c263e4d2dab2890aa55f3cc503dc1206d9f1915a6fba5ae61",
     "ef858f496fcb7c3fabbfb52e", "b08764fec1a8a75c3cb81204d932", false},

    {95, "short message",
     "f89401acb0a60d07fd733ed563f2ee241f4ecfea8114587a44dfdb0c",
     "7d3c0918085984df95097afa81", "32b9e37330307f47ef400277c9a0", false},

    {96, "short message",
     "58bce8c0d17fc7131d2fa2262409bb14663a6e68019f88299987893e",
     "1ca50cd6c3f1225eb6c4ec4d6a90", "2adc605564c6da00bb3abebd5066", false},

    {97, "short message",
     "658e510fba4e2208afac98333f9e242bc118f6e79ef0661d619dd32b",
     "32c385b75ae84558ca302881c51639", "382cec4b6a5e80a6d703ef323161", false},

    {98, "", "6a41cc3ca7142ae14e6d979a3f890a331597e592dd74520ce4ea660f",
     "78e3a770a8aaaf039fd4c9b6a1780411", "fc51222de880062beb4fb986ba71", false},

    {99, "", "b8972b93b68302cbaa08d32904eae6375a66f3508ece3c9b22382c7e",
     "3687e6287d73c9e3f679a50e7671247127", "2f9a78f5175f17372920c8e7638f",
     false},

    {100, "", "bc570932abfa11050ad4fc80a6d5afe3271d86aa29dc62738b207d14",
     "d53202acd2ec74d746531bd9ad3016d0980e0166fb427a08",
     "edba9b4466e1145179c53b5eb65c", false},

    {101, "", "c92a0665c12e87026e1b344f971fdb0e474d450cba834aae40e2d21e",
     "4a3a85ac09f5190ab94f73fd91d98f056015263c89ed5da223fc4675cab25cdd",
     "05758de1ec12f00f069eed387c83", false},

    {102, "long message",
     "6fbef67cfbacc98c63252b1ca009a60e8e3479769a2d449fb4639064",
     "006e179eacfa9e1e628bb7823ee9609ae7968b6df90e176f772a79088d37e9b15cab31292"
     "2aaf8fc6583a341002bda",
     "c3756d9a9a1ed56b97d7b95e7e46", false},

    {103, "long message",
     "700b09908174f1072e31ae8ccbda1c4460fcf21fdf146a11482b210d",
     "f772564ecb109e80eefb1d5a7f1c95e203ba4c980233dd8d13de3046079a6b2ca26dc3521"
     "e5e0c807eae7a79877c73e9",
     "1f39ce1fcdfc2f19a8f34594f0b1", false},

    {104, "long message",
     "e18a20246ebe1b5796dbfe35110efc7637d74a355f0a6758d4a00b7d",
     "77720dde530e6eeaa0e9af3311f7e99189d6c4f7d71d0a4207d62c766bee32020c92f5d5d"
     "28d5de4d0d9c94b57ec05f0c3",
     "82dcc13275c2178befa27462bff8", false},

    {105, "long message",
     "3c4585a775bec76c7d8b27b87e70a5863a85e6111f3161b3815f59b4",
     "628c0ff8c432d74f4cfb77ba46b7cef67a48ac053cf0c18be41648736abcc8c6fbe498152"
     "9babd4b27866e34ced16d8b0bec456e14653a1422f5a62556d20b0fe4e03749d5f6e98637"
     "5062dbdd82f6e9e1d4ad547c31530c2a31383c25ff57e879eae99d9b3a0da1f3c1dacb975"
     "067ac",
     "5d763c4c224c4034de56ef2aa1b2", false},

    {106, "long message",
     "acaf94cb1a8ff4677fc586d2bdf981ac3a656b208215e0a7647b420f",
     "314c2c25465de3427279dbc89436505fee6d37d56fbda0e5e2a49449d9dbf003027f2e4ef"
     "5c52f7af93fd80155a66a1cd6b9885b56d828058a0de7d247e19580b2e8dcbdef2ae46840"
     "565fd8b276569c19d7e185116ea11ad67d5fc27f4a6816ba45be5d14f3ba4315c74d1edb2"
     "0f217b116be852b62a7f4e32b3e708ff9f7",
     "8876296366c17d836b269129af65", false},

    {107, "long message",
     "e490348ad78fd2cd5b51f2795b79e5805ce1d9baf1151dbdf995e1b0",
     "f6ff1845842b9e46f79adb1079aff47397391dc269bc0c899ba4087b58a676f5408c3f763"
     "7ffc4772af3e41b5cea51058bc528ea09bb4bd797594c798b0f0ff881695e98c08bbb040c"
     "12c5cbdb228d61cc99e332e963128d06e97ed2eefded2e1b5a035f3bea68273efac03a894"
     "dcf2fcc79a5696218595404b2758deb9a80ee",
     "f6970364f45c8b91d57947649742", false},

    {108, "long message",
     "c8e099dbb60a8f19d8b86856b21c55f3437ae27f77dff9808f12a1b5",
     "edbc109bf28c8ab32b1238eff1cd14308cdd845fa919bfd8a00c991cf9a8d6b05dd8cc7d2"
     "393782949c899de79e771ef7d8567f32287623963048e6c80d91f0778dd63311106e9d091"
     "3c08b7a0b7253fa3ce307ac40ec55a4c445f5455a570fec090e251e8646bada1a486d41c3"
     "794bce5639732f2c6cfd58081c479a68c515f5d47bc5b2f1622a08d38a596a817f3d4efef"
     "8003ae430e6ae93b0a3ae8fa95a2ace3d24d90a9ef861dc04c13e38f6e524b3abdf9cce4f"
     "a490707c80c16e254b7a71af00a12dbf473b50b9fe4097ec00ab27e66b6f3022b0f101ee1"
     "a9f7fa8652e9f095ca240a446067446867f78e8352c4110794c2e3383dfedfb35e74a33e",
     "865b855fbbcb0feb5dbea3507efa", false},

    {109, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "42b8f94fe31d2662600c97097aa0", true},

    {110, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "14bbda5ae11dc2dfad9608568f01", true},

    {111, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "41b8f94fe31d2662600c97097aa0", true},

    {112, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "17bbda5ae11dc2dfad9608568f01", true},

    {113, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "c3b8f94fe31d2662600c97097aa0", true},

    {114, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "95bbda5ae11dc2dfad9608568f01", true},

    {115, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b9f94fe31d2662600c97097aa0", true},

    {116, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bada5ae11dc2dfad9608568f01", true},

    {117, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f9cfe31d2662600c97097aa0", true},

    {118, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbdadae11dc2dfad9608568f01", true},

    {119, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe21d2662600c97097aa0", true},

    {120, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae01dc2dfad9608568f01", true},

    {121, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe11d2662600c97097aa0", true},

    {122, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae31dc2dfad9608568f01", true},

    {123, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d26e2600c97097aa0", true},

    {124, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc25fad9608568f01", true},

    {125, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662610c97097aa0", true},

    {126, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfac9608568f01", true},

    {127, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662e00c97097aa0", true},

    {128, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2df2d9608568f01", true},

    {129, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662602c97097aa0", true},

    {130, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfadb608568f01", true},

    {131, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c96097aa0", true},

    {132, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfad9609568f01", true},

    {133, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097ba0", true},

    {134, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfad9608568e01", true},

    {135, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c970978a0", true},

    {136, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfad9608568d01", true},

    {137, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c9709faa0", true},

    {138, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfad9608560f01", true},

    {139, "Flipped bit 104 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097aa1", true},

    {140, "Flipped bit 104 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfad9608568f00", true},

    {141, "Flipped bit 105 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097aa2", true},

    {142, "Flipped bit 105 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfad9608568f03", true},

    {143, "Flipped bit 110 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097ae0", true},

    {144, "Flipped bit 110 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfad9608568f41", true},

    {145, "Flipped bit 111 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f94fe31d2662600c97097a20", true},

    {146, "Flipped bit 111 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbda5ae11dc2dfad9608568f81", true},

    {147, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "42b8f94fe31d2662610c97097aa0", true},

    {148, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "14bbda5ae11dc2dfac9608568f01", true},

    {149, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "43b8f9cfe31d26e2600c97097aa0", true},

    {150, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "15bbdadae11dc25fad9608568f01", true},

    {151, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "bc4706b01ce2d99d9ff368f6855f", true},

    {152, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "ea4425a51ee23d205269f7a970fe", true},

    {153, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "0000000000000000000000000000", true},

    {154, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "0000000000000000000000000000", true},

    {155, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "ffffffffffffffffffffffffffff", true},

    {156, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "ffffffffffffffffffffffffffff", true},

    {157, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "c33879cf639da6e2e08c1789fa20", true},

    {158, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "953b5ada619d425f2d1688d60f81", true},

    {159, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b", "",
     "42b9f84ee21c2763610d96087ba1", true},

    {160, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b",
     "000102030405060708090a0b0c0d0e0f", "14badb5be01cc3deac9709578e00", true},

    {161, "short key", "77b0de54e893642caeac34bfd1ab", "",
     "ec98a3472919934900eccd3e0ec3ed6b9def6f324b02fd35e1938194", false},

    {162, "short key", "7346c7e4b118b24e51f4512f906a",
     "506d4faf624f92965aa6b5c01e0c80a8",
     "09a4d9759d544b73bfd7a663adf5b13c0499073d861f9e1adea5df83", false},

    {163, "short key", "caa864179f66e826a0ef3b5edbe3",
     "73f64253706ce6b5094c24ee012ece9ac2495283dcd8c7f1114e81e4587d8ea4",
     "36db20b14b79d6294c9817d1aba325644f58526a1cda8f6f493711c3", false},

    {164, "short key", "663a97d6b5493dbfa60c8dd087ed", "",
     "afa2a693fb38a01a7ee809b44624", false},

    {165, "short key", "b08c345a7c7166fdd33ce768c1dc",
     "9964d80ee2338cffe28483aa446a6f76", "73abc31c5da5608373ec9b8248c7", false},

    {166, "short key", "fc9d2883c67534fefbd6ed4a9798",
     "a49820c194a43deef11f3a0f4eaa80425439fca9d9f1d7c8e665d6b130e4e908",
     "9a9703ea2037345f994a3a9d1267", false},

    {167, "long key",
     "cfa639656cd49f8d70f0b1a5a056ab4fc0aeeebc91338d067f36c47b6012dc8d856b8abcc"
     "4e1abffc910aeaee21b4d366e907488ffd0ca55b36a621aee0b2e9f0c",
     "", "75138f920397e8dc25abff1bbb844fb26a05f39f9456cf7157968b2b", false},

    {168, "long key",
     "b36d3d47a4585b401fc64c98eff56243d4da78863063d814e88f370b92576406d447fcf3d"
     "129a1ede57ddc56ea3a0a1f100105a95e83138cdf45ecf2a5992acf90",
     "15c75a64b04d097af2371af380079eb8",
     "0419e735f2ed98f26ef36f15c320a92512a4c3a53383d255464b70da", false},

    {169, "long key",
     "cf78b991382db5e8666ccb2333fb672179b10a75cf9e5a7699ae640005e19772ef6499a3b"
     "c97f12e58e835bb0017bb3b2e64c6ab44a0d619dfa0363484d1c991e2",
     "f661e598f180f25dc6dd76db8a9e0e4c9c272b9665a6b1756560c723b8e08595",
     "ca4610a8d081fc133fe6657700af54ee66fcda80f4bce0d4be110b51", false},

    {170, "long key",
     "3772ff6bb4e5b2811cfd4d6a3d34dc74bca3dbf89a5817b79d8472a1383b8c9afb27b3006"
     "196ce9966829eae6a313c2d724d995f4def17117c09edcfc8c0cbbc93",
     "", "1243fc7ecb0fb41e777d2207a72e", false},

    {171, "long key",
     "2ba910bc0bca90644cb21e96063e2cd85f5dd02fda75d353c9b51eaf45eee94c165ca6592"
     "d6cfdd987bfdc1cba66363d535a14b2f7ead841b17c4d76a5049105f9",
     "7ba461040de9ea3cefd4809124f78b39", "1f30f3b7a7ff3971032def03bf73", false},

    {172, "long key",
     "7fcf3cb1b1c5b537492aede4689284b5881935e3537bb7307198d6518e7a6aabf70b50b44"
     "e4a8dfee35e9f5cbada7447e511a37209390fcd171c62075c6a8bf1eb",
     "83d29c1c4d059ddb0d2aca787e5b701bac3953fb9bc72dc87b1ef92a582e9748",
     "dd10401fac834914f0a9a574c65e", false}};

#endif  // hmac_sha3_224_vectors_h__
