/*
 * Decompiled with CFR 0.152.
 */
package org.anywikidraw.any;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.anywikidraw.any.SummaryToolBar;
import org.anywikidraw.any.TextChaToolBar;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.samples.svg.SVGDrawingPanel;
import org.jhotdraw.samples.svg.gui.DrawingComponent;
import org.jhotdraw.util.ResourceBundleUtil;

public class DrawingPanel
extends JPanel
implements DrawingComponent {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    private EventListenerList listeners;
    private Preferences prefs;
    private JButton cancelButton;
    private SVGDrawingPanel drawingPanel;
    private JButton saveButton;
    private SummaryToolBar summaryToolBar;
    private TextChaToolBar textChaToolBar;
    private ButtonGroup toolButtonGroup;
    private JPanel toolsPanel;

    public DrawingPanel() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        try {
            this.prefs = Preferences.userNodeForPackage(this.getClass());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.initComponents();
        this.textChaToolBar.setVisible(false);
        this.drawingPanel.setEditor(new DefaultDrawingEditor());
    }

    public void setTextChaQuestion(String string) {
        if (string != null && string.length() > 0) {
            this.textChaToolBar.setQuestion(string);
            this.textChaToolBar.setVisible(true);
        } else {
            this.textChaToolBar.setVisible(false);
        }
    }

    public String getTextChaAnswer() {
        return this.textChaToolBar.getAnswer();
    }

    @Override
    public void setDrawing(Drawing drawing) {
        this.drawingPanel.setDrawing(drawing);
    }

    @Override
    public Drawing getDrawing() {
        return this.drawingPanel.getDrawing();
    }

    public DrawingView getView() {
        return this.drawingPanel.getView();
    }

    public DrawingEditor getEditor() {
        return this.drawingPanel.getEditor();
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.drawingPanel = new SVGDrawingPanel();
        this.toolsPanel = new JPanel();
        this.textChaToolBar = new TextChaToolBar();
        this.summaryToolBar = new SummaryToolBar();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(600, 50));
        this.setPreferredSize(new Dimension(600, 63));
        this.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(600, 38));
        this.add((Component)this.drawingPanel, "Center");
        this.toolsPanel.setBackground(new Color(255, 255, 255));
        this.toolsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toolsPanel.setOpaque(true);
        this.toolsPanel.setRequestFocusEnabled(false);
        this.toolsPanel.setLayout(new GridBagLayout());
        this.textChaToolBar.setRollover(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.toolsPanel.add((Component)this.textChaToolBar, gridBagConstraints);
        this.summaryToolBar.setMinimumSize(new Dimension(80, 23));
        this.summaryToolBar.setPreferredSize(new Dimension(80, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.toolsPanel.add((Component)this.summaryToolBar, gridBagConstraints);
        this.saveButton.setFont(new Font("Dialog", 1, 11));
        this.saveButton.setText(this.labels.getString("saveDrawing"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setOpaque(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawingPanel.this.fireActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.toolsPanel.add((Component)this.saveButton, gridBagConstraints);
        this.cancelButton.setFont(new Font("Dialog", 0, 11));
        this.cancelButton.setText(this.labels.getString("cancel"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setOpaque(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawingPanel.this.fireActionPerformed(actionEvent);
            }
        });
        this.toolsPanel.add((Component)this.cancelButton, new GridBagConstraints());
        this.add((Component)this.toolsPanel, "South");
    }

    private void fireActionPerformed(ActionEvent actionEvent) {
        for (ActionListener actionListener : (ActionListener[])this.listeners.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
            this.listeners.add(ActionListener.class, actionListener);
        }
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        if (this.listeners != null) {
            this.listeners.remove(ActionListener.class, actionListener);
            if (this.listeners.getListenerCount() == 0) {
                this.listeners = null;
            }
        }
    }

    @Override
    public String getSummary() {
        return this.summaryToolBar.getSummary();
    }

    public void setSummaryVisible(boolean bl) {
        this.summaryToolBar.setVisible(bl);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.weightx = bl ? 0.0 : 1.0;
        ((GridBagLayout)this.toolsPanel.getLayout()).setConstraints(this.saveButton, gridBagConstraints);
    }

    public boolean isSummaryVisible() {
        return this.summaryToolBar.isVisible();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

