/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.EventObject;
import javax.swing.ImageIcon;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ToolListener;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.PaletteButton;
import org.jhotdraw.util.PaletteIcon;
import org.jhotdraw.util.PaletteListener;

public class ToolButton
extends PaletteButton
implements ToolListener {
    private Tool myTool;
    private PaletteIcon myIcon;

    public ToolButton(PaletteListener paletteListener, String string, String string2, Tool tool) {
        super(paletteListener);
        tool.addToolListener(this);
        this.setEnabled(tool.isUsable());
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        Image[] imageArray = new Image[]{iconkit.loadImageResource(string + "1.gif"), iconkit.loadImageResource(string + "2.gif"), iconkit.loadImageResource(string + "3.gif")};
        MediaTracker mediaTracker = new MediaTracker(this);
        for (int i = 0; i < 3; ++i) {
            mediaTracker.addImage(imageArray[i], i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPaletteIcon(new PaletteIcon(new Dimension(24, 24), imageArray[0], imageArray[1], imageArray[2]));
        this.setTool(tool);
        this.setName(string2);
        if (imageArray[0] != null) {
            this.setIcon(new ImageIcon(imageArray[0]));
        }
        if (imageArray[1] != null) {
            this.setPressedIcon(new ImageIcon(imageArray[1]));
        }
        if (imageArray[2] != null) {
            this.setSelectedIcon(new ImageIcon(imageArray[2]));
        }
        this.setToolTipText(string2);
    }

    public Tool tool() {
        return this.myTool;
    }

    public String name() {
        return this.getName();
    }

    public Object attributeValue() {
        return this.tool();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public void paintSelected(Graphics graphics) {
        if (this.getPaletteIcon().selected() != null) {
            graphics.drawImage(this.getPaletteIcon().selected(), 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        if (this.isSelected()) {
            this.paintSelected(graphics);
        } else {
            super.paint(graphics);
        }
    }

    public void toolUsable(EventObject eventObject) {
        this.setEnabled(true);
    }

    public void toolUnusable(EventObject eventObject) {
        this.setEnabled(false);
        this.setSelected(false);
    }

    public void toolActivated(EventObject eventObject) {
    }

    public void toolDeactivated(EventObject eventObject) {
    }

    public void toolEnabled(EventObject eventObject) {
        this.setEnabled(true);
    }

    public void toolDisabled(EventObject eventObject) {
        this.setEnabled(false);
    }

    protected PaletteIcon getPaletteIcon() {
        return this.myIcon;
    }

    private void setPaletteIcon(PaletteIcon paletteIcon) {
        this.myIcon = paletteIcon;
    }

    private void setTool(Tool tool) {
        this.myTool = tool;
    }
}

