/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import com.wombatinvasion.pmwikidraw.PmWikiDrawURLEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.figures.ArrowTip;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.figures.LineDecoration;
import org.jhotdraw.figures.PolyLineConnector;
import org.jhotdraw.figures.PolyLineHandle;
import org.jhotdraw.figures.PolyLineLocator;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class PolyLineFigure
extends AttributeFigure {
    public static final int ARROW_TIP_NONE = 0;
    public static final int ARROW_TIP_START = 1;
    public static final int ARROW_TIP_END = 2;
    public static final int ARROW_TIP_BOTH = 3;
    protected List fPoints;
    protected LineDecoration fStartDecoration = null;
    protected LineDecoration fEndDecoration = null;
    protected Color fFrameColor = Color.black;
    protected Double fFrameWidth = null;
    private static final long serialVersionUID = -7951352179906577773L;
    private int polyLineFigureSerializedDataVersion = 1;

    public PolyLineFigure() {
        this(4);
    }

    public PolyLineFigure(int n) {
        this.fPoints = CollectionsFactory.current().createList(n);
    }

    public PolyLineFigure(int n, int n2) {
        this.fPoints = CollectionsFactory.current().createList();
        this.fPoints.add(new Point(n, n2));
    }

    public Rectangle displayBox() {
        Iterator iterator = this.points();
        if (iterator.hasNext()) {
            Rectangle rectangle = new Rectangle((Point)iterator.next());
            while (iterator.hasNext()) {
                rectangle.add((Point)iterator.next());
            }
            return rectangle;
        }
        return new Rectangle();
    }

    public boolean isEmpty() {
        return this.size().width < 3 && this.size().height < 3;
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList(this.fPoints.size());
        for (int i = 0; i < this.fPoints.size(); ++i) {
            list.add(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
        }
        return new HandleEnumerator(list);
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public void addPoint(int n, int n2) {
        this.fPoints.add(new Point(n, n2));
        this.changed();
    }

    public Iterator points() {
        return this.fPoints.iterator();
    }

    public int pointCount() {
        return this.fPoints.size();
    }

    protected void basicMoveBy(int n, int n2) {
        Iterator iterator = this.points();
        while (iterator.hasNext()) {
            ((Point)iterator.next()).translate(n, n2);
        }
    }

    public void setPointAt(Point point, int n) {
        this.willChange();
        this.fPoints.set(n, point);
        this.changed();
    }

    public void insertPointAt(Point point, int n) {
        this.fPoints.add(n, point);
        this.changed();
    }

    public void removePointAt(int n) {
        this.willChange();
        this.fPoints.remove(n);
        this.changed();
    }

    public int splitSegment(int n, int n2) {
        int n3 = this.findSegment(n, n2);
        if (n3 != -1) {
            this.insertPointAt(new Point(n, n2), n3 + 1);
        }
        return n3 + 1;
    }

    public Point pointAt(int n) {
        return (Point)this.fPoints.get(n);
    }

    public boolean joinSegments(int n, int n2) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            Point point = this.pointAt(i);
            if (Geom.length(n, n2, point.x, point.y) >= 3L) continue;
            this.removePointAt(i);
            return true;
        }
        return false;
    }

    public Connector connectorAt(int n, int n2) {
        return new PolyLineConnector(this);
    }

    public void setStartDecoration(LineDecoration lineDecoration) {
        this.fStartDecoration = lineDecoration;
    }

    public LineDecoration getStartDecoration() {
        return this.fStartDecoration;
    }

    public void setEndDecoration(LineDecoration lineDecoration) {
        this.fEndDecoration = lineDecoration;
    }

    public LineDecoration getEndDecoration() {
        return this.fEndDecoration;
    }

    protected void drawFrame(Graphics graphics) {
        graphics.setColor(this.getFrameColor());
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point point = this.pointAt(i);
            Point point2 = this.pointAt(i + 1);
            this.drawLine(graphics, point.x, point.y, point2.x, point2.y);
        }
        this.decorate(graphics);
    }

    protected void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
    }

    public boolean containsPoint(int n, int n2) {
        Rectangle rectangle = this.displayBox();
        rectangle.grow(4, 4);
        if (!rectangle.contains(n, n2)) {
            return false;
        }
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point point = this.pointAt(i);
            Point point2 = this.pointAt(i + 1);
            if (!Geom.lineContainsPoint(point.x, point.y, point2.x, point2.y, n, n2)) continue;
            return true;
        }
        return false;
    }

    public int findSegment(int n, int n2) {
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point point = this.pointAt(i);
            Point point2 = this.pointAt(i + 1);
            if (!Geom.lineContainsPoint(point.x, point.y, point2.x, point2.y, n, n2)) continue;
            return i;
        }
        return -1;
    }

    private void decorate(Graphics graphics) {
        Point point;
        Point point2;
        if (this.getStartDecoration() != null) {
            point2 = this.pointAt(0);
            point = this.pointAt(1);
            this.getStartDecoration().draw(graphics, point2.x, point2.y, point.x, point.y);
        }
        if (this.getEndDecoration() != null) {
            point2 = this.pointAt(this.fPoints.size() - 2);
            point = this.pointAt(this.fPoints.size() - 1);
            this.getEndDecoration().draw(graphics, point.x, point.y, point2.x, point2.y);
        }
    }

    public Object getAttribute(String string) {
        return this.getAttribute(FigureAttributeConstant.getConstant(string));
    }

    public Object getAttribute(FigureAttributeConstant figureAttributeConstant) {
        if (figureAttributeConstant.equals(FigureAttributeConstant.ARROW_MODE)) {
            int n = 0;
            if (this.getStartDecoration() != null) {
                n |= 1;
            }
            if (this.getEndDecoration() != null) {
                n |= 2;
            }
            return new Integer(n);
        }
        return super.getAttribute(figureAttributeConstant);
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(FigureAttributeConstant.getConstant(string), object);
    }

    public void setAttribute(FigureAttributeConstant figureAttributeConstant, Object object) {
        if (figureAttributeConstant.equals(FigureAttributeConstant.ARROW_MODE)) {
            Integer n = (Integer)object;
            if (n != null) {
                int n2 = n;
                if ((n2 & 1) != 0) {
                    this.setStartDecoration(new ArrowTip());
                } else {
                    this.setStartDecoration(null);
                }
                if ((n2 & 2) != 0) {
                    this.setEndDecoration(new ArrowTip());
                } else {
                    this.setEndDecoration(null);
                }
            }
            this.changed();
        } else {
            super.setAttribute(figureAttributeConstant, object);
        }
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fPoints.size());
        Iterator iterator = this.points();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            storableOutput.writeInt(point.x);
            storableOutput.writeInt(point.y);
        }
        storableOutput.writeStorable(this.fStartDecoration);
        storableOutput.writeStorable(this.fEndDecoration);
        storableOutput.writeColor(this.fFrameColor);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int n = storableInput.readInt();
        this.fPoints = CollectionsFactory.current().createList(n);
        for (int i = 0; i < n; ++i) {
            int n2 = storableInput.readInt();
            int n3 = storableInput.readInt();
            this.fPoints.add(new Point(n2, n3));
        }
        this.setStartDecoration((LineDecoration)storableInput.readStorable());
        this.setEndDecoration((LineDecoration)storableInput.readStorable());
        this.fFrameColor = storableInput.readColor();
    }

    public static Locator locator(int n) {
        return new PolyLineLocator(n);
    }

    protected Rectangle invalidateRectangle(Rectangle rectangle) {
        Rectangle rectangle2 = super.invalidateRectangle(rectangle);
        if (this.getStartDecoration() != null) {
            rectangle2.add(this.getStartDecoration().displayBox());
        }
        if (this.getEndDecoration() != null) {
            rectangle2.add(this.getEndDecoration().displayBox());
        }
        return rectangle2;
    }

    public String getMap() {
        String string = (String)this.getAttribute(FigureAttributeConstant.URL);
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            string = PmWikiDrawURLEncoder.decode(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = true;
        String string2 = "";
        String string3 = "";
        for (int i = 1; i < this.fPoints.size(); ++i) {
            Point point = (Point)this.fPoints.get(i - 1);
            Point point2 = (Point)this.fPoints.get(i);
            double d = Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y));
            int n = (int)((double)(4 * (point2.y - point.y)) / d);
            int n2 = (int)((double)(4 * (point2.x - point.x)) / d);
            if (!bl) {
                string2 = string2 + ",";
                string3 = "," + string3;
            }
            bl = false;
            string2 = string2 + (point.x + n) + "," + (point.y + n2) + "," + (point2.x + n) + "," + (point2.y + n2);
            string3 = point2.x - n + "," + (point2.y - n2) + "," + (point.x - n) + "," + (point.y - n2) + string3;
        }
        return "<area shape=\"poly\" coords=\"" + string2 + "," + string3 + "\" href=\"" + string + "\" alt=\"" + string + "\" />";
    }
}

