/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_FORMS_SOURCE_INC_FRM_STRINGS_HXX
#define INCLUDED_FORMS_SOURCE_INC_FRM_STRINGS_HXX

#include <sal/types.h>
#include <rtl/ustring.hxx>
#include <comphelper/string.hxx>

//..............................................................................
namespace frm
{
//..............................................................................

    //--------------------------------------------------------------------------
    //- properties
    //--------------------------------------------------------------------------
    #define PROPERTY_TABINDEX                 "TabIndex"
    #define PROPERTY_TAG                      "Tag"
    #define PROPERTY_NAME                     "Name"
    #define PROPERTY_GROUP_NAME               "GroupName"
    #define PROPERTY_CLASSID                  "ClassId"
    #define PROPERTY_FETCHSIZE                "FetchSize"
    #define PROPERTY_VALUE                    "Value"
    #define PROPERTY_TEXT                     "Text"
    #define PROPERTY_LABEL                    "Label"
    #define PROPERTY_CANINSERT                "CanInsert"
    #define PROPERTY_CANUPDATE                "CanUpdate"
    #define PROPERTY_CANDELETE                "CanDelete"
    #define PROPERTY_NAVIGATION               "NavigationBarMode"
    #define PROPERTY_HASNAVIGATION            "HasNavigationBar"
    #define PROPERTY_CYCLE                    "Cycle"
    #define PROPERTY_CONTROLSOURCE            "DataField"
    #define PROPERTY_ENABLED                  "Enabled"
    #define PROPERTY_ENABLEVISIBLE                  "EnableVisible"
    #define PROPERTY_READONLY                 "ReadOnly"
    #define PROPERTY_RELEVANT                 "Relevant"
    #define PROPERTY_ISREADONLY               "IsReadOnly"
    #define PROPERTY_FILTER                   "Filter"
    #define PROPERTY_WIDTH                    "Width"
    #define PROPERTY_SEARCHABLE               "IsSearchable"
    #define PROPERTY_MULTILINE                "MultiLine"
    #define PROPERTY_TARGET_URL               "TargetURL"
    #define PROPERTY_TARGET_FRAME             "TargetFrame"
    #define PROPERTY_DEFAULTCONTROL           "DefaultControl"
    #define PROPERTY_MAXTEXTLEN               "MaxTextLen"
    #define PROPERTY_EDITMASK                 "EditMask"
    #define PROPERTY_SIZE                     "Size"
    #define PROPERTY_SPIN                     "Spin"
    #define PROPERTY_DATE                     "Date"
    #define PROPERTY_TIME                     "Time"
    #define PROPERTY_STATE                    "State"
    #define PROPERTY_TRISTATE                 "TriState"
    #define PROPERTY_HIDDEN_VALUE             "HiddenValue"
    #define PROPERTY_BUTTONTYPE               "ButtonType"
    #define PROPERTY_STRINGITEMLIST           "StringItemList"
    #define PROPERTY_DEFAULT_TEXT             "DefaultText"
    #define PROPERTY_DEFAULT_STATE             "DefaultState"
    #define PROPERTY_FORMATKEY                "FormatKey"
    #define PROPERTY_FORMATSSUPPLIER          "FormatsSupplier"
    #define PROPERTY_SUBMIT_ACTION            "SubmitAction"
    #define PROPERTY_SUBMIT_TARGET            "SubmitTarget"
    #define PROPERTY_SUBMIT_METHOD            "SubmitMethod"
    #define PROPERTY_SUBMIT_ENCODING          "SubmitEncoding"
    #define PROPERTY_IMAGE_URL                "ImageURL"
    #define PROPERTY_GRAPHIC                  "Graphic"
    #define PROPERTY_IMAGE_POSITION           "ImagePosition"
    #define PROPERTY_EMPTY_IS_NULL            "ConvertEmptyToNull"
    #define PROPERTY_LISTSOURCETYPE           "ListSourceType"
    #define PROPERTY_LISTSOURCE               "ListSource"
    #define PROPERTY_SELECT_SEQ               "SelectedItems"
    #define PROPERTY_VALUE_SEQ                "ValueItemList"
    #define PROPERTY_SELECT_VALUE_SEQ         "SelectedValues"
    #define PROPERTY_SELECT_VALUE             "SelectedValue"
    #define PROPERTY_DEFAULT_SELECT_SEQ       "DefaultSelection"
    #define PROPERTY_MULTISELECTION           "MultiSelection"
    #define PROPERTY_ALIGN                    "Align"
    #define PROPERTY_VERTICAL_ALIGN           "VerticalAlign"
    #define PROPERTY_DEFAULT_DATE             "DefaultDate"
    #define PROPERTY_DEFAULT_TIME             "DefaultTime"
    #define PROPERTY_DEFAULT_VALUE            "DefaultValue"
    #define PROPERTY_DECIMAL_ACCURACY         "DecimalAccuracy"
    #define PROPERTY_CURSORSOURCE             "DataSelection"
    #define PROPERTY_CURSORSOURCETYPE         "DataSelectionType"
    #define PROPERTY_FIELDTYPE                "Type"
    #define PROPERTY_DECIMALS                 "Decimals"
    #define PROPERTY_REFVALUE                 "RefValue"
    #define PROPERTY_UNCHECKED_REFVALUE       "SecondaryRefValue"
    #define PROPERTY_VALUEMIN                 "ValueMin"
    #define PROPERTY_VALUEMAX                 "ValueMax"
    #define PROPERTY_STRICTFORMAT             "StrictFormat"
    #define PROPERTY_ALLOWADDITIONS           "AllowInserts"
    #define PROPERTY_ALLOWEDITS               "AllowUpdates"
    #define PROPERTY_ALLOWDELETIONS           "AllowDeletes"
    #define PROPERTY_MASTERFIELDS             "MasterFields"
    #define PROPERTY_ISPASSTHROUGH            "IsPassThrough"
    #define PROPERTY_QUERY                    "Query"
    #define PROPERTY_LITERALMASK              "LiteralMask"
    #define PROPERTY_VALUESTEP                "ValueStep"
    #define PROPERTY_SHOWTHOUSANDSEP          "ShowThousandsSeparator"
    #define PROPERTY_CURRENCYSYMBOL           "CurrencySymbol"
    #define PROPERTY_DATEFORMAT               "DateFormat"
    #define PROPERTY_DATEMIN                  "DateMin"
    #define PROPERTY_DATEMAX                  "DateMax"
    #define PROPERTY_DATE_SHOW_CENTURY        "DateShowCentury"
    #define PROPERTY_TIMEFORMAT               "TimeFormat"
    #define PROPERTY_TIMEMIN                  "TimeMin"
    #define PROPERTY_TIMEMAX                  "TimeMax"
    #define PROPERTY_LINECOUNT                "LineCount"
    #define PROPERTY_BOUNDCOLUMN              "BoundColumn"
    #define PROPERTY_FONT                     "FontDescriptor"
    #define PROPERTY_FILLCOLOR                "FillColor"
    #define PROPERTY_LINECOLOR                "LineColor"
    #define PROPERTY_DROPDOWN                 "Dropdown"
    #define PROPERTY_HSCROLL                  "HScroll"
    #define PROPERTY_VSCROLL                  "VScroll"
    #define PROPERTY_TABSTOP                  "Tabstop"
    #define PROPERTY_AUTOCOMPLETE             "Autocomplete"
    #define PROPERTY_HARDLINEBREAKS           "HardLineBreaks"
    #define PROPERTY_PRINTABLE                "Printable"
    #define PROPERTY_ECHO_CHAR                "EchoChar"
    #define PROPERTY_ROWHEIGHT                "RowHeight"
    #define PROPERTY_HELPTEXT                 "HelpText"
    #define PROPERTY_FONT_NAME                "FontName"
    #define PROPERTY_FONT_STYLENAME           "FontStyleName"
    #define PROPERTY_FONT_FAMILY              "FontFamily"
    #define PROPERTY_FONT_CHARSET             "FontCharset"
    #define PROPERTY_FONT_HEIGHT              "FontHeight"
    #define PROPERTY_FONT_WEIGHT              "FontWeight"
    #define PROPERTY_FONT_SLANT               "FontSlant"
    #define PROPERTY_FONT_UNDERLINE           "FontUnderline"
    #define PROPERTY_FONT_WORDLINEMODE        "FontWordLineMode"
    #define PROPERTY_FONT_STRIKEOUT           "FontStrikeout"
    #define PROPERTY_FONTEMPHASISMARK         "FontEmphasisMark"
    #define PROPERTY_FONTRELIEF               "FontRelief"
    #define PROPERTY_FONT_CHARWIDTH           "FontCharWidth"
    #define PROPERTY_FONT_KERNING             "FontKerning"
    #define PROPERTY_FONT_ORIENTATION         "FontOrientation"
    #define PROPERTY_FONT_PITCH               "FontPitch"
    #define PROPERTY_FONT_TYPE                "FontType"
    #define PROPERTY_FONT_WIDTH               "FontWidth"
    #define PROPERTY_HELPURL                  "HelpURL"
    #define PROPERTY_RECORDMARKER             "HasRecordMarker"
    #define PROPERTY_BOUNDFIELD               "BoundField"
    #define PROPERTY_INPUT_REQUIRED           "InputRequired"
    #define PROPERTY_TREATASNUMERIC           "TreatAsNumber"
    #define PROPERTY_EFFECTIVE_VALUE          "EffectiveValue"
    #define PROPERTY_EFFECTIVE_DEFAULT        "EffectiveDefault"
    #define PROPERTY_EFFECTIVE_MIN            "EffectiveMin"
    #define PROPERTY_EFFECTIVE_MAX            "EffectiveMax"
    #define PROPERTY_HIDDEN                   "Hidden"
    #define PROPERTY_FILTERPROPOSAL           "UseFilterValueProposal"
    #define PROPERTY_FIELDSOURCE              "FieldSource"
    #define PROPERTY_TABLENAME                "TableName"
    #define PROPERTY_ISFILTERAPPLIED          "IsFilterApplied"
    #define PROPERTY_CONTROLLABEL             "LabelControl"
    #define PROPERTY_CURRSYM_POSITION         "PrependCurrencySymbol"
    #define PROPERTY_CURSORCOLOR              "CursorColor"
    #define PROPERTY_ALWAYSSHOWCURSOR         "AlwaysShowCursor"
    #define PROPERTY_DISPLAYSYNCHRON          "DisplayIsSynchron"
    #define PROPERTY_TEXTCOLOR                "TextColor"
    #define PROPERTY_DELAY                    "RepeatDelay"
    #define PROPERTY_DEFAULT_SCROLL_VALUE     "DefaultScrollValue"
    #define PROPERTY_SCROLL_VALUE             "ScrollValue"
    #define PROPERTY_DEFAULT_SPIN_VALUE       "DefaultSpinValue"
    #define PROPERTY_SPIN_VALUE               "SpinValue"
    #define PROPERTY_REFERENCE_DEVICE         "ReferenceDevice"
    #define PROPERTY_ISMODIFIED               "IsModified"
    #define PROPERTY_ISNEW                    "IsNew"
    #define PROPERTY_PRIVILEGES               "Privileges"
    #define PROPERTY_COMMAND                  "Command"
    #define PROPERTY_COMMANDTYPE              "CommandType"
    #define PROPERTY_RESULTSET_CONCURRENCY    "ResultSetConcurrency"
    #define PROPERTY_INSERTONLY               "IgnoreResult"
    #define PROPERTY_RESULTSET_TYPE           "ResultSetType"
    #define PROPERTY_ESCAPE_PROCESSING        "EscapeProcessing"
    #define PROPERTY_APPLYFILTER              "ApplyFilter"
    #define PROPERTY_ROWCOUNT                 "RowCount"
    #define PROPERTY_ROWCOUNTFINAL            "IsRowCountFinal"

    #define PROPERTY_ISNULLABLE               "IsNullable"
    #define PROPERTY_ACTIVECOMMAND            "ActiveCommand"
    #define PROPERTY_ISCURRENCY               "IsCurrency"
    #define PROPERTY_URL                      "URL"
    #define PROPERTY_TITLE                    "Title"
    #define PROPERTY_ACTIVE_CONNECTION        "ActiveConnection"
    #define PROPERTY_SCALE                    "Scale"
    #define PROPERTY_SORT                     "Order"
    #define PROPERTY_DATASOURCE               "DataSourceName"
    #define PROPERTY_DETAILFIELDS             "DetailFields"

    #define PROPERTY_COLUMNSERVICENAME        "ColumnServiceName"
    #define PROPERTY_REALNAME                 "RealName"
    #define PROPERTY_CONTROLSOURCEPROPERTY    "DataFieldProperty"
    #define PROPERTY_USER                     "User"
    #define PROPERTY_PASSWORD                 "Password"
    #define PROPERTY_DISPATCHURLINTERNAL      "DispatchURLInternal"
    #define PROPERTY_PERSISTENCE_MAXTEXTLENGTH "PersistenceMaxTextLength"
    #define PROPERTY_RICH_TEXT                "RichText"
    #define PROPERTY_ENFORCE_FORMAT           "EnforceFormat"
    #define PROPERTY_LINEEND_FORMAT           "LineEndFormat"
    #define PROPERTY_WRITING_MODE             "WritingMode"
    #define PROPERTY_CONTEXT_WRITING_MODE     "ContextWritingMode"

    #define PROPERTY_NATIVE_LOOK              "NativeWidgetLook"
    #define PROPERTY_BORDER                   "Border"
    #define PROPERTY_BORDERCOLOR              "BorderColor"
    #define PROPERTY_BACKGROUNDCOLOR          "BackgroundColor"
    #define PROPERTY_ICONSIZE                 "IconSize"
    #define PROPERTY_TEXTLINECOLOR            "TextLineColor"
    #define PROPERTY_HIDEINACTIVESELECTION    "HideInactiveSelection"

    #define PROPERTY_SHOW_POSITION            "ShowPosition"
    #define PROPERTY_SHOW_NAVIGATION          "ShowNavigation"
    #define PROPERTY_SHOW_RECORDACTIONS       "ShowRecordActions"
    #define PROPERTY_SHOW_FILTERSORT          "ShowFilterSort"

    #define PROPERTY_XSD_WHITESPACE           "WhiteSpace"
    #define PROPERTY_XSD_PATTERN              "Pattern"
    #define PROPERTY_XSD_LENGTH               "Length"
    #define PROPERTY_XSD_MIN_LENGTH           "MinLength"
    #define PROPERTY_XSD_MAX_LENGTH           "MaxLength"
    #define PROPERTY_XSD_TOTAL_DIGITS         "TotalDigits"
    #define PROPERTY_XSD_FRACTION_DIGITS      "FractionDigits"
    #define PROPERTY_XSD_MAX_INCLUSIVE_INT    "MaxInclusiveInt"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_INT    "MaxExclusiveInt"
    #define PROPERTY_XSD_MIN_INCLUSIVE_INT    "MinInclusiveInt"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_INT    "MinExclusiveInt"
    #define PROPERTY_XSD_MAX_INCLUSIVE_DOUBLE "MaxInclusiveDouble"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_DOUBLE "MaxExclusiveDouble"
    #define PROPERTY_XSD_MIN_INCLUSIVE_DOUBLE "MinInclusiveDouble"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_DOUBLE "MinExclusiveDouble"
    #define PROPERTY_XSD_MAX_INCLUSIVE_DATE   "MaxInclusiveDate"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_DATE   "MaxExclusiveDate"
    #define PROPERTY_XSD_MIN_INCLUSIVE_DATE   "MinInclusiveDate"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_DATE   "MinExclusiveDate"
    #define PROPERTY_XSD_MAX_INCLUSIVE_TIME   "MaxInclusiveTime"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_TIME   "MaxExclusiveTime"
    #define PROPERTY_XSD_MIN_INCLUSIVE_TIME   "MinInclusiveTime"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_TIME   "MinExclusiveTime"
    #define PROPERTY_XSD_MAX_INCLUSIVE_DATE_TIME "MaxInclusiveDateTime"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_DATE_TIME "MaxExclusiveDateTime"
    #define PROPERTY_XSD_MIN_INCLUSIVE_DATE_TIME "MinInclusiveDateTime"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_DATE_TIME "MinExclusiveDateTime"
    #define PROPERTY_XSD_IS_BASIC             "IsBasic"
    #define PROPERTY_XSD_TYPE_CLASS           "TypeClass"

    #define PROPERTY_DYNAMIC_CONTROL_BORDER      "DynamicControlBorder"
    #define PROPERTY_CONTROL_BORDER_COLOR_FOCUS  "ControlBorderColorOnFocus"
    #define PROPERTY_CONTROL_BORDER_COLOR_MOUSE  "ControlBorderColorOnHover"
    #define PROPERTY_CONTROL_BORDER_COLOR_INVALID "ControlBorderColorOnInvalid"
    #define PROPERTY_GENERATEVBAEVENTS  "GenerateVbaEvents"
    #define PROPERTY_CONTROL_TYPE_IN_MSO          "ControlTypeinMSO"
    #define PROPERTY_OBJ_ID_IN_MSO                "ObjIDinMSO"

    //--------------------------------------------------------------------------
    //- URLs
    //--------------------------------------------------------------------------
    #define URL_FORM_POSITION     ".uno:FormController/positionForm"
    #define URL_FORM_RECORDCOUNT  ".uno:FormController/RecordCount"
    #define URL_RECORD_FIRST      ".uno:FormController/moveToFirst"
    #define URL_RECORD_PREV       ".uno:FormController/moveToPrev"
    #define URL_RECORD_NEXT       ".uno:FormController/moveToNext"
    #define URL_RECORD_LAST       ".uno:FormController/moveToLast"
    #define URL_RECORD_SAVE       ".uno:FormController/saveRecord"
    #define URL_RECORD_UNDO       ".uno:FormController/undoRecord"
    #define URL_RECORD_NEW        ".uno:FormController/moveToNew"
    #define URL_RECORD_DELETE     ".uno:FormController/deleteRecord"
    #define URL_FORM_REFRESH      ".uno:FormController/refreshForm"
    #define URL_FORM_REFRESH_CURRENT_CONTROL ".uno:FormController/refreshCurrentControl"

    #define URL_FORM_SORT_UP      ".uno:FormController/sortUp"
    #define URL_FORM_SORT_DOWN    ".uno:FormController/sortDown"
    #define URL_FORM_SORT         ".uno:FormController/sort"
    #define URL_FORM_AUTO_FILTER  ".uno:FormController/autoFilter"
    #define URL_FORM_FILTER       ".uno:FormController/filter"
    #define URL_FORM_APPLY_FILTER ".uno:FormController/applyFilter"
    #define URL_FORM_REMOVE_FILTER ".uno:FormController/removeFilterOrder"

//..............................................................................
}   // namespace frm
//..............................................................................


#endif // INCLUDED_FORMS_SOURCE_INC_FRM_STRINGS_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
