#include "mb_rr.h"

namespace ADNS {

	MB_RR::MB_RR()
	{
		rr_type = RR_TYPE::MB;
		madname = gcnew DOMAIN_NAME();
		rr_class = RR_CLASS::IN;
		UpdateRdata();
	}

	Void MB_RR::SetMadname(DOMAIN_NAME^ newname)
	{
		madname = gcnew DOMAIN_NAME(newname->GetName());
		UpdateRdata();
		return;
	}

	DOMAIN_NAME^ MB_RR::GetMadname()
	{
		return madname->Clone();
	}

	String^ MB_RR::Print()
	{
		return madname->Print();
	}

	Void MB_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(madname->GetName()->Length);
		else
			rdata->Resize(rdata,madname->GetName()->Length);

		madname->GetName()->CopyTo(rdata,0);

		return;
	}

	Void MB_RR::ToCanonical()
	{
		madname->MakeCanonical();
		owner->MakeCanonical();
		UpdateRdata();
		return;
	}

	MB_RR^ MB_RR::Clone()
	{
		MB_RR^ newrr = gcnew MB_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->madname = madname->Clone();
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ MB_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		MB_RR^ mbout;
		array<Byte>^ tmparray;
		int reallen;

		mbout = gcnew MB_RR();
		mbout->owner = gcnew DOMAIN_NAME(domainname);
		mbout->rr_class = (RR_CLASS) rr_class;
		mbout->ttl = ttl;
		tmparray = ReadDomainFromPacket(packet, rdata_start, reallen);
		mbout->SetMadname(gcnew DOMAIN_NAME(tmparray));
		return mbout;
	}

	String^ MB_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<MB_RR^>(rec)->Print();
	}

	ResourceRecord^ MB_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<MB_RR^>(rec)->Clone();
	}

}