//  Copyright (c) 2006 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Test data for RF, each row contains in order:
//
// x, y, z, RF(x, y, z)
//
   static const boost::array<boost::array<typename table_type<T>::type, 4>, 401> ellint_rf_data = {{
      {{ SC_(0.60682196926171104626767727515008970841312337712241e-30), SC_(0.20031258624e11), SC_(0.10313978271484375e4), SC_(0.69081557947567857896297308369623231790841946303168e-4) }}, 
      {{ SC_(0.13810928266794127506964991575307193802925529863273e-29), SC_(0.2529551275074481964111328125e-3), SC_(0.7030536597341097149183042347431182861328125e-8), SC_(0.41696748464385961137940994051143282877208328256968e3) }}, 
      {{ SC_(0.14532352659780781796355564562931230420316401288775e-29), SC_(0.62687453931329231730011467674071804187172354186889e-30), SC_(0.26256847716031594952568184453411959111690521240234e-12), SC_(0.40492940437281068910143789937423107620726714449588e8) }}, 
      {{ SC_(0.21161119528926488937912315394561157356168786172334e-29), SC_(0.142681614079265273176133632659912109375e-6), SC_(0.1414351724088191986083984375e-1), SC_(0.60023495609336663619731475310462707680628111629781e2) }}, 
      {{ SC_(0.43727979838159528482554219689363356095561935561375e-29), SC_(0.7798122348544e13), SC_(0.8588943201947652980736e22), SC_(0.12728379993876013222161727164717897397898227135914e-9) }}, 
      {{ SC_(0.44767214645416419053919245787147718165594030426536e-29), SC_(0.26553176031232e14), SC_(0.2085586588137791946752e23), SC_(0.80511870764678968189176930995818394321307940480734e-10) }}, 
      {{ SC_(0.60078474312334545656635060929362382794743178141472e-29), SC_(0.37131016039637643189053051173686981201171875e-8), SC_(0.32517390764125836699536241120728208287005145393778e-20), SC_(0.25056280362165428100075135368904610528487634651412e6) }}, 
      {{ SC_(0.61834249098451553748337548320711315606925672313013e-29), SC_(0.15125532639232e16), SC_(0.11666782739894188125617802143096923828125e-6), SC_(0.69024104942927043057057398977626412595781610122053e-6) }}, 
      {{ SC_(0.80490202086679616440767211156605911864354431197377e-29), SC_(0.263248904192e12), SC_(0.297980882347216843954978816e27), SC_(0.10843189731083616299141336159195842305986739069878e-11) }}, 
      {{ SC_(0.15386248307178551019952166983379913769903023636025e-28), SC_(0.11083928e9), SC_(0.210290006361901760101318359375e-2), SC_(0.13041677890491263355196952840107362001464424225232e-2) }}, 
      {{ SC_(0.21260283480045472585820552908849842179312334994757e-28), SC_(0.117237625e7), SC_(0.28658838e8), SC_(0.56137169413466917815737398640168522533687819147944e-3) }}, 
      {{ SC_(0.23067565607429071342632211210292164463707216326199e-28), SC_(0.44169701635837554931640625e-1), SC_(0.14622103125e6), SC_(0.23255376087386493123620791606540418922162034060246e-1) }}, 
      {{ SC_(0.27790564235134654243337661318427908127768828411199e-28), SC_(0.21656921296023725949679903214975529301966616912978e-20), SC_(0.16200692698475904762744903564453125e-4), SC_(0.48848907341566731317828094161181483220489237197822e4) }}, 
      {{ SC_(0.3576658041416457175462348437019377323527317041928e-28), SC_(0.182191292416e12), SC_(0.355224928e9), SC_(0.1056145023109440334189908118197725710820599937924e-4) }}, 
      {{ SC_(0.45190074381881787947113833644192369803258850957835e-28), SC_(0.903221837196690095865856e24), SC_(0.197033285648384e15), SC_(0.1316234260403974959059386181123491622884455028604e-10) }}, 
      {{ SC_(0.75787209056271355952485380019348769132814133643247e-28), SC_(0.3443290234375e5), SC_(0.87738095954812459262649215691458087947041111220869e-24), SC_(0.18482788150207164039886687903794355893352157342876e0) }}, 
      {{ SC_(0.83892250504513065845701871993405683214864787598623e-28), SC_(0.1116302655645995400846004486083984375e-5), SC_(0.5191992844812585795584e22), SC_(0.46130757625625887687399713890619646292026008752597e-9) }}, 
      {{ SC_(0.10848934303015863927446282468623299997624646840919e-27), SC_(0.62221619626030569058053553009209074892000950850727e-30), SC_(0.343400804652490021666816e24), SC_(0.10342135228893151111628599880598474090206795712037e-9) }}, 
      {{ SC_(0.1287535325337014953720268054032123824574619620157e-27), SC_(0.13705567485615801022446745431989965211687137938007e-26), SC_(0.5078582763671875e0), SC_(0.44492840412794216795211644099170510281671666177003e2) }}, 
      {{ SC_(0.20347543751535935665284243442334458135561822645851e-27), SC_(0.440987377729536e16), SC_(0.287391328125e5), SC_(0.21480602601200030281855562249446563848311273705777e-6) }}, 
      {{ SC_(0.22256795142604778055852756615936599983521384333793e-27), SC_(0.18143533359633255599212774654416246988830607733689e-18), SC_(0.21148944142623804509639739990234375e-5), SC_(0.11297576663225845000545238152727773376633249003903e5) }}, 
      {{ SC_(0.27311316429626442094674415847188181871613594240214e-27), SC_(0.10845691548033613824e20), SC_(0.400673984e9), SC_(0.40680160276715551282981129022255804380967818080019e-8) }}, 
      {{ SC_(0.55263283825603576259688637477087526891102295303199e-27), SC_(0.14570690537170526341649579027404115549870766699314e-16), SC_(0.12941088853490731622934705547460304161866623869764e-26), SC_(0.3263066756541685311171843349919704700385781288154e10) }}, 
      {{ SC_(0.56127809703514701593677302775789618452802567406812e-27), SC_(0.9228809556838246663801328395493328571319580078125e-11), SC_(0.86422194270699415064029835775727406144142150878906e-12), SC_(0.85882928958216539680438351403609321208964637689442e6) }}, 
      {{ SC_(0.88887406204705208581375488864563298833942634608052e-27), SC_(0.5811525927157390469801612198352813720703125e-8), SC_(0.32174132911148321865672794483970164947095327079296e-17), SC_(0.15798257631853654027208341257989620757183444492979e6) }}, 
      {{ SC_(0.11649136528196886067987694424015483218044894522109e-26), SC_(0.36767340167168e14), SC_(0.4968523085117340087890625e0), SC_(0.28619662675577147008545299820464843681562410993599e-5) }}, 
      {{ SC_(0.12708737924245050134296546672544059482912572403568e-26), SC_(0.903024183216244059537408e24), SC_(0.15518063165544166788813746673722175600112280614926e-28), SC_(0.62957032534216916589353715070316990128108284888469e-10) }}, 
      {{ SC_(0.25172518744793432127678756566548684645107602196601e-26), SC_(0.432213410600102056165376e24), SC_(0.1959631583933896656101239768660304818581607833039e-18), SC_(0.76260606376287472971690034770273684734039141637871e-10) }}, 
      {{ SC_(0.28601321158264026057365024112938563807684451932578e-26), SC_(0.40558081566683637682324548023871102486737072467804e-15), SC_(0.208714828125e6), SC_(0.5522837672610515535667805214004803961305903914157e-1) }}, 
      {{ SC_(0.42244364291200267661460233749011480646438909669627e-26), SC_(0.477498138427734375e3), SC_(0.17728046030944125033074269511337850424581574770855e-19), SC_(0.12451945453260696576552580190880249825955248401269e1) }}, 
      {{ SC_(0.48457483625271488463909528606996389233426292958429e-26), SC_(0.34402809559391418553704811749276853293953368218006e-26), SC_(0.3426654976e10), SC_(0.71831384058159540985490355058964459192302194019864e-3) }}, 
      {{ SC_(0.51977933341075693398899317919762114747383096799438e-26), SC_(0.266911591494591876579813490688e30), SC_(0.53580234866956732986409406294114887714385986328125e-11), SC_(0.93375161793411865686174480682610243788243937917932e-13) }}, 
      {{ SC_(0.73955594308673193523198369636584653936223991005372e-26), SC_(0.15995684594580228399252064264146611094474792480469e-12), SC_(0.170420291286861873152e22), SC_(0.98255728430318667072571074195808505094006175327076e-9) }}, 
      {{ SC_(0.16358995318300954765782308898640009098138844295667e-25), SC_(0.98936341703850100293138325469044502824544906616211e-13), SC_(0.17837596956010162360661830405206274008378386497498e-14), SC_(0.10825479757466109087874722747675913053273852855701e8) }}, 
      {{ SC_(0.19129386995031684168433400267318972464065419958335e-25), SC_(0.74098306733179406810366224487118565210547929972832e-30), SC_(0.40798337829960889676546298421300207337480969727039e-16), SC_(0.18975656681089523246977362390571886102543681656904e10) }}, 
      {{ SC_(0.20621651441981357349985057544616166528433660182218e-25), SC_(0.37752524088656425060861465681227855384349822998047e-12), SC_(0.20065922661601206578897704790875877733924426138401e-16), SC_(0.1026562701139222168152586002247636059939894265944e8) }}, 
      {{ SC_(0.21288901426793981534691419438692370107505096726852e-25), SC_(0.5289344906157640122368e23), SC_(0.11510209314816e14), SC_(0.54396628344807662681292826103022096566324190444093e-10) }}, 
      {{ SC_(0.25325901731494375978251987705874090841683295149966e-25), SC_(0.2247014312744140625e3), SC_(0.275117858615052709715247104e27), SC_(0.1755537214869906012774193839638577210495131605845e-11) }}, 
      {{ SC_(0.34857664908449107348958795506280082952452713251912e-25), SC_(0.4151866912841796875e2), SC_(0.84098145009994339684283693509730169685090217512879e-22), SC_(0.44454486362140376311920208456593332541577968986099e1) }}, 
      {{ SC_(0.34919368622379363366113344149995795887854964367758e-25), SC_(0.253342638931968e15), SC_(0.7562174072265625e3), SC_(0.92072944143905544126698873573853448498100607354808e-6) }}, 
      {{ SC_(0.43573388456807634241895548780677530339229715228289e-25), SC_(0.4951682e8), SC_(0.27826294978205525521980137859608542144911232096849e-25), SC_(0.55217533865229231709379440218980932604236253984141e-2) }}, 
      {{ SC_(0.79820903020739723608895214436397557193018231780357e-25), SC_(0.64729720161775472443612539086288393264112528413534e-17), SC_(0.68450550546432e14), SC_(0.44847121597179922927679996550818082257097417243103e-5) }}, 
      {{ SC_(0.87440356429873925658498856170228582591246249688943e-25), SC_(0.897631640625e4), SC_(0.386145068359375e4), SC_(0.20246560118180263593246019999683330284223142080123e-1) }}, 
      {{ SC_(0.94440849851249091320281320378524601844016927998382e-25), SC_(0.339495296e9), SC_(0.27455182077952e14), SC_(0.13429247262567663626711145473545103648849120559512e-5) }}, 
      {{ SC_(0.14235380836999617679740726134029336127093459674064e-24), SC_(0.13978527726259656235898667313173260930711863658793e-24), SC_(0.2028485946357250213623046875e-1), SC_(0.19206251584392463442370997640025081765353159971305e3) }}, 
      {{ SC_(0.19953517994584643852448181812338140391502663839596e-24), SC_(0.20741449842688e14), SC_(0.4743499375e6), SC_(0.22359243991203761053744717290515382846472784535058e-5) }}, 
      {{ SC_(0.24754359063412526643006257824154938047573476511687e-24), SC_(0.542938704356835328e18), SC_(0.44974670432440498891960159215184658369128360699829e-26), SC_(0.67866272584068105190014692037620145928646359916575e-7) }}, 
      {{ SC_(0.31317834636651731435069138009717243018286553235541e-24), SC_(0.446171086848e12), SC_(0.49623249953612003082525916397571563720703125e-9), SC_(0.38191286535568014551586929918910276720789086531549e-4) }}, 
      {{ SC_(0.47603821186323272660218327918596801064457513241734e-24), SC_(0.2276554752e10), SC_(0.1719185896217823028564453125e-1), SC_(0.29742088232825551204748453119751505500500823727615e-3) }}, 
      {{ SC_(0.49794778812580822691949943719295546451682199506905e-24), SC_(0.1241846768099137683456e22), SC_(0.16907547929525060340181807204941172504655995389999e-25), SC_(0.1517664520587024793869311011872864378396584169184e-8) }}, 
      {{ SC_(0.56225779987930131445265275562229206527363467582603e-24), SC_(0.59220483766176692878700381014733800100202643079683e-19), SC_(0.170295034922225631232e22), SC_(0.11622667635419788310904431315435991769296091794395e-8) }}, 
      {{ SC_(0.59662314470867055698475524004384740249344598606029e-24), SC_(0.3658255674684168267104256e25), SC_(0.347205125e7), SC_(0.11573263812518641898043129899137636153559584538173e-10) }}, 
      {{ SC_(0.63171350201374448567926894124993295043246632758382e-24), SC_(0.34594001439795600424927311319582115491182941913878e-27), SC_(0.63795086741914598182229839666991088459324643622494e-23), SC_(0.10133993353996022465682119843291432134218242147239e13) }}, 
      {{ SC_(0.13769532587968157644195235343886302517048270122046e-23), SC_(0.2007315487162486533634364604949951171875e-6), SC_(0.484821384427736035149791860021650791168212890625e-10), SC_(0.12389402269001445927668245292756768857373060188716e5) }}, 
      {{ SC_(0.1809900535358029636909945199492450026643175498009e-23), SC_(0.4521496521192602813243865966796875e-5), SC_(0.8669365225699721122509799897670745849609375e-10), SC_(0.32060615134261499907655037885120005642674260522623e4) }}, 
      {{ SC_(0.23768503319901658006414734019219381138884883419848e-23), SC_(0.545301093941248e15), SC_(0.1237108193663516431115567684173583984375e-9), SC_(0.12743839987290518287222259493370574805423695673748e-5) }}, 
      {{ SC_(0.30307608021550191165014175615417981032514993522398e-23), SC_(0.112407951746718026697635650634765625e-5), SC_(0.2082685879058432e16), SC_(0.56691050322635168060617985774434728756046014923614e-6) }}, 
      {{ SC_(0.62520772668534154026944814518561754825703991045316e-23), SC_(0.19445130267235161963321360384e29), SC_(0.27158976561908717618255837411567199524142779409885e-16), SC_(0.38026907216974328094743665088443755531206213714277e-12) }}, 
      {{ SC_(0.10943329334993736046425619587286570504047755747479e-22), SC_(0.29924868096e11), SC_(0.2513091862201690673828125e0), SC_(0.81727074296930034500798079272025541361956733831224e-4) }}, 
      {{ SC_(0.11566333023752935340761337633447216211718400202813e-22), SC_(0.18755437374336002170666266863907623019258608110249e-17), SC_(0.776579078820560653184656985104084014892578125e-9), SC_(0.40565905858913068184819366045065677568636761097112e6) }}, 
      {{ SC_(0.12363192189691982984868135714653404610974263277967e-22), SC_(0.35982240840770946433031796107826494335313327610493e-16), SC_(0.322920703887939453125e1), SC_(0.11632490874358186871413249990505026788809575604058e2) }}, 
      {{ SC_(0.13102694856934221302627057835335012189043046859638e-22), SC_(0.557648090759990083584e22), SC_(0.511986668338959560742296162061393260955810546875e-10), SC_(0.51248664482931459540724013275829878903910451492033e-9) }}, 
      {{ SC_(0.22752379870925977520487843277428559665698237779452e-22), SC_(0.169495918280704e15), SC_(0.106314858496e12), SC_(0.38973804069223761667690578386406821821893138424283e-6) }}, 
      {{ SC_(0.25335998731998849030698736206528910198942927678445e-22), SC_(0.99404931640625e3), SC_(0.204871795654296875e3), SC_(0.71159937657740084998191009093579819438581801376454e-1) }}, 
      {{ SC_(0.34646067293379381351152691325339738961930358129848e-22), SC_(0.26973976499394821796760860105960760360263583912399e-23), SC_(0.238645943284598871514390339143574237823486328125e-10), SC_(0.30233137727518071307294329779222831890404522453607e7) }}, 
      {{ SC_(0.37901014673404386117887019380781393404489243437183e-22), SC_(0.2586026539574959315359592437744140625e-5), SC_(0.13906271765126904778015790844071007475134249542492e-23), SC_(0.1280499683576237130421033280426088849010239336608e5) }}, 
      {{ SC_(0.71863877935764437100797607417958061393203905709015e-22), SC_(0.174722980453023744e19), SC_(0.13073324703744e14), SC_(0.551341711330108745264600223041680382705817370824e-8) }}, 
      {{ SC_(0.15427949623089271042983806318685344877161824683753e-21), SC_(0.47543684043676020384294744758335582446306943893433e-14), SC_(0.3374483874642825322028299383742755000492569610633e-30), SC_(0.14514502843791109783476535555536915858928043263431e9) }}, 
      {{ SC_(0.34863327790830662300885857654195697230559147783424e-21), SC_(0.941622257232666015625e-2), SC_(0.1611729536e10), SC_(0.35667604443925075539035226902339321756810277364901e-3) }}, 
      {{ SC_(0.37816734667556745747025163289015137202397909277352e-21), SC_(0.24983507829808709876928674020746257156133651733398e-14), SC_(0.3642084375e5), SC_(0.12287059533687168356517432791650885505026509128221e0) }}, 
      {{ SC_(0.96362472102334232055222076765519517715929964651878e-21), SC_(0.229194643907248973846435546875e-3), SC_(0.354709317473833607436972670257091522216796875e-9), SC_(0.53342978039746190271353828468457072780992822953649e3) }}, 
      {{ SC_(0.27589042212186362242123678200494962808875243354123e-20), SC_(0.16342684e8), SC_(0.10564504593401150001064081607182743027806282043457e-12), SC_(0.6092631429182695881654167011697706266534023656226e-2) }}, 
      {{ SC_(0.9438427249469115068287341347406937952513317213743e-20), SC_(0.200531482696533203125e1), SC_(0.66637542724609375e2), SC_(0.38641413534589247647986790175011427775190787719587e0) }}, 
      {{ SC_(0.10233203223084091273258880352287070181205308472272e-19), SC_(0.85809811133878005628972118756792042404413223266602e-13), SC_(0.231948544e9), SC_(0.17111312129091146749247383297362106242781652277967e-2) }}, 
      {{ SC_(0.18673345450030310831705831391483241255002667458029e-19), SC_(0.16140768350376832622251404282443946390469477480956e-24), SC_(0.35751782069791464758326094786154009108614104661683e-22), SC_(0.32580083767662476086644194595227808939042620549885e11) }}, 
      {{ SC_(0.19864569542637633100393889035509276119739752175519e-19), SC_(0.6342787072e10), SC_(0.22447013671875e5), SC_(0.96207689142094655800386573512496442354548791850638e-4) }}, 
      {{ SC_(0.21109476364529939751075359117074570214356299402425e-19), SC_(0.8756801014807582267041677127782781970980266472715e-25), SC_(0.19232578752860259808180970650021732008816410797181e-22), SC_(0.33190786309012978445733640384809592118937077449509e11) }}, 
      {{ SC_(0.46915519457248313591588473499272016198347046156414e-19), SC_(0.292094455289770849049091339111328125e-6), SC_(0.156863867492641304906706190336e30), SC_(0.10736234303351092627849003274144657319960447442842e-12) }}, 
      {{ SC_(0.48988976909583188869227858043553514022505623870529e-19), SC_(0.20838384443777613341808319091796875e-4), SC_(0.15278292e8), SC_(0.38494761861212656145073023306052978441909033021375e-2) }}, 
      {{ SC_(0.76062578971398177956182934736362177829960273811594e-19), SC_(0.1657523685947075284959232e25), SC_(0.25513326169038305064700172114511289578331343363971e-18), SC_(0.39023346626130050372613649601865580373904542960048e-10) }}, 
      {{ SC_(0.82997499668329372719087076888666576479636205476709e-19), SC_(0.13155479315039595949803718770027355301939497866925e-23), SC_(0.1327809695148788465823841420387907419353723526001e-14), SC_(0.17076475913109865792944964183189185127876107750271e9) }}, 
      {{ SC_(0.15449182507288713721863232866682302812932903179899e-18), SC_(0.133974442650952596522984094917774200439453125e-8), SC_(0.38424594277974055189327670217216623149703025319468e-21), SC_(0.34913733411849927277398272440663090725422971274299e6) }}, 
      {{ SC_(0.16677509527778160624086499150275919589603290660307e-18), SC_(0.50082130538252574789989333416135111329551950562359e-29), SC_(0.27393523857242675896004658903787332135948417999316e-20), SC_(0.84500092441906057349361486713809627858189091269051e10) }}, 
      {{ SC_(0.20609658618625881570536584851127681616844711243175e-18), SC_(0.827880703125e5), SC_(0.1740015537225728e16), SC_(0.31813710267864140379843054991887348784914294358726e-6) }}, 
      {{ SC_(0.30420727664434581210352358596193944606511649908498e-18), SC_(0.28656053473241627216339111328125e-4), SC_(0.94969911521617292598785838378394608128019171999767e-19), SC_(0.31814318136127268795698816874123401731043382606e4) }}, 
      {{ SC_(0.75868695590633990953827528458397466692986199632287e-18), SC_(0.930611462144e12), SC_(0.18147922618313051311153033283257685840533790511131e-24), SC_(0.37345680899047409286251384101030916729057585987005e-4) }}, 
      {{ SC_(0.79597584432992412060764095271814255738718202337623e-18), SC_(0.75974287571611502022633594876763844865744160884209e-30), SC_(0.20657736771171195551744e23), SC_(0.33337166230437980329718803405401684156691336380823e-9) }}, 
      {{ SC_(0.85474216716571798786966467076364750710126827470958e-18), SC_(0.482905248935018145708507136e27), SC_(0.11712293277443256300383769147321899595226568635553e-17), SC_(0.23724105747019863960223907175035546177431514293578e-11) }}, 
      {{ SC_(0.1145677201634679759519302305603716263249225448817e-17), SC_(0.57490079546449489559552e23), SC_(0.210827477730456275779584e24), SC_(0.46121654886964148580561085957249875214232267958269e-11) }}, 
      {{ SC_(0.12784377253954858878954355810853016350847610738128e-17), SC_(0.687874899968e12), SC_(0.2496727752685546875e2), SC_(0.16163774788262216936732624175864570071639554858486e-4) }}, 
      {{ SC_(0.20504934709643312615865232140244245329085970297456e-17), SC_(0.73745083851314552802870354829278820574245401076041e-19), SC_(0.25773770175874233245849609375e-3), SC_(0.1086635902426709059571521246941906092073302607025e4) }}, 
      {{ SC_(0.21543830132027756341550790708527785000114818103611e-17), SC_(0.22948391437530517578125e1), SC_(0.1066555328369140625e3), SC_(0.3213106933702150509400152431201753542221262845723e0) }}, 
      {{ SC_(0.22468750405760049766485005051652734664457966573536e-17), SC_(0.20721947294077835977077484130859375e-4), SC_(0.33333534375e6), SC_(0.22753717889025910067903355116012809983114508140331e-1) }}, 
      {{ SC_(0.33297255999405977634352134242323728585688513703644e-17), SC_(0.31191365320704e14), SC_(0.2293932139873504638671875e0), SC_(0.31617328082826779132454622724525132566887374163142e-5) }}, 
      {{ SC_(0.35736448257653877024582131372021365223190514370799e-17), SC_(0.1626183676572159287754752e26), SC_(0.18501463382170069138510370976291596889495849609375e-11), SC_(0.10890802574312809805885399629231553375543724066667e-10) }}, 
      {{ SC_(0.4488765904371071685042063337256479371717432513833e-17), SC_(0.12556997755786668595905972282403678229339592450908e-26), SC_(0.60742564e8), SC_(0.38902743812314487577211386432157566200767570828177e-2) }}, 
      {{ SC_(0.46574007343104197780350728130827064887853339314461e-17), SC_(0.138342221871913237479424e26), SC_(0.105195244140625e5), SC_(0.690975117923569372028946999713308497271079184874e-11) }}, 
      {{ SC_(0.46871312598868006987253009842930850936681963503361e-17), SC_(0.3093168493023691324522496e26), SC_(0.16793731632787596740420928687663819571897812904515e-26), SC_(0.91131697094521443903059177985942267322512482094196e-11) }}, 
      {{ SC_(0.57842544071306897015280826246375056598481023684144e-17), SC_(0.29870528793496387010009129880927503108978271484375e-12), SC_(0.2262512535863296e17), SC_(0.2302305948159761903194040618076972054768260671335e-6) }}, 
      {{ SC_(0.152616857880340486461855087352290638591512106359e-16), SC_(0.2803833618070566221119488e25), SC_(0.130162216009921394288539886474609375e-4), SC_(0.20996235599317174904036461576228470865489044522605e-10) }}, 
      {{ SC_(0.24715665357800610426718818102287400506611447781324e-16), SC_(0.15454139158925192518959104e26), SC_(0.1653589118287872e16), SC_(0.32726578425798516916988210488291665752573225312111e-11) }}, 
      {{ SC_(0.2486598558179742193396249971826250657613854855299e-16), SC_(0.425586784e9), SC_(0.80336704357062554970880796645360533148050308227539e-13), SC_(0.12787170247026518810998135711278552909011457029039e-2) }}, 
      {{ SC_(0.25599855258170792768942364281414825200045015662909e-16), SC_(0.301153981126844882965087890625e-2), SC_(0.1650323114690053222170624e25), SC_(0.25042211698570494214890306124497648270772610084347e-10) }}, 
      {{ SC_(0.27022364375023134885640124780437076879024971276522e-16), SC_(0.27506543358959030582888269221280574638246675400223e-29), SC_(0.10302131894484992e19), SC_(0.40590751071557904845991245264371415085266801126692e-7) }}, 
      {{ SC_(0.29292129777895166658878423060485829410026781260967e-16), SC_(0.3623176299517048782848e23), SC_(0.17793491421051038908068830934894322126638144254684e-15), SC_(0.23720119782915590066505534131870715729764828500059e-9) }}, 
      {{ SC_(0.32392597928368476898827732490815378696424886584282e-16), SC_(0.67357483203522861003875732421875e-4), SC_(0.2024667237879200631521688091840616152694565244019e-17), SC_(0.18696718576394509915149940516477691360642695264401e4) }}, 
      {{ SC_(0.51905646303429040628284185654450766378431580960751e-16), SC_(0.15583587e8), SC_(0.46741176605224609375e2), SC_(0.19619112423150604296588229321525943450291423624961e-2) }}, 
      {{ SC_(0.54374770505732477601443242143375300656771287322044e-16), SC_(0.4562802734375e3), SC_(0.10197021348467909816516131089894163913918803398168e-29), SC_(0.10848494678596107007991832533984166270247056624275e1) }}, 
      {{ SC_(0.60475637804894883005346617466102543403394520282745e-16), SC_(0.56145323516737172227849140410116390853545453865081e-18), SC_(0.64836257251954521052539348602294921875e-7), SC_(0.45912760390178930360213360786590635344323768064775e5) }}, 
      {{ SC_(0.17055543082513291604229710429763144929893314838409e-15), SC_(0.6943710148334503173828125e-1), SC_(0.61840874921367523613102701318666731822304427623749e-15), SC_(0.65045987281687846381232346342671549624399420118703e2) }}, 
      {{ SC_(0.31354745663454523796342954256033408455550670623779e-15), SC_(0.18973853599391077295877039432525634765625e-8), SC_(0.15741248433312655941040958396115456707775592803955e-13), SC_(0.16309232196306199587236841246499578205810903560841e6) }}, 
      {{ SC_(0.45365798223651683691859393121603716281242668628693e-15), SC_(0.160435796715319156646728515625e-3), SC_(0.109048366974172659712e22), SC_(0.90773201365578006665966789816711087859341300194272e-9) }}, 
      {{ SC_(0.92657114094649205629505850367877428652718663215637e-15), SC_(0.32666126748015500425026402808725833892822265625e-10), SC_(0.62660384591791979530528422515089914668351411819458e-14), SC_(0.93442817754069494094868744708536658507501213290948e6) }}, 
      {{ SC_(0.10318525717298732830018437311991874594241380691528e-14), SC_(0.14367766698608619435617583803832530975341796875e-9), SC_(0.5059831664766534231603145599365234375e-6), SC_(0.76860493569879907867342574174231921687308455794222e4) }}, 
      {{ SC_(0.11863620751000167503896864928947252337820827960968e-14), SC_(0.10501863e8), SC_(0.297662976884736e16), SC_(0.20377296104572453940554613019682833478236361016015e-6) }}, 
      {{ SC_(0.1484655421266577700334376999080632231198251247406e-14), SC_(0.242975312e9), SC_(0.398680594063019737088e21), SC_(0.77374742716312181182087266439794032798255867974115e-9) }}, 
      {{ SC_(0.3191302296140746501407203794542510877363383769989e-14), SC_(0.10381816564935609401309940371061152700193908060555e-22), SC_(0.10607265933659792978005498298443853855133056640625e-11), SC_(0.41671907070346189397396515732840095597083945698463e7) }}, 
      {{ SC_(0.63024210653626119155168439078806841280311346054077e-14), SC_(0.83430262439221944230360872296614616061560809612274e-15), SC_(0.38344456302173223195286237326130017242619817813276e-26), SC_(0.30822226845930963477751254978063864825930773776723e8) }}, 
      {{ SC_(0.68559452379320356268932457055598206352442502975464e-14), SC_(0.322791595458984375e3), SC_(0.86205957643638764405225050069248027284629642963409e-15), SC_(0.11286691758984928258891709073581323177675019302791e1) }}, 
      {{ SC_(0.89081879080330633735584910937177482992410659790039e-14), SC_(0.392437056867112321024e21), SC_(0.20596706612452379210041634624929924061650932110012e-23), SC_(0.20833713040090052179203072176122664236715044249824e-8) }}, 
      {{ SC_(0.96442290460109492133966568871983326971530914306641e-14), SC_(0.9353629648877212663808e22), SC_(0.52655215867828667928533109554578572897298727184534e-17), SC_(0.44248359304053531553503275545262277287163705756592e-9) }}, 
      {{ SC_(0.10676147262794234704674778413391322828829288482666e-13), SC_(0.43214794983836329352138753913566138198376620493946e-21), SC_(0.13713993780991436762807365477498389161326031171484e-19), SC_(0.77477951012763068780464107736853653140282630933197e8) }}, 
      {{ SC_(0.33435832770024875859604662764468230307102203369141e-13), SC_(0.47324655483842805109613708493123820154516818645152e-26), SC_(0.53386867791342146736804574152578486186809803015763e-23), SC_(0.69103580463856696918288564249817620300225293591956e8) }}, 
      {{ SC_(0.40149480284466451673885956097365124151110649108887e-13), SC_(0.256623141467571258544921875e-1), SC_(0.33872525312e11), SC_(0.83352453602304271614961387870254364044913563085681e-4) }}, 
      {{ SC_(0.5554841051654164918449652077470091171562671661377e-13), SC_(0.12544762676037794895951386908716784773787367157638e-18), SC_(0.20581069188704517551523841788208013525718342862092e-18), SC_(0.29964256109399287504029873551607571242726670155945e8) }}, 
      {{ SC_(0.18399165654589544338648465782171115279197692871094e-12), SC_(0.59311699931923680645911412736e29), SC_(0.33036756992e11), SC_(0.91985542733502026197882578870037501563914705803536e-13) }}, 
      {{ SC_(0.18488044482931759171506769234838429838418960571289e-12), SC_(0.33246523978462334755767677157978212676425755489618e-18), SC_(0.364377344204408356864e21), SC_(0.20806503238122671305898680392900908147081357204062e-8) }}, 
      {{ SC_(0.19550562611967553516834072979690972715616226196289e-12), SC_(0.18799281123449514653822470500968856016443808698568e-21), SC_(0.205092546875e6), SC_(0.4887361624197540313885328897761569933269444605574e-1) }}, 
      {{ SC_(0.22669229503540638814840235681913327425718307495117e-12), SC_(0.37976130008799530861998324174767620309278726153934e-21), SC_(0.98595622295761632362496e23), SC_(0.135084659229159261883721878470886375265281129265e-9) }}, 
      {{ SC_(0.31680756108765084633205333375371992588043212890625e-12), SC_(0.80878494291046089240994343416701894966536201536655e-17), SC_(0.1615060552761815478491414528e29), SC_(0.37964638232520579878684922762711444858962017870595e-12) }}, 
      {{ SC_(0.35943559868918673050330880869296379387378692626953e-12), SC_(0.35023133106665160704e20), SC_(0.2881296007168e13), SC_(0.16125174681924904053166769007367089757934572127931e-8) }}, 
      {{ SC_(0.60167024357529741429573277855524793267250061035156e-12), SC_(0.3838393489343095451259240448e28), SC_(0.103355013339542251670339584e27), SC_(0.51789252362880339895831183061226886556804949329166e-13) }}, 
      {{ SC_(0.9310612177071408979145417106337845325469970703125e-12), SC_(0.85308625497696339559303146948820995021378621459007e-17), SC_(0.1711439775257338052608e22), SC_(0.959167004954428871291470615043806383733773135401e-9) }}, 
      {{ SC_(0.15664042328847327389951260556699708104133605957031e-11), SC_(0.40672445e7), SC_(0.45362430968070144e18), SC_(0.20942444114651815662092507300528139632392372217436e-7) }}, 
      {{ SC_(0.164856496509546701645376742817461490631103515625e-11), SC_(0.12800646827237915914565746788866817951202392578125e-10), SC_(0.130841693878173828125e2), SC_(0.41208907613801029508698069614091329229296680023012e1) }}, 
      {{ SC_(0.2116143198171993589085104758851230144500732421875e-11), SC_(0.14341135e7), SC_(0.7228693017324945408e19), SC_(0.59549298220135661524923150503803884348448195111901e-8) }}, 
      {{ SC_(0.53607539414468607930075449985451996326446533203125e-11), SC_(0.63232212397934060070738019807261992566438379981264e-22), SC_(0.19656669921875e5), SC_(0.13769633263706751524081053809607939542780539021035e0) }}, 
      {{ SC_(0.11080205329638825872962115681730210781097412109375e-10), SC_(0.68420748430509458628227944729238707566310040419921e-19), SC_(0.2356455859375e5), SC_(0.12398673257026926468830816422986785167055400707412e0) }}, 
      {{ SC_(0.16011657277825719347674748860299587249755859375e-10), SC_(0.389046929776668548583984375e-1), SC_(0.18785430908203125e2), SC_(0.10331595275029600904213757235587288702300379535143e1) }}, 
      {{ SC_(0.1943433088069657088681196910329163074493408203125e-10), SC_(0.22031295035060773623229295812958821278778470675874e-24), SC_(0.39424006729538510485078006695403018966317176818848e-13), SC_(0.10181094094117235122748004174391301934695249818415e7) }}, 
      {{ SC_(0.2201089831233016269607105641625821590423583984375e-10), SC_(0.50355072889071337472e20), SC_(0.9924967773258686065673828125e-2), SC_(0.37168725093377584439681656402103407207281346607784e-8) }}, 
      {{ SC_(0.2500394162552321830617074738256633281707763671875e-10), SC_(0.72982407463299740342380286062361920775211799206766e-27), SC_(0.68663809933312e15), SC_(0.11705831038962670004689799738618689025236802021416e-5) }}, 
      {{ SC_(0.55001718457514670035379822365939617156982421875e-10), SC_(0.74622654356062412261962890625e-2), SC_(0.11046793904970209077021081611746922135353088378906e-11), SC_(0.12289994971595589408820551667235701158402342392922e3) }}, 
      {{ SC_(0.7451937678037978685097186826169490814208984375e-10), SC_(0.72950579063556310785863719706888276620113808904403e-28), SC_(0.590493896484375e4), SC_(0.22627840666043340650766592504897974124281842799663e0) }}, 
      {{ SC_(0.755542572949963187056710012257099151611328125e-10), SC_(0.140444835444342210428928e24), SC_(0.468889537015105749778432e24), SC_(0.30318309251223273254705079441222879870651439575784e-11) }}, 
      {{ SC_(0.10907375003199604179826565086841583251953125e-9), SC_(0.41478983876103159289527866349089890718460083007813e-12), SC_(0.914895470592e12), SC_(0.27775162984067084873871670268781393679177007122679e-4) }}, 
      {{ SC_(0.2914749275273464945712476037442684173583984375e-9), SC_(0.43084057979285717010498046875e-2), SC_(0.7663212560384e13), SC_(0.68430772514524815198021987807781248653807227632001e-5) }}, 
      {{ SC_(0.34717195784850218842620961368083953857421875e-9), SC_(0.40871053623249201233388894216602693632012233138084e-16), SC_(0.59489389257909689226875975750249807283420722114897e-22), SC_(0.50248316560720273122313530850252558311674226072784e6) }}, 
      {{ SC_(0.573736336217933740044827573001384735107421875e-9), SC_(0.141051064161956674070097506046295166015625e-7), SC_(0.2359947e8), SC_(0.38554094395081904461875352641296067711875626599237e-2) }}, 
      {{ SC_(0.704426572628591429747757501900196075439453125e-9), SC_(0.193607401472e12), SC_(0.1391435716868727467954158782958984375e-5), SC_(0.47956310371775673727806264838386592028271277030231e-4) }}, 
      {{ SC_(0.977972813842598043265752494335174560546875e-9), SC_(0.91714010218496e14), SC_(0.15903771355407769760859082452952861785888671875e-10), SC_(0.28938741327235977977821576741594517344076340819527e-5) }}, 
      {{ SC_(0.13634373630111440434120595455169677734375e-8), SC_(0.114086150930432e15), SC_(0.236092775202816e15), SC_(0.1216085317801969728066416098561874666793875786679e-6) }}, 
      {{ SC_(0.2402602117257401914685033261775970458984375e-8), SC_(0.42540803535525434114020215409929237537767221510876e-19), SC_(0.4942538125e6), SC_(0.25411435580294084180110354467998907193832753843532e-1) }}, 
      {{ SC_(0.777670283724773980793543159961700439453125e-8), SC_(0.2502269946802471167757175862789154052734375e-8), SC_(0.439172573387622833251953125e-1), SC_(0.41563917566759682174029521342465192827771529184686e2) }}, 
      {{ SC_(0.1000261828920656625996343791484832763671875e-7), SC_(0.56146556854248046875e2), SC_(0.11031288903647689304752638145772731734228777611406e-22), SC_(0.16829463699080249137255803071085987000672502474288e1) }}, 
      {{ SC_(0.11262596188998941215686500072479248046875e-7), SC_(0.15615465734711286849289990641409531235694885253906e-12), SC_(0.24870398826241113884932236596184834676037667122728e-20), SC_(0.65764328269454893067874342434806894099352544487533e5) }}, 
      {{ SC_(0.118697354167807134217582643032073974609375e-7), SC_(0.10655614337119843210155423207652347628027200698853e-13), SC_(0.80777571722833747247104e25), SC_(0.13787346457280858239134079932771036641035099994604e-10) }}, 
      {{ SC_(0.199429788239058325416408479213714599609375e-7), SC_(0.3046932220458984375e1), SC_(0.18625525552055897944743393684375905872507558290159e-28), SC_(0.6192076232851057323816547290230338711525418243608e1) }}, 
      {{ SC_(0.3125807523929324815981090068817138671875e-7), SC_(0.82854125568e11), SC_(0.58830391620982291911135882706044579926359106014644e-24), SC_(0.78504217283419246830426687871757769083908369109695e-4) }}, 
      {{ SC_(0.43614054590079831541515886783599853515625e-7), SC_(0.84901359375e5), SC_(0.18469835205078125e4), SC_(0.113697935817169804603729037873421312395676772622e-1) }}, 
      {{ SC_(0.779404700779195991344749927520751953125e-7), SC_(0.19177764892578125e3), SC_(0.84045921502887936e17), SC_(0.62927737946505012614368165862357910796598245750659e-7) }}, 
      {{ SC_(0.108193802361711277626454830169677734375e-6), SC_(0.3542151123046875e4), SC_(0.23456829198204715014597354638681281358003616333008e-13), SC_(0.22669114913192386068663428014170078920046421374282e0) }}, 
      {{ SC_(0.143673929642318398691713809967041015625e-6), SC_(0.16637075914752e15), SC_(0.23990587803828224e17), SC_(0.25030131110795701109425533504222718640116907277668e-7) }}, 
      {{ SC_(0.153669333258221740834414958953857421875e-6), SC_(0.24841828125e5), SC_(0.12379233211158146427122161981060344260185956954956e-13), SC_(0.90667600582691661389906317164068697158640273748972e-1) }}, 
      {{ SC_(0.2170967974279847112484276294708251953125e-6), SC_(0.10346977737162760356637413145463933451898572504768e-25), SC_(0.52484349362176e14), SC_(0.34306235296982079927226929528071063185602970273271e-5) }}, 
      {{ SC_(0.38700227378285489976406097412109375e-6), SC_(0.155408535003662109375e2), SC_(0.245863923712e12), SC_(0.26476778341905701201403994457712890485051575736119e-4) }}, 
      {{ SC_(0.48651935458110528998076915740966796875e-6), SC_(0.856036898821189402624e22), SC_(0.12457122281020492087329554432e29), SC_(0.75992412307353181274590395903669929407671729057739e-13) }}, 
      {{ SC_(0.66861986169897136278450489044189453125e-6), SC_(0.1611108507323484384264192e25), SC_(0.11971012087915599989354498156046702206367626786232e-15), SC_(0.28649607032338277062143826873841232146657087953982e-10) }}, 
      {{ SC_(0.91303257931940606795251369476318359375e-6), SC_(0.62647392985281462272e21), SC_(0.9029110078699886798858642578125e-3), SC_(0.11507739776693376020229808950243964552210035879271e-8) }}, 
      {{ SC_(0.10180891649724799208343029022216796875e-5), SC_(0.1729617489790698408202207232e29), SC_(0.1748718329483606178449836195413959888389499042205e-21), SC_(0.31019466440735078715861284322421485870123003839682e-12) }}, 
      {{ SC_(0.17110982071244507096707820892333984375e-5), SC_(0.11394911498010055900814674945716997028766215294127e-21), SC_(0.626809104620207335756276734173297882080078125e-9), SC_(0.40843486110333878422775052074533552102335735708533e4) }}, 
      {{ SC_(0.1905407088997890241444110870361328125e-5), SC_(0.49344100641868464538346190868691658380817941539735e-29), SC_(0.12289824338974083826108178981784992134240752648111e-21), SC_(0.14507779939109348914263365222449123146630890794173e5) }}, 
      {{ SC_(0.2085087317027500830590724945068359375e-5), SC_(0.23632697338789035110002273443186027179763186722994e-16), SC_(0.503470934927463531494140625e-2), SC_(0.7443215347307968847096816964281834644229358591967e2) }}, 
      {{ SC_(0.23743823476252146065235137939453125e-5), SC_(0.12017452733891625937800995416182558983564376831055e-12), SC_(0.355727936e9), SC_(0.93879051880457113094738180078701943399908998252877e-3) }}, 
      {{ SC_(0.403085186917451210319995880126953125e-5), SC_(0.6825940447919154921472e22), SC_(0.2035662353382506496e19), SC_(0.65910280161434525991837637870971677790493218112674e-10) }}, 
      {{ SC_(0.14422212188947014510631561279296875e-4), SC_(0.3083335169004797952e20), SC_(0.25554565784928256e17), SC_(0.8887222431698841742432172977078913130487192272629e-9) }}, 
      {{ SC_(0.25149885914288461208343505859375e-4), SC_(0.908764609375e5), SC_(0.1206146739423274993896484375e-1), SC_(0.30714609290499037536130242844126766381871451892306e-1) }}, 
      {{ SC_(0.660258883726783096790313720703125e-4), SC_(0.11791503058925568539244861654413654150630463846028e-17), SC_(0.40593102739457907768023253725075960574031341820955e-17), SC_(0.19894100891398343389380520963779686084107191291715e4) }}, 
      {{ SC_(0.759344620746560394763946533203125e-4), SC_(0.22148209406780902835423848339554340607932845033396e-29), SC_(0.19855378956352178823888896e26), SC_(0.79117745614650124107443480130078256520862299576478e-11) }}, 
      {{ SC_(0.10531136649660766124725341796875e-3), SC_(0.2080037632e10), SC_(0.951222915825664e15), SC_(0.25623765965124384972156766618148516069951096383416e-6) }}, 
      {{ SC_(0.13287944602780044078826904296875e-3), SC_(0.9115189375e6), SC_(0.179409878467662494683889664e27), SC_(0.18478402252220803197276083292428549293882335388077e-11) }}, 
      {{ SC_(0.34799534478224813938140869140625e-3), SC_(0.131195640625e6), SC_(0.399027378608056683915492826862951233901632974721e-21), SC_(0.31087481266816612541791865433784096137052060166733e-1) }}, 
      {{ SC_(0.40748735773377120494842529296875e-3), SC_(0.57247653448122368e17), SC_(0.147901005859375e5), SC_(0.66363092258528492104049160938144939223516210594126e-7) }}, 
      {{ SC_(0.6576157757081091403961181640625e-3), SC_(0.177806784e9), SC_(0.30817991819236751066216748295709401603164490197841e-29), SC_(0.1090999243005587427903803809704479209226281702979e-2) }}, 
      {{ SC_(0.8751563727855682373046875e-3), SC_(0.423289281913088785772479250432e30), SC_(0.9735179031543808e18), SC_(0.22725513224973939353905616922674295370433539957998e-13) }}, 
      {{ SC_(0.143404235132038593292236328125e-2), SC_(0.3869421658552352052474251203895150297284999396652e-20), SC_(0.2396832969158041061126381509032573502437912793539e-20), SC_(0.55541035120027319131883319022959439252280754002183e3) }}, 
      {{ SC_(0.242449971847236156463623046875e-2), SC_(0.27421585230570622547519032963236895739100873470306e-15), SC_(0.4881218719482421875e2), SC_(0.9076576429319326176242343358795236577683793680439e0) }}, 
      {{ SC_(0.256083277054131031036376953125e-2), SC_(0.894934712937934631550844928e27), SC_(0.53638430898303751261473676086308258913532532826708e-28), SC_(0.11833146781540920891925399444932864774560629000439e-11) }}, 
      {{ SC_(0.27153925038874149322509765625e-2), SC_(0.2655967255122959613800048828125e-3), SC_(0.9400097640298840064e19), SC_(0.84515860351248360302260761664917470850628902787293e-8) }}, 
      {{ SC_(0.581006519496440887451171875e-2), SC_(0.646486887490027584135532379150390625e-5), SC_(0.2791671630859375e4), SC_(0.14941941296777298036147965663357887079707509086103e0) }}, 
      {{ SC_(0.716792047023773193359375e-2), SC_(0.1701292973166346200741827487945556640625e-6), SC_(0.3599197329062775452257483266294002532958984375e-10), SC_(0.79091533254758814905193368184582720174295362236443e2) }}, 
      {{ SC_(0.1795816235244274139404296875e-1), SC_(0.1995620570919113588736e22), SC_(0.93229513968235881657927660254990574951111859851663e-29), SC_(0.62496731499491176281313290464909725830037276460312e-9) }}, 
      {{ SC_(0.366241894662380218505859375e-1), SC_(0.4340599750656e13), SC_(0.211195732798682804412225683456e30), SC_(0.44821247136667385212079811838488185763008524961105e-13) }}, 
      {{ SC_(0.71962334215641021728515625e-1), SC_(0.1265022365259937942028045654296875e-4), SC_(0.439028906074585432064e22), SC_(0.41663265850180672061289570197622867267588231373065e-9) }}, 
      {{ SC_(0.75922764837741851806640625e-1), SC_(0.116516947201716902782209217548370361328125e-7), SC_(0.113272657281024e15), SC_(0.17716242975527787068420351700957583312183164658051e-5) }}, 
      {{ SC_(0.1691611707210540771484375e0), SC_(0.7906418323516845703125e1), SC_(0.48393864862901030998784493751613466975544853481209e-29), SC_(0.11811045731634267854810490199412163219712872433987e1) }}, 
      {{ SC_(0.23772360384464263916015625e0), SC_(0.24407187456e12), SC_(0.8943501494940164775471203029155731201171875e-9), SC_(0.30797170873345087619523887239821498519392498978199e-4) }}, 
      {{ SC_(0.3555642664432525634765625e0), SC_(0.33531504e9), SC_(0.2252993226647959090769290924072265625e-5), SC_(0.63981789907418799944668516927865772748798805373403e-3) }}, 
      {{ SC_(0.4837694466114044189453125e0), SC_(0.2555249786376953125e2), SC_(0.14830236860416e15), SC_(0.13099210366154566019010026871243074384013953372139e-5) }}, 
      {{ SC_(0.67300522327423095703125e0), SC_(0.89243675925783361169152385627967305481433868408203e-13), SC_(0.21305708e8), SC_(0.21711328085160761343462693512543922230931578950399e-2) }}, 
      {{ SC_(0.15793964862823486328125e1), SC_(0.21153786174505042274269802208549073334284835448335e-27), SC_(0.12200210459945015628591136191971600055694580078125e-11), SC_(0.12198933044768666270508537504095758456302429647814e2) }}, 
      {{ SC_(0.16426203250885009765625e1), SC_(0.7117705536074936389923095703125e-4), SC_(0.5225739073284472832e20), SC_(0.32968851718218611889358209536279287871000769996669e-8) }}, 
      {{ SC_(0.2704489231109619140625e1), SC_(0.80231539790356115235923917250460135619505308568478e-17), SC_(0.48408881335894016e17), SC_(0.91346472448791211738567719163400817982202253049609e-7) }}, 
      {{ SC_(0.393867969512939453125e1), SC_(0.51874020272408766185256645893864430640143203159534e-29), SC_(0.2930298149585723876953125e0), SC_(0.13695634435406320220597865446986430075396514401845e1) }}, 
      {{ SC_(0.5558017730712890625e1), SC_(0.61238770367556633579172767440648651635964536382034e-27), SC_(0.124700664587616256e18), SC_(0.57233966559860937272528487603042810916196421651537e-7) }}, 
      {{ SC_(0.85838680267333984375e1), SC_(0.87929930903225072031923050652798379251502344788882e-25), SC_(0.75804509525494787096890253236172035888884579435398e-21), SC_(0.91357620171042027913282465443245256840164004238585e1) }}, 
      {{ SC_(0.106269702911376953125e2), SC_(0.1371270220231999488e19), SC_(0.184909165756863558272016234695911407470703125e-8), SC_(0.18006399248775818574740772742096332722693131021921e-7) }}, 
      {{ SC_(0.23412235260009765625e2), SC_(0.14768327260674323415826432e26), SC_(0.345189679104e12), SC_(0.44444589538545554741689347921713021346984910988009e-11) }}, 
      {{ SC_(0.246089305877685546875e2), SC_(0.4994587136e10), SC_(0.243351703125e6), SC_(0.89724320928610841853985597052591837847382795461715e-4) }}, 
      {{ SC_(0.316759090423583984375e2), SC_(0.153310129036299258586950600147247314453125e-7), SC_(0.15191832576e11), SC_(0.92332903202788182286730682456174598281820631595544e-4) }}, 
      {{ SC_(0.3255878448486328125e2), SC_(0.20426069933899679481125376462984716200236491481616e-28), SC_(0.3943929741312e13), SC_(0.71232868256516848147475176520372458002726844662265e-5) }}, 
      {{ SC_(0.3607895660400390625e2), SC_(0.51364582986934692598879337310791015625e-6), SC_(0.48236623830723532346288762173713848824263550341129e-17), SC_(0.17347673532522180939322276270600309020985807051641e1) }}, 
      {{ SC_(0.43738616943359375e2), SC_(0.12385733574656e14), SC_(0.18116829833984375e4), SC_(0.35701733949128307671627579982483738830128908837878e-5) }}, 
      {{ SC_(0.4479792022705078125e2), SC_(0.11175146230483004594624674155056709423661231994629e-13), SC_(0.13292268387650598312620966562043814396254504117678e-22), SC_(0.28910087971624801153304984668598930483663006171249e1) }}, 
      {{ SC_(0.482386627197265625e2), SC_(0.371529138647019863128662109375e-3), SC_(0.12312668720852486471439889495482766790246387245134e-18), SC_(0.10472143173271605010449002902995089471028533975145e1) }}, 
      {{ SC_(0.64164215087890625e2), SC_(0.60759354638336e14), SC_(0.15436498306983203153379328e27), SC_(0.12610701873795731849746574684153036868943083955312e-11) }}, 
      {{ SC_(0.8524636077880859375e2), SC_(0.480171648e9), SC_(0.81851918776879678213563875328e29), SC_(0.86258634338002805113702997464504401250478280729872e-13) }}, 
      {{ SC_(0.10158062744140625e3), SC_(0.8022529108706313066889313475107958772980509820627e-20), SC_(0.15554543059386610748262569359212648123502731323242e-12), SC_(0.18298365465719619173567924640909142160239550064496e1) }}, 
      {{ SC_(0.10465634918212890625e3), SC_(0.60640822994173504412174224853515625e-5), SC_(0.24925849334950778558742528e26), SC_(0.56683497665415153265619536109723321025064544620414e-11) }}, 
      {{ SC_(0.1277736968994140625e3), SC_(0.95177386513821491537123975490430893842130899429321e-15), SC_(0.28095007115726435603337495231684788158121206437133e-29), SC_(0.18671339067230389827188193388573190070910283000371e1) }}, 
      {{ SC_(0.175763397216796875e3), SC_(0.12685536053155962454420298550668289028209301250172e-19), SC_(0.1597107696533203125e2), SC_(0.1978675405105023319553563777471211382180555427026e0) }}, 
      {{ SC_(0.1965407257080078125e3), SC_(0.344887394304e12), SC_(0.41293741759318436379544436931610107421875e-7), SC_(0.20483020664977574825111031547790571977914102467475e-4) }}, 
      {{ SC_(0.2191826629638671875e3), SC_(0.2306111083984375e4), SC_(0.1685688489456173056e19), SC_(0.14041203428362839724006141174787810823202189936702e-7) }}, 
      {{ SC_(0.50384063720703125e3), SC_(0.404188410838900933656576e24), SC_(0.15307389070737408e17), SC_(0.15620440663369180425497691406548733014755875230719e-10) }}, 
      {{ SC_(0.53687359619140625e3), SC_(0.22982227952519826732488902867652779863117686563745e-26), SC_(0.33525770516606100656031852480509769520722329616547e-15), SC_(0.96437096354850323399933917081393941901712830743268e0) }}, 
      {{ SC_(0.7166851806640625e3), SC_(0.1690176772380537639327398519769468654416755271086e-22), SC_(0.47753922915140458067828621580019898829050362110138e-15), SC_(0.83345362070814458637707277577852723377892982671916e0) }}, 
      {{ SC_(0.82290283203125e3), SC_(0.36223742228003175114281475543975830078125e-7), SC_(0.12701055793371805794043341177064064973639689881679e-22), SC_(0.46396700975327125930708200057380311257323231142065e0) }}, 
      {{ SC_(0.11206973876953125e4), SC_(0.159823103248039936e18), SC_(0.10259405824e11), SC_(0.24180009616078806214079770723439749028154895765982e-7) }}, 
      {{ SC_(0.1157078125e4), SC_(0.944933487050227712e20), SC_(0.15171425313958986080820068309549242258071899414063e-11), SC_(0.21456119777188316813098262549564992955737617814098e-8) }}, 
      {{ SC_(0.17164217529296875e4), SC_(0.2306652249771737088e21), SC_(0.72487803782646221227581317947397110401652753353119e-15), SC_(0.13896831930886626129994990515051103720579512995724e-8) }}, 
      {{ SC_(0.3369771240234375e4), SC_(0.151668605394661426544189453125e-2), SC_(0.27588927745819091796875e0), SC_(0.1037050861580198720069064707838859943203555540206e0) }}, 
      {{ SC_(0.3374702880859375e4), SC_(0.8743139992458493952e19), SC_(0.65656960010528564453125e0), SC_(0.64655349329713995229654370953771114973136045208058e-8) }}, 
      {{ SC_(0.3524259033203125e4), SC_(0.38758790625e6), SC_(0.4173026783555223552e19), SC_(0.79787362071210789161575658664325813485738929347333e-8) }}, 
      {{ SC_(0.494414599609375e4), SC_(0.9551179238333844741448269824e28), SC_(0.7608356306944e13), SC_(0.19205300238295770675268549069547393873542853841195e-12) }}, 
      {{ SC_(0.98872197265625e4), SC_(0.58409109024165905025768874558877996605588123202324e-16), SC_(0.7126068812794983386993408203125e-3), SC_(0.96637321228954147051574559568801427186215487598058e-1) }}, 
      {{ SC_(0.1597780078125e5), SC_(0.1903848463306411019979456512e28), SC_(0.41524315625e6), SC_(0.5992170989848289153774780408282576315577615009335e-12) }}, 
      {{ SC_(0.1624405078125e5), SC_(0.40561403505621103444471068204533651486640155603425e-24), SC_(0.1332809589803218841552734375e-1), SC_(0.65851986975619196338419051361638702955083798133709e-1) }}, 
      {{ SC_(0.503876328125e5), SC_(0.72534660121208050493385086597564193056086878641509e-19), SC_(0.12543467133030450355590801336802542209625244140625e-10), SC_(0.86206245036256200056825686542991636870600429843929e-1) }}, 
      {{ SC_(0.647452890625e5), SC_(0.731999936e9), SC_(0.2930758730861938998746296647368581034243106842041e-13), SC_(0.22372323832394864484059102238022270978961483980867e-3) }}, 
      {{ SC_(0.106680765625e6), SC_(0.56570606632127019614208e23), SC_(0.34145346314045075233544504794608567192597259332132e-24), SC_(0.91624018515193040973302979323086210375918534717075e-10) }}, 
      {{ SC_(0.22300921875e6), SC_(0.22960517578125e4), SC_(0.46933254639405441853106942079784734541910233270121e-28), SC_(0.77952695721361451918265181496139655608842753454322e-2) }}, 
      {{ SC_(0.41534478125e6), SC_(0.1918984889984130859375e1), SC_(0.44006012e8), SC_(0.56108612021577121610377974075509205314587640601936e-3) }}, 
      {{ SC_(0.10005244375e7), SC_(0.11613385491986150110932385359774343669414520263672e-12), SC_(0.1767129607947373434957201408e28), SC_(0.61487989006953108752515836892875700743298527009289e-12) }}, 
      {{ SC_(0.1268757375e7), SC_(0.35219765472105368786515100509859621524810791015625e-12), SC_(0.20491329771405312e17), SC_(0.91785534375252744953625908402896905612496013389402e-7) }}, 
      {{ SC_(0.2068948375e7), SC_(0.20907895301679711719256005153511068783700466156006e-13), SC_(0.893892793119022144310292787849903106689453125e-9), SC_(0.13258256198446202053448320199255053502584813134187e-1) }}, 
      {{ SC_(0.3064297e7), SC_(0.10695072441537967968227132372606381829210908662731e-23), SC_(0.35285359539881765141448911825262056696228540886295e-21), SC_(0.19136306805411382429286198222749585149026757224371e-1) }}, 
      {{ SC_(0.320426825e7), SC_(0.32412401535258716801207369728e29), SC_(0.3877133210647759738109952e25), SC_(0.32782844045417231500038726072796541143677847718953e-13) }}, 
      {{ SC_(0.47946235e7), SC_(0.22622955483503716568203720238550147314526839181781e-18), SC_(0.85913526136044117637383110697157917456934228539467e-16), SC_(0.12570131707988271278743881541607030888057936868018e-1) }}, 
      {{ SC_(0.61216025e7), SC_(0.38630216070566644236610820764554752315689256647602e-18), SC_(0.13632195402405625179543049996233605725137749686837e-16), SC_(0.11503344648303925557309315851573629140176905961895e-1) }}, 
      {{ SC_(0.14619622e8), SC_(0.815536015625e5), SC_(0.230844914913177490234375e0), SC_(0.10417544933127055095586307886682728892365216794026e-2) }}, 
      {{ SC_(0.20014814e8), SC_(0.3708101212978363037109375e0), SC_(0.13699657060765273544864379382315910937961689342046e-19), SC_(0.22996864468381630591972233244155779735502909305578e-2) }}, 
      {{ SC_(0.31355888e8), SC_(0.441912933349609375e3), SC_(0.200361263104e12), SC_(0.12877007244527215542954125316831371277147994453458e-4) }}, 
      {{ SC_(0.123742392e9), SC_(0.10912435391066719332460695603753930316446923640128e-25), SC_(0.701712293691392e16), SC_(0.12311347838291690922542702662292536165252138116897e-6) }}, 
      {{ SC_(0.2606888e9), SC_(0.38372283060996710610105527722302198867510014679283e-18), SC_(0.738515392e9), SC_(0.73738180012907530072733237000613285438700898249664e-4) }}, 
      {{ SC_(0.396068288e9), SC_(0.3591942195412689571187997472948797567093848215336e-21), SC_(0.20276001953125e5), SC_(0.31788185695055138388831184094120612293950324118951e-3) }}, 
      {{ SC_(0.670079424e9), SC_(0.14044194233643483429544463937103636612564738772591e-24), SC_(0.11511007425024644135191920213401317596435546875e-10), SC_(0.93261634525158269555988059116555256528739591102092e-3) }}, 
      {{ SC_(0.911282624e9), SC_(0.1114427401123063379525632e25), SC_(0.53440565956804888993886271109090557729359716176987e-17), SC_(0.17767297433491847296411122503310631448338696473691e-10) }}, 
      {{ SC_(0.1161228928e10), SC_(0.18421718410258806513944641963201765549884569850292e-21), SC_(0.22427656323344421104955380977729814673260477775329e-21), SC_(0.10594325940929478060113637501415496568954096991824e-2) }}, 
      {{ SC_(0.1535589888e10), SC_(0.29343589097392396787046010830923847834128537215292e-17), SC_(0.988066171875e5), SC_(0.15852377981515093892000242963170335575794025366861e-3) }}, 
      {{ SC_(0.1910448768e10), SC_(0.19696330564073048658818435820590984305819001943432e-28), SC_(0.32238440243425309843308409068705787565729120602853e-24), SC_(0.92111764017014799167695770919732767377570397815568e-3) }}, 
      {{ SC_(0.2606333696e10), SC_(0.12266837021255184297929829995155159849673509597778e-13), SC_(0.14248488e9), SC_(0.56126741437028022213938057788405364830940046384504e-4) }}, 
      {{ SC_(0.3957605632e10), SC_(0.55799657429356219751070966594852507114410400390625e-13), SC_(0.45080659638616064e17), SC_(0.447925977382851769046008640958190262157028817521e-7) }}, 
      {{ SC_(0.55398272e10), SC_(0.341833367802954728115011584e27), SC_(0.4623806612399525462016e22), SC_(0.37816233719489315918674318961750893328790457473159e-12) }}, 
      {{ SC_(0.7560605184e10), SC_(0.62840314285494969226419925689697265625e-7), SC_(0.3143396352e11), SC_(0.12261107835007683821954047136390170041928220826969e-4) }}, 
      {{ SC_(0.35244982272e11), SC_(0.181061646295454711808e21), SC_(0.18019738841891322915192832e27), SC_(0.61768415705764898273053471004786951059602196652868e-12) }}, 
      {{ SC_(0.62680088576e11), SC_(0.63543370924890041351318359375e-2), SC_(0.17267258802243381463374302664526283024315489456058e-17), SC_(0.65291034406401789119333037245769701297524163871655e-4) }}, 
      {{ SC_(0.67647336448e11), SC_(0.59025825792e11), SC_(0.63456950551354910536750724756131128750454202264858e-27), SC_(0.62469865760259720684274593826123524112716461709126e-5) }}, 
      {{ SC_(0.68342607872e11), SC_(0.74717364929222058918122144571648805171440455019649e-24), SC_(0.82841443123718438990010781708406284451484680175781e-12), SC_(0.10622515193450570845093540504598921965159066880235e-3) }}, 
      {{ SC_(0.732471296e11), SC_(0.4801772534847259521484375e-2), SC_(0.45398853613796871007741958773072074733645399780696e-27), SC_(0.61203463071633938954054765124346998318407403998592e-4) }}, 
      {{ SC_(0.99392208896e11), SC_(0.222360095977783203125e2), SC_(0.12478698822407829848064e23), SC_(0.12679711757751463238182798861301176686419753669725e-9) }}, 
      {{ SC_(0.11738591232e12), SC_(0.761073704058645716941100545227527618408203125e-10), SC_(0.1885123992906301282346248626708984375e-5), SC_(0.60461474956993546596361636712841407004887449043071e-4) }}, 
      {{ SC_(0.191893782528e12), SC_(0.174726296875e6), SC_(0.24141449950396592978032251394348434159198291126813e-20), SC_(0.19040707638204031123150448525201784536542378277896e-4) }}, 
      {{ SC_(0.210419040256e12), SC_(0.15455189208984375e4), SC_(0.90718428578382195030384883514111792400934880018881e-30), SC_(0.23437059569446713522176906643659257742572657122755e-4) }}, 
      {{ SC_(0.217494208512e12), SC_(0.140845240494850048e18), SC_(0.15238641357421875e4), SC_(0.21521056371404093244638842162473121285888665474177e-7) }}, 
      {{ SC_(0.572994879488e12), SC_(0.4479686882443445386870784e25), SC_(0.3949284499458758322165682321378970124179942071882e-27), SC_(0.76682320268187247006742196169355086249222758011355e-11) }}, 
      {{ SC_(0.64654147584e12), SC_(0.24521487702843957217058619392e29), SC_(0.921704585926541312e18), SC_(0.85492949696474996204965492167245176476986583196674e-13) }}, 
      {{ SC_(0.698235158528e12), SC_(0.12468150316635728813707828521728515625e-5), SC_(0.11407565381205131416209042072296142578125e-6), SC_(0.25796163828681886500287718049239889266277238342313e-4) }}, 
      {{ SC_(0.920973279232e12), SC_(0.11153434660579423094016106021221904046901687488323e-27), SC_(0.750879536326465313322842121124267578125e-7), SC_(0.24344680739060412637157564940636026936671373170231e-4) }}, 
      {{ SC_(0.1125503860736e13), SC_(0.2837864448e10), SC_(0.49448484864e11), SC_(0.25990761721926745804582114293174306029621847941473e-5) }}, 
      {{ SC_(0.1494682042368e13), SC_(0.6869200625e6), SC_(0.12406291034494643099606037139892578125e-5), SC_(0.71020564354736386412964372076097982309346714376285e-5) }}, 
      {{ SC_(0.15256551424e13), SC_(0.54413439958598412815701968192616533315231208689511e-18), SC_(0.14978477476618266145402813549480924848467111587524e-14), SC_(0.2628091786622991409288218664122349364289339906203e-4) }}, 
      {{ SC_(0.2004127711232e13), SC_(0.16876090995538029053498222195215869301243571953819e-20), SC_(0.557600690481998400170491904e27), SC_(0.76295206423809195123950527899759322897020360023591e-12) }}, 
      {{ SC_(0.2374866305024e13), SC_(0.834580765033977872384e21), SC_(0.15617056749761104583740234375e-1), SC_(0.38855621237058882650617777347259262986882226729037e-9) }}, 
      {{ SC_(0.3359658737664e13), SC_(0.151865482330322265625e1), SC_(0.13662545780395737088e20), SC_(0.24336465654975224562949956315548226157467240178351e-8) }}, 
      {{ SC_(0.3518738464768e13), SC_(0.98092148011034996368806559985387139022350311279297e-13), SC_(0.8399241342592483328e19), SC_(0.30119512602075944403516099459120679758343922354013e-8) }}, 
      {{ SC_(0.395945312256e13), SC_(0.516478977703936e15), SC_(0.68443482659479816375487801854053577534347380106894e-25), SC_(0.16840445084145318025616478254869711358658756939405e-6) }}, 
      {{ SC_(0.4350305370112e13), SC_(0.27039379334450717739301340321646939538764523589583e-28), SC_(0.283915729550307204530176e24), SC_(0.25968789251736065696073448797838569487329819463428e-10) }}, 
      {{ SC_(0.589840515072e13), SC_(0.11837831633021164326650292224515978315498715423004e-25), SC_(0.27219574150194603134877979755401611328125e-7), SC_(0.10210888943426091181542188300687383506678074582093e-4) }}, 
      {{ SC_(0.9603179872256e13), SC_(0.13545880996751469282912694325204938650131225585938e-12), SC_(0.21755331614817437617422269623130535179188855751664e-26), SC_(0.10051279000658905126744286870847035998180162755846e-4) }}, 
      {{ SC_(0.11531852972032e14), SC_(0.28385876039913134187331286456979634325037409325887e-20), SC_(0.10016296110074800369742160704653044511758253065636e-19), SC_(0.11491232280455523495594395757697149408310502282362e-4) }}, 
      {{ SC_(0.51712110886912e14), SC_(0.156551992965379627797503279104e30), SC_(0.47173579223453998565673828125e-2), SC_(0.48549800883733502995596548449202365538551176451306e-13) }}, 
      {{ SC_(0.86229714468864e14), SC_(0.14452686009774895481427847698796540498733520507813e-13), SC_(0.669478515625e5), SC_(0.12787511653115388647783188605551326267855512925765e-5) }}, 
      {{ SC_(0.8952989351936e14), SC_(0.5821022205054759979248046875e-4), SC_(0.16930462580604928e17), SC_(0.30829381796682710715540287058041389212481763230193e-7) }}, 
      {{ SC_(0.3135611338752e15), SC_(0.2348838144e10), SC_(0.111468466401642984919817536137998104095458984375e-9), SC_(0.411529336999849736111827975144371129920083696715e-6) }}, 
      {{ SC_(0.323813657018368e15), SC_(0.156708486328125e5), SC_(0.16682115902222024485246354430501014576293528079987e-14), SC_(0.7369958702644463791880716959576146707074082963075e-6) }}, 
      {{ SC_(0.408575138594816e15), SC_(0.31068275e7), SC_(0.24256317430431744e18), SC_(0.93011599556041195089549598455392793081225298794889e-8) }}, 
      {{ SC_(0.575958067183616e15), SC_(0.23832502919148795513995921571681613215787365334108e-18), SC_(0.26304338632424878383014263958164513645954230014468e-19), SC_(0.16472807796336687254272355247076167177717437685574e-5) }}, 
      {{ SC_(0.95759886188544e15), SC_(0.4659874708323741288040764629840850830078125e-8), SC_(0.727262651482112e15), SC_(0.54310987080128205374622811166750387046051178910953e-7) }}, 
      {{ SC_(0.1551973144854528e16), SC_(0.10139344880747031860591903938868807433237861914677e-19), SC_(0.7740245504e10), SC_(0.19014056115932097753474017298187688901544771405586e-6) }}, 
      {{ SC_(0.1559443435159552e16), SC_(0.1296097951186681029867031611502170562744140625e-9), SC_(0.21495435284055487900379567949710191143708470917773e-19), SC_(0.7663013988695452281243153448807199273373791738192e-6) }}, 
      {{ SC_(0.183459460939776e16), SC_(0.58535432060362684618705258305616519358052915120161e-26), SC_(0.151380081803154098452068865299224853515625e-7), SC_(0.65282997003099132492706966442616652144348025595716e-6) }}, 
      {{ SC_(0.19517472243712e16), SC_(0.36385554182438912e18), SC_(0.4880095232e11), SC_(0.6630186300910710945112087195391194438693488482444e-8) }}, 
      {{ SC_(0.3762704347037696e16), SC_(0.10164524532769642241629852708355797252185587220552e-24), SC_(0.27152649027584e16), SC_(0.2773767331217958147538768064022401224149207791243e-7) }}, 
      {{ SC_(0.4624092787376128e16), SC_(0.60174052366059316378553368571567225298046821535536e-21), SC_(0.10303296875652080092595762343334930266343200944146e-25), SC_(0.64482148940804480722655080486660426128443813677427e-6) }}, 
      {{ SC_(0.6551729407524864e16), SC_(0.25762003497220575809478759765625e-3), SC_(0.156271296e9), SC_(0.12554544166213186687409065239657703785542326674054e-6) }}, 
      {{ SC_(0.6565417468297216e16), SC_(0.174148595112480631422976e24), SC_(0.187841462272e12), SC_(0.23789830484335631441682423081209752700784083266407e-10) }}, 
      {{ SC_(0.7617166912258048e16), SC_(0.78087929856e11), SC_(0.23989477554782208e17), SC_(0.1321701117619106268609736377017578983280864713024e-7) }}, 
      {{ SC_(0.9007602981666816e16), SC_(0.25765624e9), SC_(0.1591604150272e14), SC_(0.47973623298539306302801003699788440227934478669559e-7) }}, 
      {{ SC_(0.18448819419086848e17), SC_(0.55460104261295954577309919031335994077380746603012e-16), SC_(0.154132149174272e16), SC_(0.19605795152909682173633566133900848650726173495414e-7) }}, 
      {{ SC_(0.19790925832126464e17), SC_(0.14673756579750143547516416653309079265454784035683e-15), SC_(0.3067474539712255353944014848e28), SC_(0.25764513023448277884004584901484829276036066859808e-12) }}, 
      {{ SC_(0.25317517949927424e17), SC_(0.168874409984e12), SC_(0.409506688e10), SC_(0.45253530969124872335481458706908818000392720295878e-7) }}, 
      {{ SC_(0.41172763385266176e17), SC_(0.69560673828125e4), SC_(0.747194576263427734375e1), SC_(0.79141392146993468855982671530129098257002288773077e-7) }}, 
      {{ SC_(0.43086235740143616e17), SC_(0.855830077692287144095867031448610084964911948191e-19), SC_(0.1095691093411232941434718668460845947265625e-7), SC_(0.14309200962100351747105894988998450998446737109248e-6) }}, 
      {{ SC_(0.43801356384862208e17), SC_(0.121447060546875e5), SC_(0.7552590468349952e16), SC_(0.11108650085661005775379171351563490905462126914534e-7) }}, 
      {{ SC_(0.59877638017122304e17), SC_(0.53512100536178474827209150532780768116936087608337e-15), SC_(0.60865414403362585004788968196643994088311036341765e-26), SC_(0.15645277736565466376909794371812593761692076170781e-6) }}, 
      {{ SC_(0.62729268668399616e17), SC_(0.10206736333437342809907509471629755506880924287999e-26), SC_(0.81748619457743373061928487104122026290137009371661e-27), SC_(0.20426797977110290222498149823755512183312461311915e-6) }}, 
      {{ SC_(0.95498486157410304e17), SC_(0.71060984495908924431726061148159195715493970237986e-29), SC_(0.61842984e8), SC_(0.38718730304449976538375033243877597551127857381482e-7) }}, 
      {{ SC_(0.11384566732292096e18), SC_(0.58757351632535552e19), SC_(0.273440826416015625e3), SC_(0.13901474047177887628709456683915540756026341189496e-8) }}, 
      {{ SC_(0.128395461743607808e18), SC_(0.206836903384823477636694016e27), SC_(0.53310077419155277311801910400390625e-5), SC_(0.83343627587176997793147406700518956490782999936034e-12) }}, 
      {{ SC_(0.245924553149120512e18), SC_(0.12432241406593107741605394588021265875441186132822e-25), SC_(0.11698430441812742785454260394458960094979845402414e-30), SC_(0.10330525862806096829546465271534602608842300610533e-6) }}, 
      {{ SC_(0.267051548817752064e18), SC_(0.3821992612462592e16), SC_(0.630519962310791015625e1), SC_(0.68089761777131364086674439043639262187908114055846e-8) }}, 
      {{ SC_(0.304309702915784704e18), SC_(0.530327327997952e15), SC_(0.10366431646728266850195727608041629252966231433675e-18), SC_(0.82734731138287298013588108170628196451303991959397e-8) }}, 
      {{ SC_(0.308824435098386432e18), SC_(0.103648125e7), SC_(0.65166045527188006246692084100224917619925690814853e-17), SC_(0.26265753734342834204422422380109679833688799942427e-7) }}, 
      {{ SC_(0.351564170056957952e18), SC_(0.39915753210320770987303899714279126384431587576396e-26), SC_(0.21695373623974084952946051325821291927687106275468e-28), SC_(0.87546059501740626934641113006670674307659349972191e-7) }}, 
      {{ SC_(0.805980574786256896e18), SC_(0.7298279296875e4), SC_(0.135008262029312e15), SC_(0.63866710969527719038738387900072831361451588035511e-8) }}, 
      {{ SC_(0.1054551841401995264e19), SC_(0.149447225428200880514850723557174205780029296875e-10), SC_(0.16248834494529910866838585087421498870385860868737e-21), SC_(0.33692650842823621064004780981931058189924268003096e-7) }}, 
      {{ SC_(0.1855688655151038464e19), SC_(0.1106574030405632e16), SC_(0.6372859541648241998931427328e29), SC_(0.53445215560621261031724116775717209621489642181961e-13) }}, 
      {{ SC_(0.2927755373186121728e19), SC_(0.1103907262575394123707710788799551959726841232623e-19), SC_(0.16709281876399104451896857451468573346753387909303e-21), SC_(0.26595703615542517397196645845468323199908103228872e-7) }}, 
      {{ SC_(0.10280280887589339136e20), SC_(0.49921325198101894818741785761816914940427547878188e-26), SC_(0.5754278161047093248e19), SC_(0.56343122038044392548104906940409766183025596353959e-9) }}, 
      {{ SC_(0.1429457475085533184e20), SC_(0.14041162752e11), SC_(0.16802999673239973138530304e26), SC_(0.20430738758433914727245592579644201870890111941106e-11) }}, 
      {{ SC_(0.16893768561871290368e20), SC_(0.38262641055553103797137737274169921875e-7), SC_(0.56400939474343658730504103004932403564453125e-10), SC_(0.77915261196829271698710270612695654113541336314491e-8) }}, 
      {{ SC_(0.221162365880631296e20), SC_(0.4426536e8), SC_(0.89961878334825112180062577083017316681434749625623e-18), SC_(0.31587331723282902975348605784466775965197768722419e-8) }}, 
      {{ SC_(0.38083625921602912256e20), SC_(0.14043506688e11), SC_(0.13209346463532805303342509972708285204134881496429e-15), SC_(0.19845010460747579268549749986248030274199334150206e-8) }}, 
      {{ SC_(0.39525041685152137216e20), SC_(0.49020114305024e14), SC_(0.42052690625e6), SC_(0.13021232016998762845315311903834202914892122783065e-8) }}, 
      {{ SC_(0.57692237126522896384e20), SC_(0.63429242800339125096797943115234375e-5), SC_(0.31824542466005171886425636864e29), SC_(0.64186366616187505745791782232639309036647875547211e-13) }}, 
      {{ SC_(0.6036870791327383552e20), SC_(0.7191220191232e13), SC_(0.68897207938789506442844867706298828125e-6), SC_(0.12043989455764291795244235497511573734780580101692e-8) }}, 
      {{ SC_(0.113674073964877447168e21), SC_(0.183615109375e6), SC_(0.404058591811917722225189208984375e-4), SC_(0.17272793377359922611700097300655234258649545017537e-8) }}, 
      {{ SC_(0.140771054246300745728e21), SC_(0.4364620208740234375e2), SC_(0.10711124272997777587041261201942927950011067906889e-29), SC_(0.19128232203982141215362761531801216026909489860823e-8) }}, 
      {{ SC_(0.364701990405672009728e21), SC_(0.29044177532196044921875e1), SC_(0.244647525250911712646484375e-1), SC_(0.12796751058826092356060987463454163668644850859444e-8) }}, 
      {{ SC_(0.486625867239520206848e21), SC_(0.2663514463837359985504355062296832912238642165903e-19), SC_(0.4719122320543576863524228422930565122003386188676e-26), SC_(0.21640881527203026013646125580930588180406089788286e-8) }}, 
      {{ SC_(0.532848913858758180864e21), SC_(0.2804503330955387951917145983316004276275634765625e-10), SC_(0.172887280972042231349248e25), SC_(0.41289427669629848273263250460641105378035298472161e-11) }}, 
      {{ SC_(0.834977504013651542016e21), SC_(0.32316998463633678540817957675549120530669733319939e-24), SC_(0.209530830186377414747767033986747264862060546875e-11), SC_(0.13468629907095616040194262714560119999830811101342e-8) }}, 
      {{ SC_(0.949726407769284673536e21), SC_(0.3587426362916534827718351152725517749786376953125e-11), SC_(0.15142064652433650485798833454982273253063182524288e-29), SC_(0.12562432085329481933795569086575968864282984883786e-8) }}, 
      {{ SC_(0.1127446541470904877056e22), SC_(0.3806862878263927996158599853515625e-4), SC_(0.25034581291001142187945358015562879842874632885241e-22), SC_(0.91464529191030229182758659882767566213772192540149e-9) }}, 
      {{ SC_(0.1146824826980038344704e22), SC_(0.123134608e9), SC_(0.36464645756234167146109012677852867501115952109103e-20), SC_(0.481843713604384086249226418621642455904827200248e-9) }}, 
      {{ SC_(0.1672886569909744566272e22), SC_(0.22487528568887739897399753816881196044619173335377e-19), SC_(0.185430274308630309240832e25), SC_(0.35928832700209973551798809255248740015187037925404e-11) }}, 
      {{ SC_(0.188505269646754054144e22), SC_(0.395526275e7), SC_(0.52899930894361691974270976e26), SC_(0.89471124747871019906466742376203647332098667465108e-12) }}, 
      {{ SC_(0.2739399197316094099456e22), SC_(0.49426852584757985376029409962939098477363586425781e-12), SC_(0.81897635816453328380561562228976552058057336580532e-21), SC_(0.76873664982387114218355255082061632943556726749132e-9) }}, 
      {{ SC_(0.3095501916077023035392e22), SC_(0.4245943000138700927533056e25), SC_(0.577969363927259602550259712e27), SC_(0.1589649943264256958882523538760948296999724319185e-12) }}, 
      {{ SC_(0.317074383652647862272e22), SC_(0.89612589356621110444032e24), SC_(0.2342108211970048e16), SC_(0.44476667866878443028414748762621034633361204184133e-11) }}, 
      {{ SC_(0.32148523727519219712e22), SC_(0.60515264161661452673922225736467336588411333742066e-25), SC_(0.787468255232e13), SC_(0.1992955502112844222913985726620659434572497484674e-9) }}, 
      {{ SC_(0.5554756105947418984448e22), SC_(0.10294413942178161764146493602212206752710699220188e-18), SC_(0.92091661616996020185937736612924453538653324358165e-18), SC_(0.62923167961838951063873171166895738374530220191663e-9) }}, 
      {{ SC_(0.6977945379592210481152e22), SC_(0.122192155686207115650177001953125e-3), SC_(0.47637881421824e15), SC_(0.1153564632261944784394049335573252002958633905071e-9) }}, 
      {{ SC_(0.7487427472337473110016e22), SC_(0.2258636851864666112e19), SC_(0.1236770153045654296875e2), SC_(0.62865406558508979854792094110432122986004126530555e-10) }}, 
      {{ SC_(0.7671683806842035634176e22), SC_(0.232967583002618994214572012424468994140625e-7), SC_(0.15159157991879019695426709934960030068396008573472e-17), SC_(0.4038180294041886519355322320606675553072565103795e-9) }}, 
      {{ SC_(0.9581417214429984980992e22), SC_(0.60548121100288e14), SC_(0.4830761391997509580897944218263384646126507721009e-25), SC_(0.11060073021254519253950957826029586265127427792314e-9) }}, 
      {{ SC_(0.13571258581209030066176e23), SC_(0.2301062643527984619140625e-1), SC_(0.14359374149799930542314996273489668965339660644531e-11), SC_(0.24681851380117913347892801570698661675474438359461e-9) }}, 
      {{ SC_(0.20821377315431516209152e23), SC_(0.31614863423832064e17), SC_(0.64014885e7), SC_(0.56032089769057234789734583267962199678627548444354e-10) }}, 
      {{ SC_(0.37633713292972600066048e23), SC_(0.35798815666608753114714008801007788456267201895617e-28), SC_(0.52652046085871970584200887476739039172457523818593e-19), SC_(0.25553690142981741614078754424223919560151234543455e-9) }}, 
      {{ SC_(0.46577155087788907954176e23), SC_(0.46983051300048828125e0), SC_(0.5281802106793520579230971634387969970703125e-8), SC_(0.12909791823805665675979332172144566111247791403463e-9) }}, 
      {{ SC_(0.55817784918415767502848e23), SC_(0.229345916576958775296e21), SC_(0.181080293376e13), SC_(0.1750942517696852947520641867453788486695676626497e-10) }}, 
      {{ SC_(0.62052514199351953719296e23), SC_(0.53361689503260041482896036939970185741799468814861e-19), SC_(0.9145080596241438650400768e25), SC_(0.12855787442319310292082856364396666747106321041193e-11) }}, 
      {{ SC_(0.80186429235745095942144e23), SC_(0.19381367344362132598689640872180461883544921875e-9), SC_(0.79077168410563814020679685421361419447872087573614e-23), SC_(0.13750535060940713040428146298210611313360396461455e-9) }}, 
      {{ SC_(0.210179409744077661405184e24), SC_(0.775467603201754089842406683474462128114628768627e-26), SC_(0.1351436267417501696e19), SC_(0.16061787186106943486599939655138202676282554205658e-10) }}, 
      {{ SC_(0.277204771630374352584704e24), SC_(0.178649388253688812255859375e-1), SC_(0.1626075136e10), SC_(0.33753113782670926573462572782856076414365382937615e-10) }}, 
      {{ SC_(0.286204729096914532827136e24), SC_(0.18205785323743839398957788944244384765625e-7), SC_(0.6443661400749065109504e22), SC_(0.61611589313719506866679280216440715650666946230444e-11) }}, 
      {{ SC_(0.292186842467552253181952e24), SC_(0.8000304500511383121995759616e28), SC_(0.12346179962158203125e2), SC_(0.72616523057308291429033051855939086244674258126817e-13) }}, 
      {{ SC_(0.393077021751861389033472e24), SC_(0.85326592849126535957377352366076878413243909232699e-28), SC_(0.11113272845378330266896682587685063481330871582031e-11), SC_(0.67489587211812322211103469197790993805776456138298e-10) }}, 
      {{ SC_(0.48688847917066659823616e24), SC_(0.12212552573408426924125600686592708205013835254249e-21), SC_(0.1269279595243605041993096779751049041351507185027e-17), SC_(0.70584084700771314846427190765016318786027316462148e-10) }}, 
      {{ SC_(0.1063940752263547436662784e25), SC_(0.72511823806464e14), SC_(0.71711195914758718572556972503662109375e-6), SC_(0.12691455907929889535119333530631167321117700493494e-10) }}, 
      {{ SC_(0.1173381609915570272075776e25), SC_(0.63968165934984593408e20), SC_(0.45652181278958752506159224977408601139211574704291e-23), SC_(0.58112211020391626939353616976453184907767511792909e-11) }}, 
      {{ SC_(0.2582930687253756671688704e25), SC_(0.98294646430729628238873174517209463374456390738487e-16), SC_(0.523289710174790201335781603120267391204833984375e-10), SC_(0.25714555063314296471836451648878971406174986469531e-10) }}, 
      {{ SC_(0.4250650378642010683736064e25), SC_(0.556707755327488e15), SC_(0.11061723157371115940205422633821341626969569915673e-24), SC_(0.61911313046606461828731042102268373625125922526936e-11) }}, 
      {{ SC_(0.6959596827501176488460288e25), SC_(0.56396991515163736959758100092886750224006554485772e-29), SC_(0.164767579074269378772992e24), SC_(0.12400935059791630763953427454646048782024565915924e-11) }}, 
      {{ SC_(0.952333915392338525421568e25), SC_(0.880691654814744548025200279552e30), SC_(0.154135841378084202520367857664e30), SC_(0.246177174705776556085118115429848578000397850452e-14) }}, 
      {{ SC_(0.18820064668587267094216704e26), SC_(0.302210201308383830109960399568080902099609375e-9), SC_(0.33895318467300131244893458519885746926814107382597e-21), SC_(0.95534164617635088562542388865960418859145954910582e-11) }}, 
      {{ SC_(0.30659185015094057321365504e26), SC_(0.7833119869232177734375e1), SC_(0.1693339353088e13), SC_(0.30069886354161477220500208874734175760615704540309e-11) }}, 
      {{ SC_(0.34176589422481911700258816e26), SC_(0.2594374745967797935009002685546875e-4), SC_(0.32639631015324299667668128677178174257278442382813e-11), SC_(0.61686726715099850869664269896236478457721173132798e-11) }}, 
      {{ SC_(0.66192871423119660955992064e26), SC_(0.65104581211365760324995297566040105840304400052279e-28), SC_(0.700861590985368820838630199432373046875e-9), SC_(0.51196495026574394146099382874482062017583142405701e-11) }}, 
      {{ SC_(0.8845430532586596087103488e26), SC_(0.19398925304412841796875e1), SC_(0.41011344364960677921772003173828125e-6), SC_(0.32883289253336466203877579763959792657158933119763e-11) }}, 
      {{ SC_(0.9036469625899950631026688e26), SC_(0.690641880035400390625e1), SC_(0.1238969862461090087890625e0), SC_(0.31745434338722854630828915646448539066116092136479e-11) }}, 
      {{ SC_(0.26160499139176195703177216e27), SC_(0.25551566240720070127823149164214555639773607254028e-14), SC_(0.2455513858048e13), SC_(0.10841986934216006931865443143259911799200916785229e-11) }}, 
      {{ SC_(0.351293559140227787146657792e27), SC_(0.92746285056e12), SC_(0.7325884342193603515625e1), SC_(0.96945165287587645794032553087381848752888109990602e-12) }}, 
      {{ SC_(0.48555353730121618377670656e27), SC_(0.41366469991877353664505423235416110752209856263632e-29), SC_(0.1080339869874636584075679427013641468012674864323e-29), SC_(0.29736856860648111150067984819515308053148330813485e-11) }}, 
      {{ SC_(0.576385747842019784963129344e27), SC_(0.42413690615195065447551314719021320343017578125e-10), SC_(0.429480374875002013368430198170244693756103515625e-10), SC_(0.18094440824622577258491088407553210906682687995255e-11) }}, 
      {{ SC_(0.861307183935277657013354496e27), SC_(0.13938332907855510711669921875e-1), SC_(0.68459855298386769923242872813539959368599538368623e-30), SC_(0.11766749224716932927375683670462877212205767926654e-11) }}, 
      {{ SC_(0.105505156605401800151924736e28), SC_(0.36789907058298876307844693656079471111297607421875e-11), SC_(0.10516135122406685860405589982143287428734135247055e-23), SC_(0.14057878532181048238381113039649629348002517816159e-11) }}, 
      {{ SC_(0.3196617981363007079661436928e28), SC_(0.357227936120807498809881508350372314453125e-8), SC_(0.190531306287766710738651454448699951171875e-7), SC_(0.73543482163433806936996915244342283274029549975336e-12) }}, 
      {{ SC_(0.4932620110638545248192561152e28), SC_(0.39087764918804168701171875e-1), SC_(0.37496308203098109226999139757157200603110425163322e-21), SC_(0.49677918885669315094834554588390832782238505953762e-12) }}, 
      {{ SC_(0.516425012058796509045456896e28), SC_(0.3000732163818651513042917353020530062720192427143e-28), SC_(0.28816120624542236328125e1), SC_(0.45590953716748809622767271344568834414324208839861e-12) }}, 
      {{ SC_(0.6724360036363488659828113408e28), SC_(0.39914275e7), SC_(0.5617260831058956682682037353515625e-4), SC_(0.3149211786161963517965091650354250566920868130489e-12) }}, 
      {{ SC_(0.7376334675354954747676196864e28), SC_(0.3832167254355459644063744e25), SC_(0.86986000872677090266227306614155168063007295131683e-15), SC_(0.60174664703890956134939928112815630373518374796924e-13) }}, 
      {{ SC_(0.1240879712420966629044649984e29), SC_(0.35030939907262229474824187104684165838808240778235e-22), SC_(0.23553908385443359223970771765266363217961043119431e-16), SC_(0.47464339774120723669000561802171052279059315153073e-12) }}, 
      {{ SC_(0.13622372113626680630865559552e29), SC_(0.5065993732313771067901500902430633743733778828755e-18), SC_(0.1568245533434264871175400912761688232421875e-11), SC_(0.40583512551936497170672012442547588122036553493224e-12) }}, 
      {{ SC_(0.21413030105610117647127543808e29), SC_(0.56796892335439872e17), SC_(0.44545595303495604738852208133448318250202646595426e-19), SC_(0.10055266250578662063485344934342287093203087991764e-12) }}, 
      {{ SC_(0.240611655851932728105631744e29), SC_(0.15126033260477136128765155826087636266509091563425e-30), SC_(0.147685372829437255859375e1), SC_(0.21832951144880765009500199074282822236333957933832e-12) }}, 
      {{ SC_(0.61731988312258099732254031872e29), SC_(0.47155488899394500240213479534565823420775918905622e-28), SC_(0.4463543296e10), SC_(0.94272971828494080864224866724511415301020102514649e-13) }}, 
      {{ SC_(0.74469943825056746033385570304e29), SC_(0.25381451890023692523876122624e29), SC_(0.353061568e9), SC_(0.73993207202984769111475156231178550093712585836288e-14) }}, 
      {{ SC_(0.117661009908837424815142862848e30), SC_(0.434518829345703125e3), SC_(0.429355800151824951171875e0), SC_(0.9266881807310148034392861576649650379030278607074e-13) }}, 
      {{ SC_(0.593089902380358100434877939712e30), SC_(0.6506956228718475954142519412926048971712589263916e-14), SC_(0.61562469482421875e2), SC_(0.43634363152950073747311554335524072760111106270713e-13) }}, 
      {{ SC_(0.1138966491359350198995104301056e31), SC_(0.16628866613248e14), SC_(0.83722254681922700089433337836521478725337885862245e-21), SC_(0.19460821722924338220942178264562269988472467417183e-13) }}
   }};

