target=chaine1 chaine2 chaine3

\integer{n=\confparm1=1?randint(6..8)}
\integer{n=\confparm1=2?randint(9..11)}
\integer{n=\confparm1=3?randint(12..14)}
\integer{n=\confparm1=?randint(4..8)}

#if #TARGET (chaine1)
 \title{Chanes dans un graphe}
 \author{Romain BOILLAUD}
\email{Romain.Boillaud@wanadoo.fr}
#endif

#if #TARGET (chaine2)
 \title{Nombre de chanes entre deux sommets}
 \author{Bernadette PERRIN-RIOU}
#endif

#if #TARGET (chaine3)
 \title{Nombre de chanes entre deux sommets II}
 \author{Bernadette PERRIN-RIOU}
#endif

#if #TARGET (chaine3) || #TARGET (chaine2)
\integer{k=\confparm1=?randint(2..3)}
\integer{k=\confparm1=1?randint(2..3)}
\integer{k=\confparm1=2?randint(3..4)}
\integer{k=\confparm1=3?randint(4..5)}
#endif
\language{fr}
\range{-5..5}
\computeanswer{no}
\format{html}
\precision{10000}

\integer{N=\n-1}
\integer{M=max(\N/3,3)}
\text{HH=pari(2+3)}
\integer{s=randint(\M..\N)}
\matrix{G=pari(n=\n;
M=matrix(n,n,i,j,1);
for(i=2,\s,M[i-1,i]=0);
M=matrix(n,n,i,j,if(M[i,j], random\(2), 1));
for(i=1,n,M[i,i]=0);matrix(n,n,i,j,M[min(i,j),max(i,j)]))}


\matrix{p=shuffle(\n)}
\matrix{G=pari(p=[\p];G=Mat([\G]);matrix(n,n,i,j,G[p[i],p[j]]))}

\text{dessin=slib(graph/draw [\G])}

#if #TARGET (chaine1)

\matrix{chiffre=un, deux, trois, quatre, cinq, six, sept, huit, neuf,dix,onze,douze,treize,quatorze}
\text{chiffre=item(\s, \chiffre)}

\statement{On considre le graphe reprsent ci-dessous : 
<center> \draw{200,200}{\dessin} </center>
Donner une chane de ce graphe, contenant exactement \chiffre artes distinctes (on donnera la liste de ses sommets numrots comme sur le dessin). 
}

\answer{Chane}{\rep1}{vector}
\integer{m=items(\rep1)}
\matrix{v=pari(V=matrix(1,(\m)-1,i,j,0);print(V))}
\matrix{a=pari(A=matrix(\n,\n,i,j,0);print(A))}
\matrix{b=\a}
\integer{b=1}
\for{i=1 to ((\m)-1)}{
  \integer{I=item(\i,\rep1)}
  \integer{J=item((\i)+1,\rep1)}
  \integer{u=item(\I,row(\J,\G))}
  \matrix{v=wims(replace item number \i by \u in \v)}
  \integer{u=item(\I,row(\J,\a))}
  \if{\u=0}{
    \matrix{a=pari(A=[\a];A[\I,\J]=1;A[\J,\I]=1;print(A))}
    matrix{c=row(\J,\A)}
    matrix{c=wims(replace item number \I by 1 in \c)}
    matrix{A=wims(replace line number \J by \c in \A)}
  }{\integer{b=0}}
}
\integer{r=0 isin \v ?0:1}
\condition{Chane  \s artes}{(\m=(\s)+1) and (\r=1) and (\b=1)}
\feedback{\m<>(\s)+1}{La chane que vous avez entre ne contient pas le bon nombre de sommets.}
\if{\r=0}{
  \integer{test=0}
  \for{i=1 to \n}{
    \if{item(\i,\v)=0 and \test=0}{\integer{test=\i}}
  }
}
\text{a1=item(\test,\rep1)}
\text{a2=item(\test+1,\rep1)}
\feedback{\r=0}{Une des artes que vous avez cites n&#39;en est pas une... Par exemple, il  n&#39;y a pas d&#39;arte reliant les sommets \a1 et \a2.}
\feedback{\b=0}{Vous utilisez deux fois la mme arte.}
#endif

#if #TARGET (chaine2) || #TARGET (chaine3)
\text{liste=shuffle(\n)}
\text{i=item(1, \liste)}
\text{j=item(2, \liste)}
\matrix{B=pari(A=Mat([\G]); B=A^\k)}
\text{b=\B[\i;\j]}
#endif

#if #TARGET (chaine2)
\statement{On considre le graphe reprsent ci-dessous : 
<center> \draw{200,200}{\dessin} </center>
Combien de chanes de longueur \k existe-t-il entre les sommets \i et \j ? }

\answer{Longueur \k entre \i et \j}{\b}{type = numeric}
#endif

#if #TARGET (chaine3)

\statement{On considre le graphe reprsent ci-dessous : 
<center> \draw{200,200}{\dessin} </center>
Il y exactement \b \if{\b<2}{chane}{chanes} de longueur \k entre le sommet \i et un autre sommet. Trouver ce sommet (il peut y en avoir plusieurs, mais on n'en demande qu'un seul)}
\answer{Sommet}{\rep}{type = numeric}

\text{c= \B[\i;\rep]}
\text{S=\c=\b ? 1:0}
\condition{Sommet}{\S=1}

\feedback{\S=0}{Une rponse possible est le sommet \j . Par contre, il y a exactement \c chanes de longueur \k entre \i et \rep}

#endif