/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.ArrayUtil;
import com.sun.appserv.management.util.misc.IteratorUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.util.Arrays;
import java.util.Collection;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static String toString(Collection c, String delim) {
        Object[] strings = CollectionUtil.toStringArray(c);
        Arrays.sort(strings);
        return StringUtil.toString(delim, strings);
    }

    public static String toString(Collection c) {
        return CollectionUtil.toString(c, ", ");
    }

    public static <T> T getSingleton(Collection<T> s) {
        if (s.size() != 1) {
            throw new IllegalArgumentException();
        }
        return s.iterator().next();
    }

    public static <T> void addArray(Collection<T> c, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            c.add(array[i]);
        }
    }

    public static String[] toStringArray(Collection c) {
        String[] strings = new String[c.size()];
        int i = 0;
        for (Object o : c) {
            strings[i] = SmartStringifier.toString(o);
            ++i;
        }
        return strings;
    }

    public static <T> T[] toArray(Collection<? extends T> c, Class<T> elementClass) {
        T[] items = ArrayUtil.newArray(elementClass, c.size());
        c.toArray(items);
        return items;
    }

    public static boolean isAllStrings(Collection<?> c) {
        return IteratorUtil.getUniformClass(c.iterator()) == String.class;
    }
}

