/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "modulepagewidget.h"
#include "ui_modulepagewidget.h"

#include <QListWidgetItem>
#include <QDebug>

#include "mainwindow.h"
#include "interface.h"
#include "utils/functionselect.h"
#include "interface/ukcccommon.h"
using namespace ukcc;
#include "component/leftwidgetitem.h"
#include "component/leftmenulist.h"
#include <QScrollBar>

ModulePageWidget::ModulePageWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ModulePageWidget)
{
    ui->setupUi(this);
    initUI();
}

ModulePageWidget::~ModulePageWidget()
{
    delete ui;
    ui = nullptr;
}

void ModulePageWidget::initUI() {
    //设置伸缩策略

    QSizePolicy rightSizePolicy = ui->widget->sizePolicy();

    rightSizePolicy.setHorizontalStretch(5);

    ui->widget->setSizePolicy(rightSizePolicy);
    ui->widget->setObjectName("widget");
    ui->scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
    ui->scrollArea->verticalScrollBar()->setHidden(true);
    connect(ui->scrollArea->verticalScrollBar(),&QScrollBar::rangeChanged,this, [=](){
        if (ui->scrollArea->verticalScrollBar()->maximum() == 0) {
            ui->scrollArea->verticalScrollBar()->setHidden(true);
        } else {
            ui->scrollArea->verticalScrollBar()->setHidden(false);
        }
    });
    connect(ui->scrollArea->horizontalScrollBar(), &QScrollBar::rangeChanged, this, [=](){
        if (ui->scrollArea->horizontalScrollBar()->maximum() == 0) {
            emit hScrollBarHide();
        } else {
            emit hScrollBarShow();
        }
    });

    //设置qss之后,点击屏保再主页进入插件会卡死,原因未知
//    ui->scrollArea->setStyleSheet("QScrollArea{background-color: palette(window);}");
    ui->scrollArea->verticalScrollBar()->setProperty("drawScrollBarGroove", false);
}

void ModulePageWidget::switchPage(QObject *plugin, bool recorded, QString jumpText){
    Q_UNUSED(recorded);
    CommonInterface * pluginInstance = qobject_cast<CommonInterface *>(plugin);
    refreshPluginWidget(pluginInstance);
    if (jumpText.isEmpty() || !pluginwidget) {
        return;
    }
    for (QLabel *o : pluginwidget->findChildren<QLabel*>()) {
        if (o->text() == jumpText) {
            QPoint pos = o->mapTo(ui->scrollArea->widget(), o->pos());
            int widgetHeight = ui->scrollArea->widget()->height();
            int areaHeight   = ui->scrollArea->height();
            if (pluginInstance->name() == "Theme") {
               pos.setY(pos.y()/2);
            }
            int maxNum = widgetHeight - areaHeight;
            int value = pos.y() + o->height() - areaHeight;
            value = value + areaHeight/2; //尽量让选中的显示在中间位置
            if (value <= 0) {
               ui->scrollArea->verticalScrollBar()->setValue(0);
            } else if (value > maxNum){
                ui->scrollArea->verticalScrollBar()->setValue(maxNum);
            } else {
               ui->scrollArea->verticalScrollBar()->setValue(value);
            }
            return;
       }
    }
}

void ModulePageWidget::refreshPluginWidget(CommonInterface *plu){
    if (plu->pluginBtn) {
        plu->pluginBtn->setCheckState(Qt::Checked);
    }
    prePlugin = currentPlugin;
    if (prePlugin) {
        qInfo()<<"plugin_leave(): "<<prePlugin->name();
        prePlugin->plugin_leave();
    }
    currentPlugin = plu;
    ui->scrollArea->takeWidget();
    delete(ui->scrollArea->widget());

    pluginwidget =  plu->pluginUi();
    qInfo()<<"pluginUi(): "<<currentPlugin->name();
    pluginwidget->setContentsMargins(24,0,4,40);
    ui->scrollArea->setWidget(pluginwidget);
    mCurrentPluName = plu->name();

    //记录打开历史
    if (flagBit){
        FunctionSelect::pushRecordValue(plu->pluginTypes(), plu->plugini18nName());
    }

    //恢复标志位
    flagBit = true;
}

void ModulePageWidget::pluginLeave()
{
    if (currentPlugin) {
        currentPlugin->plugin_leave();
    }
}

