/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2011  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of web browser Links 0.96

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#ifndef __HEADER_H
#define __HEADER_H


#ifdef _MSC_VER
#include "msvc.h"
#endif

#ifdef __MINGW32__
#include "mingw.h"
#endif

#include <glib.h>
#include <glib/gprintf.h>


#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#ifndef __USE_POSIX 
#define __USE_POSIX
#endif
#ifndef __USE_POSIX2
#define __USE_POSIX2
#endif
#ifndef __USE_MISC
#define __USE_MISC
#endif
#ifndef __USE_BSD
#define __USE_BSD
#endif

#ifdef HAVE_MATH_H
#include <math.h>
#endif
 
#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#include <stdio.h>


#include <stdlib.h>
#include <stdarg.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <ctype.h>
#include <string.h>
#include <errno.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
//#include <sys/file.h>  not in msvc10
#include <sys/types.h>
#include <sys/stat.h>

#include "os_dep.h"

#ifdef TIME_WITH_SYS_TIME
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#ifdef HAVE_TIME_H
#include <time.h>
#endif
#else
#if defined(TM_IN_SYS_TIME) && defined(HAVE_SYS_TIME_H)
#include <sys/time.h>
#elif defined(HAVE_TIME_H)
#include <time.h>
#endif
#endif

#include <sys/stat.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#include <signal.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef HAVE_NETINET_IN_SYSTM_H
#include <netinet/in_systm.h>
#else
#ifdef HAVE_NETINET_IN_SYSTEM_H
#include <netinet/in_system.h>
#endif
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_WINSOCK2_H
#include <winsock2.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#ifdef HAVE_NETINET_IP_H
#include <netinet/ip.h>
#endif
#ifdef HAVE_UTIME_H
#include <utime.h>
#endif
#ifdef HAVE_PWD_H
#include <pwd.h>
#endif
#ifdef HAVE_GRP_H
#include <grp.h>
#endif
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif


#ifdef HAVE_PTY_H
#include <pty.h>
#endif

#ifdef __CYGWIN__
#include <windows.h>
#endif

#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif

#ifdef HAVE_SDL
#include <SDL.h>
#include <SDL_thread.h>
#include <SDL_endian.h>
#endif

#ifdef HAVE_PNG_H
#include <png.h>
#endif

#ifdef HAVE_SYS_SOUNDCARD_H
#include <sys/soundcard.h>
#define HAVE_OSS
#endif

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#ifdef HAVE_SNDFILE
#include <sndfile.h>
#endif

#ifdef HAVE_LINUX_PPDEV_H
# include <linux/ppdev.h>
# include <linux/parport.h>
#endif

#ifdef HAVE_ALSA
#define ALSA_PCM_NEW_HW_PARAMS_API
#define ALSA_PCM_NEW_SW_PARAMS_API
#include <alsa/asoundlib.h>
#endif

#ifdef HAVE_HAMLIB
#include <hamlib/rig.h>
#include <hamlib/rotator.h>
#endif

#ifdef HAVE_LIBFFTW3
#include <fftw3.h>
#endif

#ifdef __GLIBC__
#include <gnu/libc-version.h>
#endif

#ifdef HAVE_ICONV_H
#include <iconv.h> 
#endif

#ifndef HAVE_UINT32_T
#if SIZEOF_CHAR == 4
typedef unsigned char uint32_t;
#elif SIZEOF_SHORT == 4
typedef unsigned short uint32_t;
#elif SIZEOF_INT == 4
typedef unsigned int uint32_t;
#elif SIZEOF_LONG == 4
typedef unsigned long uint32_t;
#elif defined(HAVE_LONG_LONG) && SIZEOF_LONG_LONG == 4
typedef unsigned long long uint32_t;
#else
#error You have no 32-bit integer type. Get in touch with reality.
#endif
#endif

#ifdef HAVE_LONG_LONG
#define longlong long long
#else
#define longlong long
#endif

/* integer type same size as void *   */
#undef vint
#if SIZEOF_SHORT == SIZEOF_VOID_P
typedef short vint;
#elif SIZEOF_INT == SIZEOF_VOID_P
typedef int vint;
#elif SIZEOF_LONG == SIZEOF_VOID_P
typedef long vint;
#elif defined(HAVE_LONG_LONG) && SIZEOF_LONG_LONG == SIZEOF_VOID_P
typedef long long vint;
#else
#error You have no integer type of size void *
#endif

#ifdef TERMIOS_H
#include <termios.h>
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif


#ifdef HAVE_LIBFTDI
#include <ftdi.h>
#endif

#include "setup.h"
#include "interfaces.h"
#include "iarray.h"

#define DUMMY ((void *)-1L)

#ifdef _MSC_VER
#define __MSVC2
#include "msvc.h"
#undef __MSVC2
#endif

#ifdef __MINGW32__
#define __MINGW2
#include "mingw.h"
#undef __MINGW2
#endif

#ifdef __CYGWIN__
/* cfmakeraw is missing in cygwin. If fails in future versions of cywin, remove it */
void cfmakeraw (struct termios *);
#endif
	

/* for BSD */
#ifndef SOUND_MIXER_LINE 
#define SOUND_MIXER_LINE 6
#endif

#ifndef SOUND_MIXER_MIC 
#define SOUND_MIXER_MIC 7
#endif


#undef USE_FFT
#if defined(HAVE_LIBFFTW3) && defined(HAVE_SDL)
#define USE_FFT
#endif


/* FIXME 
#ifndef HAVE_SOCKLEN_T
typedef unsigned int __socklen_t;
typedef __socklen_t socklen_t;
#define __socklen_t_defined
#endif
*/

/*#ifndef _MSC_VER
int fileno(FILE *stream);
#endif*/


struct menu_item;
struct qso;
struct tmpqso;
struct cwdaemon;
struct cq;
struct itrm;
struct refresh;
struct net;
struct conn;
struct gpm_mouse_spec;
struct rotar;
struct sconn;
struct ssbd;
struct subwin;
struct ntpq;
struct zstring;
struct config_rotar;
enum extcq;
struct qrv_item;
struct qrvdb;
struct spot;
struct chband;
struct httpconn;

#ifdef _MSC_VER
typedef void * cba_t;
#define GETCBA(var, item) (var)
#define SETCBA(var, item, value) var = (void*)(value)
#define CBA0 NULL
#else
typedef union cba_t{
    char *charp;
    void *void_;
    int int_;
    struct menu_item *menu_item;
    struct qso *qso;
    struct tmpqso *tmpqso;
    struct cwdaemon *cwda;
    struct cq *cq;
    struct itrm *itrm;
    struct refresh *refresh;
    struct net *net;
    struct conn *conn;
    struct gpm_mouse_spec *gpm_mouse_spec;
    struct rotar *rotar;
    struct sconn *sconn;
    struct ssbd *ssbd;
    struct subwin *subwin;
    struct ntpq *ntpq;
    struct config_rotar *config_rotar;
    struct qrv_item *qrv_item;
    struct chband *chband;
	struct httpconn *httpconn;
}cba_t;
//#define TOCBA(arg) ((union cba_t)(arg))
#define GETCBA(var, item) (var.item)
#define SETCBA(var, item, value) var.item = (value)
//#define CBA0 inline_cba0()
#define CBA0 ((union cba_t)0)
#endif



#define MUTEX_INIT(x) x##_mutex = g_mutex_new()
#define MUTEX_FREE(x) g_mutex_free(x##_mutex)

#ifdef LEAK_DEBUG_LIST

#define MUTEX_DEFINE(x) \
    GMutex *x##_mutex; \
    char *x##_file; \
    int x##_line;

#define MUTEX_LOCK(x) { \
    g_mutex_lock(x##_mutex); \
    x##_file = __FILE__; \
    x##_line = __LINE__; \
}

#define MUTEX_TRYLOCK(x) { \
    g_mutex_trylock(x##_mutex); \
    x##_file = __FILE__; \
    x##_line = __LINE__; \
}

#define MUTEX_UNLOCK(x) g_mutex_unlock(x##_mutex)

#else

#define MUTEX_DEFINE(x) GMutex *x##_mutex
#define MUTEX_LOCK(x) g_mutex_lock(x##_mutex)
#define MUTEX_TRYLOCK(x) g_mutex_trylock(x##_mutex)
#define MUTEX_UNLOCK(x) g_mutex_unlock(x##_mutex)

#endif

/*#define LOCK(x)    dbg("   lock %p %s:%d\n", x##_mutex, __FILE__, __LINE__); g_mutex_lock(x##_mutex)
#define UNLOCK(x)  dbg(" unlock %p %s:%d\n", x##_mutex, __FILE__, __LINE__); g_mutex_unlock(x##_mutex)
  */
/* error.c */

extern int debug_type;
extern char *debug_filename;

void do_not_optimize_here(void *p);
void check_memory_leaks(void);
void error(char *, ...);
void debug_msg(char *, ...);
void internal_error( char *, ...);

void init_debug(void);
void free_debug(void);

void dbg(char *m, ...) __attribute__((no_instrument_function));
void trace(int enable, char *m, ...);

void sock_debug(int sock, char *m, ...);
void dbg_str_hash(GHashTable *hash);
extern int errline;
extern char *errfile;

#define internal_ errfile = __FILE__, errline = __LINE__, internal_error
#define debug errfile = __FILE__, errline = __LINE__, debug_msg

#define xmalloc malloc
#define xfree free
#define xrealloc realloc



#ifdef LEAK_DEBUG

extern long mem_amount;
extern long last_mem_amount;

#ifndef LEAK_DEBUG_LIST
struct alloc_header {
    int size;
};
#else
#define MCHK_LEAD 8
#define MCHK_TRAIL 8
#define MCHK_PATTERN ((char)0xee)
struct alloc_header {
    struct alloc_header *next;
    struct alloc_header *prev;
    int size;
    int line;
    char *file;
    char *comment;
};
#endif

#define L_D_S ((sizeof(struct alloc_header) + MCHK_LEAD + 7) & ~7)

#endif

#ifdef LEAK_DEBUG

void *debug_mem_alloc(char *, int, size_t);
void debug_mem_free(char *, int, void *);
void *debug_mem_realloc(char *, int, void *, size_t);
void set_mem_comment(void *, char *, int);
void *debug_g_new0(char *, int, size_t);
void *debug_g_new(char *, int, size_t);
gchar *debug_g_strdup(char *, int, const gchar *);
gchar *debug_g_strndup(char *, int, gchar *, gint);
gchar *debug_g_strdup_printf(char *, int, gchar *, ...);
gchar *debug_g_strdup_vprintf(char *, int, gchar *, va_list args);
gchar *debug_g_strconcat(char *, int, ...);

#define mem_alloc(x) debug_mem_alloc(__FILE__, __LINE__, x)
#define mem_free(x) debug_mem_free(__FILE__, __LINE__, x)
#define mem_realloc(x, y) debug_mem_realloc(__FILE__, __LINE__, x, y)
#undef g_new0
#define g_new0(x, y) debug_g_new0(__FILE__, __LINE__, sizeof(x)* y)        
#undef g_new
#define g_new(x, y) debug_g_new0(__FILE__, __LINE__, sizeof(x)* y)        
#define g_free(x) debug_mem_free(__FILE__, __LINE__, x)
#define g_realloc(x, y) debug_mem_realloc(__FILE__, __LINE__, x, y)
#undef g_renew
#define g_renew(t, m, n) debug_mem_realloc(__FILE__, __LINE__, m, sizeof(t) * n)
#define g_strdup(x) debug_g_strdup(__FILE__, __LINE__, x) 
#define g_strndup(x,y) debug_g_strndup(__FILE__, __LINE__, x, y) 
#define g_strdup_printf(x...) debug_g_strdup_printf(__FILE__, __LINE__, x) 
#define g_strdup_vprintf(x, y) debug_g_strdup_vprintf(__FILE__, __LINE__, x, y) 
#define g_strconcat(x...) debug_g_strconcat(__FILE__, __LINE__, x) 


#else

static inline void *mem_alloc(size_t size)
{
    void *p;
    if (!size) return DUMMY;
    if (!(p = malloc(size))) {
        error("ERROR: out of memory (malloc returned NULL)\n");
        return NULL;
    }
    return p;
}

static inline void mem_free(void *p)
{
    if (p == DUMMY) return;
    if (!p) {
        internal_("mem_free(NULL)");
        return;
    }
    free(p);
}

static inline void *mem_realloc(void *p, size_t size)
{
    if (p == DUMMY) return mem_alloc(size);
    if (!p) {
        internal_("mem_realloc(NULL, %d)", size);
        return NULL;
    }
    if (!size) {
        mem_free(p);
        return DUMMY;
    }
    if (!(p = realloc(p, size))) {
        error("ERROR: out of memory (realloc returned NULL)\n");
        return NULL;
    }
    return p;
}

static inline void *debug_mem_alloc(char *f, int l, size_t s) { return mem_alloc(s); }
static inline void debug_mem_free(char *f, int l, void *p) { mem_free(p); }
static inline void *debug_mem_realloc(char *f, int l, void *p, size_t s) { return mem_realloc(p, s); }
static inline void set_mem_comment(void *p, char *c, int l) {}

#endif

static inline char upcase(char a)
{
    if (a>='a' && a<='z') a -= 0x20;
    return a;
}

static inline char lowcase(char a)
{
    if (a>='A' && a<='Z') a += 0x20;
    return a;
}

static inline char *lc(char *str){
    char *c;
    
    if (!str) return str;
    c=str;
    while (*c!='\0'){
        if (*c>='A' && *c<='Z') *c+=0x20;
        c++;
    }
    return str;
}

static inline char *uc(char *str){
    char *c;
    
    if (!str) return str;
    c=str;
    while (*c!='\0'){
        if (*c>='a' && *c<='z') *c-=0x20;
        c++;
    }
    return str;
}

static inline char *fixsemi(char *str){
    char *c;
    
    if (!str) return str;
    c=str;
    while (*c!='\0'){
        if (*c==';') *c=':';
        c++;
    }
    return str;
} 

static inline char *chomp(char *s){
    int l;

    l = strlen(s);
    if (l > 0 && s[l - 1] == '\n') {
        s[l - 1] = '\0'; 
        l--;
    }
    if (l > 0 && s[l - 1] == '\r') s[l - 1] = '\0';

    return s;
}


static inline char *trim(char *s){
    char *c;

    if (!s || !*s) return s;
    for (c=s+strlen(s)-1; c>s; c--) {
        if (*c != ' ') break;
        *c = '\0';
    }
    for (c=s; *c!='\0'; c++) if (*c != ' ') break;
    return c;
}


static inline gchar *g_strdup_trim(gchar *s){
    gchar *c1, *c2;
    c1 = g_strdup(s);
    c2 = g_strdup(trim(c1));
    g_free(c1);
    return c2;
}

/*static inline int cmpbeg(char *str, char *b)
{
    while (*str && upcase(*str) == upcase(*b)) str++, b++;
    return !!*b;
} */


#if !(defined(LEAK_DEBUG) && defined(LEAK_DEBUG_LIST))

static inline char *memacpy(const char *src, int len)
{
    char *m;
    if ((m = mem_alloc(len + 1))) {
        memcpy(m, src, len);
        m[len] = 0;
    }
    return m;
}

static inline char *stracpy(const char *src)
{
    return src ? memacpy(src, src != DUMMY ? strlen(src) : 0) : NULL;
}

#else

static inline char *debug_memacpy(char *f, int l, char *src, int len)
{
    char *m;
    if ((m = debug_mem_alloc(f, l, len + 1))) {
        memcpy(m, src, len);
        m[len] = 0;
    }
    return m;
}

#define memacpy(s, l) debug_memacpy(__FILE__, __LINE__, s, l)

static inline char *debug_stracpy(char *f, int l, char *src)
{
    return src ? debug_memacpy(f, l, src, src != DUMMY ? strlen((char*)src) : 0) : NULL;
}

#define stracpy(s) debug_stracpy(__FILE__, __LINE__, s)

#endif
  
static inline int snprint(char *s, int n, unsigned num)
{
    int q = 1;
    while (q <= num / 10) q *= 10;
    while (n-- > 1 && q) *(s++) = num / q + '0', num %= q, q /= 10;
    *s = 0;
    return !!q;
}

static inline int snzprint(char *s, int n, int num)
{
    if (n > 1 && num < 0) *(s++) = '-', num = -num, n--;
    return snprint(s, n, num);
}

static inline void add_to_strn(char **s, char *a)
{
    char *p;
    if (!(p = mem_realloc(*s, strlen(*s) + strlen(a) + 1))) return;
    strcat(p, a);
    *s = p;
}

#define ALLOC_GR    0x100       /* must be power of 2 */

#define init_str() init_str_x(__FILE__, __LINE__)

static inline char *init_str_x(char *file, int line)
{
    char *p;
    if ((p = debug_mem_alloc(file, line, ALLOC_GR))) *p = 0;
    return p;
}

static inline void add_to_str(char **s, int *l, char *a)
{
    char *p;
    int ll = strlen(a);
    if ((*l & ~(ALLOC_GR - 1)) != ((*l + ll) & ~(ALLOC_GR - 1)) &&
       (!(p = mem_realloc(*s, (*l + ll + ALLOC_GR) & ~(ALLOC_GR - 1))) ||
       !(*s = p))) return;
    strcpy(*s + *l, a); *l += ll;
}

/*static inline void add_bytes_to_str(char **s, int *l, char *a, int ll)
{
    char *p;
    if ((*l & ~(ALLOC_GR - 1)) != ((*l + ll) & ~(ALLOC_GR - 1)) &&
       (!(p = mem_realloc(*s, (*l + ll + ALLOC_GR) & ~(ALLOC_GR - 1))) ||
       !(*s = p))) return;
    memcpy(*s + *l, a, ll); (*s)[*l += ll] = 0;
} */

static inline void add_chr_to_str(char **s, int *l, char a)
{
    char *p;
    if ((*l & (ALLOC_GR - 1)) == ALLOC_GR - 1 &&
       (!(p = mem_realloc(*s, (*l + 1 + ALLOC_GR) & ~(ALLOC_GR - 1))) ||
       !(*s = p))) return;
    *(*s + *l) = a; *(*s + ++(*l)) = 0;
}

static inline void add_num_to_str(char **s, int *l, int n)
{
    char a[64];
    snzprint(a, 64, n);
    add_to_str(s, l, a);
}

/*static inline void add_knum_to_str(char **s, int *l, int n)
{
    char a[13];
    if (n && n / (1024 * 1024) * (1024 * 1024) == n) snzprint(a, 12, n / (1024 * 1024)), strcat(a, "M");
    else if (n && n / 1024 * 1024 == n) snzprint(a, 12, n / 1024), strcat(a, "k");
    else snzprint(a, 13, n);
    add_to_str(s, l, a);
}  */

/*static inline char *copy_string(char **dst, char *src)
{
    if ((*dst = src) && (*dst = mem_alloc(strlen(src) + 1))) strcpy(*dst, src);
    return *dst;
} */

/* Copies at most dst_size chars into dst. Ensures null termination of dst. */

static inline char *safe_strncpy(char *dst, const char *src, size_t dst_size) {
    strncpy(dst, src, dst_size);
    if (strlen(src) >= dst_size) dst[dst_size - 1] = 0;
    return dst;
}


static inline char *safe_strncpy0(char *dst, const char *src, size_t dst_size) {
    if (!src) {
        *dst='\0';
        return dst;
    }

    strncpy(dst, src, dst_size);
    if (strlen(src) >= dst_size) dst[dst_size - 1] = 0;
    return dst;
}


struct list_head {
    void *next;
    void *prev;
};
#ifndef HAVE_TYPEOF

struct xlist_head {
    struct xlist_head *next;
    struct xlist_head *prev;
};

#endif

#define init_list(x) {(x).next=&(x); (x).prev=&(x);}
#define list_empty(x) ((x).next == &(x))
#define del_from_list(x) {((struct list_head *)(x)->next)->prev=(x)->prev; ((struct list_head *)(x)->prev)->next=(x)->next;}
#define add_at_pos(p,x) do {(x)->next=(p)->next; (x)->prev=(p); (p)->next=(x); (x)->next->prev=(x);} while(0)

#ifdef HAVE_TYPEOF
#define add_to_list(l,x) add_at_pos((typeof(x))&(l),(x))
#define foreach(e,l) for ((e)=(l).next; (e)!=(typeof(e))&(l); (e)=(e)->next)
#define foreachback(e,l) for ((e)=(l).prev; (e)!=(typeof(e))&(l); (e)=(e)->prev)
#else
#define add_to_list(l,x) add_at_pos((struct xlist_head *)&(l),(struct xlist_head *)(x))
#define foreach(e,l) for ((e)=(l).next; (e)!=(void *)&(l); (e)=(e)->next)
#define foreachback(e,l) for ((e)=(l).prev; (e)!=(void *)&(l); (e)=(e)->prev)
#endif
#define free_list(l) {while ((l).next != &(l)) {struct list_head *a=(l).next; del_from_list(a); mem_free(a); }}

/*static inline int isA(char c)
{
    return (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || (c >= '0' && c <= '9') ||
            c == '_' || c == '-';
} */

static inline int casecmp(char *c1, char *c2, int len)
{
    int i;
    for (i = 0; i < len; i++) if (upcase(c1[i]) != upcase(c2[i])) return 1;
    return 0;
}

static inline int can_write(int fd)
{
    fd_set fds;
    struct timeval tv = {0, 0};
    FD_ZERO(&fds);
    FD_SET(fd, &fds);
    return select(fd + 1, NULL, &fds, NULL, &tv);
}

static inline int can_read(int fd)
{
    fd_set fds;
    struct timeval tv = {0, 0};
    FD_ZERO(&fds);
    FD_SET(fd, &fds);
    return select(fd + 1, &fds, NULL, NULL, &tv);
}


/* os_dep.c */

struct terminal;

struct open_in_new {
     char *text;
     char *hk;
    void (*fn)(struct terminal *term,  char *,  char *);
};


int get_system_env(void);
int is_xterm(void);
int can_twterm(void);
int term_get_terminal_size(int, int *, int *);
void handle_terminal_resize(int, void (*)(cba_t));
void unhandle_terminal_resize(int);
void set_bin(int);
int c_pipe(int *);
int get_input_handle(void);
int get_output_handle(void);
int get_ctl_handle(void);
void want_draw(void);
void done_draw(void);
void terminate_osdep(void);
void *handle_mouse(int, void (*)(void *,  char *, int), void *);
void unhandle_mouse(void *);
int check_file_name( char *);
int start_thread(void (*)(void *, int), void *, int);
char *get_clipboard_text(void);
void set_clipboard_text(char *);
void set_window_title( char *);
char *get_window_title(void);
int is_safe_in_shell( char);
void check_shell_security( char **);
void block_stdin(void);
void unblock_stdin(void);
int exe(char *);
int resize_window(int, int);
int can_resize_window(int);
int can_open_os_shell(int);
struct open_in_new *get_open_in_new(int);
void disable_screensaver(void);

/* ghash.c */

typedef struct _THashNode      THashNode;
typedef struct _THashTable     THashTable;

struct _THashNode
{
  gpointer key;
  gpointer value;
  THashNode *next;
};

struct _THashTable
{
  gint size;
  gint nnodes;
  guint frozen;
  THashNode **nodes;
  GHashFunc hash_func;
  GCompareFunc key_compare_func;
};

void init_ghash(void);
void free_ghash(void);
THashTable *t_hash_table_new (GHashFunc hash_func, GCompareFunc key_compare_func);
void t_hash_table_destroy (THashTable *hash_table);
void t_hash_table_foreach (THashTable *hash_table, GHFunc func, gpointer user_data);
void t_hash_table_insert (THashTable *hash_table, gpointer key, gpointer value);
void t_hash_table_remove (THashTable *hash_table, gconstpointer key);
gpointer t_hash_table_lookup (THashTable *hash_table, gconstpointer key);
gboolean t_hash_table_lookup_extended (THashTable *hash_table, gconstpointer lookup_key, gpointer *orig_key, gpointer *value);
guint t_hash_table_foreach_remove (THashTable *hash_table, GHRFunc func, gpointer user_data);
guint t_hash_table_size (THashTable *hash_table);



/* select.c */

#ifndef FD_SETSIZE
#define FD_SETSIZE 1024
#endif

typedef long ttime;
typedef unsigned tcount;

extern int terminate;

/*long select_info(int);*/
void select_loop(void (*)(void));
int register_bottom_half(void (*)(cba_t), cba_t cba);
void check_bottom_halves(void);
#ifdef LEAK_DEBUG_LIST
int debug_install_timer(char *file, int line, ttime, void (*)(cba_t), cba_t cba, char *fname); /* todo argument callbacku */
#define install_timer(x, y, z) debug_install_timer(__FILE__, __LINE__, x, y, z, #y)
void debug_kill_timer(char *file, int line, int timer_id);
#define kill_timer(x) debug_kill_timer(__FILE__, __LINE__, x)
void debug_set_handlers(char *file, int line, 
        int, 
        void (*)(cba_t), void (*)(cba_t), void (*)(cba_t), 
        cba_t cba, 
        char *read_fname, char *write_fname, char *error_fname);
#define set_handlers(n, r, w, x, a) debug_set_handlers(__FILE__, __LINE__, n, r, w, x, a, #r, #w, #x);
void debug_tcp_disconnect(char *file, int line, struct conn *conn);
#define tcp_disconnect(a) debug_tcp_disconnect(__FILE__, __LINE__, (a))
#else
int install_timer(ttime, void (*)(cba_t), cba_t cba); /* todo argument callbacku */
void kill_timer(int);
void set_handlers(int, void (*)(cba_t), void (*)(cba_t), void (*)(cba_t), cba_t cba);
void tcp_disconnect(struct conn *conn);
#endif
ttime get_timer_time(int);
ttime get_time(void);

//tODO
//void debug_set_handlers(char *file, int line, int, void (*)(cba_t), void (*)(cba_t), void (*)(cba_t), cba_t cba);
//#define set_handlers(n, r, w, x, a) debug_set_handlers(__FILE__, __LINE__, n, r, w, x, a);

#define H_READ  0
#define H_WRITE 1
#define H_ERROR 2
#define H_DATA  3

void *get_handler(int, int);
void install_signal_handler(int, void (*)(cba_t), cba_t, int);
void set_sigcld(void);

extern struct timeval start;
#define ST_START gettimeofday(&start, NULL)
#define ST_STOP {\
    struct timeval stop;\
    int sec, usec;\
    gettimeofday(&stop, NULL);\
    usec=stop.tv_usec-start.tv_usec;\
    sec=stop.tv_sec-start.tv_sec;\
    if (usec<0){usec+=1000000;sec--;}\
    dbg("stopky: %s: %d.%06d \n", __FUNCTION__, sec,usec);\
}

// recursive
#define RST_START struct timeval rstart; gettimeofday(&rstart, NULL)
#define RST_STOP {\
    struct timeval stop;\
    int sec, usec;\
    gettimeofday(&stop, NULL);\
    usec=stop.tv_usec-rstart.tv_usec;\
    sec=stop.tv_sec-rstart.tv_sec;\
    if (usec<0){usec+=1000000;sec--;}\
    dbg("stopky: %s: %d.%06d \n", __FUNCTION__, sec,usec);\
}

/* kbd.c */

#define BM_BUTT     3
#define BM_EBUTT    7
#define B_LEFT      1
#define B_MIDDLE    2
#define B_RIGHT     3
#define B_WHUP      4
#define B_WHDOWN    5
#define BM_ACT      0x38
#define B_DOWN      0
#define B_UP        8
#define B_DRAG      0x10
#define B_MOVE      0x20

#define KBD_ENTER   0x100
#define KBD_BS      0x101
#define KBD_TAB     0x102
#define KBD_ESC     0x103
#define KBD_LEFT    0x104
#define KBD_RIGHT   0x105
#define KBD_UP      0x106
#define KBD_DOWN    0x107
#define KBD_INS     0x108
#define KBD_DEL     0x109
#define KBD_HOME    0x10a
#define KBD_END     0x10b
#define KBD_PGUP    0x10c
#define KBD_PGDN    0x10d

#define KBD_F1      0x120
#define KBD_F2      0x121
#define KBD_F3      0x122
#define KBD_F4      0x123
#define KBD_F5      0x124
#define KBD_F6      0x125
#define KBD_F7      0x126
#define KBD_F8      0x127
#define KBD_F9      0x128
#define KBD_F10     0x129
#define KBD_F11     0x12a
#define KBD_F12     0x12b

#define KBD_CTRL_C  0x200

#define KBD_SHIFT   1
#define KBD_CTRL    2
#define KBD_ALT     4

void handle_trm(int, int, int, int, int);
void free_all_itrms(void);
void resize_terminal(cba_t);
void dispatch_special( char *);
void kbd_ctrl_c(void);
int is_blocked(void);
void itrm_safe_abort(void);

/* terminal.c */

/* UTF-8 */
typedef uint32_t unicode_val;
/* UCS/Unicode replacement character. */
#define UCS_NO_CHAR ((unicode_val) 0xFFFD)

typedef unsigned short chr;

struct event {
    long ev;
    long x;
    long y;
    long b;
    long mx;
    long my;
};

#define EV_INIT         0
#define EV_KBD          1
#define EV_MOUSE        2
#define EV_REDRAW       3
#define EV_RESIZE       4
#define EV_ABORT        5
#define EV_SDLRESIZE    6
#define EV_SKIP         7

struct window {
    struct window *next;
    struct window *prev;
    void (*handler)(struct window *, struct event *, int fwd);
    void *data;
    int xp, yp;
    struct terminal *term;
};

#define MAX_TERM_LEN    16  /* this must be multiple of 8! (alignment problems) */

#define MAX_CWD_LEN 8192    /* this must be multiple of 8! (alignment problems) */  

#define ENV_XWIN    1
#define ENV_SCREEN  2
#define ENV_OS2VIO  4
#define ENV_BE      8
#define ENV_TWIN    16
#undef FALL

struct terminal {
    int master;
    int fdin;
    int fdout;
    int x;
    int y;
    int environment;
    char term[MAX_TERM_LEN];
    char cwd[MAX_CWD_LEN];
    unsigned *screen;
    unsigned *last_screen;
    struct term_spec *spec;
    int cx;
    int cy;
    int lcx;
    int lcy;
    int dirty;
    int redrawing;
    int blocked;
    char *input_queue;
    int qlen;
    /*struct list_head windows;*/
    struct window  windows;
     char *title;
    /* Something weird regarding the UTF8 I/O. */
    struct {
        unicode_val ucs;
        int len;
        int min;
    } utf_8;
#ifdef FALL
    int *fall;
#endif
};

extern struct terminal *term;

struct term_spec {
    struct term_spec *next;
    struct term_spec *prev;
    char term[MAX_TERM_LEN];
    int mode;
    int m11_hack;
    int restrict_852;
    int block_cursor;
    int col;
    int utf_8_io;
    int charset;
};

#define TERM_DUMB   0
#define TERM_VT100  1
#define TERM_LINUX  2
#define TERM_KOI8   3

#define ATTR_FRAME  0x8000

extern struct term_spec term_specs;

int hard_write(int, char *, int);
int hard_read(int, char *, int);
char *get_cwd(void);
void set_cwd(char *);
struct terminal *init_term(int, int, void (*)(struct window *, struct event *, int));
void sync_term_specs(void);
struct term_spec *new_term_spec(char *);
void free_term_specs(void);
void destroy_terminal(cba_t);
void redraw_terminal(cba_t);
void redraw_terminal_all(void);
void redraw_terminal_cls(void);
void redraw_later(void);
/*void cls_redraw_all_terminals(void);*/
void redraw_from_window(struct window *);
void redraw_below_window(struct window *);
void add_window(void (*)(struct window *, struct event *, int), void *);
void add_window_at_pos(void (*)(struct window *, struct event *, int), void *, struct window *);
void delete_window(struct window *);
void delete_window_ev(struct window *, struct event *ev);
void set_window_ptr(struct window *, int, int);
void get_parent_ptr(struct window *, int *, int *);
struct window *get_root_window(void);
/*void add_empty_window(void (*)(void *), void *);*/
void term_redraw_screen(void);
/*void redraw_all_terminals(void);*/
void set_char(int, int, unsigned);
void set_last_char(int, int, unsigned);
unsigned get_char(int, int);
void set_color(int, int, unsigned);
void set_only_char(int, int, unsigned);
void set_line(int, int, int, chr *);
void set_line_color(int, int, int, unsigned);
void fill_area(int, int, int, int, unsigned);
void fill_lastarea(int x, int y, int xw, int yw, unsigned c);
void draw_frame(int, int, int, int, unsigned, int);
void print_text(int, int, int, char *, unsigned); /* todo, ale asi nikoli jen smazat term */
void set_cursor(int, int, int, int);
/*void destroy_all_terminals(void);*/
void block_itrm(int);
int unblock_itrm(int);
void exec_thread(char *, int);
void close_handle(cba_t cba);
void set_ctest_title(void);

#define TERM_FN_TITLE   1
#define TERM_FN_RESIZE  2

void exec_on_terminal(char *, char *, int);
void set_terminal_title(char *);
void do_terminal_function(char, char *);
void timer_redraw(cba_t);


#define FRAME_URDL 0x80c5
#define FRAME_UDL  0x80b4
#define FRAME_URD  0x80c3
#define FRAME_URL  0x80c1
#define FRAME_RDL  0x80c2
#define FRAME_RL   0x80c4

/* language.c */

#include "language.h"

extern char dummyarray[];

extern int current_language;

void init_trans(void);
void shutdown_trans(void);
char *get_text_translation(char *);
char *get_english_translation(char *);
void set_language(int);
int n_languages(void);
char *language_name(int);

#define _(_x_) get_text_translation(_x_)
#define CTEXT(x) (dummyarray + x)
#define VTEXT(_x_) get_text_translation(CTEXT(_x_))

/* main.c */

#define RET_OK      0
#define RET_ERROR   1
#define RET_SIGNAL  2
#define RET_SYNTAX  3
#define RET_FATAL   4

extern int retval;
extern int first_use;
extern int first_contest_def;
extern char *starting_sbrk;

extern char *path_to_exe;

void unhandle_terminal_signals(void);
void unhandle_basic_signals(void);
int term_attach_terminal(int, int, int);
void shrink_memory(int);
void handle_basic_signals(struct terminal *term);
void sig_segv(cba_t cba);


/* types.c */


/* session.c */

#define TMPQ aband->tmpqsos[0]

struct inputln;
struct band; 
struct skedwin_data;

/* also used for ctest->cq->type */
enum modes{ /* TX_RX */
    MOD_NONE = 0,
    MOD_SSB_SSB,
    MOD_CW_CW,
    MOD_SSB_CW,
    MOD_CW_SSB,
    MOD_AM_AM,
    MOD_FM_FM,
    MOD_RTTY_RTTY,
    MOD_SSTV_SSTV,
    MOD_ATV_ATV /* 9 */
};

enum extcq { EC_NONE, EC_ODD, EC_EVEN, EC_1ST, EC_2ND };

struct session {
    struct window *win;                                             
    int id;
    int exit_query;
    
    GPtrArray *subwins; 
    struct subwin *ontop, *ontop2;
    gint focused, height1, height2, y1, y2;
    
    gint timer_id;
    struct inputln *il;  /* inputline without contest for C_W testing ETC.. */
    GPtrArray *qs;
    MUTEX_DEFINE(qs);
//    GMutex *qs_mutex;
//#ifdef LEAK_DEBUG_LIST    
//    char *qs_file;
//    int qs_line;
//#endif                                               
    GThread *qs_thread;
    int qs_thread_break;
    int qs_max_matches;
    gchar *qs_str;     /* modified only from main thread without cwqs worker thread, no mutex needed */
    gchar *qs_master;
    enum modes mode;  
    gint last_cq_timer_id;
    struct cq *last_cq;
    struct cq *ac_cq;
    gint extcq_break_timer_id;
    enum extcq extcq;
    int tx;
#ifdef HAVE_SDL    
    SDL_Surface *icon, *oldicon;
#else
    void *icon, *oldicon;
#endif    
    GHashTable *hicalls; /* highlighted callsigns in shell */
    int tune;
    int redraw_timer_id;
#ifdef HAVE_SDL
    int update_rotar_timer_id;
#endif
    struct skedwin_data *skedwdata;
    int skedw_timer_id;
    struct dw_item *adwi;
    char *adxc;
	char *asunriseset;
    int aqrb, aqtf;
#ifdef FALL
    int fall_id;
#endif
};


extern struct session *gses;
extern struct window *gseswin;

struct session *create_session(struct window *win);
void *create_session_info(int, char *, int *);
void rxtx(void);
void esc(void);
void rx(void);
int preferred_func(struct event *ev);
void win_func(struct window *, struct event *, int);

void draw_root_window(void);
void send_event(struct event *ev);
void add_date_time(struct band *band);
void fix_date_time(struct band *band);
void process_input(void *,char *, int cq);
void draw_time(void);
void time_func(cba_t);
void print_tucnak(int x, int y);
void net_timer_redraw(cba_t);
int load_hicalls_from_file(char *filename);
int save_hicalls_to_file(char *filename);
void after_callsign(struct band *band,char *c, char *oldtmpqcall);
void after_exc(struct band *band,char *c);
void after_locator(struct band *band,char *c);
void after_nr(struct band *band,char *c);
#ifdef FALL
void fall_func(union cba_t cba);
#endif

/* bfu.c */

struct memory_list {
    int n;
    void *p[1];
};

struct memory_list *getml(void *, ...);
void add_to_ml(struct memory_list **, ...);
void freeml(struct memory_list *);

#define MENU_FUNC (void (*)(cba_t, cba_t))
#define CALLBACK_FUNC (void (*)(cba_t))

extern char m_bar;

#define M_BAR   (&m_bar)

struct menu_item {
    char *text;
    char *rtext;
    char *hotkey;
    void (*func)(cba_t, cba_t);
    cba_t data;
    int in_m; /* 0 menu zmizi po vyberu */
    int free_i;
};

struct menu {
    int selected;
    int view;
    int xp, yp;
    int x, y, xw, yw;
    int ni;
    cba_t data;
    struct window *win;
    struct menu_item *items;
};

struct mainmenu {
    int selected;
    int sp;
    int ni;
    cba_t data;
    struct window *win;
    struct menu_item *items;
};

struct history_item {
    struct history_item *next;
    struct history_item *prev;
    char d[1];
};

struct history {
    int n;
    struct list_head items;
};

#define D_END       0
#define D_CHECKBOX  1
#define D_FIELD     2
#define D_FIELD_PASS    3
#define D_BUTTON    4
#define D_BOX       5
#define D_CHECKBOX3 6

#define B_ENTER     1
#define B_ESC       2

struct dialog_item_data;
struct dialog_data;

struct dialog_item {
    int type;
    int gid, gnum; /* for buttons: gid - flags B_XXX */ /* for fields: min/max */ /* for box: gid is box height */
    int (*fn)(struct dialog_data *, struct dialog_item_data *);
    struct history *history;
    int dlen;           /* data length */
    int maxl;
    char *data;
    void *udata;        /* for box: holds list */
    char *text;
    char *msg;
    int wrap;
    int align;
    int tabcompl, tabi;
};

struct dialog_item_data {
    int x, y, l;
    int vpos, cpos;
    int checked;
    struct dialog_item *item;
    struct list_head history;
    struct history_item *cur_hist;
    char *cdata;
};

#define EVENT_PROCESSED     0

struct dialog {
    char *title;
    void (*fn)(struct dialog_data *);
    void (*fn2)(struct dialog_data *);
    int (*handle_event)(struct dialog_data *, struct event *);
    void (*abort)(struct dialog_data *);
    void *udata;
    void *udata2;
    int align;
    void (*refresh)(void *);
    void *refresh_data;
    int y0;
    struct dialog_item items[1];
};

struct dialog_data {
    struct window *win;
    struct dialog *dlg;
    int x, y, xw, yw;
    int n;
    int selected;
    struct memory_list *ml;
    int min, max, yy, w, rw, ofs;
    struct dialog_item_data items[1];
};

void menu_func(struct window *, struct event *, int);
void mainmenu_func(struct window *, struct event *, int);
void dialog_func(struct window *, struct event *, int);

struct menu_item *new_menu(int);
void add_to_menu(struct menu_item **, char *, char *, char *, void (*)(cba_t, cba_t), cba_t, int);
void do_menu(struct menu_item *items, cba_t data); /* todo data=ses */
void do_menu_selected(struct menu_item *, cba_t data, int);
void do_mainmenu(struct menu_item *, cba_t, int);
void do_dialog(struct dialog *, struct memory_list *);
int check_number(struct dialog_data *, struct dialog_item_data *);
int check_qrg(struct dialog_data *, struct dialog_item_data *);
int check_nonempty(struct dialog_data *, struct dialog_item_data *);
void max_text_width(struct terminal *, char *, int *);
void min_text_width(struct terminal *, char *, int *);
void dlg_format_text(struct terminal *, struct terminal *, char *, int, int *, int, int *, int, int);
void max_buttons_width(struct terminal *, struct dialog_item_data *, int, int *);
void min_buttons_width(struct terminal *, struct dialog_item_data *, int, int *);
void dlg_format_buttons(struct terminal *, struct terminal *, struct dialog_item_data *, int, int, int *, int, int *, int);
void dlg_format_buttons1(struct terminal *, struct terminal *, struct dialog_item_data *, int, int, int *, int, int *, int);
void checkboxes_width(struct terminal *, char **, int *, void (*)(struct terminal *, char *, int *));
void dlg_format_checkbox(struct terminal *, struct terminal *, struct dialog_item_data *, int, int *, int, int *, char *);
void dlg_format_checkboxes(struct terminal *, struct terminal *, struct dialog_item_data *, int, int, int *, int, int *, char **);
void dlg_format_field(struct terminal *, struct terminal *, struct dialog_item_data *, int, int *, int, int *, int);
void max_group_width(struct terminal *, char **, struct dialog_item_data *, int, int *);
void min_group_width(struct terminal *, char **, struct dialog_item_data *, int, int *);
void dlg_format_group(struct terminal *, struct terminal *, char **, struct dialog_item_data *, int, int, int *, int, int *);
void dlg_format_group1(struct terminal *, struct terminal *, char **, struct dialog_item_data *, int, int, int *, int, int *);
void dlg_format_box(struct terminal *, struct terminal *, struct dialog_item_data *, int, int *, int, int *, int);
void checkbox_list_fn(struct dialog_data *);
void group_fn(struct dialog_data *);
void center_dlg(struct dialog_data *);
void draw_dlg(struct dialog_data *);
void display_dlg_item(struct dialog_data *, struct dialog_item_data *, int);
int ok_dialog(struct dialog_data *, struct dialog_item_data *);
int cancel_dialog(struct dialog_data *, struct dialog_item_data *);
void msg_box(struct memory_list *, char *, int, ...);
void input_field_fn(struct dialog_data *);
void input_field(struct memory_list *, char *, char *, char *, char *, void *,struct history *, int, char *, int, int, int (*)(struct dialog_data *, struct dialog_item_data *), void (*)(void *, char *), void (*)(void *), int tabcompl);
void add_to_history(struct history *, char *);

void box_sel_move(struct dialog_item_data *, int ); 
void show_dlg_item_box(struct dialog_data *, struct dialog_item_data *);
void box_sel_set_visible(struct dialog_item_data *, int ); 
void errbox(char *text, int errcode, ...); 
void menu_save_rc(cba_t cba);


void dlg_pf_init(int phase, struct dialog_data *dlgd);
void dlg_pf_group(int phase, struct dialog_data *dlgd, int cnt);
void dlg_pf_buttons(int phase, struct dialog_data *dlgd, int cnt);
void dlg_pf_fn(struct dialog_data *dlgd);

int do_tab_compl(struct dialog_item_data *di, int tabi);


/* menu.c */

#define CONDGFREE(item) { if (item) { g_free(item); item=NULL; }}

#define STORE_STR(base,item) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(item); 
    
#define STORE_STR_UC(base,item) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(item); \
    uc(base->item);

#define STORE_STR_FS(base,item) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(item); \
    fixsemi(base->item)    
    
#define STORE_STR_FS_UC(base,item) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(item); \
    fixsemi(base->item); \
    uc(base->item);

#define STORE_STR2(dbase,sbase,item) \
    if (dbase->item) g_free(dbase->item); \
    dbase->item = g_strdup(sbase->item); 

#define STORE_STR2_UC(dbase,sbase,item) \
    if (dbase->item) g_free(dbase->item); \
    dbase->item = g_strdup(sbase->item); \
    uc(dbase->item);

#define STORE_INT(base, item) \
    base->item = item; 

#define STORE_SINT(base, item) \
    base->item = atoi(item##_str); 

#define STORE_SHEX(base, item) \
    base->item = strtol(item##_str, NULL, 16); 

#define STORE_SDBL(base, item) \
    base->item = atof(item##_str); 

#define STORE_STR3(base,item,src,first) \
    if (base->item) g_free(base->item); \
    base->item = g_strdup(ztokenize(src, first)); 


#define LOAD_STR(base,item) \
    safe_strncpy0(item, base->item, sizeof(item));

#define LOAD_INT(base,item) \
    item = base->item

#define LOAD_SINT(base,item) \
    g_snprintf(item##_str, sizeof(item##_str), "%d", base->item)

#define LOAD_SHEX4(base,item) \
    g_snprintf(item##_str, sizeof(item##_str), "%04x", base->item)


#define EQSO_LEN 15


struct tmpqso;
//int fileno(FILE *stream);
void activate_bfu_technology(int);
void free_history_lists(void);
void exit_prog(cba_t cba);
void menu_play_last(cba_t cba);
void menu_break_record(cba_t cba);
void menu_export_edi(cba_t cba);
void menu_export_report(cba_t cba);
void menu_export_html(cba_t cba);
void menu_export_stats(cba_t cba);
void menu_export_titlpage(cba_t cba);
void menu_save_all(cba_t cba);
void do_edit_menu(cba_t cba);
void menu_contest_open(cba_t cba);
void free_namelist(void);
void do_peer_menu( void (* func)(cba_t cba));
void do_peer_operators_menu(void (* func)(cba_t cba));
void menu_load_from_peer(cba_t cba);
void menu_spy_from_peer(cba_t cba);
void do_spy_peer_menu(void (* func)(cba_t cba));
void menu_set_language(cba_t cba);
void menu_contest_config_from_peer(cba_t cba);
void send_contest_config_request(int no);

/* menu1.c */
void band_settings(cba_t cba, int from_ctest);
void menu_wizz(cba_t cba);
int save_desc_to_file(gchar *filename);
void contest_options1(char *title, int from_ctest);
void contest_options1_from_menu(cba_t cba);
void contest_options1_from_ctest(cba_t cba);
void contest_def(cba_t cba);
void edi_prop(cba_t cba);
int dlg_edi_prop(struct dialog_data *dlg, struct dialog_item_data *di);
void menu_responsible_op(cba_t cba);
void refresh_contest_options1(void *xxx);
void init_ctest2(int from_dlg, int updloc, struct zstring *zs);

/* menu2.c */
extern char operator_[EQSO_LEN];
void edit_qso(struct qso *qso);

/* menu3.c */
void duplicate_callsign(struct qso *qso);
void menu_add_error(cba_t cba);
void menu_chop(cba_t cba);
void menu_skedqrg(cba_t cba);
void menu_fillop(cba_t cba);
void menu_recalc_qrb(cba_t cba);
void menu_cw_update_contest(cba_t cba);
void menu_cw_update_band(cba_t cba);
void menu_exc_update_contest(cba_t cba);
void menu_exc_update_band(cba_t cba);
void menu_import_ebw(cba_t cba);
void menu_autosave(cba_t cba);
void menu_add_subwin(cba_t cba);
void menu_close_subwin(cba_t cba);
void menu_split_subwin(cba_t cba);
void menu_remove_split(cba_t cba);
void menu_unfinished(cba_t cba);

/* menu4.c */
void menu_cq_cw(cba_t cba);
void menu_cq_ssb(cba_t cba);
void menu_cwda(cba_t cba);
void menu_ssbd(cba_t cba);
void menu_network(cba_t cba);

/* menu5.c */
void misc_opts(cba_t cba);
#ifdef HAVE_HAMLIB
void menu_fixqrg(struct terminal *term, void *d, struct session *ses);
#endif
void winkey_opts(cba_t cba);
int dlg_winkey_opts(struct dialog_data *, struct dialog_item_data *);
void menu_rig_opts(cba_t cba);
void menu_rotars(cba_t cba);



/* charsets.c */

#include "codepage.h"

struct conv_table {
    int t;
    union {
        char *str;
        struct conv_table *tbl;
    } u;
};

/*struct conv_table *get_translation_table(int, int);*/
int get_cp_index(char *n);
char *get_cp_name(int);
/*char *get_cp_mime_name(int);*/
int is_cp_special(int);
void free_conv_table(void);
char *cp2utf_8(int, int);
char *u2cp(unicode_val, int);

#define AL_LEFT     0
#define AL_CENTER   1

#define AL_MASK     0x7f

#define AL_EXTD_TEXT    0x80
#define AL_BUTTONS  0x100
    /* DIRTY! for backward compatibility with old menu code */

/* default.c */

#define MAX_STR_LEN 1024


/* Which fields to free when zapping a box_item. Bitwise or these. */
enum box_item_free {NOTHING = 0, TEXT = 1 , DATA = 2};
/* An item in a box */
struct box_item {
    struct box_item *next;
    struct box_item *prev;
    char *text;    /* Text to display */
    void *data; /* data */
    enum box_item_free free_i;
};

/* Stores display information about a box. Kept in cdata. */
struct dlg_data_item_data_box {
    int sel;    /* Item currently selected */   
    int box_top;    /* Index into items of the item that is on the top line of the box */
    /*struct list_head items;*/
    struct box_item items; /* The list being displayed */
    int list_len;   /* Number of items in the list */
};

void show_dlg_item_box(struct dialog_data *, struct dialog_item_data *); 

/* kbdbind.c */

#define KM_MAIN     0
#define KM_EDIT     1
#define KM_MENU     2
#define KM_MAX      3

enum {
    ACT_AC_CQ,
    ACT_BACKSPACE,
    ACT_CALLINFO,
    ACT_CHOP, 
    ACT_CLEAR_TMPQSOS,
    ACT_CLEAR_TMPQSOS_INPUTLINE,
    ACT_CONFIRM_CALL,
    ACT_CONFIRM_EXC,
    ACT_CONFIRM_WWL,
    ACT_COPY_CLIPBOARD,
    ACT_CQ_0,
    ACT_CQ_1,
    ACT_CQ_2,
    ACT_CQ_3,
    ACT_CQ_4,
    ACT_CQ_5,
    ACT_CUT_CLIPBOARD,
    ACT_DELETE,
    ACT_DOWN,
    ACT_END,
    ACT_ENTER,
    ACT_ESC,
    ACT_FILE_MENU,
    ACT_FIND_NEXT,
    ACT_FIND_NEXT_BACK,
    ACT_GRAB_BAND,
    ACT_HOME,
    ACT_INSERT,
    ACT_KILL_LINE,
    ACT_KILL_TO_BOL,
    ACT_KILL_TO_EOL,
    ACT_LASTCALL_KST,
    ACT_LEFT,
    ACT_MENU,
    ACT_MODE,
    ACT_NEXT_HISTORY,
    ACT_NEXT_SUBWIN,  
    ACT_NEWCALL_KST,
    ACT_PAGE_DOWN,
    ACT_PAGE_UP,
    ACT_PASTE_CLIPBOARD,
    ACT_PREV_HISTORY, 
    ACT_PREV_SUBWIN,
	ACT_PLAY_LAST,
    ACT_QUIT,
    ACT_REALLYQUIT,
    ACT_RIGHT,
    ACT_ROTAR,
    ACT_RX,
    ACT_RXTX, 
    ACT_SAVE_ALL,
/*    ACT_SCROLL_DOWN,*/
    ACT_SCREENSHOT,
    ACT_SCROLL_LEFT,
    ACT_SCROLL_RIGHT,
/*    ACT_SCROLL_UP,*/
    ACT_SEARCH,
    ACT_SEARCH_BACK,
    ACT_SEEK_A,
    ACT_SEEK_B,
    ACT_SHOW_HISTORY,
    ACT_SKED,
    ACT_SKED_QRG,
    ACT_SWAP_CALL,
    ACT_SWAP_WWL,
/*    ACT_TX, */
    ACT_TUNE,
    ACT_UNFINISHED,
    ACT_UP,
    ACT_WINDOWSHOT    
};

void init_keymaps(void);
void free_keymaps(void);
int kbd_action(int, struct event *);

/* stats.c */

#define QSONR_WIDTH 20
#define QSONR_HEIGHT 7
#define BAND_WIDTH 16
#define ORIG_Y 1

struct cntpts{
	int count;
	int points;
    struct qso *qso; /* used only in st->hours */
};

struct stats{
    gint first_date, last_date; /* 20021115*/
    gint nqsos, nqsop;  /* without errors and dupes */
    gint nwwlp; 
    gint nprefs; 
    gint ndxcp; 
    gint nexcp; 
    gint ntotal;
    int nmult;

    gint odxqrb_int;
    gchar *odxcall, *odxwwl, *odxoperator;

    GHashTable *wwls, *dxcs, *excs, *hours, *prefs; /* of struct cntpts */
    GHashTable *calls;
    
	int qso_per_hour, pts_per_hour, pts_per_50qso;
    char *mycontinent;
    char *mydxcc;
    struct qso *odx;
};

struct miss_struct{
    GIndexArray *ia;
    struct stats *st;
    int maxlen;
};


struct contest;
struct config_subwin;

char *get_raw_call(char *buf, const char *call);
int is_rover(const char *callsign);
char *get_wwl(char *buf, char *wwl);

void draw_one_bigdigit(int x, int y, int num);
void draw_bigdigit(int x, int y, int num);

struct stats *init_stats(void);
void free_stats(struct stats *st);
void clear_stats(struct stats *st);
void update_stats(struct band *b, struct stats *st, struct qso *q);
void recalc_stats(struct band *b);
void recalc_all_stats(struct contest *ctest);
void recalc_all_qrbqtf(struct contest *ctest);
void redraw_stats(struct band *band);
void recalc_statsfifo(struct band *band);
void export_stats_fifo(void);

void stats_thread_create(struct band *band);
void stats_thread_join(struct band *band);
void stats_thread_kill(struct band *band);

void timer_minute_stats_all(cba_t cba);
void minute_stats_all(void);
void minute_stats(struct band *band);

void stats_merge_prefs_fn(gpointer key, gpointer value, gpointer data);
void recalc_allb_stats(void);
void miss_compute_ms(struct miss_struct *ms, struct band *b);
int qsomult16(struct band *b);
gint compare_string (gconstpointer a, gconstpointer b);



/* inputln.c */

#define VALID_CHARS " ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/#',.-_:?!;"

struct inputln {
    int (*fn)(struct dialog_data *, struct dialog_item_data *);
    int dlen;           /* data length */
    int x, y, l;
    int vpos, cpos, focused, wasctrlv;
    int upconvert, readonly, allow_ctrlv;
    char *cdata;
    struct terminal *term;
    void *enterdata;
    void (*enter)(void *, gchar *, int);
    GPtrArray *history;
    int hist_i;
    struct band *band;
    struct subwin *sw;
    char *valid_chars;
};

void il_set_focus(struct inputln *il);
void il_unset_focus(struct inputln *il);
void clear_inputline(struct inputln *il);
int inputln_func(struct inputln *il, struct event *ev);
void il_readonly(struct inputln *il, int ro);
void draw_inputln(struct inputln *il, int sel);
void newkst(struct inputln *il, char *callkst);

/* rc.c */

struct config_band{
    gchar bandchar; /* 'a' ... */
    gchar *pband;           /* 144 MHz */ 
    gint psect;           /* Single, Multi */
    gint qrv,qrvnow,readonly;
    
    gchar *stxeq,*spowe;        /* TM-255 + gi7b, 300 */ 
    gchar *srxeq,*sante,*santh; /* TM-255, GW4PTS, 60;800 */
    gchar *mope1,*mope2;    /* OK1XDF, OK1MZM, OK1ZIA */
    gchar *remarks;

       /* a little hack for OK  */
    gchar *ok_section_single;  /* 2m=01, 70cm=03, ... */
    gchar *ok_section_multi;   /* 2m=02, 70cm=04, ... */
    gint qrg_min,qrg_max;      /* kHz */
	gchar *adifband;           /* 2m,70cm,23cm... */  
	gchar *cbrband;            /* 2M,432,1.2G... */  
    gchar *skedqrg;
    gdouble band_lo;
    int band_sw;
};

struct config {   /* depending on callsign */
    gchar *pcall;
    gchar *pwwlo;
    gchar *pexch;

    gchar *padr1,*padr2,*pclub;
    gchar *rname,*rcall,*radr1,*radr2,*rpoco,*rcity,*rcoun,*rphon,*rhbbs;

    gchar *default_rs,*default_rst;
    gint qsop_method, total_method;
    
    gint as_disk_aq, as_disk_am, as_floppy_aq, as_floppy_am;
    gint as_disk_fsync, as_floppy_fsync, as_mount;
    gchar *as_floppy_path, *as_mount_cmd;

    gchar *net_if_ignore, *net_ip_ignore, *net_ip_announce;
    
    GPtrArray *bands;
    struct config_band *band;  /* active band during loading config */
    GPtrArray *cqs;            /* of struct cq */
    struct cq *cq;
    struct term_spec *ts;
    GPtrArray *sws;            /* of struct config_subwin */
    struct config_subwin *sw;
    
    gint cwda_type;  /* enum cwtype */
    gchar *cwda_device, *cwda_hostname;
    gint cwda_udp_port, cwda_io_port;
    gint cwda_speed, cwda_weight, cwda_minwpm, cwda_maxwpm;
    gint cwda_leadin, cwda_spk;
    gint cwda_vid, cwda_pid, cwda_autgive;
    gint wk_wk2, wk_usepot, wk_usebut, wk_keymode, wk_swap;
    
    gint ssbd_type;
    gint ssbd_record, ssbd_maxmin, ssbd_diskfree;
    gint ssbd_format, ssbd_channels, ssbd_samplerate;
    gint ssbd_plev, ssbd_rlev;
    gchar *ssbd_template; 

    gchar *ssbd_pcm_play, *ssbd_pcm_rec;
    gint ssbd_period_time, ssbd_buffer_time;
    gchar *ssbd_alsa_mixer, *ssbd_alsa_src;
    int ssbd_pa_play, ssbd_pa_rec;

    gchar *ssbd_dsp;
    gint ssbd_maxfrag;
    gchar *ssbd_mixer, *ssbd_oss_src;
    gint ssbd_recsrc;

    gchar *ssbd_hostname;
    gint ssbd_udp_port;
    
    gint trace_bcast, trace_sock, trace_recv, trace_send, trace_qsos, trace_sdev;
    
    gchar *rig_filename;
    gint rig_model, rig_civaddr;
    gint rig_speed;
    gdouble rig_lo;          /* qrg displayed on rig + rig_lo = real_qrg_on_air 
                                use get/set_rig_lo for access */
    gint rig_ssbcw_shift;   /* Hz added to qrg on change ssb->cw */
    gint rig_poll_ms;
    gint rig_qrg_r2t;
    gint rig_qrg_t2r;
    gint rig_mode_t2r;
    gint rig_clr_rit;
    gint rig_verbose;
    
    GPtrArray *crotars;  /* of struct config_rotar */
    struct config_rotar *crotar;
    int loglines,skedshift,skedcount;
    gchar *startband;
    GPtrArray *takeoff; /* of struct takeoff */
    int global_operator;
    gchar *operator_;
	int gfx_x, gfx_y, ntpq, dssaver, splitheight;
    int fontheight;
    char *slashkey;

	char *dxc_host;
	int dxc_port;
	char *dxc_user, *dxc_pass;
	char *kst_user, *kst_pass, *kst_name;
};



extern struct config *cfg;
extern int opt_g, opt_i, opt_m, opt_s, opt_t, debug_keyboard;

gint init_rc(void);
void free_config_rotar(struct config_rotar *crot);
gint free_rc(void);
gint read_rc_line(gchar *str);
gint read_rc_file(gchar *filename, const char *text);
gint read_rc_files(void);
void save_rc_string(GString *gs); 
gint save_rc_file(gchar *filename);
int term_spec_init(void);
char *parse_options(int argc, char **argv);
gdouble get_rig_lo(struct band *band);
void set_rig_lo(struct band *band, gdouble lo);

/* qsodb.c */

#define STORE_HASH_STR(base, item) {\
    if (base->item) g_free((gpointer)base->item);\
    base->item = g_strdup((char *)g_hash_table_lookup(hash, #item)); \
}

#define STORE_HASH_INT(base, item) {\
    gchar *c; \
    c = (char*)g_hash_table_lookup(hash, #item); \
    if (c) base->item = atoi(c); \
    else base->item = 0; \
}

#define STORE_HASH_INT_DEF(base, item, def) {\
    gchar *c; \
    c = (char*)g_hash_table_lookup(hash, #item); \
    if (c) base->item = atoi(c); \
    else base->item = def; \
}

#define STORE_HASH_CHR(base, item) {\
    gchar *c;\
    c=(char *)g_hash_table_lookup(hash, #item); \
    if (c) base->item = tolower(*c);\
    else c='\0';\
}



#define NEW_EXC 1
#define NEW_WWL 2
#define NEW_DXC 4
#define NEW_PREF 8
#define NEW_MULT 16

enum suspcall {
    SUSP_NONE,
    SUSP_QRB,
    SUSP_REM,
    SUSP_WARN,
    SUSP_ERR
};

struct qso{
    gchar *source; /* "192.168.0.1:1026" CONSTANT */
    gint  ser_id; /* 0..X in one source  CONSTANT */
    time_t stamp;  /* last modification  VARIABLE */
    
    gchar *operator_;
    
    gchar *date_str,*time_str;
    gchar *callsign;
    gint  mode;
    gchar *rsts,*rstr;
    gchar *qsonrs,*qsonrr;
    gchar *exc, *locator;
    gchar *remark;
    gint error;
    gdouble qrg;
   /* computed*/
    gint dupe,qsop,new_,qsl;
    gdouble qrb;
    gint qtf;
    gint susploc; /* 1=warn, 2=err */ 
    enum suspcall suspcall1; 
    gint unkcall;
    /* "foreign key", don't dealloc! */
    struct band *band;
    int kx,ky;
};

struct tmpqso{
    gchar *date_str,*time_str;
    gchar *callsign;
    gchar *rsts,*rstr;
    gchar *qsonrs,*qsonrr;
    gchar *exc, *locator;
    gchar *remark;
    gint dupe,qsl;
   /* computed*/
    gdouble qrb;
    gint qtf;
    gchar *name;
   /* ultimate values                     */
    gint ucallsign,udummy,ulocator,uexc;
    int uqrb,uqtf;
   /* suspicious */
    gint suspcallsign, susplocator, suspexc, unkcall;
};

#define ADD_TMPQSO_STRING(band,item,str,isu,uitem) {\
    int i; \
    if (band->tmpqsos[TMP_QSOS-1].item) { \
        g_free(band->tmpqsos[TMP_QSOS-1].item); \
        band->tmpqsos[TMP_QSOS-1].item = NULL; \
    }\
    for (i=TMP_QSOS-2;i>=0;i--) {\
        band->tmpqsos[i+1].item=band->tmpqsos[i].item; \
        band->tmpqsos[i+1].uitem=band->tmpqsos[i].uitem; \
    }\
    band->tmpqsos[0].item=g_strdup(str); \
    band->tmpqsos[0].uitem = isu; \
}

#define CLEAR_TMPQSO_STRING(band,item) {\
    if (band->tmpqsos[i].item) { \
        g_free(band->tmpqsos[i].item); \
        band->tmpqsos[i].item=NULL;\
    } \
}

#define CLEAR_TMPQSO_STRING_UU(band,item, uitem){ \
    int i; \
    for (i=0;i<TMP_QSOS;i++) {\
        if (!band->tmpqsos[i].uitem && band->tmpqsos[i].item) {\
            g_free(band->tmpqsos[i].item); \
            band->tmpqsos[i].item=NULL;\
        }\
    }\
}
    
#define ADD_TMPQSO_GINT(band,item,num,isu,uitem) {\
    int i; \
    for (i=TMP_QSOS-2;i>=0;i--) {\
        band->tmpqsos[i+1].item=band->tmpqsos[i].item; \
        band->tmpqsos[i+1].uitem=band->tmpqsos[i].uitem; \
    }\
    band->tmpqsos[0].item=num; \
    band->tmpqsos[0].uitem = isu; \
}

#define ADD_TMPQSO_GDOUBLE(band,item,num,isu,uitem) {\
    int i; \
    for (i=TMP_QSOS-2;i>=0;i--) {\
        band->tmpqsos[i+1].item=band->tmpqsos[i].item; \
        band->tmpqsos[i+1].uitem=band->tmpqsos[i].uitem; \
    }\
    band->tmpqsos[0].item=num; \
    band->tmpqsos[0].uitem = isu; \
}

#define CLEAR_TMPQSO_GINT(band,item) \
        band->tmpqsos[i].item=0

/*#define CLEAR_TMPQSO_GINT_UU(band,item, uitem) {\
    int i; \
    for (i=0;i<TMP_QSOS;i++) {\
        if (!band->tmpqsos[i].uitem) {\
            band->tmpqsos[i].item=0;\
        }\
    }\
} */
    
#define CLEAR_TMPQSO_GDOUBLE_UU(band,item, uitem) {\
    int i; \
    for (i=0;i<TMP_QSOS;i++) {\
        if (!band->tmpqsos[i].uitem) {\
            band->tmpqsos[i].item=0;\
        }\
    }\
}
    
#define CLEAR_TMPQSO_QTF(band) \
        band->tmpqsos[i].qtf=-1

#define CLEAR_TMPQSO_QTF_UU(band) {\
    int i; \
    for (i=0;i<TMP_QSOS;i++) {\
        if (!band->tmpqsos[i].uqtf) {\
            band->tmpqsos[i].qtf=-1;\
        }\
    }\
}
    
#define TMP_QSOS 3
#define DISP_QSOS 2
#define INPUTLN(b) (ctest && b ? b->il : gses->il)

void add_tmpqso_locator(struct band *b,gchar *c,int isu, int isshort); 
void add_tmpqso_exc(struct band *b,gchar *exc,int isu);

    
enum last_items{
    LI_NONE = 0,
    LI_CALL,
    LI_WWL
};

enum ctrlstates{
    CTRL_RUN = 0,       /* RUN, TX    */
    CTRL_SP = 1,        /* S&P, no TX */
    CTRL_REQR = 2,      /* RUN, TX    */
    CTRL_REQS = 3,      /* S&P, no TX */
    CTRL_RUNING = 4,    /* S&P, TX    */
    CTRL_GIVEN = 5      /* RUN, no TX */
};

enum ccmd{
    CCMD_REQ = 0,       /* S&P->RUN */
    CCMD_ACC,           /* RUN->S&P */
    CCMD_REJ,           /* RUN->S&P */
    CCMD_BACK           /* S&P->RUN */
};

enum exctype {
    EXC_FREE = 1,
    EXC_VERIFIED = 2,
    EXC_WAZ = 3,
    EXC_ITU = 4
};

enum tttype{
    TT_NONE = 0,
    TT_RSTS = 1,
    TT_RSTR = 2,
    TT_QSONRR = 3,
    TT_EXC = 4
};


struct spypeer;

struct band{
    gchar bandchar; /* 'c' ...*/
    gchar *pband;           /* 144 MHz */ 
	gchar *bandname;        /* 2m,70cm,23cm... */  
    
    GPtrArray *qsos;
    struct inputln *il;
    struct tmpqso tmpqsos[TMP_QSOS];
    gchar  *unres, *qrv_str, *wkd_str;
    gint   dupe_in_tmpqso_index;
    gint dirty_save, dirty_stats, dirty_statsf;
    gint readonly;
    gchar *call_played; // call played in run mode
    gint agcall;        // call was sent in autogive mode. RST follows
    gint iscall;        // currently played text is call
//    enum modes mode;  
//    gint bandmulti;
    gchar *operator_;

    gint psect;
    gchar *stxeq,*spowe;        /* TM-255 + gi7b, 300 */ 
    gchar *srxeq,*sante,*santh; /* TM-255, GW4PTS, 60;800 */
    gchar *mope1,*mope2;    /* OK1XDF, OK1MZM, OK1ZIA */
    gchar *remarks;

    struct stats *stats;
    struct stats *tmpstats;
    GThread *stats_thread;
    MUTEX_DEFINE(stats);
//    GMutex *stats_mutex;
//#ifdef LEAK_DEBUG_LIST    
//    char *stats_file;
 //   int stats_line;    
//#endif
    int stats_break;
    
    /* file */
    FILE *swap;
    gint saveid,ignoreswap;

    struct fifo *swapfifo, *unfi, *statsfifo1;
    GPtrArray *qs, *oqs;
    enum last_items last_item;
    gchar *skedqrg;
    enum ctrlstates ctrlstate;
    gchar *ctrlsp;
/*    enum spymodes spymode;*/
    struct qso tmplocqso;
    GPtrArray *skeds;
    gint qrg_min,qrg_max;      /* kHz */
    int band_sw;
    struct config_band *cbr_confb; // local for cabrillo, not filled elsewhere!
    double qrg;
};


struct contest {
      /* EDI & contest properties */
    gchar *tname;           /* A1 Contest - MMC */
    gchar *tdate;           /* TODO */
    gchar *pcall;           /* DL/OK1KRQ/P */
    gchar *pclub;           /* OK1KRQ */
    gchar *pwwlo;           /* JN69HN12 */
    gchar *pexch;  
    gchar *default_rs,*default_rst;


      /* EDI only properties */
    gchar *padr1,*padr2;    /* Lite */
    gchar *rname;           /* Roman Staif */
    gchar *rcall;           /* OK1XST */
    gchar *radr1,*radr2;  /* Pod svabinami  */ 
    gchar *rpoco,*rcity,*rcoun;  /* 30100, Plzen, CZECHIA */
    gchar *rphon,*rhbbs;    /* 0603123456 , OK0POK */ 
    
      /* contest properties */
    gint  rstused;          /* no,used, optional */
    gint  defrstr;          
    gint  qsoused;          /* no,used, optional */
    gint  wwlused;          /* no,used, optional */
    gint  wwltype;          /* short,normal,extended */
    gint  wwlcfm;
    gint  excused;          /* no,used, optional */
    enum exctype exctype;  
    gchar *excname;         /* database name f.e. OKRES */
    gint  exccfm;
    enum tttype  tttype;
    int qsoglob;            /* qsonr is global in contest */
    gint prefglob;          /* prefix is global in contest */
    gint expmode;           /* epedition mode */
    
    
      /* points calculation */
    gint qsomult;
    gint wwlbonu,wwlmult;
    gint prefmult;
    gint dxcbonu,dxcmult;  
    gint excbonu,excmult;
    gint qsop_method;            /* 1..12 */
    gint total_method;       /* 1..2 */
    
    GPtrArray *bands;
    GHashTable *bystamp;  /* key=source, val=GIndexArray */
                          /* GIndexArrays are NOT sorted by ser_id but only by stamp */
    GIndexArray *allqsos;
    
     /* disk */
    FILE *descfile;     /* ~/tucnak/.../desc */ 
    FILE *logfile;      /* ~/tucnak/.../log */ 
    gchar *directory;   /* /home/ok1zia/tucnak/20021113.2 */
    gchar *cdate;       /* 20021113 without .X */ 
     /* autosave */
    int as_disk_qsonr, as_disk_time, as_floppy_qsonr, as_floppy_time;
    
    
    int qrv;             /* bit array of used bands */
    int oldcontest;      /* date of contest is too old, not recording */

	int minute_timer_id; /* for statistics */
    int hf;              /* HF contest */
    GPtrArray *spypeers; /* of struct spypeer */

    int allb_nqsos;
    int allb_nqsop;
    int allb_nwwlp;
    int allb_nprefp;
    int allb_ndxcp;
    int allb_nexcp;
    int allb_ntotal;
    int allb_nmult;
    GHashTable *allb_prefs;
    int runmode;
    int qso_per_10, qso_per_60;
    struct qso *lastmultqso;
};


extern struct contest *ctest;
extern struct band *aband;
struct conn;
extern char *mode_msg[];

int init_ctest(void);
int new_ctest(char *tdate); /* called after filling data members by refresh_... */
void free_ctest(void);
struct band *init_band(struct config_band *, GHashTable *opt_band, struct zstring *zs);
void free_band(struct band *b);
void free_qso(struct qso *qso);
struct band *find_band_by_pband(char *pband);
struct band *find_band_by_bandchar(char bandchar);
struct band *find_band_by_qrg(double freq);
struct band *init_qrv_bands(void);
int write_qso_to_swap(struct band *b, struct qso *q);
void add_qso(struct band *b, struct qso *q);
struct qso *get_qso(struct band *b, gint i);
struct qso *get_qso_by_callsign(struct band *b, gchar *callsign);
struct qso *get_gqso(struct band *b, gint i);
int get_qso_index_by_callsign(struct band *b, gchar *callsign);
struct qso *get_qso_by_id(struct band *b, gchar *source, gint ser_id);
struct qso *get_qso_by_qsonr(struct band *b, int qsonr);
void add_error(struct band *b, gchar *remark);
void activate_band(struct band *b);
int add_tmpxchg(struct band *band, gchar *xchg);
int add_swap(struct band *band, gchar *s);
void clear_tmpqsos(struct band *b, int set_defaults);
void default_rst_to_tmpqsos(struct band *b);

int export_all_bands_edi(void);
int export_all_bands_report(void);
int export_all_bands_titlpage(void);
struct config_band *get_config_band_by_bandchar(char bandchar);
struct config_band *get_config_band_by_pband(char *pband);
struct config_band *get_config_band_by_qrg(int qrg); /* kHz */
void foreach_source_recalc_ser_id(gpointer key, gpointer value, gpointer data);
void foreach_source_qsort_by_stamp(gpointer key, gpointer value, gpointer data);
void foreach_source_print(gpointer key, gpointer value, gpointer data);

void add_qso_to_index(struct qso *q, int qsort_if_needed);
void remove_qso_from_index(struct qso *q);
gchar *get_latests_str(void);
int compare_stamp(const void *a, const void *b);
void compute_qrbqtf(struct qso *q);
GPtrArray *get_band_qs(struct band *band, gchar *str);
GPtrArray *get_oband_qs(struct band *band, gchar *str);
gchar *find_wwl_by_oband(struct band *oband, gchar *call);
gchar *find_exc_by_oband(struct band *oband, gchar *call);
int load_ctest_from_mem(struct contest *ctest, gchar *datedir, GHashTable *hash);
void qso_mark_as_error(struct band *b, gint i);
int get_psect_int(char *psect);
void dump_qso(struct qso *q, char *desc);
void invalidate_tmpqso(struct band *b, struct qso *q);
void dirty_band(struct band *band);
struct zstring *contest_format(struct contest *ctest);
void ctest_parse(struct zstring *zstr, struct contest *ctest);
struct zstring *band_format(struct band *b);
struct band *band_parse(struct zstring *zstr, struct band *b);
int compare_date_time_qsonrs(const void *a, const void *b);

/* edi.c */
int save_all_bands_txt(int is_autosave);
int check_autosave(void);
void load_contest_edi(gchar *date, int edi);
void add_qso_str1(GString *gs, struct qso *q, struct band *b);
void add_qso_str2(GString *gs, struct qso *q, struct band *b);
void add_qso_str3(GString *gs, struct qso *q, struct band *b);
void import_edi (void *xxx, char *filename);
void import_swap(void *xxx, char *filename);
void dump_all_sources(struct contest *ctest);
enum modes get_mode(void);
void set_mode(enum modes mode);
char *my_strstr(const char *, const char *);
char *my_strcasestr(const char *phaystack, const char *pneedle);



/* adif.c */

int export_all_bands_adif(void);
void import_adifx(char *filename);
void import_adif(void *xxx, char *filename);

/* regex.c */

#define MAX_MATCHES 10

int regcmp(char *string, char *regex);
int regcmpi(char *string, char *regex);

#ifdef LEAK_DEBUG_LIST
#define regmatch(string, regex...) debug_regmatch(__FILE__, __LINE__, string, regex)
int debug_regmatch(char *file, int line, char *string, char *regex, ...);
#else
int regmatch(char *string, char *regex, ...);
#endif


/* subwin.c */

#if defined(_MSC_VER) || defined(__MINGW32__)
struct winsize{
	unsigned short ws_row, ws_col, ws_xpixel, ws_ypixel;
};
#endif

enum sw_type { SWT_QSOS, SWT_LOG, SWT_PIPE, SWT_TALK, 
               SWT_DXC, SWT_SKED, SWT_SWAP, SWT_UNFI,
               SWT_STAT, SWT_MAP, SWT_SCOPE, SWT_QRV,
               SWT_HF, SWT_PLAYER, SWT_CHART, SWT_KST3};  	  

struct subwin {
    gchar *title;
    enum sw_type type;
    gint x,y,w,h,hh;
    gint offset,cur,ho, offset2;
    gint ontop, ontop2,focused;
    gint titl1,titl2;

    int  (*kbd_func)(struct subwin *, struct event *ev, int fw);
    int  (*mouse_func)(struct subwin *, struct event *ev, int fw);
    void (*redraw)(struct subwin *, int flags);
    void (*check_bounds)(struct subwin *);
    void (*raise)(struct subwin *);
    GPtrArray *lines;
    int eol, maxlen, unread;
    
    struct inputln *il; /* optional */
    
      /* subwins having pipes */
    gint read_fd, write_fd; 
    pid_t pid;
    struct winsize ws;
    GPtrArray *high; /* of gchar* */

    gchar *command;
    gint respawn_time;

    /* fifo is foreign key mostly to global variable */
    struct fifo *fifo;

    /* for graphics subwins (SWT_MAP) */
#ifdef HAVE_SDL    
    SDL_Surface *l1map;
//    SDL_Surface *l2rot;
    SDL_Surface *screen;
    MUTEX_DEFINE(screen);
//    GMutex *screen_mutex;
//#ifdef LEAK_DEBUG_LIST    
//    char *screen_file;
//    int screen_line;
//#endif
    int ox, oy;
    int zoom;
    int gdirty;
    SDL_Rect map, info;
    gchar *pwwlo;
    struct qso *minqso;
    gchar *minqrvcall;
    double myw, myh;
    int scope_mode;
    int fft_wf_y, fft_wf_h;  
    int fft_sp_y, fft_sp_h;
    int fft_wf_x2;
    int fft_sp_x2;
    
    double antchar[360];
    int beamwidth;
    double gst[360];

    int mint, maxt, minv, maxv;
    int ch_left, ch_right, ch_top, ch_bottom;
    int mx, my, ch_mouse_value;
#endif    
    GPtrArray *chbands; // of struct chband
#ifdef HAVE_SNDFILE
    int pl_rate;
    int pl_channels;
    unsigned char *pl_shapebuf;
    int pl_shapelen;
    int pl_len;      
    int pl_pxlen;
    int pl_ofs;
#ifdef HAVE_SDL    
    SDL_Surface *pl_preview_screen;
    int pl_preview_w;
#endif
#endif
};

struct config_subwin{
    int nr;
    enum sw_type type;
    gchar *command;
    gchar *autorun;
    int respawn_time;
};


struct subwin *new_subwin(enum sw_type type, gchar *title,
         /* optional */ void (*enter)(void *,gchar *, int));
void free_subwins(void);
void free_subwin(struct subwin *sw);

int sw_add_line(struct subwin *sw, gchar *line, int eol);
int sw_add_block(struct subwin *sw, gchar *data);


int sw_default_func(struct subwin *sw, struct event *ev, int fw);
int sw_all_func(struct event *ev, int fw);
int sw_focus_func(struct event *ev, int fw);
int sw_ontop_func(struct event *ev, int fw);
struct subwin *find_sw_ontop(void);
void sw_set_focus(void); 
void sw_unset_focus(void);
struct subwin *sw_set_ontop(int n, int set2); /* n abs */
struct subwin *sw_totop_next(int n, int set2); /* n = +-1 */
void sw_set_unread(struct fifo *fifo);
void sw_unset_unread(struct fifo *fifo);
struct config_subwin *get_config_sw_by_number(GPtrArray *sws, int nr);

void sw_default_redraw(struct subwin *sw, int flags);
void sw_check_len(struct subwin *sw);
void draw_titles(int y, int ontop2);
int sw_line_is_highlighted(struct subwin *sw, gchar *c);


int  sw_qsos_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_qsos_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_qsos_redraw(struct subwin *sw, int flags);
void sw_qsos_check_bounds(struct subwin *sw);
int show_qs(void);
void sw_qs_redraw(void);

/*int  sw_il_kbd_func(struct subwin *sw, struct event *ev, int fw);
void sw_il_redraw(struct subwin *sw);
void sw_il_check_bounds(struct subwin *sw);
void sw_il_enter(void *enterdata, gchar *str);
*/
int  sw_fifo_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_fifo_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_fifo_redraw(struct subwin *sw, int flags);
void sw_fifo_check_bounds(struct subwin *sw);
  
int  sw_pipe_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_pipe_redraw(struct subwin *sw, int flags);
void sw_pipe_check_bounds(struct subwin *sw);
void sw_pipe_enter(void *enterdata, gchar *str, int);
int  sw_pipe_run(struct subwin *sw, char *cmd);
void sw_pipe_read_handler(cba_t);
void sw_pipe_write_handler(cba_t);
void sw_pipe_exception_handler(cba_t);
void sw_pipe_kill(struct subwin *sw);
void sw_pipe_match(gpointer acall, gpointer nic, gpointer astr);
int sw_pipe_hihglight(struct subwin *sw, char *str);
int sw_pty_run(struct subwin *sw, char *cmd);
int sw_pipe_run(struct subwin *sw, char *cmd);
  
void sw_talk_enter(void *enterdata, gchar *str, int);
void sw_talk_read(gchar *);

int sw_dxc_kbd_func(struct subwin *sw, struct event *ev, int fw);
int sw_dxc_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_dxc_redraw(struct subwin *sw, int flags);
void sw_dxc_check_bounds(struct subwin *sw);
    
  
int  sw_unfi_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_unfi_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_unfi_redraw(struct subwin *sw, int flags);
void sw_unfi_check_bounds(struct subwin *sw);

int  sw_stat_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_stat_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_stat_redraw(struct subwin *sw, int flags);
void sw_stat_check_bounds(struct subwin *sw);
void sw_stat_raise(struct subwin *sw);

int sw_qrv_kbd_func(struct subwin *sw, struct event *ev, int fw);
int sw_qrv_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_qrv_redraw(struct subwin *sw, int flags);
void sw_qrv_check_bounds(struct subwin *sw);
void sw_qrv_raise(struct subwin *sw);
void sw_qrv_sort(struct qrvdb *qrvdb);
void qrv_read_line(char *);

    /* hf.c */

int  sw_hf_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_hf_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_hf_redraw(struct subwin *sw, int flags);
void sw_hf_check_bounds(struct subwin *sw);
void sw_hf_raise(struct subwin *sw);
void get_hf_dxc(char *str);
void sw_hf_draw_spot(struct subwin *sw, int x, int y, struct spot *spot, int color);
void clip_char(struct subwin *sw, int xrel, int yrel, short c);
void clip_color(struct subwin *sw, int xrel, int yrel, short c);
void clip_printf(struct subwin *sw, int xrel, int yrel, short color, char *fmt, ...);




    /* cwdb.c */
  
extern struct cw *cw;  
  
struct cw_item{
   gchar *wwl0, *wwl1;    
   gint stamp0, stamp1;
   gint qrv;                /* bit array, lsb = A = 50MHz etc. Since 1.15 */
};

struct wc_item{
   gchar *call0, *call1;    
   gint stamp0, stamp1;
};

struct cw{
    THashTable *cw; /* key=call, value=cw_item */
    GHashTable *wc;
    int latest;
    int minstamp;
};

struct qs{
    GPtrArray *result1;
    gchar *str;
}; 

struct cw *init_cw(void);
void free_cw(struct cw *cw);

gint get_cw_size(struct cw *cw);
gint get_wc_size(struct cw *cw);

void load_one_cw(struct cw *cw, gchar *s);
int load_cw_from_file(struct cw *cw, gchar *filename);
void read_cw_files(struct cw *cw);
int save_cw_string(struct cw *cw, GString *gs);
int save_cw_into_file(struct cw *cw, gchar *filename);

void add_cw(struct cw *cw, gchar *call, gchar *wwl, gint stamp, gchar *qrv);
gchar *find_wwl_by_call(struct cw *cw, gchar *call);
gchar *find_wwl_by_call_newer(struct cw *cw, gchar *call, int minstamp);

void add_wc(struct cw *cw, gchar *wwl, gchar *call, gint stamp);
gchar *find_call_by_wwl(struct cw *cw, gchar *wwl);

gchar *find_qrv_str_by_call(struct cw *cw, gchar *call);

int compare_gstring(const void *a, const void *b);

void update_cw_from_band(struct cw *cw, struct band *band);
void update_cw_from_ctest(struct cw *cw, struct contest *ctest);

void get_cw_qs(gchar *str);
gpointer cw_thread_func(gpointer data);
int cmp_cw_qs(gchar *call, struct cw_item *cwi, GPtrArray *result);
void qs_thread_create(void);
void qs_thread_join(void);
void qs_thread_kill(void);
int get_susp_ambiguous_call(struct cw *cw, struct band *band, char *call, char *wwl, GString *gs, int thr);
int similar_calls(const char *call1, const char *call2, int factor, int thr, int p);
int cwdb_call_info(GString *gs, gchar *call, gchar *stroke);
int levenshtein(const char *s, const char*t);

   /* dwdb.c */

#include "txts.h"

extern struct dw *dw;

struct dw_item{
    gchar *wwl0, *wwl1;   /* center of activity (optional),  */
                            /* center of dxcc (geometric)     */
    GHashTable *wwls;      /* all wwls valid for this dxcc */
    int waz, itu;
    gchar *continent;
    gchar *dxcname;
	double latitude, longitude;
};

struct wd_item{
    gchar *dxc0, *dxc1;
};

struct dw{
    GHashTable *pd;  /* key=prefix "DF", value=dxcc (main prefix) "DL" */
    GHashTable *dw;  /* key=dxcc "DL", value=dw_item */
    GHashTable *wd;  /* key=big wwl, "JN69" */
};


struct dw *init_dw(void);
void free_dw(struct dw *dw);

gint get_pd_size(struct dw *dw);
gint get_dw_size(struct dw *dw);
gint get_wd_size(struct dw *dw);

gchar *safe_fgets(GString *gs, FILE *f, int stripcomment);
gchar *safe_mgets(GString *gs, const char *file, long int *pos, const long int len, int stripcomment);
void add_pd(struct dw *dw, gchar *prefix, gchar *dxc);
struct dw_item *add_dxc(struct dw *dw, gchar *dxc, gchar *wwl0, gchar *wwl1, int waz, int itu, gchar *continent, gchar *dxcname, double latitude, double longitude);
void add_dw(struct dw_item *dxci, gchar *dxc, gchar *wwl);
void add_wd(struct dw *dw, gchar *wwl, gchar *dxc);
    
int load_dw_from_file(struct dw *dw, gchar *filename);
int load_cty_from_file(struct dw *dw, gchar *filename);
void read_dw_files(struct dw *dw);


struct dw_item *get_dw_item_by_call(struct dw *dw, gchar *call);
int wwl_is_ok_by_call(struct dw *dw, gchar *wwl, gchar *call);
int get_susp(struct cw *cw, struct dw *dw, gchar *call, gchar *wwl, int ambig);
int get_susp_call(struct cw *cw, struct dw *dw, gchar *call, gchar *wwl);
int get_susp_loc(struct cw *cw, struct dw *dw, gchar *call, gchar *wwl);
gchar *find_wwl_by_dxc(struct dw *dw,  gchar *dxc);
gchar *find_dxc_by_wwl(struct dw *dw, gchar *wwl);
char *get_dxcc(struct dw *dw, char *buf, char *call);
char *get_pref(char *buf, char *call);

gboolean free_gpointer_item(gpointer key, gpointer value, gpointer user_data);
int load_dw_from_mem(struct dw *dw, const char *file, const long int len);
int load_cty_from_mem(struct dw *dw, const char *file, const long int len);
void call_info(cba_t cba);
void menu_qso_check(cba_t cba);

/* net.c */

#define C0(item) (item?item:"")
#define PEER_FUNC void(*)(void)

extern struct net *net;

enum net_state { 
    NS_INIT=0, 
    NS_CONNECTING,
    NS_CONNECTED,
    NS_WAIT_ACK,
    NS_DISCONNECTED,
    NS_DEAD,  /* conn removed immediately */
};

extern char *ns_desc[];

struct conn{
    struct sockaddr_in sin;   /* {sin_port, sin_addr.s_addr } */
    int sock; 
    enum net_state state;
    GString *wrbuf, *rdbuf;
    int relseq;
    int timer;
    gchar *remote_id;
    gchar *remote_ac;
    gchar *operator_;
    gchar *rwbands;
    int is_same_ctest;
    int replicating;     /* replicating from other station in progress, huge amout of QSOs */
};

struct net{
    struct sockaddr_in my; /* IP of first interface (except lo) in alphab. order. host byteorder */
    gchar *myid; /* 0.0.0.0:0 or 192.168.1.97:55555 */
    struct sockaddr_in global; /* global master */
    time_t global_expire; 
    int udpsock;   /* listen for announcement, -1 unused */
    int tcpsock;   /* listen for slaves, -1 unused */
    int udptimer_id; 
    int udptimer_period;
    struct sockaddr bcast_addr[MAX_INTERFACES];
    int max_addrs;

    struct conn *master;
    GPtrArray *peers; /* struct conn[] */
    gchar *allpeers;  /* separated by semicolon */
    gchar *rwbpeers; /* separated by semicolon. ID;OP;RWB */
    gchar *bpeers;    /* separated by semicolon. ID;OP;B */
    void (*peerfunc)(void); /* todo */

};

struct net *init_net(void);
void free_net(struct net *net);

int init_net_udp (struct net *net);
int init_net_tcp (struct net *net);
int init_net_ifaces(struct net *net);
void free_net_udp(struct net *net);
void free_net_tcp(struct net *net);
void free_net_ifaces(struct net *net);
void free_conn(struct conn *conn);

void udp_read_handler(cba_t);
void udp_exception_handler(cba_t);
void udp_timer(cba_t);

void tcp_read_handler(cba_t);
void tcp_write_handler(cba_t);
void tcp_exception_handler(cba_t);
void tcp_accept_handler(cba_t);

void rel_write(struct conn *conn, gchar *s);
void rel_write_all(gchar *s);
void rel_read(struct conn *conn, gchar *s);

void tcp_set_state(struct conn *conn, enum net_state state);

void tcp_connect(struct conn *conn);
void tcp_kill(struct conn *conn);
int cmp_sin(struct sockaddr_in *a, struct sockaddr_in *b);
void net_send_id(void);
void net_send_ac(void);
void net_send_operator(void);
void net_send_read_write_bands(void);
void net_test_same_contest(struct conn *conn, gchar *ac_text);
void compare_remote_with_me(gpointer key, gpointer value, gpointer data);
void qso_from_net(struct conn *conn, gchar *c);
void replicate_qso(struct conn *conn, struct qso *q);
gchar *get_timer_str(struct conn *conn);
void send_config_request(int no);
void send_cwdb_request(int no);
int conn_prod_state(struct conn *conn);
int some_replicating(struct net *net);
struct conn *find_conn_by_remote_id(gchar *remote_id);
void remove_conn_timer(cba_t cba);
char *tcp_state_s(struct conn *conn);

//char *my_inet_ntoa(struct in_addr in);
void iface_info(void);

    /* loc.c */
#define MY_PI 3.14159265358979323846

double qth(char *qth,int width);
char *compute_wwl4(char *s, double h, double w);
char *mkwwl4(char *buf, int w, int h);
char *hw2loc(char *buf, double w, double h);
char *x2gramin(char *buf, double x, char *signs);

int qrbqtf(char *myqth,char *recqth,double *qrb,double *qtf,char *str, int flags);
int hw2qrbqtf(double h1, double w1, double h2, double w2, double *qrb, double *qtf);

int qrbqtf2hw(double h1, double w1, double qrb, double qtf, double *h2, double *w2);
/*
int xy2qrbqtf(struct gfx *gfx, int x, int y, double *qrb, double *qtf);
int xy2hw(struct gfx *gfx, int x, int y, double *h, double *w);
*/
int qsopwr( char *myqth, char *recqth);
int qthwr(char *qth,int width);
void qrb_qtf_int(gchar *wwl, int *qrb_int, int *qtf_int);
int iaru_round(double qrb);



    /* fifo.c */ 
struct fifo{
    int x,y,w,h,maxlen,ho;
    int withouttime;
    GPtrArray *items;
};

#define log_adds(s) fifo_adds(glog, s) 

extern struct fifo *glog, *gtalk;
struct fifo *init_fifo(int maxlen);
void fifo_resize(struct fifo *log, int x, int y, int w, int h);
void free_fifo(struct fifo *fifo);
void drop_fifo(struct fifo *fifo);
void fifo_adds(struct fifo *fifo, gchar *str);
void fifo_addf(struct fifo *fifo, char *m, ...); 
void fifo_addfq(struct fifo *fifo, char *m, ...); 
void log_addf(char *m, ...); 
int fifo_len(struct fifo *fifo);
gchar *fifo_index(struct fifo *fifo, int);
int save_fifo_to_file(struct fifo *fifo, gchar *filename);
int load_fifo_from_file(struct fifo *fifo, gchar *filename, int drop);
void log_draw(struct fifo *fifo);


    /* wizz.c */

struct wizz_item{
    gchar *tname, *pexch;
    enum tttype tttype;
    int qsoused, qsomult, qsoglob;
    int wwlused, wwlbonu, wwlmult, wwlcfm; 
    int excused, excbonu, excmult, exccfm;
    enum exctype exctype;
    gchar *excname;
    int rstused, defrstr;
    int prefmult, prefglob;
    int dxcbonu, dxcmult;
    gint  qsop_method, total_method;
    gchar *bands;
};

struct wizz{
    GPtrArray *items; /* struct wizz_item */
};

extern struct wizz *wizz;

struct wizz *init_wizz(void);
void free_wizz_item(struct wizz_item *wi);
void free_wizz(struct wizz *wizz);
struct wizz_item *find_wizz(struct wizz *wizz, gchar *tname);

int load_wizz_from_file(struct wizz *wizz, gchar *filename);
void read_wizz_files(struct wizz *wizz);

struct wizz_item *get_wizz(struct wizz *wizz, int i);
struct wizz_item *find_wizz(struct wizz *wizz, gchar *tname);

	/* ppdev.c */

#ifdef HAVE_LINUX_PPDEV_H
int parport_init   (struct cwdaemon *);
int parport_open   (struct cwdaemon *cwda, int verbose);
int parport_free   (struct cwdaemon *);
int parport_reset  (struct cwdaemon *);
int parport_cw     (struct cwdaemon *, int onoff);
int parport_ptt    (struct cwdaemon *, int onoff);
int parport_ssbway (struct cwdaemon *, int onoff);
int parport_band   (struct cwdaemon *, int bandsw);
#endif

	/* inpout.c */

#ifdef __CYGWIN__
int parport_init   (struct cwdaemon *);
int parport_open   (struct cwdaemon *cwda, int verbose);
int parport_free   (struct cwdaemon *);
int parport_reset  (struct cwdaemon *);
int parport_cw     (struct cwdaemon *, int onoff);
int parport_ptt    (struct cwdaemon *, int onoff);
int parport_ssbway (struct cwdaemon *, int onoff);
int parport_band   (struct cwdaemon *, int bandsw);
#endif

	/* ttys.c */

int ttys_init   (struct cwdaemon *);
int ttys_open   (struct cwdaemon *cwda, int verbose);
int ttys_free   (struct cwdaemon *);
int ttys_reset  (struct cwdaemon *);
int ttys_cw     (struct cwdaemon *, int onoff);
int ttys_ptt    (struct cwdaemon *, int onoff);
int ttys_ssbway (struct cwdaemon *, int onoff);

	/* davac4.c */
#ifdef HAVE_LIBFTDI
int davac4_init    (struct cwdaemon *);
int davac4_open    (struct cwdaemon *cwda, int verbose);
int davac4_free    (struct cwdaemon *);
int davac4_reset   (struct cwdaemon *);
int davac4_cw      (struct cwdaemon *, int onoff);
int davac4_ptt     (struct cwdaemon *, int onoff);
int davac4_ssbway  (struct cwdaemon *, int onoff);
int davac4_monitor (struct cwdaemon *, int onoff);
int davac4_band    (struct cwdaemon *, int bandsw);


#ifndef HAVE_FTDI_NEW
struct ftdi_context *ftdi_new(void);
void ftdi_free(struct ftdi_context *ftdi);
#endif

void usb_info(void);
unsigned short ftdi_checksum(unsigned char *eeprom, int eeprom_size);

#endif /* HAVE_LIBFTDI */ 
	
    /* winkey.c */

int winkey_init   (struct cwdaemon *);
int winkey_open   (struct cwdaemon *cwda, int verbose);
int winkey_free   (struct cwdaemon *);
int winkey_reset  (struct cwdaemon *);
int winkey_cw     (struct cwdaemon *, int onoff);
int winkey_ptt    (struct cwdaemon *, int onoff);
int winkey_ssbway (struct cwdaemon *, int onoff);
int winkey_text   (struct cwdaemon *cwda, char *text);
int winkey_speed  (struct cwdaemon *cwda, int wpm);
int winkey_weight (struct cwdaemon *cwda, int weight);
int winkey_tune   (struct cwdaemon *cwda, int tune);
int winkey_back   (struct cwdaemon *cwda);

void winkey_read_handler(cba_t cba);
int winkey_read(struct cwdaemon *cwda, int timeout_us);


int winkey4_init   (struct cwdaemon *);
int winkey4_free   (struct cwdaemon *);
int winkey4_reset  (struct cwdaemon *);

    /* cwdaemon.c */

enum cwtype { CWD_NONE, CWD_PARPORT, CWD_TTYS, CWD_DAVAC4, CWD_CWD, CWD_WINKEY, CWD_WINKEY4};

struct cwdaemon {
	int (*init)    (struct cwdaemon *);
	int (*free)    (struct cwdaemon *);
	int (*reset)   (struct cwdaemon *);
    int (*text)    (struct cwdaemon *, char *);
	int (*sspeed)  (struct cwdaemon *, int);
	int (*sweight) (struct cwdaemon *, int);
	int (*cw)      (struct cwdaemon *, int);
	int (*ptt)     (struct cwdaemon *, int);
	int (*ssbway)  (struct cwdaemon *, int);
	int (*monitor) (struct cwdaemon *, int);
	int (*echo)    (struct cwdaemon *);
    int (*dtune)   (struct cwdaemon *, int);
    int (*back)    (struct cwdaemon *);
    int (*band)    (struct cwdaemon *, int bandsw);

	int fd;
	char *desc;
    gint speed, weight;
    GThread *thread;
    int thread_break, abort;
    int pipe_read, pipe_write;
    GString *code;
    GString *played;
    MUTEX_DEFINE(code);
/*    GMutex *code_mutex;
#ifdef LEAK_DEBUG_LIST
    char *code_file;
    int code_line;
#endif*/
    struct cwdev *dev;
#ifdef __CYGWIN__
	HINSTANCE hInpOut;
    MUTEX_DEFINE(hInpOut);
/*    GMutex *hInpOut_mutex;
#ifdef LEAK_DEBUG_LIST
    char *hInpOut_file;
    int hInpOut_line;
#endif  */
	short _stdcall (*inp32)(short port);
	void _stdcall (*out32)(short port, short data);
	short baseport;
	unsigned char ctrl;
#endif
    unsigned char data;
#ifdef HAVE_LIBFTDI
    struct ftdi_context *ftdi;
    unsigned char ftdi_state;
    MUTEX_DEFINE(ftdi);
/*    GMutex *ftdi_mutex;
#ifdef LEAK_DEBUG_LIST
    char *ftdi_file;
    int ftdi_line;
#endif*/

#endif
    int tune;
    int sock;
    unsigned char winkey_version, winkey_oldstatus;
    int ttys_locked; // for CWD_TTYS and CWD_WINKEY
    int hold_ptt;
    int freeing;
};

extern struct cwdaemon *cwda;

struct cwdaemon *init_cwdaemon(void);
void free_cwdaemon(struct cwdaemon *cwda);

void cwdaemon_read_handler(struct cwdaemon *cwda, char *s, char *played);
void cq_cw_wait(struct cq *cq);
void cq_timer_cw2(cba_t cq);
void cwdaemon_set_defaults(struct cwdaemon *cwda, int speed);
gpointer cwdaemon_thread_func(gpointer data);
void cwdaemon_echo(struct cwdaemon *cwda);

int cwdaemon_text(struct cwdaemon *cwda, char *text);
void cwdaemon_abort(struct cwdaemon *cwda);
void cwdaemon_safe_abort(struct cwdaemon *cwda);
void cwdaemon_ptt(struct cwdaemon *cwda, int ptt, int hold_ptt);
void cwdaemon_ssbway(struct cwdaemon *cwda, int ssbway); /* 0=microphone, 1=soundcard */
int cwdaemon_speed(struct cwdaemon *cwda, int wpm);
void cwdaemon_qrq(struct cwdaemon *cwda, int qrq);
void cwdaemon_qrs(struct cwdaemon *cwda, int qrs);
int cwdaemon_weight(struct cwdaemon *cwda, int weight);
void cwdaemon_tune(struct cwdaemon *cwda, int tune);
int cwdaemon_back(struct cwdaemon *cwda);
int cwdaemon_band(struct cwdaemon *, int bandsw);

void parport_info  (void);


int cwd_init   (struct cwdaemon *);
int cwd_free   (struct cwdaemon *);
int cwd_reset  (struct cwdaemon *);
int cwd_text   (struct cwdaemon *, char *text);
int cwd_speed  (struct cwdaemon *, int onoff);
int cwd_weight (struct cwdaemon *, int onoff);
int cwd_cw     (struct cwdaemon *, int onoff);
int cwd_ptt    (struct cwdaemon *, int onoff);
int cwd_ssbway (struct cwdaemon *, int onoff);
int cwd_echo   (struct cwdaemon *);
void cwd_read_handler(cba_t cba);
void cwd_tone  (struct cwdaemon *cwda, int tone);
int cwd_tune   (struct cwdaemon *cwda, int tune);
int cwd_band   (struct cwdaemon *, int bandsw);


struct cq{
    int nr;
    int type; /* MOD_CW_CW, MOD_SSB_SSB */

    gchar *cw_str;
    int    cw_speed;  /* 0 = unused */
    int    cw_repeat; /* 0 or 1 */
    int    cw_ts;     /* tenth of second */
    int    cw_allowifundef;
    
    gchar *ssb_file;
    int    ssb_repeat;/* 0 or 1 */
    int    ssb_ts;    /* tenth of second */

    int stripcall;
};       

struct cq *init_cq(void);
struct cq *get_cq_by_number(GPtrArray *cqs, int nr);
void free_cq (struct cq *cq);

int cq_run_cw(struct cq *cq);
int cq_run_ssb(struct cq *cq);
int cq_run_by_number(int no);
int cq_abort(int abort_rec);
//void cq_timer_cw(cba_t cq);
void cq_timer_ssb1(cba_t cq);
void cq_ssb_wait(struct cq *cq);
void cq_timer_ssb2(cba_t cq);

gchar *convert_cq(struct cq *cq);
gchar *convert_esc(gchar *format, int *undef, int flags, time_t now); 
gchar *optimize_path(gchar *src); /* src must be allocated by glib, return can differ */
        
void menu_runmode(cba_t cba);
void menu_spmode(cba_t cba);
void runmode(int run);
void menu_extcq(cba_t cba);
int cq_remains_run(void);
int cq_remains_brk(void);
void cq_timer_brk(cba_t cba);
void ac_cq(void);

    /* cwwindow.c */

struct cwwin_data{
    int x,y,w,h;
    GString *text;
    int speed;
};

void cwwindow_func(struct window *win, struct event *ev, int fwd);


    /* ssbd.c */
#define CE_NONE             0
#define CE_ONLY_STRFTIME    1

#define SSBBUFFER_LEN 4096

#ifdef HAVE_SNDFILE


struct ssbd {
    int recording;
    
    GThread *thread;
    int proc_break;
    int channels;
    
    FILE *f;
    gchar *callsign;
    gchar *pfilename, *rfilename;
    gint serno;
    int b;
    short buffer2 [SSBBUFFER_LEN];
    int a;
    SNDFILE *sndfile;
    int sndfd;  /* filedescriptor for sndfile */
    int norecshowed;
    int midlevel, maxlevel, cntlevel, loglevel, oldloglevel;
    MUTEX_DEFINE(loglevel); 
    time_t recstop;
#ifdef HAVE_SDL    
    SDL_Surface *norecicon, *playicon, *recicon;
#else
    void *norecicon, *playicon, *recicon;
#endif    
    int code;
    int swontoptype;
    int played; // samples
    int seek;
    MUTEX_DEFINE(seek);
    char *pl_pcmfile;
};

extern struct ssbd *ssbd;

struct ssbd *init_ssbd(void);
void free_ssbd(struct ssbd *ssbd);

int ssbd_play_file(struct ssbd *ssbd, gchar *filename);
int ssbd_rec_file(struct ssbd *ssbd);
void ssbd_abort(struct ssbd *ssbd, int abort_rec);
int ssbd_recording(struct ssbd *ssbd);
int ssbd_callsign(struct ssbd *ssbd, char *call);
void ssbd_play_read_handler(struct ssbd *ssbd, gchar *str);
void ssbd_rec_read_handler(struct ssbd *ssbd, gchar *str);

gpointer ssbd_play_thread_func(gpointer data);
gpointer ssbd_rec_thread_func(gpointer data);
void ssbd_thread_create(struct ssbd *ssbd, GThreadFunc thread_func);
void ssbd_thread_join(struct ssbd *ssbd);
void ssbd_thread_kill(struct ssbd *ssbd);
int mkdir_p(const char *s,mode_t mode);
int fmkdir_p(const char *filename, mode_t mode);
void ssbd_watchdog(struct ssbd *ssbd, int start_rec);
void ssbd_play_last_sample(struct ssbd *ssbd, struct qso *qso);
void ssbd_assert(void);

#define SSBDRECORDING (ssbd->recording)
#else
#define SSBDRECORDING 0
#endif

    /* cor.c */


#ifdef HAVE_SDL 

#define COR_KM_MASK 0xffffff00
#define COR_KM_MIN  -19968
#define COR_KM_MAX  20224
#define COR_KM_STEP 256


#include "cor.h"
#include "cordata.h"

#ifdef _MSC_VER
#pragma pack(push, 1)
#endif

struct kmpoint{
    short int kx,ky;
    char c;
}__attribute__((packed));

#ifdef _MSC_VER
#pragma pack(pop)
#endif

struct kmarray{
    struct kmpoint *data;
    int len;
    int size;
};

struct cor{
    const struct cpoint *file;
    int items;
    gchar *loc;
    GHashTable *km; /* of struct ckmpoint */
    GHashTable *wwl4; /* of struct ckmpoint */
    GHashTable *wwl2; /* of struct ckmpoint */
    GThread *thread;
    int thread_break;
    double sw_myw, sw_myh;

};

extern struct cor *cor;
extern double maxcnt;
//extern double gst[360];


struct kmarray *kmarray_new(void);
void kmarray_add(GHashTable *hash, gpointer key, struct kmpoint *km);

struct cor *init_cor(void);
void free_cor(struct cor *cor);
int cor_recalc(struct subwin *sw, gchar *locator);
gpointer cor_thread_func(gpointer arg); 
void cor_read_handler(char *line);
gboolean free_km_item(gpointer key, gpointer value, gpointer user_data);
gpointer k2key(int kx, int ky);

#endif
	
    /* font.c */


#define R_EARTH (111.2*180.0/MY_PI)
/* 6371.2907 */
/* #define R_EARTH 6373.4 */
#define FONT_TRANSP 1
#define FONT_CENTER 2 
#define FONT_RIGHT  4 
#define FONT_SYNC   8
#define q0(item) (item)?(item):""

#define sqr(x) ((x)*(x))       

#ifdef HAVE_SDL
void fontoutc(SDL_Surface *surface, int x, int y, int color, int bgcolor, int flags, unsigned char c);
void fontout(SDL_Surface *surface, int x, int y, int color, int flags, char *s);
void fontoutf(SDL_Surface *surface, int x, int y, int color, int flags, char *m, ...); 

#endif /* HAVE_SDL */

struct takeoff{
    int from, to;
    int value;
};


/* dxc.c */

struct spot{
    double qrg;
    gchar *callsign,*from,*text;
    int zulu;
    time_t expire,endbold;
    struct spot *prev,*next;
};

struct spotdb{
    struct spot **first;
    struct spot **cur;
    int timer_id;
	int sfi;
};

extern struct spotdb *spotdb;

struct spotdb *init_spotdb(void);
void free_spotdb(struct spotdb *spotdb);

void remove_spot(struct spotdb *spotdb, int bi, struct spot *spot);
struct spot *dxc_parse_spot(gchar *str);
void free_spot(struct spot *spot);
int dxc_read_spot(gchar *str);
void dxc_seek(struct spotdb *spotdb, int value);

void dxc_assert_spot(struct spot *spot);
void dxc_assert(struct spotdb *spotdb, int bi);
int dxc_remove_expired(void);
void dxc_timer(cba_t);
void dxc_dump(struct spotdb *spotdb, int bi);


    /* namedb.c */
  
struct namedb{
    GHashTable *names; /* key=rawcall, value=name */
    GHashTable *dummy;
};

extern struct namedb *namedb;  
  
struct namedb *init_namedb(void);
void free_namedb(struct namedb *namedb);
void read_namedb_files(struct namedb *namedb);
gchar *find_name_by_call(struct namedb *namedb, gchar *call);
int save_namedb_into_file(struct namedb *namedb, gchar *filename);
void add_namedb(struct namedb *namedb, gchar *call, gchar *name);
gint get_namedb_size(struct namedb *namedb);

   
/* ebw.c */

#ifdef _MSC_VER
#pragma pack(push, 1)
#endif

struct dbfhdr{
    char ver; /* mostly 03 */
    char year,month,day;
    guint32 records;
    guint16 hdrsize, recsize;
    char padding[20];
    /* total 32 bytes */
}__attribute__((packed));


struct dbffield{
    char name[11]; /* \0 terminated */
    char type; /* Char,Date YYYYMMDD,Float,Logical TFYN,Memo,Numeric */ 
    guint32 disaplacement;
    char len, decimal;
    char padding[14];
    /* total 32 bytes */
}__attribute__((packed));

#ifdef _MSC_VER
#pragma pack(pop)
#endif

int load_ebw_from_file(struct cw *cw, struct namedb *namedb, char *filename);
int read_ebw_files(struct cw *cw, struct namedb *namedb);

/* sdev.c */

#define SDINIT char sdlen=0;int sdret;char sdbuf[256]
#define SDADD(a) sdbuf[sdlen++]=(a)
#define SDADD2(a) sdbuf[sdlen++]=(a)&0xff;sdbuf[sdlen++]=(a)>>8
//#define SDPLUS(sd,cmd) sdret=sd_protplus((sd),(cmd),sdbuf,&sdlen)

#define SDMAXLEN 300
#define SDFCE   1
#define SDADR   2
#define SDLEN   3

enum conntype{
    CT_TTYS, CT_UDP, CT_TCP, CT_FTDI
};

enum sprotocol{
	SPROT_NONE,
	SPROT_ROTAR
};

enum SCONN_CMD{
    SCONN_ROT_AZIM
};

struct sconn_job{
    struct sconn_job *next;
    struct sconn_job *prev;
    enum SCONN_CMD cmd;
    struct sdev *sdev;
    int azim;
};

struct sdev{
    struct sdev *next;
    struct sdev *prev;

    struct sconn *sconn;
    unsigned char saddr;
    int timeout_ms;

    int (*sdev_main)(struct sdev *sdev);
    void *arg;
};

struct sconn{
    struct sconn *next;
    struct sconn *prev;

    enum conntype type;
    int opened;
    int refcnt;

    gchar *ttys_filename;
    gchar *ip_hostname;
    int ip_port;
    int usb_port;
    GThread *thread;
    int thread_break;
    int give_me_chance;
    struct sconn_job jobs;
    MUTEX_DEFINE(jobs);
    struct sdev sdevs;
    MUTEX_DEFINE(sdevs);
    int sdevi;
	enum sprotocol sprotocol;
    int fd; /* valid only in child process! */
#ifdef HAVE_LIBFTDI
    struct ftdi_context *ftdi;
    unsigned char ftdi_state;
    int ftdi_vid, ftdi_pid;
    char *ftdi_serial;
#endif
    int freeing;

    int (*open)(struct sconn *, int verbose);
    int (*close2)(struct sconn *);
    int (*read)(struct sconn *, void *data, size_t len, int timeout_ms);
    int (*write)(struct sconn *, void *data, size_t len);
};


extern struct sconn sconns;
extern MUTEX_DEFINE(sconns);

void init_sconns(void);
struct sdev *sd_open_ttys(char saddr, char *filename, int timeout_ms);
struct sdev *sd_open_udp(char *hostname, int udpport);
struct sdev *sd_open_udp(char *hostname, int tcpport);
#ifdef HAVE_LIBFTDI
struct sdev *sd_open_ftdi(char saddr, int vid, int pid, char *serial, int timeout_ms);
#endif

void sc_open_common(struct sconn *sconn);
int free_sd(struct sdev *sd);

int sconn_file_open(struct sconn *sconn, int verbose);
int sconn_file_close(struct sconn *sconn);
int sconn_file_read(struct sconn *sconn, void *data, size_t len, int timeout_ms);
int sconn_file_write(struct sconn *sconn, void *data, size_t len);

#ifdef HAVE_LIBFTDI
int sconn_ftdi_open(struct sconn *sconn, int verbose);
int sconn_ftdi_close(struct sconn *sconn);
int sconn_ftdi_read(struct sconn *sconn, void *data, size_t len, int timeout_ms);
int sconn_ftdi_write(struct sconn *sconn, void *data, size_t len);
#endif
    
gpointer sc_main(gpointer xxx);
char *sd_err(int err);          
int sd_prot(struct sconn *sconn, char saddr, char fce, char *data, int *len, int timeout);

void sconn_job_add(struct sconn *sconn, struct sconn_job *job);
struct sconn_job *sconn_job_get(struct sconn *sconn);


/* rotar.c */

struct sdev;


enum rot_type {
    ROT_NONE=0,
    ROT_OK1ZIA_TTYS=1,
    ROT_OK1ZIA_FTDI=2,
    ROT_HAMLIB=3,
    ROT_REMOTE=4
};

struct config_rotar{
    gint nr;

    /* common */
    gchar *rot_desc;
    enum rot_type rot_type;
    gchar *rot_filename;
    gchar *rot_hostname;
    gint rot_port;
    gint rot_vid, rot_pid;
    gchar *rot_serial;
    gint rot_timeout_ms, rot_beamwidth;

    /* ok1zia */
    gint rot_saddr;

    /* hamlib */
    gint rot_model;

    /* remote */
    gchar *rot_rem_rotstr;
};


struct rotar{
    /* config */
    struct sdev *sdev;
#ifdef HAVE_HAMLIB
    ROT *rot;
#endif
    int step;      
    int rotchar; /* A, B, ... */
	char rotstr[2]; 
    int type;
    gchar *netid;
    gchar *desc;
    int beamwidth; /* in degrees */
    
    /* device versions */
    int verh, verl, identa;
    
    /* state */
    int qtf, oldqtf, elev;
//    int timer_id;           /* time between two command to prevent high cpu load */

    int color; /* color of arrow in polar map */
    int termcolor; /* color on terminal */
    gchar *rem_rotstr;
    int last_req;
#ifdef HAVE_HAMLIB
    GThread *hl_thread;
    int hl_azim;
    int hl_model;
    int hl_give_me_chance;
    int hl_thread_break;
#endif
};


extern GPtrArray *rotars;
extern MUTEX_DEFINE(rotars);
extern struct rotar *rotar;


int init_rotars(void);
int free_rotars(void);

struct rotar *init_rotar(struct config_rotar *cfg, int rotchar);
void free_rotar(struct rotar *rot);
int rot_seek(struct rotar *rot, int uhel);
struct config_rotar *get_config_rotar_by_number(GPtrArray *rotars, int nr);
struct rotar *get_rotar(int nr);
struct rotar *get_rotar_by_rotstr(char *rotstr);
void rotar_read_handler(char *line);
void timer_update_rotar(cba_t cba);
void rotar_remote_update(char *c);
void menu_rotar(cba_t cba);

#ifdef HAVE_SDL
int rot_update_colors(void);
#endif

int rotar_main(struct sdev *sdev);

/* hash.c */

void hash_safe_insert(GHashTable *table, gchar *key, gchar *value);
gboolean free_gstr(gpointer key, gpointer value, gpointer user_data);
void free_hash(GHashTable *hash);


/* control.c */

enum wt_type{
    WT_CLEAR=0,
    WT_CALLSIGN,
    WT_RSTS,
    WT_RSTR,
    WT_QSONRS,
    WT_QSONRR,
    WT_EXC,
    WT_LOCATOR,
    WT_OPERATOR,
    WT_REMARK       /* unused */
};

struct spypeer{
    gchar *callsign;
    gchar *rsts,*rstr;
    gchar *qsonrs,*qsonrr;
    gchar *exc, *locator;
    gchar *remark, *operator_;
    
    gint peertx;
    gchar *inputline;

    gchar *peerid;
    gchar bandchar;
};


void menu_forcerun(cba_t cba);
/*void menu_spy(cba_t cba);*/
void menu_endspy(cba_t cba);
int can_tx(struct band *b);
int can_cq(struct band *b);
void menu_grabband(cba_t cba);
void net_grab(struct band *b, enum ccmd ccmd, char *netid);
void ctrl_back(struct band *b);
void wkd_tmpqso(struct band *band, enum wt_type type, gchar *call);
void peer_tx(struct band *band, int tx); 
void do_endspy(cba_t cba, cba_t cba1);
void menu_endspy(cba_t cba);
void send_inputline(struct band *band);
struct spypeer *init_spypeer(GPtrArray *sps, gchar *peerid, char bandchar);
struct spypeer *get_spypeer_by_peerid(GPtrArray *sps, gchar *peerid, char bandchar);
void free_spypeer(struct spypeer *sp);
void free_spypeers(GPtrArray *sps);
void clear_spypeer(struct spypeer *sp);
void send_spypeer_request(cba_t cba);
void spypeer_add(char *peerid, char bandchar);
int load_spypeers_from_file(char *filename);
int save_spypeers_to_file(char *filename);


/* html.c */
#define HTML_ICON 1
#define HTML_MAP 2
#define HTML_CHART 4
#define HTML_IMG_ROOT 8
#define HTML_FOR_PHOTO 0x10

gchar *qh(GString *gs, gchar *s);
void html_style(GString *gs);
void html_header(GString *gs, gchar *title, int flags);
void html_ref_header(GString *gs);
void html_band_ref(GString *gs, struct band *b, struct config_band *confb);
void html_ref_footer(GString *gs, struct band *b, struct config_band *confb);
void html_band_header(GString *gs, struct band *b, struct config_band *confb, int flags, struct subwin *map, struct subwin *chart);
void html_band_footer(GString *gs);
void html_footer(GString *gs);
void html_qsos(GString *gs, struct band *b, struct config_band *confb);
void html_complete(GString *gs, int flags);

int export_all_bands_html(void);

/* sdl.c */
#ifdef HAVE_SDL

#define SDL_USERDATA_IN_FILTEREVENTx

#define FONT_W sdl->font_w
#define FONT_H sdl->font_h 

struct sdl{
    SDL_Surface *screen;
    SDL_Surface *icon;
    int bpp;
    SDL_Color colors[256];
    SDL_Rect termarea;
    int gr[16];
    int termcol[16];
    int yellow, red, green;
    int cursor;
    SDL_Thread *event_thread;
    int event_thread_break;
    int mouse_drag, drag_buttons;
    int eventpipestate;
    MUTEX_DEFINE(eventpipestate);
/*    GMutex *eventpipestate_mutex;
#ifdef LEAK_DEBUG_LIST
    char *eventpipestate_file;
    int eventpipestate_line;
#endif        */
    gchar *title;
    int mouse_x, mouse_y;
    int pipefd;
    iconv_t iconv;
    int font_w;
    int font_h;
#if defined(_MSC_VER) || defined(__MINGW32__)
	int event_timer_id;
#endif

};

extern struct sdl *sdl;

struct sdl *init_sdl(void);
void sdl_stop_event_thread(void);
void free_sdl(void);
SDL_Rect *new_rect(int x, int y, int w, int h);
void free_rect(SDL_Rect *rect);
void sdl_info(void);
int sdl_setvideomode(int w, int h, int init);
void sdl_redraw_screen(void);
int sdl_get_terminal_size(int, int *, int *);
int sdl_attach_terminal(int, int, int);
int sdl_event_thread(void *handle);
#ifdef SDL_USERDATA_IN_FILTEREVENT
int sdl_filter_events(void *userdata, const SDL_Event *ev);
#else    
int sdl_filter_events(const SDL_Event *ev);
#endif    

int makecol(int r, int g, int b);

int clip_pixel(SDL_Rect *clip, int x, int y);
    
void fast_putpixel8(SDL_Surface *surface, int x, int y, int color);
void fast_putpixel16(SDL_Surface *surface, int x, int y, int color);
void fast_putpixel24(SDL_Surface *surface, int x, int y, int color);
void fast_putpixel32(SDL_Surface *surface, int x, int y, int color);
extern void (*fast_putpixel)(SDL_Surface *surface, int x, int y, int color);
int fast_getpixel8(SDL_Surface *surface, int x, int y);
int fast_getpixel16(SDL_Surface *surface, int x, int y);
int fast_getpixel24(SDL_Surface *surface, int x, int y);
int fast_getpixel32(SDL_Surface *surface, int x, int y);
extern int (*fast_getpixel)(SDL_Surface *surface, int x, int y);
int overlapped_pixel(SDL_Rect *clip_rect, int x, int y);
int overlapped_rect(SDL_Rect *clip_rect, SDL_Rect *rect);
int overlapped_line(SDL_Rect *clip_rect, int x1, int y1, int x2, int y2);
void line(SDL_Surface *surface, int x1, int y1, int x2, int y2, int color);
void cross(SDL_Surface *surface, int x, int y, int color, int zoom);
void pip(SDL_Surface *surface, int x, int y, int color1, int color2, int zoom);
void rect(SDL_Surface *surface, int x1, int y1, int x2, int y2, int c);
void rect2(SDL_Surface *surface, SDL_Rect *r, int c);
int sdl_set_title(gchar *title);
void sdl_screenshot(int topwindow);
void do_line(SDL_Surface *surface, int x1, int y1, int x2, int y2, int color, 
        void (*func)(SDL_Surface *surface, int x, int y, int d) );
void triangle(SDL_Surface *surface, int x1, int y1, int x2, int y2, int x3, int y3, int c);

#endif

/* map.c */

int  sw_map_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_map_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_map_redraw(struct subwin *sw, int flags);
void sw_map_check_bounds(struct subwin *sw);
void sw_map_raise(struct subwin *sw);
int maps_reload(void);
void map_clear_qso(struct qso *qso);
void map_add_qso(struct qso *qso);
#ifdef HAVE_SDL
void sw_map_redraw_rect(struct subwin *sw, SDL_Rect *area, int flags);
void sw_map_compose(struct subwin *sw, SDL_Rect *area);
void sw_map_redraw_rotar(struct subwin *sw, SDL_Rect *area, int flags);
void sw_map_update_rotar(struct subwin *sw);
void km2px(struct subwin *sw, int kx, int ky, int *px, int *py);
void px2km(struct subwin *sw, int px, int py, int *kx, int *ky);
void pxkm2o(struct subwin *sw, int px, int py, int kx, int ky, int *ox, int *oy);
void hw2km(double h1, double w1, double h2, double w2, int *kx, int *ky);
void km2qrbqtf(int kx, int ky, double *qrb, double *qtf);

void plot_cor(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area);
void plot_qrv(struct subwin *sw, SDL_Surface *surface, struct qrv_item *qi);
void plot_qrvs(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area);
void plot_gst(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area, double gst[360], int c);
void plot_qso(struct subwin *sw, SDL_Surface *surface, struct qso *qso);
void plot_qsos(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area);
void plot_nearest_qso(struct subwin *sw);
void plot_nearest_qrv(struct subwin *sw);
void plot_info_qso(struct subwin *sw, SDL_Surface *surface, struct qso *qso);
void plot_info_qrv(struct subwin *sw, SDL_Surface *surface, struct qrv_item *qi);
int plot_qrb_qth(struct subwin *sw, SDL_Surface *surface, int mouse_x, int mouse_y);
void plot_rotars(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area, SDL_Rect *outarea);

void map_update_layout(struct subwin *sw);
void move_map(struct subwin *sw, int dx, int dy);
void zoom(struct subwin *sw, double factor, int centerx, int centery);

int map_update_qth(struct subwin *sw);
void map_recalc_cors(void);
struct qso *find_nearest_qso(struct band *b, int mouse_x, int mouse_y);
gchar *find_nearest_qrv(struct qrvdb *qrvdb, int mouse_x, int mouse_y);
void map_for_photo(struct subwin *sw);
void map_recalc_gst(struct subwin *sw);
#endif

/* scope.c */

int  sw_scope_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_scope_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_scope_redraw(struct subwin *sw, int flags);
void sw_scope_check_bounds(struct subwin *sw);
void sw_scope_raise(struct subwin *sw);

/* dsp */

#ifdef HAVE_SNDFILE

#define MAX_CHANNELS 4

enum dsp_type { DSPT_OSS, DSPT_ALSA, DSPT_SSBD };

struct dsp{
    enum dsp_type type;

/* OSS only */    
#ifdef HAVE_OSS
    char *filename;
    int fd;
    int fmt_mask;
    int oss_format,fragment,blksize;
#endif

/* Alsa only */    
#ifdef HAVE_ALSA    
    snd_pcm_t *pcm;
    snd_pcm_format_t pcm_format;
    int pcm_opened;
    int pcm_recover;
#endif    
   
/* OSS and Alsa */
    gchar *name; /* human readable string (/dev/dsp, hw:0,0) */
    int channels,speed;
    char *source;
    int bpf;        /* bytes per frame 8bit=1, 16bit=2 ... */
    int (*open)(struct dsp *dsp, int rec);
    int (*close2)(struct dsp *dsp);
    int (*write)(struct dsp *dsp, void *data, int len);
    int (*read)(struct dsp *dsp, void *data, int len);
    int (*reset)(struct dsp *dsp);
    int (*sync)(struct dsp *dsp);
    int (*set_format)(struct dsp *dsp, SF_INFO *sfinfo);
	int (*set_source)(struct dsp *dsp);
	int (*set_plevel)(struct dsp *dsp);
};

/* format:
    0x10005     8 bit PCM
    0x10002     16 bit PCM    
    0x10010     u-law
    0x10011     a-law
    0x10012     IMA ADPCM
    0x10013     MS ADPCM
    0x10020     GSM 6.1  */

extern struct dsp *dsp;

struct dsp *init_dsp (void);
void free_dsp(struct dsp *dsp);

int dummy_dsp_set_format(struct dsp *dsp, SF_INFO *sfinfo);
int dummy_dsp_open(struct dsp *dsp, int rec);
int dummy_dsp_close(struct dsp *dsp);
int dummy_dsp_write(struct dsp *dsp, void *data, int len);
int dummy_dsp_read(struct dsp *dsp, void *data, int len);
int dummy_dsp_reset(struct dsp *dsp);
int dummy_dsp_sync(struct dsp *dsp);
int dummy_dsp_set_source(struct dsp *dsp);
int dummy_dsp_set_plevel(struct dsp *dsp);
#endif

/* oss.c */

#if defined(HAVE_OSS) && defined(HAVE_SNDFILE)
int oss_set_format(struct dsp *dsp, SF_INFO *sfinfo);
int oss_open(struct dsp *dsp, int rec);
int oss_close(struct dsp *dsp);
int oss_write(struct dsp *dsp, void *data, int len);
int oss_read(struct dsp *dsp, void *data, int len);
int oss_reset(struct dsp *dsp);
int oss_sync(struct dsp *dsp);
int oss_get_sources(GString *labels);
int oss_set_source(struct dsp *dsp);
int oss_set_plevel(struct dsp *dsp);
char *oss_recsrc2source(int recsrc);

char *stripr(char *s);
#endif

/* alsa.c */

#ifdef HAVE_SNDFILE
int alsa_set_format(struct dsp *dsp, SF_INFO *sfinfo);
int alsa_open(struct dsp *dsp, int rec);
int alsa_close(struct dsp *dsp);
int alsa_write(struct dsp *dsp, void *data, int len);
int alsa_read(struct dsp *dsp, void *data, int len);
int alsa_reset(struct dsp *dsp);
int alsa_sync(struct dsp *dsp);
int alsa_get_sources(GString *labels);
int alsa_set_source(struct dsp *dsp);
int alsa_set_plevel(struct dsp *dsp);
#endif
  

  /* threadpipe.c */

struct threadpipe{
    int threadpipe_read, threadpipe_write; /* communication worker_threads->main */
    GString *threadpipe_rdbuf;
};

extern struct threadpipe *tpipe;
struct threadpipe *init_threadpipe(void);
void free_threadpipe(struct threadpipe *tpipe);
void threadpipe_read_handler(cba_t cba);
void threadpipe_rel_read(gchar *str);
int tp_printf(char *m, ...);


  /* img_png.c */
#ifdef HAVE_SDL
SDL_Surface *do_png_load(char *filename);
SDL_Surface *do_png_create(const void *data, int len);
#endif

  /* gfx_img.c */
#ifdef HAVE_SDL
int do_png_save(SDL_Surface * surf, char * fname);
#endif


  /* icons.inc */
#include "icons.h"


  /* alsa.c */
#ifdef HAVE_ALSA
void alsa_info(void);
#endif


  /* scandir.c */
/*int tucnak_scandir(const char *dir, struct dirent ***namelist, int (*select) (const struct dirent *), int (*cmp) (const void *, const void *));*/
int tucnak_scandir(char *dir, struct dirent ***namelist, int (*select) (const struct dirent *), int (*cmp) (const void *, const void *));
int tucnak_alphasort (const void *a, const void *b);


  /* settings.c */
extern char *txt_settings;


  /* ntpq.c */


#ifndef __CYGWIN__

struct ntpq {
    pid_t pid;
    int rfd;
    struct winsize ws;
    GString *buf;
    int good, oldgood;
    int timer;
};

extern struct ntpq *ntpq;

struct ntpq *init_ntpq(void);
void free_ntpq(struct ntpq *ntpq);
void ntpq_timer(cba_t cba);
void ntpq_read_handler(cba_t cba);

#endif

  /* sked.c */

struct skedwin_data{
    int x,y,w,h;
    int esccnt;
    struct band *band;
};

struct sked{
    gchar *sked_time, *operator_ , *src_shortpband, *qrg;
    gint we_call;
    gchar *pband, *time_str, *callsign, *locator, *remark;

    int worked;
};


int sw_sked_kbd_func(struct subwin *sw, struct event *ev, int fw);
int sw_sked_mouse_func(struct subwin *sw, struct event *ev, int fw);
gchar *sw_sked_sprint(struct sked *sked);
void sw_sked_redraw(struct subwin *sw, int flags);
void sw_sked_check_bounds(struct subwin *sw);
void sw_sked_read(gchar *str, int from_my);
void refresh_sked(struct qso *q);
void sked_fn(struct dialog_data *dlg);
void sked(void);
void sked_from_tmpqso(struct tmpqso *tmpqso);
void sked_from_qso(struct qso *qso);
void sked_pband_func(cba_t cba);
void sked_pband(int apband_int);
int dlg_pband(struct dialog_data *dlg, struct dialog_item_data *di);
struct zstring *sked_format(struct sked *sked);
struct sked *sked_parse(struct zstring *zstr);
void free_sked(struct sked *sked);
void recalc_worked_skeds(struct band *band);
void draw_skedwindow(struct skedwin_data *skedwdata);
void skedwindow_func(struct window *win, struct event *ev, int fwd);
void skedw_create(struct band *b);

  /* trig.c */

#ifdef HAVE_HAMLIB

enum trig_cmd { 
    TRIG_FREQ, TRIG_MODE, TRIG_MODE_FREQ, TRIG_RESENDFREQ, TRIG_RIT
};

struct trig_job{
    struct trig_job *next; 
    struct trig_job *prev; 
    enum trig_cmd cmd;
    rmode_t mode;
    freq_t freq;
};

struct trig{
    GThread *thread;
    int thread_break;
    //int pipe_read, pipe_write;
    struct trig_job jobs;
    MUTEX_DEFINE(jobs);

    RIG *rig;
    freq_t qrg;
    int locked;
    rig_model_t model;
    char *filename;
    int speed;
    enum rig_errcode_e error;
};
extern struct trig *trig;
extern GIndexArray *riglist; // of struct rig_caps

struct trig *init_trig(void);
void free_trig(struct trig *trig);

void trig_job_add(struct trig *trig, struct trig_job *job);
struct trig_job *trig_job_get(struct trig *trig);

gpointer trig_main(gpointer xxx);
void trig_read_handler(struct trig *trig, char *s);
void trig_set_mode(struct trig *trig, rmode_t mode);
void trig_set_qrg(struct trig *trig, double qrg);
void trig_set_mode_qrg(struct trig *trig, rmode_t mode, double qrg);
void trig_resend_freq(struct trig *trig);
void trig_set_rit(struct trig *trig, double rit);
int trig_save_riglist(const struct rig_caps *caps, void *data);
int trig_compare (const void *a, const void *b);
char *trig_short_errstr(enum rig_errcode_e error);

#endif

    /* glinebuf.c */

struct glinebuf{
    GString *gs;
    gchar *line;
};

struct glinebuf *init_glb(const char *str);
void free_glb(struct glinebuf *glb);
void glb_append(struct glinebuf *glb, const char *str);
const char *glb_line(struct glinebuf *glb);


    /* zstring.c */

struct zstring {
    int tokenpos;
    char *str;
#ifdef LEAK_DEBUG_LIST
    char *file;
    int line;
#endif
};

#ifdef LEAK_DEBUG_LIST
#define zconcatesc(x...) debug_zconcatesc(__FILE__, __LINE__, x)
#define zstrdup(x) debug_zstrdup(__FILE__, __LINE__, x)
struct zstring *debug_zconcatesc(char *file, int line, char *s1, ...);
struct zstring *debug_zstrdup(char *file, int line, const char *str);
#else
struct zstring *zconcatesc(char *s1, ...);
struct zstring *zstrdup(const char *str);
#endif
char *ztokenize(struct zstring *zstr, int first);
void zfree(struct zstring *zstr);
int ztokens(struct zstring *zstr);
int zwrite(int fd, struct zstring *zs);


    /* fhs.c */

int fhs_lock(char *device, int ignore_stale);
int fhs_unlock(char *device);
char *fhs_error(char *buf, int maxlen, int err, char *device);


    /* excdb.c */

extern struct excdb *excdb;  
  
struct exc_item{
   gchar *exc0, *exc1;    
   gint stamp0, stamp1;
};

struct cxe_item{
   gchar *call0, *call1;    
   gint stamp0, stamp1;
};

struct excdb{
    GHashTable *exc;  /* key=call, value=exc_item */
    GHashTable *cxe;  /* key=exc, value=cxe_item */
    GHashTable *vexc; /* key=exc, value=null (exists or not) */
    GIndexArray *vexcia; /* sorted excs */
    int latest;
    gchar *excname;
    enum exctype exctype;
};


struct excdb *init_exc(void);
gboolean free_exc_item(gpointer key, gpointer value, gpointer user_data);
gboolean free_cxe_item(gpointer key, gpointer value, gpointer user_data);
gboolean free_vexc_item(gpointer key, gpointer value, gpointer user_data);
void free_exc(struct excdb *excdb);
void clear_exc(struct excdb *excdb);

gint get_exc_size(struct excdb *excdb);
gint get_cxe_size(struct excdb *excdb);
gint get_vexc_size(struct excdb *excdb);

void load_one_exc(struct excdb *excdb, gchar *s);
int load_exc_from_file(struct excdb *excdb, gchar *filename);

void load_one_vexc(struct excdb *excdb, gchar *s);
int load_vexc_from_file(struct excdb *excdb, gchar *filename);
int load_vexc_from_mem(struct excdb *excdb, const char *file, const long int len);

int is_valid_vexc(struct excdb *excdb, gchar *vexc);
    
void read_exc_files(struct excdb *excdb, enum exctype exctype, gchar *excname);
void exc_ia_verified(gpointer key, gpointer value, gpointer user_data);
void exc_ia_waz(gpointer key, gpointer value, gpointer user_data);
void exc_ia_itu(gpointer key, gpointer value, gpointer user_data);

void save_one_exc(gpointer key, gpointer value, gpointer user_data);
int save_exc_string(struct excdb *excdb, GString *gs);
int save_exc_into_file(struct excdb *excdb, gchar *filename);

void add_exc(struct excdb *excdb, gchar *call, gchar *wwl, gint stamp);
void add_cxe(struct excdb *excdb, gchar *wwl, gchar *call, gint stamp);

gchar *find_exc_by_call(struct excdb *excdb, gchar *call);
gchar *find_exc_by_call_newer(struct excdb *excdb, gchar *call, int maxstamp);
gchar *find_call_by_exc(struct excdb *exc, gchar *wwl);
void update_exc_from_band(struct excdb *excdb, struct band *band);
void update_exc_from_ctest(struct excdb *excdb, struct contest *ctest);
int valid_vexc(struct excdb *excdb, gchar *vexc);
int rsgbdc_maxcount(char *exc);
void usaca_multiple_exc(char *s);

/* qrvdb.c */

#define QRVSSIZE 30
struct qrv_item{
    gchar *call;
    gchar *wwl;
    int bands_qrv;        // qrv on band
    int wkd[32];          // 0  not wkd or no info about
                          // <0 wkd by others
                          // >0 wkd by me, maybe also by others
    gchar *text;
    time_t kst_time;         // time when spot was caught on KST
    
    int bands_wkd;        // wkd in this contest
    int kx,ky;
    double qrb;
    int qtf;
    double weight;
};

struct qrvdb{
    GIndexArray *qrvs;      // of struct qrv_item
    GHashTable *hash;

    int def_bands;
    double antchar[360];
    int beamwidth;
    double gst[360];
    int (*sort)(const void*, const void *); 
    int (*sort2)(const void*, const void *); 
    int showall;
    char search[QRVSSIZE];
};

extern struct qrvdb *qrvdb;

struct qrvdb *init_qrv(void);
void clear_qrv(struct qrvdb *qrvdb);
void free_qrv(struct qrvdb *qrvdb);

struct qrv_item *qrv_add(gchar *call, gchar *wwl, int qrv_int, int wkd[32], const gchar *text, time_t kst_time);
int load_qrv_files(struct qrvdb *qrvdb);
int save_qrv_to_file(char *filename);

int load_qrv_from_file(struct qrvdb *qrvdb, gchar *filename);
void load_one_qrv(struct qrvdb *qrvdb, gchar *s);

void qrv_set_wkd(struct qrvdb *qrvdb, struct qso *qso);
void qrv_recalc_wkd(struct qrvdb *qrvdb);

void qrv_compute_qrbqtf(struct qrv_item *q);
void qrv_recalc_qrbqtf(struct qrvdb *qrvdb); 
void qrv_recalc_gst(struct qrvdb *qrvdb); 

int qrv_skip(struct qrv_item *qi, int bi);
void sw_qrv_seek(struct subwin *sw, int value);

struct qrv_item *qrv_get(struct qrvdb *qrvdb, char *call);
int qrv_compare_call(const void *a, const void *b);
int qrv_compare_wwl(const void *a, const void *b);
int qrv_compare_me(const void *a, const void *b);
int qrv_compare_qrb(const void *a, const void *b);
int qrv_compare_qtf(const void *a, const void *b);
int qrv_compare_kst_time(const void *a, const void *b);
int qrv_compare_text(const void *a, const void *b);

void qrv_touch(struct qrvdb *qrvdb, char *call);

void edit_qrv(cba_t cba);

/*  fft.c */

#define BLUEPAL
#define ZIAPALx

#ifdef ZIAPAL
#define FFT_COLORS 864
#endif
#ifdef BLUEPAL
#define FFT_COLORS 256
#endif
#define FFT_AMPLEN (SSBBUFFER_LEN/4 + 1)
#define FFT_MA 8

struct fft{
#ifdef USE_FFT 
    fftw_plan plan;
    double *rin;
    fftw_complex *cout;
    int n;
    int pal[FFT_COLORS];
    SDL_Surface *screen;
    MUTEX_DEFINE(screen);
    int screeny;    
    double amp[FFT_AMPLEN];
    /*double ma_amp[FFT_MA][FFT_AMPLEN];
    double ma_sum[FFT_AMPLEN];*/
    //int ma_i;
    //int wf_x2, wf_x3;
    double nea_amp[FFT_AMPLEN];
#else
	int dummy;
#endif
};        	

extern struct fft *fft;

struct fft *init_fft(void);
void free_fft(struct fft *fft);
void fft_start(int n);

void fft_resize(struct fft *fft, struct subwin *sw);
void sw_fft_redraw(struct subwin *sw, int flags);  
void fft_do(struct fft *fft);
int fft_pal(double amp, double min, double max);


/* cabrillo.c */

int export_all_bands_cbr(void);

/* sun.c */

double sunriseset(int sunrise, double latitude, double longitude);
char *sunrisesetstr(char *str, double latitude, double longitude);

/* list.c */

void import_list(void *xxx, char *filename);
    
/* masterdb.c */
  
struct masterdb{
    THashTable *masters; /* key=call, value=name */
};

extern struct masterdb *masterdb;  
  
struct masterdb *init_masterdb(void);
void free_masterdb(struct masterdb *masterdb);
void add_masterdb(struct masterdb *masterdb, gchar *call);
gint get_masterdb_size(struct masterdb *masterdb);
void load_one_masterdb(struct masterdb *masterdb, gchar *s);
int load_masterdb_from_mem(struct masterdb *masterdb, const char *file, const long int len);
int load_masterdb_from_file(struct masterdb *masterdb, gchar *filename);
void read_masterdb_files(struct masterdb *masterdb);
gchar *masterdb_search(struct masterdb *masterdb, char *pattern, int maxreslen);


/* hdkeyb.c */

#define LINE_1 0
#define LINE_2 0x40
#define HDKEYB_LINES 2
#define HDKEYB_CHARS 16

#define HDKEYB_ROTARS 4
#define HDKEYB_BUFLEN 32 

struct hdkeyb{
#ifdef HAVE_LIBFTDI
    struct ftdi_context *ftdi;
    GThread *thread;
    int qtf[HDKEYB_ROTARS];
    int give_me_chance;
    int thread_break;
    char sbuf[HDKEYB_BUFLEN], rbuf[HDKEYB_BUFLEN];
    int slen, rlen;
    char wr, rd;
    char oldkeystate;
    char vram[HDKEYB_LINES][HDKEYB_CHARS], oldvram[HDKEYB_LINES][HDKEYB_CHARS];
    int actnr;
    char qtfstr[4];
#else
	int dummy;
#endif    
};

extern struct hdkeyb *hdkeyb;

struct hdkeyb *init_hdkeyb(void);
void free_hdkeyb(struct hdkeyb *hdkeyb);
gpointer hdkeyb_main(gpointer xxx);
void hdkeyb_read_handler(char *s);
void hdkeyb_key(struct hdkeyb *hdkeyb, char key);
void hdkeyb_activate(struct hdkeyb *hdkeyb, int nr);

void hdkeyb_set_qtf(struct hdkeyb *hdkeyb);
void hdkeyb_rel_qtf(struct hdkeyb *hdkeyb, int rel);

void hdkeyb_send(struct hdkeyb *hdkeyb);
int hdkeyb_flush(struct hdkeyb *hdkeyb);
int hdkeyb_reset(struct hdkeyb *hdkeyb);
int hdkeyb_setdir(struct hdkeyb *hdkeyb);
int hdkeyb_cmd_nowait(struct hdkeyb *hdkeyb, char c);
int hdkeyb_write(struct hdkeyb *hdkeyb, char c);
int hdkeyb_wait(struct hdkeyb *hdkeyb);
int hdkeyb_cmd(struct hdkeyb *hdkeyb, char c);
#define hdkeyb_cursor(hdkeyb, c) hdkeyb_cmd(hdkeyb, 0x80|(c))
int hdkeyb_data(struct hdkeyb *hdkeyb, char c);
void hdkeyb_cgram(struct hdkeyb *hdkeyb, char pos);
void hdkeyb_printc(struct hdkeyb *hdkeyb, char *str);
void hdkeyb_printf(struct hdkeyb *hdkeyb, char line, char col, char *m, ...);
void hdkeyb_print(struct hdkeyb *hdkeyb, char pos, char *str);
void hdkeyb_clear(struct hdkeyb *hdkeyb);
char hdkeyb_keyb_state(struct hdkeyb *hdkeyb);
char hdkeyb_read_key(struct hdkeyb *hdkeyb);
int hdkeyb_debug_pins(char a, char *t);
void hdkeyb_draw_rotar(struct hdkeyb *hdkeyb, int nr);
void hdkeyb_draw_rotars(struct hdkeyb *hdkeyb);
//int hdkeyb_test(void);

/* wiki.c */

//gchar *qw(GString *gs, gchar *s);
void wiki_header(GString *gs);
void wiki_band_header(GString *gs, struct band *b, int flags);
void wiki_footer(GString *gs);
void wiki_complete(GString *gs);
int export_all_bands_wiki(void);

/* player.c */

#define PREVIEW_H 3
#define PLAYER_H 1
int  sw_player_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_player_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_player_redraw(struct subwin *sw, int flags);
void sw_player_check_bounds(struct subwin *sw);
void sw_player_raise(struct subwin *sw);

void sw_player_free(struct subwin *sw);
void player_play(char *filename);

/* chart.c */

#define CHART_H 0

struct chqso{
    int time;
    int value;
    char *call;
    int pts;
};

struct chband{
    GPtrArray *chqsos; // of struct chqso
    int color;
    gchar *pcall;
    gchar *pwwlo;
    gchar *tname;
    gchar *pband;
    int mouse_value;
    gchar *filename;
};

//int  sw_chart_load_files(struct subwin *sw);
int  sw_chart_load_file(struct subwin *sw, char *filename);
int  sw_chart_kbd_func(struct subwin *sw, struct event *ev, int fw);
int  sw_chart_mouse_func(struct subwin *sw, struct event *ev, int fw);
void sw_chart_redraw(struct subwin *sw, int flags);
void sw_chart_check_bounds(struct subwin *sw);
void sw_chart_raise(struct subwin *sw);
int save_chart_to_file(char *filename);
int load_chart_from_file(char *filename);

void sw_chart_free(struct subwin *sw);
void sw_chart_free_band(struct chband *b);
int sw_chart_recalc_extremes(struct subwin *sw);
int chart_reload(void);
void chart_clear_all(void);
void sw_chart_delete_band(cba_t idx, cba_t unused);

/* httpd.c */

struct httpd{
    int port;
    int sock;
    GPtrArray *conns;
};

struct httpconn{
    int sock;
    GString *request;
    GString *response;
	char *response_mem;
	int response_len, response_i;
};

extern struct httpd *httpd;

struct httpd *init_httpd(void);
void free_httpd(struct httpd *httpd);
void httpd_accept_handler(cba_t cba);
void httpd_read_handler(cba_t cba);
void httpd_write_handler(cba_t cba);
void httpd_header(struct httpconn *conn, int status);
void httpd_get(struct httpconn *conn);


/* eprintf.c */
int zg_string_veprintfa(const char *flags, GString *gs, char *fmt, va_list l);
int zg_string_eprintfa(const char *flags, GString *gs, char *fmt, ...);
int zg_string_eprintf(const char *flags, GString *gs, char *fmt, ...);

#endif /* __HEADER_H */     
