/* ====================================================================
 * Copyright (c) 2007-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "WcViewWhatsThis.h"
#include "StatusId.h"
#include "sublib/ColorStorage.h"



static QString getStatusCodeInfo( StatusId id )
{
  QString s;
  s += "<td align=center>" + getStatusCode(id)         +  "</td>";
  s += "<td align=center>" + getStatusName(id)         +  "</td>";
  s += "<td bgcolor="      + getStatusColor(id).name() + " width=20></td>";
  return s;
}

static QString getStatusCodeInfo2( StatusId id )
{
  QString s;
  s += "<td align=center>" + getStatusCode(id) + "</td>";
  s += "<td align=center>" + getStatusName(id) + "</td>";
  s += "<td>                                      </td>";
  return s;
}

static QString buildWhatsThis()
{
  QString ws = 
    "<qt>";
  ws += "<b>" + _q("working copy view columns") + "</b>";
  ws += 
     "<hr>"
     "<table cellspacing=2>"
      "<tr>";
  ws += "<td><nobr>"     + _q("path/name")                    + "</nobr></td>";
  ws += "<td colspan=6>" + _q("the path and name of an item") + "</td>"
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("text status")                  + "</nobr></td>";
  ws += "<td colspan=6>" + _q("whether an item is modified")  + "</td>"
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo(StatusNormal) + getStatusCodeInfo(StatusAdded) +
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo(StatusConflicted) + getStatusCodeInfo(StatusDeleted) +
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo(StatusMerged) + getStatusCodeInfo(StatusIgnored) +
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo(StatusModified) + getStatusCodeInfo(StatusReplaced) +
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo(StatusExternal) + getStatusCodeInfo(StatusIncomplete) +
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo(StatusMissing) + getStatusCodeInfo(StatusObstructed) +
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("property status")                          + "</nobr></td>";
  ws += "<td colspan=6>" + _q("whether an items properties are modified") + "</td>"
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo(StatusNormal) + getStatusCodeInfo(StatusConflicted) +
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo(StatusModified) + "<td colspan=3></td>" +
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("working copy lock")                                                       + "</nobr></td>";
  ws += "<td colspan=6>" + _q("whether a working copy folder is locked by another subversion operation") + "</td>"
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo2(StatusWcLockNone) + getStatusCodeInfo2(StatusWcLockLocked) +
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"      + _q("added with history")                    + "</nobr></td>";
  ws += "<td colspan=6>"  + _q("whether an item is added with history") + "</td>"
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo2(StatusHistoryNone) + getStatusCodeInfo2(StatusHistory) +
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("switched")                                          + "</nobr></td>";
  ws += "<td colspan=6>" + _q("whether an item is switched relativ to its parent") + "</td>"
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo2(StatusSwitchedNo) + getStatusCodeInfo2(StatusSwitched) +
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("repository lock")                             + "</nobr></td>";
  ws += "<td colspan=6>" + _q("whether an item is locked in the repository") + "</td>"
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo2(StatusLockNone)   + getStatusCodeInfo2(StatusLockLocked) +
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo2(StatusLockOther)  + getStatusCodeInfo2(StatusLockStolen) +
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo2(StatusLockBroken) + "<td colspan=3></td>"
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("update available")                                       + "</nobr></td>";
  ws += "<td colspan=6>" + _q("whether an item has a newer revision in the repository") + "</td>"
      "</tr>"
      "<tr>";
  ws += "<td colspan=1></td>";
  ws += getStatusCodeInfo2(StatusUpToDate) + getStatusCodeInfo2(StatusUpToDateNo) +
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("working copy revision")     + "</nobr></td>";
  ws += "<td colspan=6>" + _q("the working copy revision") + "</td>"
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("last committed revision")          + "</nobr></td>";
  ws += "<td colspan=6>" + _q("an items last committed revision") + "</td>"
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("last committed author")                   + "</nobr></td>";
  ws += "<td colspan=6>" + _q("an items last committed revision author") + "</td>"
      "</tr>"
      "<tr><td colspan=7></td></tr>"
      "<tr>";
  ws += "<td><nobr>"     + _q("deep status")                                               + "</nobr></td>";
  ws += "<td colspan=6>" + _q("(folders only) whether there are any child items modified") + "</td>"
      "</tr>"
      "<tr>";
  ws += "<td></td>"
        "<td></td><td>not modified</td><td></td>" "<td>*</td><td>modified</td><td></td>";
      "</tr>"
     "</table>"
    "</qt>";

  return ws;
}


QString WcViewWhatsThis::get()
{
  return buildWhatsThis();
}
