6.1 Ajout de FX

# Ajout d'effets (FX)

Dans cette section, nous allons regarder un couple de FX : 
réverbération et écho. Nous allons voir comment les utiliser, comment 
contrôler leurs paramètres et comment les chaîner.

Le système des FX de Sonic Pi utilise les blocs. Donc, si vous n'avez 
pas lu la section 5.1, vous pourriez vouloir lui jeter un œil et puis 
revenir ici.

## Réverbération

Si nous voulons utiliser la réverbération, nous écrivons `with_fx :reverb`
en tant qu'entête particulière de notre bloc, comme ceci :

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Maintenant exécutez ce code et vous l'entendrez joué avec réverbération. 
Ça sonne bien, n'est-ce pas ! Toute chose sonne plutôt agréablement 
avec de la réverbération.

Maintenant, voyons ce qui se passe si nous avons du code en dehors du 
bloc do/end :

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

Remarquez que le dernier `play 55` n'est pas joué avec de la 
réverbération. C'est parce qu'il est *en dehors* du bloc do/end, ainsi 
le FX de réverbération n'agit pas sur lui.

Similairement, si vous placez des sons avant le bloc do/end, ils ne 
seront pas non plus affectés :

```
play 55
sleep 1

with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

## Écho

Il y a beaucoup de FX au choix. Que dire au sujet de l'écho ?

```
with_fx :echo do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Un des puissants aspects des blocs FX de Sonic Pi est qu'on peut leur 
passer des paramètres de manière similaire aux paramètres que nous 
avons déjà vus avec `play` et `sample`. Par exemple, un paramètre 
sympa d'écho avec lequel jouer est `phase:`. Il représente la durée 
d'un écho en temps musicaux. Faisons l'écho plus lent :

```
with_fx :echo, phase: 0.5 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Faisons aussi l'écho plus rapide :

```
with_fx :echo, phase: 0.125 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Faisons décroître l'écho plus longuement en spécifiant la durée de `decay:`
à 8 temps :

```
with_fx :echo, phase: 0.5, decay: 8 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

## Imbrication des FX

Un des aspects les plus puissants des blocs FX est que vous pouvez les 
imbriquer. Ce qui vous permet de chaîner facilement les FX entre eux. 
Par exemple, que faire si vous vouliez jouer du code avec de l'écho et 
ensuite de la réverbération ? Facile, mettez simplement l'un à 
l'intérieur de l'autre :

```
with_fx :reverb do
  with_fx :echo, phase: 0.5, decay: 8 do
    play 50
    sleep 0.5
    sample :elec_blup
    sleep 0.5
    play 62
  end
end
```

Pensez à du son provenant de l'intérieur et se propageant vers 
l'extérieur. Le son de tout le code situé dans le bloc intérieur dont 
`play 50` est d'abord envoyé vers le FX écho et le son produit par le FX 
écho est à son tour envoyé vers le FX réverbération. 

Nous pouvons utiliser des imbrications très profondes pour des 
résultats délirants. Toutefois, soyez averti, les FX peuvent utiliser 
beaucoup de ressources et quand vous les imbriquez, vous allez 
effectivement faire agir de multiples FX simultanément. Donc soyez 
économe avec l'utilisation des FX, en particulier sur des plateformes 
peu puissantes telles que le Raspberry Pi.

## À la découverte des FX

Sonic Pi est livré avec un grand nombre de FX avec lesquels vous pouvez 
jouer. Pour trouver ceux qui sont disponibles, cliquez sur "FX" dans le
menu horizontal du système d'aide et vous verrez une liste des options 
disponibles. Voici une liste de mes préférés :

* wobble,
* reverb,
* echo,
* distortion,
* slicer

Maintenant, défoulez-vous et ajoutez des effets partout pour obtenir
d'étonnants sons nouveaux !
