---
title: Translating Solaar
layout: page
---

# Translating Solaar

First, make sure you have installed the `gettext` package.

Here are the steps to add/update a translation (you should run all scripts from
the source root):

1. Get an up-to-date copy of the source files. Preferably, make a clone on
   GitHub and clone it locally on your machine; this way you can later make a
   pull request to the main project.

2. Run `./tools/po-update.sh <language>`; it will create/update the file
   `./po/<language>.po`.

3. Edit `./po/<language>.po` with your favorite editor (just make sure it saves
   the file with the UTF-8 encoding). For each string in English (msgid), edit
   the translation (msgstr); if you leave msgstr empty, the string will remain
   untranslated.

   Alternatively, you can use the excellent `poedit`.

4. Run `./tools/po-compile.sh`. It will bring up-to-date all the compiled
   language files, necessary at runtime.

5. Start Solaar (`./bin/solaar`). By default, it will pick up the system language
   from your environment; to start it in another language, run
   `LANGUAGE=<language> ./bin/solaar`.

You can edit the translation iteratively, just repeat from step 3.
If the upstream changes, do a `git pull` and then repeat from step 2.

Before opening a pull request, please run `./tools/po-update.sh` again. It will
format and sort the translation file, and ensure a minimal diff when updating
a translation.

## Supported languages

Currently Solaar has been translated in the following languages:

- Français: [Papoteur][papoteur], [David Geiger][david-geiger],
  [Damien Lallement][damsweb]
- Italiano: [Michele Olivo][micheleolivo]
- Polski: [Adrian Piotrowicz][nexces]
- Portuguese-BR: [Drovetto][drovetto], [Josenivaldo Benito Jr.][jrbenito]
- Română: Daniel Pavel
- Russian: [Dimitriy Ryazantcev][DJm00n]
- Slovak: [Jose Riha][jose1711]
- Svensk: [Daniel Zippert][zipperten], Emelie Snecker

[papoteur]: http://github.com/papoteur
[david-geiger]: http://github.com/david-geiger
[damsweb]: http://github.com/damsweb
[DJm00n]: https://github.com/DJm00n
[jose1711]: https://github.com/jose1711
[nexces]: http://github.com/nexces
[zipperten]: http://github.com/zipperten
[micheleolivo]: http://github.com/micheleolivo
[drovetto]: https://github.com/drovetto
[jrbenito]: https://github.com/jrbenito/
