/*
 * VRT RULES
 *
 * Copyright (C) 2014-2019 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule2527eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule2527flow0 =
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule2527option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    { &rule2527flow0 }
};
// content:"STARTTLS|0D 0A|", depth 10, relative;
static ContentInfo rule2527content1 =
{
    (u_int8_t *)("STARTTLS|0D 0A|"), /* pattern (now in snort content format) */
    10, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2527option1 =
{
    OPTION_TYPE_CONTENT,
    { &rule2527content1 }
};
/* flowbits:set "starttls.attempt"; */
static FlowBitsInfo rule2527flowbits2 =
{
    "starttls.attempt",
    FLOWBIT_SET,
    0,
    0, /* flags */
    NULL, /*group name*/
    0,/*eval*/
    NULL, /*ids*/
    0 /*num_ids*/
};

static RuleOption rule2527option2 =
{
    OPTION_TYPE_FLOWBIT,
    { &rule2527flowbits2 }
};
/* flowbits:noalert; */
static FlowBitsInfo rule2527flowbits3 =
{
    "",
    FLOWBIT_NOALERT,
    0,
    0, /* flags */
    NULL, /*group name*/
    0,/*eval*/
    NULL, /*ids*/
    0 /*num_ids*/
};

static RuleOption rule2527option3 =
{
    OPTION_TYPE_FLOWBIT,
    { &rule2527flowbits3 }
};

/* references for sid 2527 */
static RuleReference *rule2527refs[] =
{
    NULL
};
RuleOption *rule2527options[] =
{
    &rule2527option0,
    &rule2527option1,
    &rule2527option2,
    &rule2527option3,
    NULL
};

Rule rule2527 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       1, /* DIRECTION */
       "$SMTP_SERVERS", /* DSTIP     */
       "25", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       2527, /* sigid */
       3, /* revision */

       "protocol-command-decode", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SMTP STARTTLS attempt",     /* message */
       rule2527refs, /* ptr to references */
       NULL /* Meta data */
   },
   rule2527options, /* ptr to rule options */
   &rule2527eval, /* use the built in detection function */
   0, /* am I initialized yet? */
   0,                                  /* Rule option count, used internally */
   0,                                  /* Flag with no alert, used internally */
   NULL /* ptr to internal data... setup during rule registration */
};


/* detection functions */
int rule2527eval(void *p) {
    //const u_int8_t *cursor_uri = 0;
    //const u_int8_t *cursor_raw = 0;
    const u_int8_t *cursor_normal = 0;


    // flow:established, to_server;
    if (checkFlow(p, rule2527options[0]->option_u.flowFlags) > 0 ) {
        // content:"STARTTLS|0D 0A|", depth 10, relative;
        if (contentMatch(p, rule2527options[1]->option_u.content, &cursor_normal) > 0) {
            // flowbits:set "starttls.attempt";
            if (processFlowbits(p, rule2527options[2]->option_u.flowBit) > 0) {
                    // flowbits:noalert;
                /* NOTE: Not including any further functions for testing! */
                return RULE_NOMATCH;
            }
        }
    }
    return RULE_NOMATCH;
}

