// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Serge Steer
// Copyright (C) 2011 - DIGITEO - Michal Baudin
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// Maple code used to create reference
// Digits := 40: 
// writeto("asecd.ref"): interface(prettyprint = 0): 
// for i from 1 by 1/100  to 10 do  print(i,evalf[30](arcsec(i)*180/pi, 30)) end do: 
// writeto(terminal):
// writeto("asecdi.ref"): interface(prettyprint = 0): 
// for i from 1/100 by 1/100 to 1 do  print(i,evalf[30](Im(arcsec(i))*180/pi, 30)) end do: 
// writeto(terminal):
ieee(2)

pi=%pi;eps=%eps;Inf=%inf;NaN=%nan; //used to make following code runnable under Matlab

ref=[1, 0.
101/100, 8.06930115939378219266534386602
51/50, 11.3648769670336770665211939354
103/100, 13.8624321164338475678213420980
26/25, 15.9423686056286392297353154763
21/20, 17.7527901619466830009137842084
53/50, 19.3700382455405467115104945520
107/100, 20.8396936648444636318851719446
27/25, 22.1916065662727853093984037327
109/100, 23.4466172550467659331909315350
11/10, 24.6199773286571016746480033030
111/100, 25.7232595218800805765528721166
28/25, 26.7655005767560996837811723218
113/100, 27.7539233557700798996764394207
57/50, 28.6944135267943759113160998586
23/20, 29.5918457939507343510392721100
29/25, 30.4503140213556401728627303853
117/100, 31.2732977997236005762075958893
59/50, 32.0637857175384205113848847899
119/100, 32.8243683734346662827420824027
6/5, 33.5573097619207152928807991556
121/100, 34.2646028937062044673546872717
61/50, 34.9480137199057150930088130331
123/100, 35.6091162417449542601010157770
31/25, 36.2493208828993838395882580521
5/4, 36.8698976458440212968556125590
63/50, 37.4719951828138861916485498861
127/100, 38.0566566327405659938765676053
32/25, 38.6248328730529618705183198215
129/100, 39.1773936864242545938700955159
13/10, 39.7151372318262061833784337809
131/100, 40.2387981259242899662193794111
33/25, 40.7490543774703902395794621858
133/100, 41.2465333686727655465580330981
67/50, 41.7318170397937627260992369650
27/20, 42.2054464037322934190506579180
34/25, 42.6679254941083862799280468043
137/100, 43.1197248319180253890532333519
69/50, 43.5612844810774379375487801661
139/100, 43.9930167513068938003543237939
7/5, 44.4153085971929749741112400523
141/100, 44.8285237544397341559251832043
71/50, 45.2330046479070303405224211281
143/100, 45.6290741007545989377263184922
36/25, 46.0170368696413160715570072570
29/20, 46.3971810272963764595102678261
73/50, 46.7697792107449388576347201541
147/100, 47.1350897509256427902783199138
37/25, 47.4933576972936692039910443734
149/100, 47.8448157491903040029735894708
3/2, 48.1896851042214019341420832694
151/100, 48.5281762325765884766908227983
38/25, 48.8604895851008536320171029782
153/100, 49.1868162419695743626385959484
77/50, 49.5073385079916182193900040832
31/20, 49.8222304598521146732787875379
39/25, 50.1316584499893996657490771339
157/100, 50.4357815712651247990560149804
79/50, 50.7347520861205394024507500763
159/100, 51.0287158235054195432129435155
8/5, 51.3178125465105600090612516256
161/100, 51.6021762933230200435387772807
81/50, 51.8819356938493803093794706445
163/100, 52.1572142641110035309205847960
41/25, 52.4281306803023363965768831612
33/20, 52.6947990342149283753167855221
83/50, 52.9573290715628951091077860564
167/100, 53.2158264145972942400962211866
42/25, 53.4703927702649669685044040794
169/100, 53.7211261250498105340774958714
17/10, 53.9681209275294416296046324803
171/100, 54.2114682595862792423106503513
43/25, 54.4512559971279082623843024569
173/100, 54.6875689610960441013079345178
87/50, 54.9204890594755118578538588843
7/4, 55.1500954209535155885194822800
44/25, 55.3764645208243468253798732344
177/100, 55.5996702996849031314734981920
89/50, 55.8197842754213746769815801940
179/100, 56.0368756489466972288648571370
9/5, 56.2510114041114121825956672556
181/100, 56.4622564021770199512762516139
91/50, 56.6706734712104099930833917492
183/100, 56.8763234907301871731629185677
46/25, 57.0792654719104134774366198504
37/20, 57.2795566336242006965966133014
93/50, 57.4772524745885050859260658604
187/100, 57.6724068418521945401997816542
47/25, 57.8650719958518088641700587289
189/100, 58.0552986722432591496934704438
19/10, 58.2431361407028743289166584148
191/100, 58.4286322608775773651971987827
48/25, 58.6118335356514487907115106191
193/100, 58.7927851618844112904439806451
97/50, 58.9715310787681557520100583445
39/20, 59.1481140139346456160283619315
49/25, 59.3225755274435094377217648358
197/100, 59.4949560537662954054088637835
99/50, 59.6652949418778566230897801627
199/100, 59.8336304935580084141625008279
2, 60.
201/100, 60.1644397768162284768172241344
101/50, 60.3269851975259529811112825895
203/100, 60.4876707256045049030119967802
51/25, 60.6465299451686028930912919511
41/20, 60.8035955903678391060745616512
103/50, 60.9588995735481782140579035591
207/100, 61.1124730122493782040346934151
52/25, 61.2643462550945790388459532172
209/100, 61.4145489066268910733398714068
21/10, 61.5631098511446306338063052668
211/100, 61.7100572755838779641943393957
53/25, 61.8554186914942568616825054208
213/100, 61.9992209561512411442046349548
107/50, 62.1414902928458672014763278867
43/20, 62.2822523103904619673383991235
54/25, 62.4215320218768704045335740769
217/100, 62.5593538627216756148644429023
109/50, 62.6957417080310384105782662530
219/100, 62.8307188893160327973663418044
11/5, 62.9643082105877112081664769110
221/100, 63.0965319638595910049138985844
111/50, 63.2274119440838048255428350585
223/100, 63.3569694635457954179992741802
56/25, 63.4852253657411547783917597051
9/4, 63.6122000387570022473271756439
113/50, 63.7379134281791616748508100805
227/100, 63.8623850495453291719187723169
57/25, 63.9856340003634159999740908450
229/100, 64.1076789717133018005213025945
23/10, 64.2285382594493379143715497296
231/100, 64.3482297750200955333556215605
58/25, 64.4667710559210556596889545782
233/100, 64.5841792757951843404654777388
117/50, 64.7004712541956246266948173565
47/20, 64.8156634660240636005678777804
59/25, 64.9297720506576962220915713983
237/100, 65.0428128207771054323404177226
119/50, 65.1548012709068078329828738550
239/100, 65.2657525856796743988867653443
12/5, 65.3756816478359242612320614690
241/100, 65.4846030459669049320853034739
121/50, 65.5925310820134128490776966605
243/100, 65.6994797785278723256304685192
61/25, 65.8054628857092775192360186498
49/20, 65.9104938882194095880734062510
123/50, 66.0145860117884685880814337457
247/100, 66.1177522296179057389595660973
62/25, 66.2200052685879054004849275385
249/100, 66.3213576152766464587309929439
5/2, 66.4218215217981688959775005800
251/100, 66.5214090114653822367861585052
63/25, 66.6201318842844775081544073113
253/100, 66.7180017222867425562624770177
127/50, 66.8150298947035313052661906205
51/20, 66.9112275629899001476491032853
64/25, 67.0066056857021984843368146289
257/100, 67.1011750232346848876173423696
129/50, 67.1949461424200348779470787579
259/100, 67.2879294209984103571929166487
13/5, 67.3801350519595738270509891232
261/100, 67.4715730477623521726141165974
131/50, 67.5622532444355845648342582348
263/100, 67.6521853055645265148898973980
66/25, 67.7413787261665269050030857748
53/20, 67.8298428364596465531734720217
133/50, 67.9175868055277451936616553360
267/100, 68.0046196448854283405525900586
67/25, 68.0909502119461160364755122392
269/100, 68.1765872133963716779554692546
27/10, 68.2615392084795106745643564880
271/100, 68.3458146121913953779182444298
68/25, 68.4294216983912142598549686520
273/100, 68.5123686028299394915146079533
137/50, 68.5946633260990576538963978402
11/4, 68.6763137365020730850562951539
69/25, 68.7573275728511921399315844169
277/100, 68.8377124471915092168814303193
139/50, 68.9174758474549316114058673924
279/100, 68.9966251400459999225069625879
14/5, 69.0751675723616836999676051418
281/100, 69.1531102752471581289489299741
141/50, 69.2304602653894966570966034745
283/100, 69.3072244476511464415508246174
71/25, 69.3834096173449881986114539376
57/20, 69.4590224624527193536480777112
143/50, 69.5340695657882391957208164676
287/100, 69.6085574071076569287278031002
72/25, 69.6824923651674879727124766437
289/100, 69.7558807197325505044928988902
29/10, 69.8287286535350229402261881767
291/100, 69.9010422541860737627996784937
73/25, 69.9728275160414276973946912282
293/100, 70.0440903420221866567507871935
147/50, 70.1148365453921800350992208352
59/20, 70.1850718514930767517329909292
74/25, 70.2548018994384508606048888349
297/100, 70.3240322437679534834426713220
149/50, 70.3927683560627062260942571614
299/100, 70.4610156265229950396551143269
3, 70.5287793655093086307540006601
301/100, 70.5960648050477319532825200882
151/50, 70.6628771003006729735403866296
303/100, 70.7292213310038697413826834624
76/25, 70.7951025028705947729827256310
61/20, 70.8605255489639448099655144958
153/50, 70.9254953310380761207280626182
307/100, 70.9900166408492186105493111988
77/25, 71.0540942014372760673090108413
309/100, 71.1177326683787948507924891251
31/10, 71.1809366310120591988839598205
311/100, 71.2437106136350480383045150806
78/25, 71.3060590766769657173443035184
313/100, 71.3679864178440373911607927804
157/50, 71.4294969732402388559611467437
63/20, 71.4905950184636104173891403598
79/25, 71.5512847696787848626018808225
317/100, 71.6115703846663407579679601820
159/50, 71.6714559638495740893208246184
319/100, 71.7309455512992636746339941979
16/5, 71.7900431357169887862719594506
321/100, 71.8487526513975409990353845754
161/50, 71.9070779791709564094378966852
323/100, 71.9650229473246790303091712521
81/25, 72.0225913325063513330668467415
13/4, 72.0797868606077135688164003881
163/50, 72.1366132076300796305907516507
327/100, 72.1930740005318438050501630576
82/25, 72.2491728180584597860667776871
329/100, 72.3049131915553207687418186937
33/10, 72.3602986057639572951272744104
331/100, 72.4153324996019577674538555628
83/25, 72.4700182669270051668070995976
333/100, 72.5243592572854125013189923905
167/50, 72.5783587766455288449746842330
67/20, 72.6320200881163775035160481431
84/25, 72.6853464126518778455982494351
337/100, 72.7383409297409926537416647496
169/50, 72.7910067780841334695953411416
339/100, 72.8433470562561473209023013483
17/5, 72.8953648233561994130617516630
341/100, 72.9470630996448578364488310088
171/50, 72.9984448671686780721918537685
343/100, 73.0495130703725770647993248539
86/25, 73.1002706167002788611044403841
69/20, 73.1507203771831062830194037872
173/50, 73.2008651870173857984535759945
347/100, 73.2507078461307256726444436303
87/25, 73.3002511197374206135702597377
349/100, 73.3494977388832294628327423317
7/2, 73.3984504009797660204635462547
351/100, 73.4471117703287368218256673801
88/25, 73.4954844786362536007062791738
353/100, 73.5435711255174422686257698818
177/50, 73.5913742789915645103434527472
71/20, 73.6388964759678625337682169904
89/25, 73.6861402227223321134381577098
357/100, 73.7331079953656238250755568358
179/50, 73.7798022403022672793056291051
359/100, 73.8262253746814082204891054251
18/5, 73.8723797868392435569792229726
361/100, 73.9182678367333347273644354036
181/50, 73.9638918563689752789559248716
363/100, 74.0092541502177841356394124935
91/25, 74.0543569956286917581020504329
73/20, 74.0992026432314822463821892344
183/50, 74.1437933173330503988283081713
367/100, 74.1881312163065288191845648418
92/25, 74.2322185129734363510656400727
369/100, 74.2760573549789954130893659075
37/10, 74.3196498651607622050689204069
371/100, 74.3629981419107102527097875906
93/25, 74.4061042595309043521041731248
373/100, 74.4489702685828986629681866095
187/50, 74.4915981962309894781289331839
15/4, 74.5339900465794500634429273130
94/25, 74.5761478010038719144125898499
377/100, 74.6180734184767338106544915828
189/50, 74.6597688358873171645403434442
379/100, 74.7012359683560833533435006067
19/5, 74.7424767095436259927258967588
381/100, 74.7834929319543084511177347580
191/50, 74.8242864872346943172758289393
383/100, 74.8648592064668760149303493136
96/25, 74.9052129004568043068885349217
77/20, 74.9453493600177190442703759827
193/50, 74.9852703562487791927834726211
387/100, 75.0249776408089879052435571907
97/25, 75.0644729461865062061156693651
389/100, 75.1037579859634467079495175905
39/10, 75.1428344550762366895285310093
391/100, 75.1817040300716378297174301798
98/25, 75.2203683693585079078023517912
393/100, 75.2588291134553878490459158946
197/50, 75.2970878852339956117513278352
79/20, 75.3351462901587065779160798020
99/25, 75.3730059165220983221740331413
397/100, 75.4106683356766358918355569933
199/50, 75.4481351022625720331423316407
399/100, 75.4854077544321351441007058467
4, 75.5224878140700761212289652011
401/100, 75.5593767870106436950715244234
201/50, 75.5960761632510563162557495959
403/100, 75.6325874171615371590892771400
101/25, 75.6689120076919773521461193093
81/20, 75.7050513785752911239305160453
203/50, 75.7410069585275251655324567382
407/100, 75.7767801614447831602230734549
102/25, 75.8123723865970251112366471388
409/100, 75.8477850188187998126326363450
41/10, 75.8830194286969675532377470874
411/100, 75.9180769727554689193734362798
103/25, 75.9529589936371943675433129797
413/100, 75.9876668202830080726778440964
207/50, 76.0222017681079784201251601396
83/20, 76.0565651391748663995747626824
104/25, 76.0907582223649220757665468227
417/100, 76.1247822935460382534538241302
209/50, 76.1586386157383094219603634108
419/100, 76.1923284392770430571229033762
21/5, 76.2258530019732693747871518680
421/100, 76.2592135292717946696913146241
211/50, 76.2924112344068424359097354813
423/100, 76.3254473185553255494414178526
106/25, 76.3583229709877918994326854360
17/4, 76.3910393692170849813556303910
213/50, 76.4235976791447601126763001628
427/100, 76.4559990552052960986066849448
107/25, 76.4882446405081413619257613661
429/100, 76.5203355669776327560752909975
43/10, 76.5522729554908245042983521199
431/100, 76.5840579160132639490192534009
108/25, 76.6156915477327500545026192047
433/100, 76.6471749391911098816302315576
217/50, 76.6785091684140275459625399960
87/20, 76.7096953030389594786857819804
109/25, 76.7407344004411691341754829841
437/100, 76.7716275078579136273343626685
219/50, 76.8023756625108141382001870048
439/100, 76.8329798917264412901905454705
22/5, 76.8634412130551460913910786587
441/100, 76.8937606343881664251457049629
221/50, 76.9239391540730384865261435880
443/100, 76.9539777610273419847073299150
111/25, 76.9838774348508073675282791756
89/20, 77.0136391459358127732566907808
223/50, 77.0432638555762978754909463975
447/100, 77.0727525160751212599244571684
112/25, 77.1021060708498874560720912157
449/100, 77.1313254545372692427321625054
9/2, 77.1604115930958503526534173673
451/100, 77.1893654039075132193253467069
113/25, 77.2181877958773959367499888242
453/100, 77.2468796695324421412292395701
227/50, 77.2754419171185670723654763226
91/20, 77.3038754226964626283836032366
114/25, 77.3321810622360637983044663326
457/100, 77.3603597037096984302042627862
229/50, 77.3884122071839418805594566380
459/100, 77.4163394249101976842850957418
23/5, 77.4441422014140249883153182270
461/100, 77.4718213735832331032428244319
231/50, 77.4993777707547631474291616294
463/100, 77.5268122148003763859250634541
116/25, 77.5541255202111685023101423070
93/20, 77.5813184941809286849892423083
233/50, 77.6083919366883620603888246214
467/100, 77.6353466405781936637056515437
117/25, 77.6621833916411718032010764926
469/100, 77.6889029686929883463411609562
47/10, 77.7155061436521331351936401362
471/100, 77.7419936816166994242496250441
118/25, 77.7683663409401569260870867050
473/100, 77.7946248733061087488847783426
237/50, 77.8207700238020482145832980863
19/4, 77.8468025309921312573321786740
119/25, 77.8727231269889798186195256385
477/100, 77.8985325375245313780186377708
239/50, 77.9242314820199494866724744675
479/100, 77.9498206736546099043433453518
24/5, 77.9753008194341766799565784908
481/100, 78.0006726202577822599411044814
241/50, 78.0259367709843254581978578157
483/100, 78.0510939604979008760925972295
121/25, 78.0761448717723731203600245284
97/20, 78.1010901819351089311105877220
243/50, 78.1259305623298801011424734403
487/100, 78.1506666785789498413740688074
122/25, 78.1752991906443550253242345204
489/100, 78.1998287528883965280792261961
49/10, 78.2242560141333496619986268500
491/100, 78.2485816177204065024331898470
123/25, 78.2728062015678616918623385019
493/100, 78.2969303982285531100177829971
247/50, 78.3209548349465686006540518689
99/20, 78.3448801337132297525705872694
124/25, 78.3687069113223635431993957612
497/100, 78.3924357794248724674650815313
249/50, 78.4160673445826135926203919504
499/100, 78.4396022083215968012820726960
5, 78.4630409671845123098626284894
501/100, 78.4863842127825973779391044209
251/50, 78.5096325318468519557476045589
503/100, 78.5327865062786128518710391686
126/25, 78.5558467131994958412283121059
101/20, 78.5788137250007149746082373033
253/50, 78.6016881093917881951549155241
507/100, 78.6244704294486382143386725406
127/25, 78.6471612436610974499750352349
509/100, 78.6697611059798256817221562957
51/10, 78.6922705658626489351345826983
511/100, 78.7146901683203279637196903490
128/25, 78.7370204539617645594752350018
513/100, 78.7592619590386537860263857744
257/50, 78.7814152154895900946736970356
103/20, 78.8034807509836351523563851831
129/25, 78.8254590889633550816758887792
517/100, 78.8473507486873346866620837263
259/50, 78.8691562452721761138489500568
519/100, 78.8908760897339892764093344821
26/5, 78.9125107890293812495322261201
521/100, 78.9340608460959517278642491039
261/50, 78.9555267598923015206345192795
523/100, 78.9769090254375609469942880626
131/25, 78.9982081338504448830865846880
21/4, 79.0194245723878411033740287856
263/50, 79.0405588244829384517537343878
527/100, 79.0616113697829012729363122546
132/25, 79.0825826841860964314218571357
529/100, 79.1034732398788791441308243703
53/10, 79.1242835053719437533040652221
531/100, 79.1450139455362454686370555611
133/25, 79.1656650216384990117223940307
533/100, 79.1862371913762600017066430597
267/50, 79.2067309089125948285880017147
107/20, 79.2271466249103446697563609088
134/25, 79.2474847865659892161739721328
537/100, 79.2677458376431155869809620425
269/50, 79.2879302185054978252536585151
539/100, 79.3080383661497922831142641864
27/5, 79.3280707142378541213576025332
541/100, 79.3480276931286800671949112010
271/50, 79.3679097299099824935870540579
543/100, 79.3877172484293998049217830975
136/25, 79.4074506693253480364541337138
109/20, 79.4271104100575184989486116323
273/50, 79.4466968849370262253100417086
547/100, 79.4662105051562139026408844356
137/25, 79.4856516788181159010911296576
549/100, 79.5050208109655869400477380796
11/2, 79.5243183036100998626197409207
551/100, 79.5435445557602169209887674719
138/25, 79.5626999634497389079896975856
553/100, 79.5817849197655364042395750802
277/50, 79.6007998148750673452225964185
111/20, 79.6197450360535850489431072370
139/25, 79.6386209677110407820557595667
557/100, 79.6574279914186848807514179751
279/50, 79.6761664859353703820986071744
559/100, 79.6948368272335630619932509250
28/5, 79.7134393885250617173345670137
561/100, 79.7319745402864324725030710047
281/50, 79.7504426502841608336489192489
563/100, 79.7688440835995251586868982236
141/25, 79.7871792026531951562202348828
113/20, 79.8054483672295589728614280842
283/50, 79.8236519345007823755672169129
567/100, 79.8417902590506034836396982627
142/25, 79.8598636928978664539499231407
569/100, 79.8778725855197974726978204146
57/10, 79.8958172838750263576171334608
571/100, 79.9136981324263570259506513104
143/25, 79.9315154731632900357441322349
573/100, 79.9492696456243003610220270569
287/50, 79.9669609869188735151997895235
23/4, 79.9845898317493030916418875889
144/25, 80.0021565124322527455775696377
577/100, 80.0196613589200855976242457436
289/50, 80.0371046988219639959275467724
579/100, 80.0544868574247225313945267340
29/5, 80.0718081577135171586591459503
581/100, 80.0890689203922532342644444721
291/50, 80.1062694639037952430612717281
583/100, 80.1234101044499609439969137577
146/25, 80.1404911560113026272865313649
117/20, 80.1575129303666781364143074254
293/50, 80.1744757371126142704881485702
587/100, 80.1913798836824651451604731523
147/25, 80.2082256753653680536170440571
589/100, 80.2250134153249993330151904498
59/10, 80.2417434046181327062115390273
591/100, 80.2584159422130025336471839403
148/25, 80.2750313250074743758449106604
593/100, 80.2915898478470252331086980827
297/50, 80.3080918035425357956904960853
119/20, 80.3245374828878970048936450602
149/25, 80.3409271746774331933068893406
597/100, 80.3572611657231440405985410381
299/50, 80.3735397408717675500379570405
599/100, 80.3897631830216662201422578331
6, 80.4059317731395385555614721596
601/100, 80.4220457902769580315065344593
301/50, 80.4381055115867415966834549736
603/100, 80.4541112123391497708153492177
151/25, 80.4700631659379203644038355515
121/20, 80.4859616439361378203947226313
303/50, 80.5018069160519401498621995729
607/100, 80.5175992501840654067033455081
152/25, 80.5333389124272396196332716566
609/100, 80.5490261670874080734833195694
61/10, 80.5646612766968118059233242145
611/100, 80.5802445020289111602470063967
153/25, 80.5957761021131582097702150989
613/100, 80.6112563342496198446882564885
307/50, 80.6266854540234532879143099851
123/20, 80.6420637153192357824694553951
154/25, 80.6573913703351501694097535502
617/100, 80.6726686695970280520508908629
309/50, 80.6878958619722522193799879174
619/100, 80.7030731946835199790212708522
31/5, 80.7182009133224690279415115942
621/100, 80.7332792618631674672366692428
311/50, 80.7483084826754695458273281775
623/100, 80.7632888165382386967017529946
156/25, 80.7782205026524394084761938935
25/4, 80.7931037786540994544871081003
313/50, 80.8079388806271439813839422848
627/100, 80.8227260431161029392488741682
157/25, 80.8374654991386933156263606818
629/100, 80.8521574801982776164955007654
63/10, 80.8668022162962000181572005654
631/100, 80.8813999359440015952311247013
158/25, 80.8959508661755160114597147061
633/100, 80.9104552325588470417935264619
317/50, 80.9249132592082292762792385851
127/20, 80.9393251687957733385844524969
159/25, 80.9536911825630969345674626600
637/100, 80.9680115203328430291312222079
319/50, 80.9822864005200864326845429497
639/100, 80.9965160401436300618660040658
32/5, 81.0107006548371921227630301818
641/100, 81.0248404588604854486761399350
321/50, 81.0389356651101902085325356784
643/100, 81.0529864851308211863401492253
161/25, 81.0669931291254908165891924365
129/20, 81.0809558059665691452494677421
323/50, 81.0948747232062418709745216580
647/100, 81.1087500870869676063045885837
162/25, 81.1225821025518354840556510812
649/100, 81.1363709732548242196883777152
13/2, 81.1501169015709637262647930705
651/100, 81.1638200886064003646189497523
163/25, 81.1774807342083668975873311458
653/100, 81.1910990369750582035619966407
327/50, 81.2046751942654137912414248104
131/20, 81.2182094022088081442575074778
164/25, 81.2317018557146499113491461280
657/100, 81.2451527484818909449304027563
329/50, 81.2585622730084461782612137352
659/100, 81.2719306206005253189683928100
33/5, 81.2852579813818773243811838425
661/100, 81.2985445443029486120361809217
331/50, 81.3117904971499559467682671230
663/100, 81.3249960265538749340346355357
166/25, 81.3381613179993450375152960531
133/20, 81.3512865558334920275931335498
333/50, 81.3643719232746687560370074534
667/100, 81.3774176024211151410900534305
167/25, 81.3904237742595382361997925256
669/100, 81.4033906186736132448144417513
67/10, 81.4163183144524063330085647372
671/100, 81.4292070392987200811885545730
168/25, 81.4420569698373624057620965091
673/100, 81.4548682816233397714334484090
337/50, 81.4676411491499755047058731344
27/4, 81.4803757458569540092316687065
169/25, 81.4930722441382916738468159512
677/100, 81.5057308153502352544591825517
339/50, 81.5183516298190885014244063532
679/100, 81.5309348568489677946399838234
34/5, 81.5434806647294875393137008926
681/100, 81.5559892207433760662153860739
341/50, 81.5684606911740227711990962068
683/100, 81.5808952413129572198843524911
171/25, 81.5932930354672609346080500650
137/20, 81.6056542369669125721013208929
343/50, 81.6179790081720671918061210718
687/100, 81.6302675104802703063228539216
172/25, 81.6425199043336073971711733917
689/100, 81.6547363492257895708495117112
69/10, 81.6669170037091760220931428493
691/100, 81.6790620254017339632540594611
173/25, 81.6911715709939366708569636700
693/100, 81.7032457962556002926226363406
347/50, 81.7152848560426600505912674772
139/20, 81.7272889043038864684224401252
174/25, 81.7392580940875422434938256120
697/100, 81.7511925775479803770657583801
349/50, 81.7630925059521841685222281010
699/100, 81.7749580296862496725389936661
7, 81.7867892982618112109650505195
701/100, 81.7985864603224105242331555345
351/50, 81.8103496636498101402371413333
703/100, 81.8220790551702515318269664260
176/25, 81.8337747809606586273755027609
141/20, 81.8454369862547872322626343317
353/50, 81.8570658154493209126010267034
707/100, 81.8686614121099138860926464220
177/25, 81.8802239189771814585545004757
709/100, 81.8917534779726385383848891251
71/10, 81.9032502302045867550565001605
711/100, 81.9147143159739507016187184631
178/25, 81.9261458747800638151674003349
713/100, 81.9375450453264044032949051692
357/50, 81.9489119655262823186652440341
143/20, 81.9602467725084767780676702898
179/25, 81.9715496026228258165857941897
717/100, 81.9828205914457678618772619298
359/50, 81.9940598737858359079901274620
719/100, 82.0052675836891047626452075620
36/5, 82.0164438544445918364879086353
721/100, 82.0275888185896119374572257010
361/50, 82.0387026079150865281328342165
723/100, 82.0497853534708078987024341169
181/25, 82.0608371855706587030397884668
29/4, 82.0718582337977873002982677706
363/50, 82.0828486270097393394042215246
727/100, 82.0938084933435460188782222882
182/25, 82.1047379602207694495192501296
729/100, 82.1156371543525055426563069642
73/10, 82.1265062017443448419028851962
731/100, 82.1373452277012917116412913666
183/25, 82.1481543568326422908151848492
733/100, 82.1589337130568216160189891145
367/50, 82.1696834196061803133412369938
147/20, 82.1804035990317512539446028422
184/25, 82.1910943732079665639475474517
737/100, 82.2017558633373353748103624078
369/50, 82.2123881899550826961211679494
739/100, 82.2229914729337497884243231208
37/5, 82.2335658314877564095339916358
741/100, 82.2441113841779253036285258146
371/50, 82.2546282489159692983261499111
743/100, 82.2651165429689413708984202614
186/25, 82.2755763829636480407844010752
149/20, 82.2860078848910264416247204449
373/50, 82.2964111641104854221399711222
747/100, 82.3067863353542110213316150653
187/25, 82.3171335127314366596849704967
749/100, 82.3274528097326783843023461349
15/2, 82.3377443392339355021892902721
751/100, 82.3480082135008569322576033567
188/25, 82.3582445441928736029945921646
753/100, 82.3684534423672972191784015338
377/50, 82.3786350184833857174935354923
151/20, 82.3887893824063757274182720076
189/25, 82.3989166434114823503159922816
757/100, 82.4090169101878665662649031514
379/50, 82.4190902908425705748046551715
759/100, 82.4291368929044213724633833296
38/5, 82.4391568233279028666541647453
761/100, 82.4491501884969968222952488771
381/50, 82.4591170942289929343131299517
763/100, 82.4690576457782683160310655882
191/25, 82.4789719478400366903274751987
153/20, 82.4888601045540675673682594981
383/50, 82.4987222195083756896739591283
767/100, 82.5085583957428810222763141318
192/25, 82.5183687357530395627487024446
769/100, 82.5281533414934452429606377563
77/10, 82.5379123143814031915075150901
771/100, 82.5476457553004746229026336591
193/25, 82.5573537646039936167887350946
773/100, 82.5670364421185560476304122071
387/50, 82.5766938871474809225863168077
31/4, 82.5863261984742443825306793470
194/25, 82.5959334743658866184968091821
777/100, 82.6055158125763919531505396778
389/50, 82.6150733103500423342685908428
779/100, 82.6246060644247444845951237839
39/5, 82.6341141710353309498789421645
781/100, 82.6435977259168352843534480947
391/50, 82.6530568243077416104111817502
783/100, 82.6624915609532087867441692714
196/25, 82.6719020301082694167699819861
157/20, 82.6812883255410039267409869416
393/50, 82.6906505405356899405403651393
787/100, 82.6999887678959271758027160442
197/25, 82.7093030999477380836590867476
789/100, 82.7185936285426444520956986069
79/10, 82.7278604450607201906321356517
791/100, 82.7371036404136205117679549202
198/25, 82.7463233050475877224162317451
793/100, 82.7555195289464338363381202733
397/50, 82.7646924016345002164137536257
159/20, 82.7738420121795944534313962788
199/25, 82.7829684491959046859483654509
797/100, 82.7920718008468915636735351443
399/50, 82.8011521548481580547419073310
799/100, 82.8102095984702972951964652588
8, 82.8192442185417186769610043736
801/100, 82.8282561014514523685795614055
401/50, 82.8372453331519324610131308458
803/100, 82.8462119991617589288222734537
201/25, 82.8551561845684385951246910715
161/20, 82.8640779740311052867995773965
403/50, 82.8729774517832193645152710776
807/100, 82.8818547016352468102831551577
202/25, 82.8907098069773180533885890435
809/100, 82.8995428507818667137186532628
81/10, 82.9083539156062484396963644990
811/100, 82.9171430835953400162415137946
203/25, 82.9259104364841189164091330956
813/100, 82.9346560556002234686075468139
407/50, 82.9433800218664938095687617765
163/20, 82.9520824158034937915343402742
204/25, 82.9607633175320140104296399129
817/100, 82.9694228067755561201281469719
409/50, 82.9780609628627985962553367921
819/100, 82.9866778647300441113478284477
41/5, 82.9952735909236486815683279457
821/100, 83.0038482196024327435797441235
411/50, 83.0124018285400743186026869853
823/100, 83.0209344951274844191190953976
206/25, 83.0294462963751648521407688515
33/4, 83.0379373089155485714348783825
413/50, 83.0464076090053227295888898317
827/100, 83.0548572725277345793045363060
207/25, 83.0632863749948803718343169267
829/100, 83.0716949915499773990142694094
83/10, 83.0800831969696193239032612704
831/100, 83.0884510656660149436115678687
208/25, 83.0967986716892105264898570484
833/100, 83.1051260887292958644536846842
417/50, 83.1134333901185941798380303085
167/20, 83.1217206488338360248110772244
209/25, 83.1299879374983173100261797217
837/100, 83.1382353283840415978555763022
419/50, 83.1464628934138467942287198219
839/100, 83.1546707041635163717919232881
42/5, 83.1628588318638752558141861877
841/100, 83.1710273474028705029863955921
421/50, 83.1791763213276369019974161589
843/100, 83.1873058238465476235207230842
211/25, 83.1954159248312500460090239327
169/20, 83.2035066938186868824715932206
423/50, 83.2115782000131027321996439371
847/100, 83.2196305122880361802088214803
212/25, 83.2276636991882975659846683170
849/100, 83.2356778289319325419465149674
17/2, 83.2436729694121715408875495106
851/100, 83.2516491881993652705036506447
213/25, 83.2596065525429063519907874801
853/100, 83.2675451293731372185702436215
427/50, 83.2754649853032443886924667253
171/20, 83.2833661866311392275738324798
214/25, 83.2912487993413253096359007231
857/100, 83.2991128891067524933436898753
429/50, 83.3069585212906578188779646192
859/100, 83.3147857609483933380263832463
43/5, 83.3225946728292409846394494940
861/100, 83.3303853213782145929694251111
431/50, 83.3381577707378491701935514733
863/100, 83.3459120847499775284169709656
216/25, 83.3536483269574943804555026312
173/20, 83.3613665606061080027137847545
433/50, 83.3690668486460795675001241069
867/100, 83.3767492537339502461555637284
217/25, 83.3844138382342561834210761779
869/100, 83.3920606642212314425232865101
87/10, 83.3996897934804990195256098275
871/100, 83.4073012875107500245680345982
218/25, 83.4148952075254111267048790380
873/100, 83.4224716144543003581455792811
437/50, 83.4300305689452713728088218069
35/4, 83.4375721313658462532149971039
219/25, 83.4450963618048369588659167569
877/100, 83.4526033200739555083938933752
439/50, 83.4600930657094129869045247117
879/100, 83.4675656579735074690887441234
44/5, 83.4750211558562009478397945921
881/100, 83.4824596180766853572796497090
441/50, 83.4898811030849377782769403907
883/100, 83.4972856690632649137245501604
221/25, 83.5046733739278369200396151605
177/20, 83.5120442753302106805516098087
443/50, 83.5193984306588426056554182349
887/100, 83.5267358970405910438256899148
222/25, 83.5340567313422083868162608590
889/100, 83.5413609901718229516038962163
89/10, 83.5486487298804107208789842294
891/100, 83.5559200065632570231369944354
223/25, 83.5631748760614082326834150620
893/100, 83.5704133939631135691314173811
447/50, 83.5776356156052570752455708454
179/20, 83.5848415960747798512664659301
224/25, 83.5920313902100926231400065006
897/100, 83.5992050526024787213713261317
449/50, 83.6063626375974875465266800293
899/100, 83.6135041992963185967171840131
9, 83.6206297915571961317158334614
901/100, 83.6277394679967345476837581408
451/50, 83.6348332819912945358130745486
903/100, 83.6419112866783300975319076827
226/25, 83.6489735349577264882620921272
181/20, 83.6560200794931291610716518115
453/50, 83.6630509727132637809223237433
907/100, 83.6700662668132473795770592069
227/25, 83.6770660137558907206035331096
909/100, 83.6840502652729919432871459821
91/10, 83.6910190728666215536507421738
911/100, 83.6979724878103988301682214221
228/25, 83.7049105611507597111553195316
913/100, 83.7118333437082162302230085607
457/50, 83.7187408860786075655871496299
183/20, 83.7256332386343427684421551619
229/25, 83.7325104515256352350264156686
917/100, 83.7393725746817289864330535847
459/50, 83.7462196578121168196511184790
919/100, 83.7530517504077503927595702618
46/5, 83.7598689017422423066392466739
921/100, 83.7666711608730602450164160026
461/50, 83.7734585766427132341054140527
923/100, 83.7802311976799300825771950481
231/25, 83.7869890724008300620453292367
37/4, 83.7937322490100858877309962016
463/50, 83.8004607755020790584437935272
927/100, 83.8071746996620476144956476639
232/25, 83.8138740690672263716507202935
929/100, 83.8205589310879796887048927270
93/10, 83.8272293328889268257841269834
931/100, 83.8338853214300599499516900455
233/25, 83.8405269434678548442198328488
933/100, 83.8471542455563743755719839789
467/50, 83.8537672740483647771167966430
187/20, 83.8603660750963447990154236641
234/25, 83.8669506946536877823481370911
937/100, 83.8735211784756967096158052542
469/50, 83.8800775721206722851057399848
939/100, 83.8866199209509740978899802046
47/5, 83.8931482701340749197671357049
941/100, 83.8996626646436081900064277624
471/50, 83.9061631492604087383044829795
943/100, 83.9126497685735467969217156826
236/25, 83.9191225669813553525257251726
189/20, 83.9255815886924508878339905225
473/50, 83.9320268777267475627172213929
947/100, 83.9384584779164648839979730296
237/25, 83.9448764329071289127565122008
949/100, 83.9512807861585670575373839608
19/2, 83.9576715809458965014356328671
951/100, 83.9640488603605063106311332329
238/25, 83.9704126673110332715329383624
953/100, 83.9767630445243315032929260456
477/50, 83.9831000345464358920492551116
191/20, 83.9894236797435193928652141227
239/25, 83.9957340223028442449378974806
957/100, 84.0020311042337071452637459384
479/50, 84.0083149673683784255642977606
959/100, 84.0145856533630352768954742154
48/5, 84.0208432036986890659873295989
961/100, 84.0270876596821067869883931147
481/50, 84.0333190624467266919194795815
963/100, 84.0395374529535681427761104214
241/25, 84.0457428719921357278564285277
193/20, 84.0519353601813176845326736592
483/50, 84.0581149579702786703288725807
967/100, 84.0642817056393469238153543696
242/25, 84.0704356433008958564819906552
969/100, 84.0765768109002201164066478893
97/10, 84.0827052482164061641931894776
971/100, 84.0888209948631974013144453613
243/25, 84.0949240902898538906598415795
973/100, 84.1010145737820067087548190072
487/50, 84.1070924844625069687897356323
39/4, 84.1131578612922695532696078392
244/25, 84.1192107430711115947727706944
977/100, 84.1252511684385857429862933301
489/50, 84.1312791758748082558687415152
979/100, 84.1372948037012819524766041675
49/5, 84.1432980900817140646793629907
981/100, 84.1492890730228290246797541136
491/50, 84.1552677903751762249502173379
983/100, 84.1612342798339327868938225477
246/25, 84.1671885789397013742380745184
197/20, 84.1731307250793030868728975514
493/50, 84.1790607554865654705497613311
987/100, 84.1849787072431056775673005308
247/25, 84.1908846172791088132798748958
989/100, 84.1967785223741015029792859063
99/10, 84.2026604591577207134162831220
991/100, 84.2085304641104778629475307211
248/25, 84.2143885735645182540153356528
993/100, 84.2202348237043758613916365541
497/50, 84.2260692505677235093444909156
199/20, 84.2318918900461184706145507759
249/25, 84.2377027778857435198207588913
997/100, 84.2435019496881434736487022778
499/50, 84.2492894409109572499117032557
999/100, 84.2550652868686454773137846487
10, 84.2608295227332136874850910961
];

refi=[1/100, 953.692625809887226326300030289/pi
1/50, 828.912630777256288701103059272/pi
3/100, 755.906400342798443320214442674/pi
1/25, 704.092097738625924045892191239/pi
1/20, 663.885696125033400171270162965/pi
3/50, 631.018202379160658445752813471/pi
7/100, 603.212392873421568492191420783/pi
2/25, 579.108954808306417725956805368/pi
9/100, 557.831089880478500011874572856/pi
1/10, 538.780112302748561624280188479/pi
11/100, 521.528989464764906897148981255/pi
3/25, 505.762401555893760231613925432/pi
13/100, 491.240876207433422627888891633/pi
7/50, 477.778252437535934662152570655/pi
3/20, 465.226938421620148479466602090/pi
4/25, 453.467936796997254887346705770/pi
17/100, 442.403899207022412910940939759/pi
9/50, 431.954169050699682560734915301/pi
19/100, 422.051166276632923052383153787/pi
1/5, 412.637700521011983804141716043/pi
21/100, 403.664940427709196278891195805/pi
11/50, 395.090855754260770877807173311/pi
23/100, 386.879006014096747673715173937/pi
6/25, 378.997587065403790455622664336/pi
1/4, 371.418672401200898410910611072/pi
13/50, 364.117603277223198510732621754/pi
27/100, 357.072493942105075460926280227/pi
7/25, 350.263826829956394918963493819/pi
29/100, 343.674118755569119321828315184/pi
3/10, 337.287643654934596495859637338/pi
31/100, 331.090200734074806650873437300/pi
8/25, 325.068919365471564611955310112/pi
33/100, 319.212093937561119251249432173/pi
17/50, 313.509043282889813522178844474/pi
7/20, 307.949990401048873659259709313/pi
9/25, 302.525959037040641603431664894/pi
37/100, 297.228684334963733542592384650/pi
19/50, 292.050535305332395361359954512/pi
39/100, 286.984447254891321707005289613/pi
2/5, 282.023862655033994159530235264/pi
41/100, 277.162679187387068534552292646/pi
21/50, 272.395203916827861595162426748/pi
43/100, 267.716112713890234566564776402/pi
11/25, 263.120414188447849546310820129/pi
9/20, 258.603417511143446343520587199/pi
23/50, 254.160703593247387616147698142/pi
47/100, 249.788099173388865122773363662/pi
12/25, 245.481653423990027529697889601/pi
49/100, 241.237616743685682806950856682/pi
1/2, 237.052421446467007552508342516/pi
51/100, 232.922664095291280104680720177/pi
13/25, 228.845089258684071033395973668/pi
53/100, 224.816574494410019830998707188/pi
27/50, 220.834116385387287820612044493/pi
11/20, 216.894817470289311800799604184/pi
14/25, 212.995873925200107455487266227/pi
57/100, 209.134563863635596198097813376/pi
29/50, 205.308236130482703713846396540/pi
59/100, 201.514299471119657276511438397/pi
3/5, 197.750211960259744451144142646/pi
61/100, 194.013470575918160725418209094/pi
31/50, 190.301600802262303025378188013/pi
63/100, 186.612146140800280069368474232/pi
16/25, 182.942657402112684974444628901/pi
13/20, 179.290681639732232130311442565/pi
33/50, 175.653750573259785312524075289/pi
67/100, 172.029368328608891679812989751/pi
17/25, 168.414998298372161318369195147/pi
69/100, 164.808048893342689789692393191/pi
7/10, 161.205857915395648033733384630/pi
71/100, 157.605675229830698309582167423/pi
18/25, 154.004643348667652475425167984/pi
73/100, 150.399775450921555249141974361/pi
37/50, 146.787930255636808906279037496/pi
3/4, 143.165783020303013495020367967/pi
19/25, 139.529791749931840182440793514/pi
77/100, 135.876157454727681504150566343/pi
39/50, 132.200776964474439045705369948/pi
79/100, 128.499186363162240007201100248/pi
4/5, 124.766492500790155695101781862/pi
81/100, 120.997289200680968213398533865/pi
41/50, 117.185553604342968372772977752/pi
83/100, 113.324516419348677729056685051/pi
21/25, 109.406497403581317820816796969/pi
17/20, 105.422693821318440968361718623/pi
43/50, 101.362904166848211784317256328/pi
87/100, 97.2151610230715030519691985412/pi
22/25, 92.9652334983101836291936016054/pi
89/100, 88.5959376196532738751245640533/pi
9/10, 84.0861554585871632631086684999/pi
91/100, 79.4093969314865685037421800690/pi
23/25, 74.5316133977661121087340263434/pi
93/100, 69.4077248057463274448178239267/pi
47/50, 63.9757949786879454764726118763/pi
19/20, 58.1465590689245896570442622430/pi
24/25, 51.7827730413205669390594210784/pi
97/100, 44.6528558913470769137901710180/pi
49/50, 36.3039278037904895407809621453/pi
99/100, 25.5625993342938723742434229733/pi
1, 0.
];


     x=ref(:,1);
	 y = asecd(x);
	 e=ref(:,2);
	 assert_checkalmostequal(y,e,10*%eps,[],"element");
	//
     x=-ref(:,1);
	 y = asecd(x);
	 e = 180-ref(:,2);
	 assert_checkalmostequal(y,e,10*%eps,[],"element");
     
     
     x=refi(:,1);
	 y = asecd(x);
	 e = imult(refi(:,2));
	 assert_checkalmostequal(y,e,20*%eps,[],"element");
 
     x=-refi(:,1);
	 y = asecd(x);
	 e = 180-imult(refi(:,2));
	 assert_checkalmostequal(y,e,20*%eps,[],"element");
 
    
     assert_checkequal(asecd(0),imult(Inf));
     assert_checkalmostequal(asecd(Inf),90,%eps,[],"element");

     assert_checkequal(asecd(NaN),%nan);

     assert_checkequal(asecd([]),[]);

