#include "Metanet.hxx"
/* Generated by GIWS (version 2.0.1) with command:
giws -e -g -f src/jni/Metanet.giws.xml 
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_metanet {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * Metanet::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

Metanet::~Metanet() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
Metanet::Metanet(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidmetanetjstringjava_lang_Stringjstringjava_lang_StringjdoubledoublejdoubledoublejdoubleArray_doubledoubleID=NULL;
voidloadIntoScilabjstringjava_lang_StringID=NULL;
jdoublenetwindowjdoubledoubleID=NULL;
jdoubleArray_netwindowsID=NULL;
voidshowjbooleanbooleanjbooleanbooleanjdoubleArray_doubledoublejbooleanbooleanjstringjava_lang_StringID=NULL;
voidwarnObjectByUIDjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidcloseMetanetFromScilabID=NULL;


}

Metanet::Metanet(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidmetanetjstringjava_lang_Stringjstringjava_lang_StringjdoubledoublejdoubledoublejdoubleArray_doubledoubleID=NULL;
voidloadIntoScilabjstringjava_lang_StringID=NULL;
jdoublenetwindowjdoubledoubleID=NULL;
jdoubleArray_netwindowsID=NULL;
voidshowjbooleanbooleanjbooleanbooleanjdoubleArray_doubledoublejbooleanbooleanjstringjava_lang_StringID=NULL;
voidwarnObjectByUIDjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidcloseMetanetFromScilabID=NULL;


}

// Generic methods

void Metanet::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Metanet");
}
}

void Metanet::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Metanet");
}
}
// Method(s)

void Metanet::metanet (JavaVM * jvm_, char const* varname, char const* filename, double window, double scale, double const* winsize, int winsizeSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidmetanetjstringjava_lang_Stringjstringjava_lang_StringjdoubledoublejdoubledoublejdoubleArray_doubledoubleID = curEnv->GetStaticMethodID(cls, "metanet", "(Ljava/lang/String;Ljava/lang/String;DD[D)V" ) ;
if (voidmetanetjstringjava_lang_Stringjstringjava_lang_StringjdoubledoublejdoubledoublejdoubleArray_doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "metanet");
}

jstring varname_ = curEnv->NewStringUTF( varname );
if (varname != NULL && varname_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring filename_ = curEnv->NewStringUTF( filename );
if (filename != NULL && filename_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jdoubleArray winsize_ = curEnv->NewDoubleArray( winsizeSize ) ;

if (winsize_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( winsize_, 0, winsizeSize, (jdouble*)(winsize) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidmetanetjstringjava_lang_Stringjstringjava_lang_StringjdoubledoublejdoubledoublejdoubleArray_doubledoubleID ,varname_, filename_, window, scale, winsize_);
                        curEnv->DeleteLocalRef(varname_);
curEnv->DeleteLocalRef(filename_);
curEnv->DeleteLocalRef(winsize_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Metanet::loadIntoScilab (JavaVM * jvm_, char const* filename){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidloadIntoScilabjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "loadIntoScilab", "(Ljava/lang/String;)V" ) ;
if (voidloadIntoScilabjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "loadIntoScilab");
}

jstring filename_ = curEnv->NewStringUTF( filename );
if (filename != NULL && filename_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidloadIntoScilabjstringjava_lang_StringID ,filename_);
                        curEnv->DeleteLocalRef(filename_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

double Metanet::netwindow (JavaVM * jvm_, double index){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublenetwindowjdoubledoubleID = curEnv->GetStaticMethodID(cls, "netwindow", "(D)D" ) ;
if (jdoublenetwindowjdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "netwindow");
}

                        jdouble res =  static_cast<jdouble>( curEnv->CallStaticDoubleMethod(cls, jdoublenetwindowjdoubledoubleID ,index));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

double* Metanet::netwindows (JavaVM * jvm_, int *lenRow){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoubleArray_netwindowsID = curEnv->GetStaticMethodID(cls, "netwindows", "()[D" ) ;
if (jdoubleArray_netwindowsID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "netwindows");
}

                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallStaticObjectMethod(cls, jdoubleArray_netwindowsID ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
* lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[* lenRow];

for (jsize i = 0; i < * lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void Metanet::show (JavaVM * jvm_, bool nodes, bool edges, double const* indexes, int indexesSize, bool clearPrevious, char const* message){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidshowjbooleanbooleanjbooleanbooleanjdoubleArray_doubledoublejbooleanbooleanjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "show", "(ZZ[DZLjava/lang/String;)V" ) ;
if (voidshowjbooleanbooleanjbooleanbooleanjdoubleArray_doubledoublejbooleanbooleanjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "show");
}

jboolean nodes_ = (static_cast<bool>(nodes) ? JNI_TRUE : JNI_FALSE);

jboolean edges_ = (static_cast<bool>(edges) ? JNI_TRUE : JNI_FALSE);

jdoubleArray indexes_ = curEnv->NewDoubleArray( indexesSize ) ;

if (indexes_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( indexes_, 0, indexesSize, (jdouble*)(indexes) ) ;


jboolean clearPrevious_ = (static_cast<bool>(clearPrevious) ? JNI_TRUE : JNI_FALSE);

jstring message_ = curEnv->NewStringUTF( message );
if (message != NULL && message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidshowjbooleanbooleanjbooleanbooleanjdoubleArray_doubledoublejbooleanbooleanjstringjava_lang_StringID ,nodes_, edges_, indexes_, clearPrevious_, message_);
                        curEnv->DeleteLocalRef(indexes_);
curEnv->DeleteLocalRef(message_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Metanet::warnObjectByUID (JavaVM * jvm_, char const* uid, char const* message){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidwarnObjectByUIDjstringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "warnObjectByUID", "(Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidwarnObjectByUIDjstringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "warnObjectByUID");
}

jstring uid_ = curEnv->NewStringUTF( uid );
if (uid != NULL && uid_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring message_ = curEnv->NewStringUTF( message );
if (message != NULL && message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidwarnObjectByUIDjstringjava_lang_Stringjstringjava_lang_StringID ,uid_, message_);
                        curEnv->DeleteLocalRef(uid_);
curEnv->DeleteLocalRef(message_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Metanet::closeMetanetFromScilab (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcloseMetanetFromScilabID = curEnv->GetStaticMethodID(cls, "closeMetanetFromScilab", "()V" ) ;
if (voidcloseMetanetFromScilabID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "closeMetanetFromScilab");
}

                         curEnv->CallStaticVoidMethod(cls, voidcloseMetanetFromScilabID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
