
#line 1 "ragel/i18n/cs.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/cs.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_cs/gherkin_lexer_cs.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 18, 19, 20, 37, 38, 39, 
	41, 43, 48, 53, 58, 63, 67, 71, 
	73, 74, 75, 76, 77, 78, 79, 80, 
	81, 82, 83, 84, 85, 86, 87, 88, 
	89, 91, 93, 98, 105, 110, 112, 115, 
	118, 121, 124, 127, 130, 131, 133, 134, 
	135, 136, 137, 138, 139, 140, 141, 142, 
	143, 144, 159, 161, 163, 165, 167, 169, 
	171, 173, 175, 177, 179, 181, 183, 185, 
	187, 189, 206, 207, 208, 209, 210, 211, 
	212, 213, 214, 215, 216, 217, 218, 219, 
	220, 221, 222, 223, 224, 225, 226, 239, 
	241, 243, 245, 247, 249, 251, 253, 255, 
	257, 259, 261, 263, 265, 267, 269, 272, 
	290, 291, 292, 293, 294, 295, 296, 297, 
	300, 301, 302, 303, 304, 305, 306, 307, 
	308, 309, 310, 311, 318, 320, 322, 324, 
	326, 328, 330, 332, 334, 336, 338, 339, 
	342, 343, 344, 345, 346, 347, 348, 349, 
	350, 351, 352, 364, 366, 368, 370, 372, 
	374, 376, 378, 380, 382, 384, 386, 388, 
	390, 392, 394, 396, 398, 400, 402, 404, 
	406, 408, 410, 412, 414, 416, 418, 420, 
	422, 424, 426, 428, 430, 432, 434, 436, 
	438, 440, 442, 444, 446, 448, 450, 452, 
	454, 457, 459, 461, 463, 465, 467, 469, 
	471, 473, 476, 478, 480, 482, 484, 486, 
	488, 490, 492, 494, 496, 498, 500, 502, 
	504, 506, 508, 510, 512, 514, 515, 516, 
	517, 518, 519, 520, 521, 522, 523, 524, 
	525, 526, 527, 528, 529, 530, 531, 546, 
	548, 550, 552, 554, 556, 558, 560, 562, 
	564, 566, 568, 570, 572, 574, 576, 579, 
	597, 598, 599, 600, 601, 602, 603, 604, 
	605, 606, 607, 608, 609, 610, 611, 612, 
	613, 614, 615, 616, 620, 626, 629, 631, 
	637, 654, 656, 659, 661, 663, 665, 667, 
	669, 671, 673, 675, 677, 679, 681, 683, 
	685, 687, 689, 691, 693, 695, 697, 699, 
	701, 703, 705, 707, 709, 711, 713, 715, 
	717, 719, 721, 723, 725, 728, 730, 734, 
	736, 738, 740, 742, 744, 746, 748, 750, 
	752, 754, 756, 758, 760, 762, 764, 766, 
	768, 770, 772, 774, 776, 778, 780, 782, 
	784, 786, 788, 790, 792, 794, 796, 798, 
	800, 802, 804, 805, 806, 807, 808, 809, 
	811, 813, 815, 817, 819, 822, 824, 827, 
	829, 831, 833, 835, 837, 839, 841, 843, 
	845, 847, 849, 851, 853, 855, 857, 859, 
	861, 863, 865, 867, 869, 871, 873, 875, 
	877, 879, 881, 883, 885, 887, 889, 891, 
	894, 912, 913, 914, 915, 916, 917, 919, 
	921, 923, 925, 927, 929, 931, 933, 935, 
	937, 939, 941, 943, 945, 947, 949, 951, 
	953, 955, 957, 959, 961, 963, 965, 967, 
	969, 971, 973, 975, 977, 980, 982, 985, 
	987, 989, 991, 993, 995, 997, 999, 1001, 
	1003, 1005, 1007, 1009, 1011, 1013, 1015, 1017, 
	1019, 1021, 1023, 1025, 1027, 1029, 1031, 1033, 
	1035, 1037, 1039, 1041, 1043, 1045, 1047
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 75, 78, 79, 80, 83, 90, 124, 
	9, 13, -69, -65, 10, 32, 34, 35, 
	37, 42, 64, 65, 75, 78, 79, 80, 
	83, 90, 124, 9, 13, 34, 34, 10, 
	13, 10, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 9, 13, 10, 32, 9, 13, 10, 
	13, 10, 95, 70, 69, 65, 84, 85, 
	82, 69, 95, 69, 78, 68, 95, 37, 
	32, 10, 13, 10, 13, 13, 32, 64, 
	9, 10, 9, 10, 13, 32, 64, 11, 
	12, 10, 32, 64, 9, 13, 32, 108, 
	10, 13, 116, 10, 13, 97, 10, 13, 
	107, -61, 10, 13, -87, 10, 13, 10, 
	13, 32, 101, 100, 111, 121, -59, -66, 
	110, 116, 101, 120, 116, 58, 10, 10, 
	10, 32, 35, 37, 42, 64, 65, 75, 
	78, 79, 80, 83, 90, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, 10, 32, 34, 
	35, 37, 42, 64, 65, 75, 78, 79, 
	80, 83, 90, 124, 9, 13, -61, -95, 
	-60, -115, 114, 116, 32, 83, 99, -61, 
	-87, 110, -61, -95, -59, -103, 101, 58, 
	10, 10, 10, 32, 35, 37, 42, 64, 
	65, 75, 80, 83, 90, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, 10, 32, 108, 
	10, 32, 34, 35, 37, 42, 64, 65, 
	75, 78, 79, 80, 83, 90, 116, 124, 
	9, 13, 115, 110, 111, 118, 97, 32, 
	115, -59, 97, 111, -103, -61, -83, 107, 
	108, 97, 100, 121, 58, 10, 10, 10, 
	32, 35, 80, 124, 9, 13, 10, 111, 
	-59, 10, -66, 10, 10, 97, 10, 100, 
	10, 97, 10, 118, 10, 101, 10, 107, 
	10, 58, 107, -59, 107, 122, -66, 97, 
	100, 97, 118, 101, 107, 58, 10, 10, 
	10, 32, 35, 37, 64, 75, 78, 79, 
	80, 83, 9, 13, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 111, 10, 110, 10, 116, 10, 101, 
	10, 120, 10, 116, 10, 58, -61, 10, 
	-95, 10, -60, 10, -115, 10, 10, 114, 
	10, 116, 10, 32, 10, 83, 10, 99, 
	-61, 10, -87, 10, 10, 110, -61, 10, 
	-95, 10, -59, 10, -103, 10, 10, 101, 
	10, 115, 10, 110, 10, 111, 10, 118, 
	10, 97, 10, 32, 10, 115, -59, 10, 
	111, -103, 10, -61, 10, -83, 10, 10, 
	107, 10, 108, 10, 97, 10, 100, 10, 
	121, -59, 10, 122, -66, 10, 10, 97, 
	10, 100, 10, 97, 10, 118, 10, 101, 
	10, 107, 10, 97, 10, 100, -61, 10, 
	-83, 10, 10, 99, -61, 10, -87, 10, 
	10, 110, -61, 10, -95, 10, -59, 10, 
	-103, 10, 117, 100, 97, 100, -61, -83, 
	99, -61, -87, 110, -61, -95, -59, -103, 
	58, 10, 10, 10, 32, 35, 37, 42, 
	64, 65, 75, 78, 79, 80, 83, 90, 
	9, 13, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, 10, 32, 
	10, 32, 108, 10, 32, 34, 35, 37, 
	42, 64, 65, 75, 78, 79, 80, 83, 
	90, 116, 124, 9, 13, 97, 32, 112, 
	-59, -103, 101, 100, 112, 111, 107, 108, 
	97, 100, 117, 97, 107, -61, -87, 32, 
	32, 124, 9, 13, 10, 32, 92, 124, 
	9, 13, 10, 92, 124, 10, 92, 10, 
	32, 92, 124, 9, 13, 10, 32, 34, 
	35, 37, 42, 64, 65, 75, 78, 79, 
	80, 83, 90, 124, 9, 13, 10, 101, 
	10, 100, 111, 10, 121, -59, 10, -66, 
	10, 10, 110, 10, 116, 10, 101, 10, 
	120, 10, 116, 10, 58, -61, 10, -95, 
	10, -60, 10, -115, 10, 10, 114, 10, 
	116, 10, 32, 10, 83, 10, 99, -61, 
	10, -87, 10, 10, 110, -61, 10, -95, 
	10, -59, 10, -103, 10, 10, 101, 10, 
	115, 10, 110, 10, 111, 10, 118, 10, 
	97, 10, 32, 10, 115, 10, 97, 111, 
	10, 107, -59, 10, 107, 122, -66, 10, 
	10, 97, 10, 100, 10, 97, 10, 118, 
	10, 101, 10, 107, 10, 117, 10, 100, 
	10, 97, 10, 100, -61, 10, -83, 10, 
	10, 99, -61, 10, -87, 10, 10, 110, 
	-61, 10, -95, 10, -59, 10, -103, 10, 
	10, 97, 10, 32, 10, 112, -59, 10, 
	-103, 10, 10, 101, 10, 100, 10, 112, 
	10, 111, 10, 107, 10, 108, 10, 97, 
	10, 100, 10, 117, 97, 107, -61, -87, 
	32, 10, 101, 10, 100, 10, 121, -59, 
	10, -66, 10, 10, 97, 111, 10, 107, 
	-59, 10, 107, -66, 10, 10, 97, 10, 
	100, 10, 97, 10, 118, 10, 101, 10, 
	107, 10, 58, 10, 117, 10, 100, 10, 
	99, -61, 10, -87, 10, 10, 110, -61, 
	10, -95, 10, -59, 10, -103, 10, 10, 
	97, 10, 32, 10, 112, -59, 10, -103, 
	10, 10, 101, 10, 100, 10, 112, 10, 
	111, 10, 107, 10, 108, 10, 97, 10, 
	100, 10, 117, 10, 32, 108, 10, 32, 
	34, 35, 37, 42, 64, 65, 75, 78, 
	79, 80, 83, 90, 116, 124, 9, 13, 
	97, 107, -61, -87, 32, 10, 101, 10, 
	100, 10, 121, -59, 10, -66, 10, -61, 
	10, -95, 10, -60, 10, -115, 10, 10, 
	114, 10, 116, 10, 32, 10, 83, 10, 
	99, -61, 10, -87, 10, 10, 110, -61, 
	10, -95, 10, -59, 10, -103, 10, 10, 
	101, 10, 58, 10, 115, 10, 110, 10, 
	111, 10, 118, 10, 97, 10, 32, 10, 
	115, 10, 97, 111, 10, 107, -59, 10, 
	107, -66, 10, 10, 97, 10, 100, 10, 
	97, 10, 118, 10, 101, 10, 107, 10, 
	117, 10, 100, 10, 99, -61, 10, -87, 
	10, 10, 110, -61, 10, -95, 10, -59, 
	10, -103, 10, 10, 97, 10, 32, 10, 
	112, -59, 10, -103, 10, 10, 101, 10, 
	100, 10, 112, 10, 111, 10, 107, 10, 
	108, 10, 97, 10, 100, 10, 117, 0
};

static const char _lexer_single_lengths[] = {
	0, 16, 1, 1, 15, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 2, 3, 3, 
	3, 3, 3, 3, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 13, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 15, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 11, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 16, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 3, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 10, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 13, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 16, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 4, 3, 2, 4, 
	15, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 4, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 2, 
	2, 2, 2, 2, 3, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	16, 1, 1, 1, 1, 1, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 18, 20, 22, 39, 41, 43, 
	46, 49, 54, 59, 64, 69, 73, 77, 
	80, 82, 84, 86, 88, 90, 92, 94, 
	96, 98, 100, 102, 104, 106, 108, 110, 
	112, 115, 118, 123, 130, 135, 138, 142, 
	146, 150, 154, 158, 162, 164, 167, 169, 
	171, 173, 175, 177, 179, 181, 183, 185, 
	187, 189, 204, 207, 210, 213, 216, 219, 
	222, 225, 228, 231, 234, 237, 240, 243, 
	246, 249, 266, 268, 270, 272, 274, 276, 
	278, 280, 282, 284, 286, 288, 290, 292, 
	294, 296, 298, 300, 302, 304, 306, 319, 
	322, 325, 328, 331, 334, 337, 340, 343, 
	346, 349, 352, 355, 358, 361, 364, 368, 
	386, 388, 390, 392, 394, 396, 398, 400, 
	404, 406, 408, 410, 412, 414, 416, 418, 
	420, 422, 424, 426, 433, 436, 439, 442, 
	445, 448, 451, 454, 457, 460, 463, 465, 
	469, 471, 473, 475, 477, 479, 481, 483, 
	485, 487, 489, 501, 504, 507, 510, 513, 
	516, 519, 522, 525, 528, 531, 534, 537, 
	540, 543, 546, 549, 552, 555, 558, 561, 
	564, 567, 570, 573, 576, 579, 582, 585, 
	588, 591, 594, 597, 600, 603, 606, 609, 
	612, 615, 618, 621, 624, 627, 630, 633, 
	636, 640, 643, 646, 649, 652, 655, 658, 
	661, 664, 668, 671, 674, 677, 680, 683, 
	686, 689, 692, 695, 698, 701, 704, 707, 
	710, 713, 716, 719, 722, 725, 727, 729, 
	731, 733, 735, 737, 739, 741, 743, 745, 
	747, 749, 751, 753, 755, 757, 759, 774, 
	777, 780, 783, 786, 789, 792, 795, 798, 
	801, 804, 807, 810, 813, 816, 819, 823, 
	841, 843, 845, 847, 849, 851, 853, 855, 
	857, 859, 861, 863, 865, 867, 869, 871, 
	873, 875, 877, 879, 883, 889, 893, 896, 
	902, 919, 922, 926, 929, 932, 935, 938, 
	941, 944, 947, 950, 953, 956, 959, 962, 
	965, 968, 971, 974, 977, 980, 983, 986, 
	989, 992, 995, 998, 1001, 1004, 1007, 1010, 
	1013, 1016, 1019, 1022, 1025, 1029, 1032, 1037, 
	1040, 1043, 1046, 1049, 1052, 1055, 1058, 1061, 
	1064, 1067, 1070, 1073, 1076, 1079, 1082, 1085, 
	1088, 1091, 1094, 1097, 1100, 1103, 1106, 1109, 
	1112, 1115, 1118, 1121, 1124, 1127, 1130, 1133, 
	1136, 1139, 1142, 1144, 1146, 1148, 1150, 1152, 
	1155, 1158, 1161, 1164, 1167, 1171, 1174, 1178, 
	1181, 1184, 1187, 1190, 1193, 1196, 1199, 1202, 
	1205, 1208, 1211, 1214, 1217, 1220, 1223, 1226, 
	1229, 1232, 1235, 1238, 1241, 1244, 1247, 1250, 
	1253, 1256, 1259, 1262, 1265, 1268, 1271, 1274, 
	1278, 1296, 1298, 1300, 1302, 1304, 1306, 1309, 
	1312, 1315, 1318, 1321, 1324, 1327, 1330, 1333, 
	1336, 1339, 1342, 1345, 1348, 1351, 1354, 1357, 
	1360, 1363, 1366, 1369, 1372, 1375, 1378, 1381, 
	1384, 1387, 1390, 1393, 1396, 1400, 1403, 1407, 
	1410, 1413, 1416, 1419, 1422, 1425, 1428, 1431, 
	1434, 1437, 1440, 1443, 1446, 1449, 1452, 1455, 
	1458, 1461, 1464, 1467, 1470, 1473, 1476, 1479, 
	1482, 1485, 1488, 1491, 1494, 1497, 1500
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 45, 74, 112, 119, 235, 264, 283, 
	4, 0, 3, 0, 4, 0, 4, 4, 
	5, 15, 17, 31, 34, 37, 45, 74, 
	112, 119, 235, 264, 283, 4, 0, 6, 
	0, 7, 0, 9, 8, 8, 9, 8, 
	8, 10, 10, 11, 10, 10, 10, 10, 
	11, 10, 10, 10, 10, 12, 10, 10, 
	10, 10, 13, 10, 10, 4, 14, 14, 
	0, 4, 14, 14, 0, 4, 16, 15, 
	4, 0, 18, 0, 19, 0, 20, 0, 
	21, 0, 22, 0, 23, 0, 24, 0, 
	25, 0, 26, 0, 27, 0, 28, 0, 
	29, 0, 30, 0, 478, 0, 32, 0, 
	4, 16, 33, 4, 16, 33, 0, 0, 
	0, 0, 35, 36, 4, 36, 36, 34, 
	35, 35, 4, 36, 34, 36, 0, 38, 
	44, 0, 4, 16, 39, 33, 4, 16, 
	40, 33, 4, 16, 41, 33, 42, 4, 
	16, 33, 43, 4, 16, 33, 4, 16, 
	32, 33, 31, 0, 46, 49, 0, 47, 
	0, 48, 0, 31, 0, 50, 0, 51, 
	0, 52, 0, 53, 0, 54, 0, 55, 
	0, 57, 56, 57, 56, 57, 57, 4, 
	58, 72, 4, 407, 415, 419, 437, 444, 
	456, 464, 57, 56, 57, 59, 56, 57, 
	60, 56, 57, 61, 56, 57, 62, 56, 
	57, 63, 56, 57, 64, 56, 57, 65, 
	56, 57, 66, 56, 57, 67, 56, 57, 
	68, 56, 57, 69, 56, 57, 70, 56, 
	57, 71, 56, 57, 4, 56, 57, 73, 
	56, 4, 4, 5, 15, 17, 31, 34, 
	37, 45, 74, 112, 119, 235, 264, 283, 
	4, 0, 75, 0, 76, 0, 77, 0, 
	78, 0, 79, 0, 80, 0, 81, 0, 
	82, 0, 83, 0, 84, 0, 85, 0, 
	86, 0, 87, 0, 88, 0, 89, 0, 
	90, 0, 91, 0, 92, 0, 94, 93, 
	94, 93, 94, 94, 4, 95, 109, 4, 
	110, 368, 372, 385, 393, 94, 93, 94, 
	96, 93, 94, 97, 93, 94, 98, 93, 
	94, 99, 93, 94, 100, 93, 94, 101, 
	93, 94, 102, 93, 94, 103, 93, 94, 
	104, 93, 94, 105, 93, 94, 106, 93, 
	94, 107, 93, 94, 108, 93, 94, 4, 
	93, 94, 73, 93, 94, 111, 367, 93, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	45, 74, 112, 119, 235, 264, 362, 283, 
	4, 0, 113, 0, 114, 0, 115, 0, 
	116, 0, 117, 0, 118, 0, 82, 0, 
	120, 142, 143, 0, 121, 0, 122, 0, 
	123, 0, 124, 0, 125, 0, 126, 0, 
	127, 0, 128, 0, 129, 0, 131, 130, 
	131, 130, 131, 131, 4, 132, 4, 131, 
	130, 131, 133, 130, 134, 131, 130, 135, 
	131, 130, 131, 136, 130, 131, 137, 130, 
	131, 138, 130, 131, 139, 130, 131, 140, 
	130, 131, 141, 130, 131, 73, 130, 31, 
	0, 144, 229, 231, 0, 145, 0, 146, 
	0, 147, 0, 148, 0, 149, 0, 150, 
	0, 151, 0, 152, 0, 154, 153, 154, 
	153, 154, 154, 4, 155, 4, 169, 176, 
	193, 200, 221, 154, 153, 154, 156, 153, 
	154, 157, 153, 154, 158, 153, 154, 159, 
	153, 154, 160, 153, 154, 161, 153, 154, 
	162, 153, 154, 163, 153, 154, 164, 153, 
	154, 165, 153, 154, 166, 153, 154, 167, 
	153, 154, 168, 153, 154, 4, 153, 154, 
	170, 153, 154, 171, 153, 154, 172, 153, 
	154, 173, 153, 154, 174, 153, 154, 175, 
	153, 154, 73, 153, 177, 154, 153, 178, 
	154, 153, 179, 154, 153, 180, 154, 153, 
	154, 181, 153, 154, 182, 153, 154, 183, 
	153, 154, 184, 153, 154, 185, 153, 186, 
	154, 153, 187, 154, 153, 154, 188, 153, 
	189, 154, 153, 190, 154, 153, 191, 154, 
	153, 192, 154, 153, 154, 175, 153, 154, 
	194, 153, 154, 195, 153, 154, 196, 153, 
	154, 197, 153, 154, 198, 153, 154, 199, 
	153, 154, 184, 153, 201, 154, 209, 153, 
	202, 154, 153, 203, 154, 153, 204, 154, 
	153, 154, 205, 153, 154, 206, 153, 154, 
	207, 153, 154, 208, 153, 154, 175, 153, 
	210, 154, 217, 153, 211, 154, 153, 154, 
	212, 153, 154, 213, 153, 154, 214, 153, 
	154, 215, 153, 154, 216, 153, 154, 175, 
	153, 154, 218, 153, 154, 219, 153, 220, 
	154, 153, 175, 154, 153, 154, 222, 153, 
	223, 154, 153, 224, 154, 153, 154, 225, 
	153, 226, 154, 153, 227, 154, 153, 228, 
	154, 153, 175, 154, 153, 230, 0, 31, 
	0, 232, 0, 233, 0, 234, 0, 54, 
	0, 236, 0, 237, 0, 238, 0, 239, 
	0, 240, 0, 241, 0, 242, 0, 243, 
	0, 244, 0, 246, 245, 246, 245, 246, 
	246, 4, 247, 261, 4, 262, 290, 300, 
	317, 324, 340, 348, 246, 245, 246, 248, 
	245, 246, 249, 245, 246, 250, 245, 246, 
	251, 245, 246, 252, 245, 246, 253, 245, 
	246, 254, 245, 246, 255, 245, 246, 256, 
	245, 246, 257, 245, 246, 258, 245, 246, 
	259, 245, 246, 260, 245, 246, 4, 245, 
	246, 73, 245, 246, 263, 289, 245, 4, 
	4, 5, 15, 17, 31, 34, 37, 45, 
	74, 112, 119, 235, 264, 278, 283, 4, 
	0, 265, 0, 266, 0, 267, 0, 268, 
	0, 269, 0, 270, 0, 271, 0, 272, 
	0, 273, 0, 274, 0, 275, 0, 276, 
	0, 277, 0, 31, 0, 279, 0, 280, 
	0, 281, 0, 282, 0, 73, 0, 283, 
	284, 283, 0, 288, 287, 286, 284, 287, 
	285, 0, 286, 284, 285, 0, 286, 285, 
	288, 287, 286, 284, 287, 285, 288, 288, 
	5, 15, 17, 31, 34, 37, 45, 74, 
	112, 119, 235, 264, 283, 288, 0, 246, 
	261, 245, 246, 291, 294, 245, 246, 292, 
	245, 293, 246, 245, 261, 246, 245, 246, 
	295, 245, 246, 296, 245, 246, 297, 245, 
	246, 298, 245, 246, 299, 245, 246, 73, 
	245, 301, 246, 245, 302, 246, 245, 303, 
	246, 245, 304, 246, 245, 246, 305, 245, 
	246, 306, 245, 246, 307, 245, 246, 308, 
	245, 246, 309, 245, 310, 246, 245, 311, 
	246, 245, 246, 312, 245, 313, 246, 245, 
	314, 246, 245, 315, 246, 245, 316, 246, 
	245, 246, 299, 245, 246, 318, 245, 246, 
	319, 245, 246, 320, 245, 246, 321, 245, 
	246, 322, 245, 246, 323, 245, 246, 308, 
	245, 246, 325, 326, 245, 246, 261, 245, 
	327, 246, 334, 336, 245, 328, 246, 245, 
	246, 329, 245, 246, 330, 245, 246, 331, 
	245, 246, 332, 245, 246, 333, 245, 246, 
	299, 245, 246, 335, 245, 246, 261, 245, 
	246, 337, 245, 246, 338, 245, 339, 246, 
	245, 299, 246, 245, 246, 341, 245, 342, 
	246, 245, 343, 246, 245, 246, 344, 245, 
	345, 246, 245, 346, 246, 245, 347, 246, 
	245, 299, 246, 245, 246, 349, 245, 246, 
	350, 245, 246, 351, 245, 352, 246, 245, 
	353, 246, 245, 246, 354, 245, 246, 355, 
	245, 246, 356, 245, 246, 357, 245, 246, 
	358, 245, 246, 359, 245, 246, 360, 245, 
	246, 361, 245, 246, 261, 245, 363, 0, 
	364, 0, 365, 0, 366, 0, 73, 0, 
	94, 109, 93, 94, 369, 93, 94, 370, 
	93, 371, 94, 93, 109, 94, 93, 94, 
	373, 374, 93, 94, 109, 93, 375, 94, 
	383, 93, 376, 94, 93, 94, 377, 93, 
	94, 378, 93, 94, 379, 93, 94, 380, 
	93, 94, 381, 93, 94, 382, 93, 94, 
	73, 93, 94, 384, 93, 94, 109, 93, 
	94, 386, 93, 387, 94, 93, 388, 94, 
	93, 94, 389, 93, 390, 94, 93, 391, 
	94, 93, 392, 94, 93, 382, 94, 93, 
	94, 394, 93, 94, 395, 93, 94, 396, 
	93, 397, 94, 93, 398, 94, 93, 94, 
	399, 93, 94, 400, 93, 94, 401, 93, 
	94, 402, 93, 94, 403, 93, 94, 404, 
	93, 94, 405, 93, 94, 406, 93, 94, 
	109, 93, 57, 408, 414, 56, 4, 4, 
	5, 15, 17, 31, 34, 37, 45, 74, 
	112, 119, 235, 264, 409, 283, 4, 0, 
	410, 0, 411, 0, 412, 0, 413, 0, 
	73, 0, 57, 72, 56, 57, 416, 56, 
	57, 417, 56, 418, 57, 56, 72, 57, 
	56, 420, 57, 56, 421, 57, 56, 422, 
	57, 56, 423, 57, 56, 57, 424, 56, 
	57, 425, 56, 57, 426, 56, 57, 427, 
	56, 57, 428, 56, 429, 57, 56, 430, 
	57, 56, 57, 431, 56, 432, 57, 56, 
	433, 57, 56, 434, 57, 56, 435, 57, 
	56, 57, 436, 56, 57, 73, 56, 57, 
	438, 56, 57, 439, 56, 57, 440, 56, 
	57, 441, 56, 57, 442, 56, 57, 443, 
	56, 57, 427, 56, 57, 445, 446, 56, 
	57, 72, 56, 447, 57, 454, 56, 448, 
	57, 56, 57, 449, 56, 57, 450, 56, 
	57, 451, 56, 57, 452, 56, 57, 453, 
	56, 57, 436, 56, 57, 455, 56, 57, 
	72, 56, 57, 457, 56, 458, 57, 56, 
	459, 57, 56, 57, 460, 56, 461, 57, 
	56, 462, 57, 56, 463, 57, 56, 436, 
	57, 56, 57, 465, 56, 57, 466, 56, 
	57, 467, 56, 468, 57, 56, 469, 57, 
	56, 57, 470, 56, 57, 471, 56, 57, 
	472, 56, 57, 473, 56, 57, 474, 56, 
	57, 475, 56, 57, 476, 56, 57, 477, 
	56, 57, 72, 56, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 35, 
	0, 43, 0, 43, 0, 43, 54, 0, 
	5, 1, 0, 29, 1, 29, 29, 29, 
	29, 29, 29, 29, 35, 0, 43, 0, 
	43, 0, 43, 139, 48, 9, 106, 11, 
	0, 134, 45, 45, 45, 3, 122, 33, 
	33, 33, 0, 122, 33, 33, 33, 0, 
	122, 33, 0, 33, 0, 102, 7, 7, 
	43, 54, 0, 0, 43, 114, 25, 0, 
	54, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	149, 126, 57, 110, 23, 0, 43, 43, 
	43, 43, 0, 27, 118, 27, 27, 51, 
	27, 0, 54, 0, 1, 0, 43, 0, 
	0, 43, 149, 126, 57, 57, 110, 23, 
	0, 0, 110, 23, 0, 0, 0, 110, 
	23, 0, 0, 110, 23, 0, 110, 23, 
	0, 0, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 54, 0, 72, 
	33, 84, 72, 84, 84, 84, 84, 84, 
	84, 84, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 15, 0, 54, 15, 
	0, 130, 31, 60, 57, 31, 63, 57, 
	63, 63, 63, 63, 63, 63, 63, 66, 
	31, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 78, 33, 84, 78, 
	84, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 19, 
	0, 54, 19, 0, 54, 19, 0, 0, 
	130, 31, 60, 57, 31, 63, 57, 63, 
	63, 63, 63, 63, 63, 63, 0, 66, 
	31, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 81, 84, 81, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 21, 0, 0, 
	43, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 54, 0, 69, 33, 69, 84, 84, 
	84, 84, 84, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 13, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 13, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 75, 33, 84, 75, 84, 84, 84, 
	84, 84, 84, 84, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	54, 17, 0, 54, 17, 0, 0, 130, 
	31, 60, 57, 31, 63, 57, 63, 63, 
	63, 63, 63, 63, 63, 0, 66, 31, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 17, 43, 0, 
	0, 0, 43, 54, 37, 37, 87, 37, 
	37, 43, 0, 39, 0, 43, 0, 0, 
	54, 0, 0, 39, 0, 0, 54, 0, 
	93, 90, 41, 96, 90, 96, 96, 96, 
	96, 96, 96, 96, 99, 0, 43, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 17, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 19, 43, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	19, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 0, 130, 31, 
	60, 57, 31, 63, 57, 63, 63, 63, 
	63, 63, 63, 63, 0, 66, 31, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	15, 43, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 15, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 478;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/cs.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1119 "ext/gherkin_lexer_cs/gherkin_lexer_cs.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/cs.c.rl"
    
#line 1126 "ext/gherkin_lexer_cs/gherkin_lexer_cs.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/cs.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/cs.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/cs.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/cs.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/cs.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/cs.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/cs.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/cs.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/cs.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/cs.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/cs.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/cs.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/cs.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/cs.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/cs.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/cs.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/cs.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/cs.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/cs.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/cs.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/cs.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/cs.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/cs.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/cs.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1416 "ext/gherkin_lexer_cs/gherkin_lexer_cs.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/cs.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1479 "ext/gherkin_lexer_cs/gherkin_lexer_cs.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/cs.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_cs()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Cs", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

