#if defined(HAVE_CONFIG_H)
#include "config.h"
#endif

#include <algorithm>

#include "resip/stack/SipMessage.hxx"
#include "resip/stack/NameAddr.hxx"
#include "repro/monkeys/RecursiveRedirect.hxx"
#include "repro/RequestContext.hxx"
#include "repro/QValueTarget.hxx"
#include "rutil/Logger.hxx"

#define RESIPROCATE_SUBSYSTEM resip::Subsystem::REPRO

using namespace resip;
using namespace repro;
using namespace std;

RecursiveRedirect::RecursiveRedirect() :
   Processor("RecursiveRedirectHandler")
{}


RecursiveRedirect::~RecursiveRedirect()
{}


Processor::processor_action_t
RecursiveRedirect::process(RequestContext& context)
{
   DebugLog(<< "Lemur handling request: " << *this 
            << "; reqcontext = " << context);
   
   const SipMessage* response = dynamic_cast<const SipMessage*>(context.getCurrentEvent());
   if (response && 
       response->isResponse() && 
       response->header(h_StatusLine).statusCode() / 100 == 3)
   {
      TargetPtrList batch;
      for (NameAddrs::const_iterator i=response->header(h_Contacts).begin(); 
           i != response->header(h_Contacts).end(); ++i)
      {
         if(i->isWellFormed() && !i->isAllContacts())
         {
            QValueTarget* target = new QValueTarget(*i);
            batch.push_back(target);
         }
      }
      if(!batch.empty())
      {
#ifdef __SUNPRO_CC
         sort(batch.begin(), batch.end(), Target::priorityMetricCompare);
#else
         batch.sort(Target::priorityMetricCompare);
#endif
         context.getResponseContext().addTargetBatch(batch);
         //ResponseContext should be consuming the vector
         resip_assert(batch.empty());
      }
      return Processor::SkipAllChains;
   }
   return Processor::Continue;   
}


/* ====================================================================
 * The Vovida Software License, Version 1.0 
 * 
 * Copyright (c) 2000 Vovida Networks, Inc.  All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * 3. The names "VOCAL", "Vovida Open Communication Application Library",
 *    and "Vovida Open Communication Application Library (VOCAL)" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact vocal@vovida.org.
 *
 * 4. Products derived from this software may not be called "VOCAL", nor
 *    may "VOCAL" appear in their name, without prior written
 *    permission of Vovida Networks, Inc.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL VOVIDA
 * NETWORKS, INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT DAMAGES
 * IN EXCESS OF $1,000, NOR FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 * 
 * ====================================================================
 */
