/*
 *	recite - english text speech synthesizer
 *	Copyright (C) 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to access binary files
 */

#include <stdio.h>

#include <file.h>
#include <error.h>
#include <mem.h>


void
file_read(filename, data_p, datalen_p)
	char		*filename;
	char		**data_p;
	long		*datalen_p;
{
	FILE		*fp;
	char		*data;
	long		datalen;
	long		pos;

	if (!filename)
	{
		fp = stdin;
		filename = "(standard input)";
	}
	else
	{
		fp = fopen(filename, "rb");
		if (!fp)
			nfatal("open \"%s\"", filename);
	}
	datalen = (1L << 15);
	data = mem_alloc(datalen);
	pos = 0;
	for (;;)
	{
		int	c;

		c = getc(fp);
		if (c == EOF)
		{
			if (ferror(fp))
				nfatal("read \"%s\"", filename);
			break;
		}
		if (pos >= datalen)
		{
			datalen += (1L << 15);
			mem_change_size(&data, datalen);
		}
		data[pos++] = c;
	}
	if (fclose(fp))
		nfatal("close \"%s\"", filename);
	if (pos < datalen)
	{
		datalen = pos;
		mem_change_size(&data, datalen);
	}
	*data_p = data;
	*datalen_p = datalen;
}


void
file_write(filename, data, datalen)
	char	*filename;
	char	*data;
	long	datalen;
{
	FILE	*fp;

	if (!filename)
	{
		fp = stdout;
		filename = "(standard output)";
	}
	else
	{
		fp = fopen(filename, "wb");
		if (!fp)
			nfatal("create \"%s\"", filename);
	}
	if (fwrite(data, 1, datalen, fp) != datalen)
		nfatal("write \"%s\"", filename);
	if (datalen > 0 && data[datalen - 1] != '\n')
		fputc('\n', fp);
	if (fflush(fp))
		nfatal("write \"%s\"", filename);
	if (fclose(fp))
		nfatal("close \"%s\"", filename);
}
