
%  $Id: Kmenta.Rd 486 2007-10-10 07:58:53Z henningsena $

\name{Kmenta}
\alias{Kmenta}
\docType{data}
\title{Partly Artificial Data on the U. S. Economy}
\description{
   These are partly contrived data from Kmenta (1986), constructed
   to illustrate estimation of a simultaneous-equation model.
}

\usage{
   data("Kmenta")
}

\format{
This data frame contains 20 annual observations of 5 variables:
\describe{
   \item{consump}{food consumption per capita.}
   \item{price}{ratio of food prices to general consumer prices.}
   \item{income}{disposable income in constant dollars.}
   \item{farmPrice}{ratio of preceding year's prices received by farmers
      to general consumer prices.}
   \item{trend}{time trend in years.}
}
}

\details{
   The exogenous variables \code{income}, \code{farmPrice},
   and \code{trend} are based on real data;
   the endogenous variables \code{price} and \code{consump}
   were generated by simulation.
}

\source{
   Kmenta (1986), Table 13-1, p. 687.
}

\references{
Kmenta, J. (1986). \emph{Elements of Econometrics}, Second Edition,
Macmillan, New York.
}

\examples{
## Replicating the estimations in Kmenta (1986), p. 712, Tab 13-2
data( "Kmenta" )
eqDemand <- consump ~ price + income
eqSupply <- consump ~ price + farmPrice + trend
inst <- ~ income + farmPrice + trend
system <- list( demand = eqDemand, supply = eqSupply )

## OLS estimation
fitOls <- systemfit( system, data = Kmenta )
summary( fitOls )

## 2SLS estimation
fit2sls <- systemfit( system, "2SLS", inst = inst, data = Kmenta )
summary( fit2sls )

## 3SLS estimation
fit3sls <- systemfit( system, "3SLS", inst = inst, data = Kmenta )
summary( fit3sls )

## I3LS estimation
fitI3sls <- systemfit( system, "3SLS", inst = inst, data = Kmenta,
   maxit = 250 )
summary( fitI3sls )
}

\keyword{datasets}


