% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{st_contour}
\alias{st_contour}
\title{Compute or plot contour lines or sets}
\usage{
st_contour(
  x,
  na.rm = TRUE,
  contour_lines = FALSE,
  breaks = classInt::classIntervals(na.omit(as.vector(x[[1]])))$brks
)
}
\arguments{
\item{x}{object of class \code{stars}}

\item{na.rm}{logical; should missing valued cells be removed, or also be converted to features?}

\item{contour_lines}{logical; if \code{FALSE}, polygons are returned (contour sets), otherwise contour lines}

\item{breaks}{numerical; values at which to "draw" contour levels}
}
\description{
Compute contour lines or sets
}
\details{
this function requires GDAL >= 2.4.0
}
\seealso{
for polygonizing rasters following grid boundaries, see \link{st_as_sf} with arguments \code{as_points=FALSE} and \code{merge=TRUE}; \link{contour} plots contour lines using R's native algorithm (which also plots contour levels)
}
