% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmd.R
\name{gmd}
\alias{gmd}
\title{Gini's Mean Difference}
\usage{
gmd(x, select = NULL)
}
\arguments{
\item{x}{A vector or data frame.}

\item{select}{Optional, names of variables as character vector that should be
selected for further processing. Required, if \code{x} is a data frame (and no vector)
and only selected variables from \code{x} should be processed.}
}
\value{
For numeric vectors, Gini's mean difference. For non-numeric vectors
or vectors of length < 2, returns \code{NA}.
}
\description{
\code{gmd()} computes Gini's mean difference for a numeric vector
or for all numeric vectors in a data frame.
}
\note{
Gini's mean difference is defined as the mean absolute difference between
any two distinct elements of a vector. Missing values from \code{x} are silently
removed.
}
\examples{
data(efc)
gmd(efc$e17age)
gmd(efc, c("e17age", "c160age", "c12hour"))

}
\references{
David HA. Gini's mean difference rediscovered. Biometrika 1968(55): 573-575
}
