% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_range.R
\name{pretty_range}
\alias{pretty_range}
\title{Create a pretty sequence over a range of a vector}
\usage{
pretty_range(x, n = NULL, length = NULL)
}
\arguments{
\item{x}{A numeric vector.}

\item{n}{Numeric value, indicating the size of how many values are used to
create a pretty sequence. If \code{x} has a large value range (> 100),
\code{n} could be something between 1 to 5. If \code{x} has a rather
small amount of unique values, \code{n} could be something between
10 to 20. If \code{n = NULL}, \code{pretty_range()} automatically
tries to find a pretty sequence.}

\item{length}{Integer value, as alternative to \code{n}, defines the number of
intervals to be returned.}
}
\value{
A numeric vector with a range corresponding to the minimum and maximum
  values of \code{x}.
}
\description{
Creates an evenly spaced, pretty sequence of numbers for a
  range of a vector.
}
\examples{
library(sjmisc)
data(efc)

x <- std(efc$c12hour)
x
# pretty range for vectors with decimal points
pretty_range(x)

# pretty range for large range, increasing by 50
pretty_range(1:1000)

# increasing by 20
pretty_range(1:1000, n = 7)

# return 10 intervals
pretty_range(1:1000, length = 10)

# same result
pretty_range(1:1000, n = 2.5)

}
