% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng.R
\name{as_lecyer_cmrg_seed}
\alias{as_lecyer_cmrg_seed}
\alias{is_lecyer_cmrg_seed}
\title{Get a L'Ecuyer-CMRG seed either from an input seed or the current RNG state}
\usage{
as_lecyer_cmrg_seed(seed)

is_lecyer_cmrg_seed(seed)
}
\arguments{
\item{seed}{TRUE or NA, or a numeric vector of length one or seven.}
}
\value{
\code{as_lecyer_cmrg_seed(seed)} returns a L'Ecuyer-CMRG seed, which is a
7-digit integer vector, based on the input \code{seed}.
If already a L'Ecuyer-CMRG seed, then \code{seed} is return as-is.
If a scalar integer, then a random L'Ecuyer-CMRG seed is created based
on this seed as the current RNG state.
If \code{seed = TRUE} and the current seed is already a L'Ecuyer-CMRG seed,
then then current seed (\code{.Random.seed}) is return as-is.
If \code{seed = TRUE} and the current seed is \emph{not} of the 'L'Ecuyer-CMRG' kind,
or \code{seed = NA}, then a random one is created (based on the current RNG
state).
Any other values, including FALSE, is an error.

\code{is_lecyer_cmrg_seed(seed)} returns TRUE if \code{seed} is L'Ecuyer-CMRG seed,
otherwise FALSE.
}
\description{
Get a L'Ecuyer-CMRG seed either from an input seed or the current RNG state
}
\details{
The \code{as_lecyer_cmrg_seed()} function preserves the current RNG state, that
is, it leaves \code{globalenv()$.Random.seed} intact, which means it also leaved
the RNG kind (\code{RNGkind()}) intact.

Per \code{\link[base:Random]{base::RNGkind()}}, a L'Ecuyer-CMRG seed comprise a length-seven integer
vector of format \code{.Random.seed <- c(rng.kind, n)} where \code{length(n) == 6L} and \code{rng.kind} fulfills \code{rng.kind \%\% 10000L == 407L}.
}
\examples{
# The current RNG kind
okind <- RNGkind()
oseed <- globalenv()$.Random.seed

# (a) A L'Ecuyer-CMRG seed based on a numeric-scalar seed
seed1 <- future:::as_lecyer_cmrg_seed(42)
str(seed1)
## int [1:7] 10407 -2133391687 507561766 1260545903 1362917092 -1772566379 -1344458670
# The RNG kind and the RNG state is preserved
stopifnot(
  future:::is_lecyer_cmrg_seed(seed1),
  identical(RNGkind(), okind),
  identical(globalenv()$.Random.seed, oseed)
)

# (b) A L'Ecuyer-CMRG seed based on a L'Ecuyer-CMRG seed
seed2 <- future:::as_lecyer_cmrg_seed(seed1)
str(seed2)
## int [1:7] 10407 -2133391687 507561766 1260545903 1362917092 -1772566379 -1344458670
# The input L'Ecuyer-CMRG seed is returned as-is
stopifnot(identical(seed2, seed1))
# The RNG kind and the RNG state is preserved
stopifnot(
  future:::is_lecyer_cmrg_seed(seed2),
  identical(RNGkind(), okind),
  identical(globalenv()$.Random.seed, oseed)
)

# (c) A L'Ecuyer-CMRG seed based on the current RNG state
seed3 <- future:::as_lecyer_cmrg_seed(TRUE)
str(seed3)
## int [1:7] 10407 495333909 -1491719214 416071979 49340016 1956499377 899435966
stopifnot(future:::is_lecyer_cmrg_seed(seed3))


# All of the above calls preserve the RNG state including the RNG kind
stopifnot(
  identical(RNGkind(), okind),
  identical(globalenv()$.Random.seed, oseed)
)
}
\keyword{internal}
