% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freetypeharfbuzz.R
\name{font_info}
\alias{font_info}
\alias{str_info}
\alias{str_width}
\title{Font metrics}
\usage{
font_info(font_size = 12, font_file = NULL)

str_info(string, font_size = 12, font_file = NULL)

str_width(string, font_size = 12, font_file = NULL)
}
\arguments{
\item{font_size}{Font size in point.}

\item{font_file}{Path to a ttf or otf file.}

\item{string}{A string whose metrics will be computed.}
}
\description{
* `font_info()` returns the typographical metrics (ascent, descent,
   linegap) for a font.

* `str_info()` returns the metrics (width, height, ascent,
  descent) for a string. `str_width()` only returns the width.
}
\examples{
file <- fontquiver::font("Liberation", "serif", "bold")$ttf
font_info(font_size = 13, font_file = file)

str_width("foobar", font_size = 13)
str_info("foobar", font_size = 13)
str_info("foobar", font_size = 13, font_file = file)
}
